/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.util.Vector;
import novartis.chemistry.molecule.Atom;
import novartis.chemistry.molecule.Bond;
import novartis.chemistry.molecule.Molecule;
import novartis.utilities.Box;
import novartis.utilities.IntProperty;

public class MoleculeDepicter {
    public static final int USE_ATOM_COLORS = 1;
    public static final int USE_BOND_COLORS = 2;
    public static final int USE_COLORS = 3;
    public static final int USE_CLUSTAL = 4;
    public static final int STDBND = 504;
    public static final int FONTSIZE = 260;
    public static final double CCBND = 1.54;
    public static final String HELVETICA = "SansSerif";
    public static final String TIMES = "Serif";
    public static final String COURIER = "Monospaced";
    public static final String DIALOG = "Dialog";
    static final int SNG = 1;
    static final int BND_RIGHT = 2;
    static final int BND_LEFT = 4;
    static final int DBL_RIGHT = 3;
    static final int DBL_LEFT = 5;
    static final int DBL = 3;
    static final int TRP = 7;
    static final int MANHATTAN = 8192;
    static final int SYM_DBL = 8;
    static final int WDG = 16;
    static final int HSH = 32;
    static final int UNK = 64;
    static final int DSH = 128;
    static final int CHN = 256;
    static final int RNG = 512;
    static final int BSD = 1024;
    static final int BSA = 2048;
    static final int BDA = 4096;
    static final int CUT = 1;
    static final int CUT_SEC = 2;
    double xoffset;
    double yoffset;
    double scale = 1.0;
    double fontscale = 1.0;
    static String[] colortable = new String[]{"0x000000", "0xFF0000", "0x0000FF", "0x007F00", "0x7F3F00", "0x3F007F", "0x003F3F", "0x7F7F00", "0x7F007F", "0x999999"};
    static final int GREY_INDEX = 9;
    static String[] clustal_colors = new String[]{"0xf09048", "0xc0c000", "0x80a0f0", "0xf01505", "0x15c015", "0xf08080", "0xc048c0", "0x15a4a4"};
    static String[] rasmol_colors = new String[]{"0xe60a0a", "0x145aff", "0x3232aa", "0xc8c8c8", "0xa4a4a4", "0x8282d2", "0xc0c000", "0xfa9600", "0x00dcdc", "0x0f820f", "0xb45ab4", "0xdc96dc"};

    private static void ChooseFont(Vector<String> vector, double d, String string) {
        vector.addElement(("f " + string + " " + (int)(d * 260.5)).toString());
    }

    private static boolean plotBond(Vector<String> vector, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        String string;
        double d = 0.45;
        double d2 = 0.5;
        double d3 = 0.5;
        double d4 = 0.65;
        double d5 = 0.45;
        int[][] nArrayArray = new int[][]{{0, 0}, {0, 0}, {0, 0}};
        int n11 = n;
        int n12 = n2;
        int n13 = n3;
        int n14 = n4;
        int n15 = (int)Math.sqrt((double)(n - n3) * (double)(n - n3) + (double)(n2 - n4) * (double)(n2 - n4));
        int n16 = (int)(d * ((double)n5 * (double)(n3 - n)) / (double)n15);
        int n17 = (int)(d * ((double)n5 * (double)(n4 - n2)) / (double)n15);
        int n18 = (int)(d2 * ((double)n5 * (double)(n3 - n)) / (double)n15);
        int n19 = (int)(d2 * ((double)n5 * (double)(n4 - n2)) / (double)n15);
        int n20 = (int)(d4 * ((double)n5 * (double)(n3 - n)) / (double)n15);
        int n21 = (int)(d4 * ((double)n5 * (double)(n4 - n2)) / (double)n15);
        int n22 = (int)(d5 * ((double)n5 * (double)(n3 - n)) / (double)n15);
        int n23 = (int)(d5 * ((double)n5 * (double)(n4 - n2)) / (double)n15);
        boolean bl = false;
        if ((n6 & 0x2000) != 0) {
            if (n2 > n4) {
                int n24 = n;
                n = n3;
                n3 = n24;
                n24 = n2;
                n2 = n4;
                n4 = n24;
            }
            if ((double)Math.abs(n2 - n4) < 252.0) {
                vector.addElement("l " + n + " " + (int)((double)n2 + (double)n5 * d4) + " " + n + " " + (int)((double)n2 + (double)n5 * d4 + (double)(n5 / 2)));
                vector.addElement("l " + n + " " + (int)((double)n2 + (double)n5 * d4 + (double)(n5 / 2)) + " " + n3 + " " + (int)((double)n4 + (double)n5 * d4 + (double)(n5 / 2)));
                vector.addElement("l " + n3 + " " + (int)((double)n4 + (double)n5 * d4) + " " + n3 + " " + (int)((double)n4 + (double)n5 * d4 + (double)(n5 / 2)));
            } else {
                vector.addElement("l " + n + " " + (int)((double)n2 + (double)n5 * d4) + " " + n + " " + (int)((double)n2 + (double)n5 * d4 + (double)(n5 / 2)));
                vector.addElement("l " + n + " " + (int)((double)n2 + (double)n5 * d4 + (double)(n5 / 2)) + " " + n3 + " " + (int)((double)n4 - (double)n5 * d4 - (double)(n5 / 2)));
                vector.addElement("l " + n3 + " " + (int)((double)n4 - (double)n5 * d4 - (double)(n5 / 2)) + " " + n3 + " " + (int)((double)n4 - (double)n5 * d4));
            }
            return bl;
        }
        if ((n7 & 1) != 0) {
            n += n20;
            n2 += n21;
        }
        if ((n8 & 1) != 0) {
            n3 -= n20;
            n4 -= n21;
        }
        if ((n6 & 1) != 0) {
            vector.addElement("l " + n + " " + n2 + " " + n3 + " " + n4);
        }
        if ((n6 & 2) != 0) {
            string = (n7 & 2) != 0 ? "l " + (n - n17 + n22) + " " + (n2 + n16 + n23) + " " : "l " + (n - n17) + " " + (n2 + n16) + " ";
            string = (n8 & 2) != 0 ? string + (n3 - n17 - n22) + " " + (n4 + n16 - n23) : string + (n3 - n17) + " " + (n4 + n16);
            vector.addElement(string);
        }
        if ((n6 & 4) != 0) {
            string = (n7 & 2) != 0 ? "l " + (n + n17 + n22) + " " + (n2 - n16 + n23) + " " : "l " + (n + n17) + " " + (n2 - n16) + " ";
            string = (n8 & 2) != 0 ? string + (n3 + n17 - n22) + " " + (n4 - n16 - n23) : string + (n3 + n17) + " " + (n4 - n16);
            vector.addElement(string);
        }
        if ((n6 & 8) != 0) {
            string = "l " + (n - n17 / 2) + " " + (n2 + n16 / 2) + " " + (n3 - n17 / 2) + " " + (n4 + n16 / 2);
            vector.addElement(string);
            string = "l " + (n + n17 / 2) + " " + (n2 - n16 / 2) + " " + (n3 + n17 / 2) + " " + (n4 - n16 / 2);
            vector.addElement(string);
        }
        if ((n6 & 0x10) != 0) {
            nArrayArray[0][0] = n;
            nArrayArray[0][1] = n2;
            nArrayArray[1][0] = n3 - n19 / 2;
            nArrayArray[1][1] = n4 + n18 / 2;
            nArrayArray[2][0] = n3 + n19 / 2;
            nArrayArray[2][1] = n4 - n18 / 2;
            string = "pf 3 " + nArrayArray[0][0] + " " + nArrayArray[0][1] + " " + nArrayArray[1][0] + " " + nArrayArray[1][1] + " " + nArrayArray[2][0] + " " + nArrayArray[2][1];
            vector.addElement(string);
        }
        if ((n6 & 0x20) != 0) {
            n10 = (int)((double)n15 / (d3 * (double)n5) + 0.5);
            if (n10 < 2) {
                n10 = 2;
            }
            double d6 = d2 * ((double)n5 * (double)(n3 - n)) / (double)n15;
            double d7 = d2 * ((double)n5 * (double)(n4 - n2)) / (double)n15;
            for (n9 = 0; n9 <= n10; ++n9) {
                string = "l " + (int)((double)n + (double)n9 * ((double)(n3 - n) - d7 / 2.0) / (double)n10) + " " + (int)((double)n2 + (double)n9 * ((double)(n4 - n2) + d6 / 2.0) / (double)n10) + " " + (int)((double)n + (double)n9 * ((double)(n3 - n) + d7 / 2.0) / (double)n10) + " " + (int)((double)n2 + (double)n9 * ((double)(n4 - n2) - d6 / 2.0) / (double)n10);
                vector.addElement(string);
            }
        }
        if ((n6 & 0x80) != 0) {
            n10 = (int)((double)n15 / (d3 * (double)n5) + 0.5);
            if (n10 < 4) {
                n10 = 4;
            }
            if (n10 % 2 == 1) {
                ++n10;
            }
            if ((n6 & 1) != 0) {
                n += -n17 + n22;
                n2 -= -n16 - n23;
                n3 += -n17 - n22;
                n4 -= -n16 + n23;
            }
            for (n9 = 0; n9 < n10; n9 += 2) {
                string = "l " + (n + n9 * (n3 - n) / n10) + " " + (n2 + n9 * (n4 - n2) / n10) + " " + (n + (n9 + 1) * (n3 - n) / n10) + " " + (n2 + (n9 + 1) * (n4 - n2) / n10);
                vector.addElement(string);
            }
        }
        if ((n6 & 0x100) != 0) {
            bl = true;
            vector.addElement("c " + colortable[1]);
            vector.addElement("t 0 " + (n11 + n13) / 2 + " " + (n12 + n14) / 2 + " ch");
        }
        if ((n6 & 0x200) != 0) {
            bl = true;
            vector.addElement("c " + colortable[1]);
            vector.addElement("t 0 " + (n11 + n13) / 2 + " " + (n12 + n14) / 2 + " rn");
        }
        if ((n6 & 0x400) != 0) {
            bl = true;
            vector.addElement("c " + colortable[1]);
            vector.addElement("t 0 " + (n11 + n13) / 2 + " " + (n12 + n14) / 2 + " s/d");
        }
        if ((n6 & 0x800) != 0) {
            bl = true;
            vector.addElement("c " + colortable[1]);
            vector.addElement("t 0 " + (n11 + n13) / 2 + " " + (n12 + n14) / 2 + " s/a");
        }
        if ((n6 & 0x1000) != 0) {
            bl = true;
            vector.addElement("c " + colortable[1]);
            vector.addElement("t 0 " + (n11 + n13) / 2 + " " + (n12 + n14) / 2 + " d/a");
        }
        return bl;
    }

    public static double getWorldWindow(Molecule molecule, Box box) {
        int n;
        Object object;
        Atom atom;
        int n2;
        box.ymin = 1.0E10;
        box.xmin = 1.0E10;
        box.ymax = -1.0E10;
        box.xmax = -1.0E10;
        for (n2 = 0; molecule.atoms != null && n2 < molecule.atoms.length; ++n2) {
            atom = molecule.atoms[n2];
            if (box.xmin > atom.x) {
                box.xmin = atom.x;
            }
            if (box.xmax < atom.x) {
                box.xmax = atom.x;
            }
            if (box.ymin > atom.y) {
                box.ymin = atom.y;
            }
            if (!(box.ymax < atom.y)) continue;
            box.ymax = atom.y;
        }
        if (box.xmin == box.xmax) {
            box.xmin -= 0.5;
            box.xmax += 0.5;
        }
        if (box.ymin == box.ymax) {
            box.ymin -= 0.5;
            box.ymax += 0.5;
        }
        double d = 0.0;
        double[] dArray = new double[]{0.77};
        if (molecule.bonds != null && molecule.bonds.length > 0) {
            dArray = new double[molecule.bonds.length];
        }
        int n3 = 0;
        for (n2 = 0; molecule.bonds != null && n2 < molecule.bonds.length; ++n2) {
            Bond bond = molecule.bonds[n2];
            Atom atom2 = molecule.atoms[bond.atoms[0] - 1];
            object = molecule.atoms[bond.atoms[1] - 1];
            n = 0;
            String string = atom2.symbol;
            String string2 = ((Atom)object).symbol;
            if (atom2.getStringProperty("A") != null) {
                n = 1;
                string = atom2.getStringProperty("A");
            }
            if (((Atom)object).getStringProperty("A") != null) {
                n = 1;
                string2 = ((Atom)object).getStringProperty("A");
            }
            double d2 = atom2.x - ((Atom)object).x;
            double d3 = atom2.y - ((Atom)object).y;
            dArray[n2] = d2 * d2 + d3 * d3;
            if (n == 0) continue;
            ++n3;
            int n4 = n2;
            dArray[n4] = dArray[n4] * (4.0 / (3.0 + 0.5 * (double)(string.length() + string2.length())));
            int n5 = n2;
            dArray[n5] = dArray[n5] * (4.0 / (3.0 + 0.5 * (double)(string.length() + string2.length())));
        }
        for (n2 = 1; n2 < dArray.length; ++n2) {
            for (int i = n2 - 1; i >= 0 && dArray[i + 1] < dArray[i]; --i) {
                double d4 = dArray[i + 1];
                dArray[i + 1] = dArray[i];
                dArray[i] = d4;
            }
        }
        d = Math.sqrt(dArray[2 * dArray.length / 10]);
        for (n2 = 0; molecule.atoms != null && n2 < molecule.atoms.length; ++n2) {
            atom = molecule.atoms[n2];
            String string = atom.symbol;
            if (atom.getStringProperty("A") != null) {
                string = atom.getStringProperty("A");
            } else if (atom.atomList != null) {
                object = new StringBuffer();
                for (n = 0; n < atom.atomList.length; ++n) {
                    if (n == 0) {
                        ((StringBuffer)object).append("[");
                    } else if (atom.notLogic) {
                        ((StringBuffer)object).append(";");
                    } else {
                        ((StringBuffer)object).append(",");
                    }
                    if (atom.notLogic) {
                        ((StringBuffer)object).append("!");
                    }
                    ((StringBuffer)object).append(atom.atomList[n]);
                }
                ((StringBuffer)object).append("]");
                string = ((StringBuffer)object).toString();
            }
            if (!(box.xmax < atom.x + (double)string.length() * d / 4.0)) continue;
            box.xmax = atom.x + (double)string.length() * d / 4.0;
        }
        box.xmin -= d / 2.0;
        box.xmax += d / 2.0;
        return d;
    }

    private void setTransformation(int n, Box box, double d) {
        this.scale = (double)n / d;
        this.fontscale = 1.0;
        this.xoffset = (box.xmin + box.xmax) / 2.0;
        this.yoffset = (box.ymin + box.ymax) / 2.0;
    }

    private void fixScale(double d, double d2, double d3, double d4) {
        if (d < d3 && d2 < d4) {
            return;
        }
        if (d3 / d <= d4 / d2) {
            this.scale *= d3 / d;
            this.fontscale *= d3 / d;
        } else {
            this.scale *= d4 / d2;
            this.fontscale *= d4 / d2;
        }
    }

    int worldToMetaX(double d) {
        return (int)((d - this.xoffset) * this.scale);
    }

    int worldToMetaY(double d) {
        return -((int)((d - this.yoffset) * this.scale));
    }

    static void SetDrawFlags(Molecule molecule) {
        Bond bond;
        int n;
        molecule.resetColors();
        for (n = 0; n < molecule.bonds.length; ++n) {
            bond = molecule.bonds[n];
            bond.color = 0;
            if (bond.topography == 2) {
                bond.color |= 0x100;
            }
            if (bond.topography != 1) continue;
            bond.color |= 0x200;
        }
        molecule.setupNeighbourhood();
        molecule.perceiveRingBonds();
        molecule.makeRingsClockwise();
        for (n = 0; n < molecule.atoms.length; ++n) {
            Atom atom = molecule.atoms[n];
            if (!atom.symbol.equals("C") || atom.charge != 0 || atom.radical != 0 || atom.implicit_H_count != -1 && atom.reaction_mapping == 0 || atom.getIntProperty("SUB", 0) != 0 || atom.isotope != 0) {
                atom.color |= 1;
                continue;
            }
            if (molecule.atoms[n].neighbour_atoms.length == 1) continue;
            atom.color |= 2;
        }
        block11: for (n = 0; n < molecule.bonds.length; ++n) {
            bond = molecule.bonds[n];
            switch (bond.bond_type) {
                case 2: {
                    if (bond.stereo_symbol == 1) {
                        bond.color |= 0x10;
                        continue block11;
                    }
                    if (bond.stereo_symbol == 2) {
                        bond.color |= 0x20;
                        continue block11;
                    }
                    bond.color |= 1;
                    continue block11;
                }
                case 4: {
                    int n2 = bond.atoms[0];
                    int n3 = bond.atoms[1];
                    Atom atom = molecule.atoms[n2 - 1];
                    Atom atom2 = molecule.atoms[n3 - 1];
                    if (bond.topography != 1 && (atom2.x - atom.x) * 2.0 + (atom2.y - atom.y) * 3.0 < 0.0) {
                        bond.atoms[0] = n3;
                        bond.atoms[1] = n2;
                    }
                    if (atom.neighbour_atoms.length < 2 || atom2.neighbour_atoms.length < 2 || atom.neighbour_atoms.length == 2 && atom2.neighbour_atoms.length == 2 && (!atom.symbol.equals("C") || !atom2.symbol.equals("C")) && bond.topography != 1 || atom.neighbour_atoms.length == 3 && atom2.neighbour_atoms.length == 3 && bond.topography != 1) {
                        bond.color |= 8;
                        continue block11;
                    }
                    bond.color |= 3;
                    continue block11;
                }
                case 8: {
                    bond.color |= 7;
                    int n2 = bond.atoms[0];
                    int n3 = bond.atoms[1];
                    Atom atom = molecule.atoms[n2 - 1];
                    Atom atom2 = molecule.atoms[n3 - 1];
                    atom.color &= 0xFFFFFFFD;
                    atom2.color &= 0xFFFFFFFD;
                    continue block11;
                }
                case 6: {
                    bond.color |= 0x400;
                    bond.color |= 0x80;
                    bond.color |= 1;
                    continue block11;
                }
                case 18: {
                    bond.color |= 0x800;
                    bond.color |= 0x80;
                    bond.color |= 1;
                    continue block11;
                }
                case 20: {
                    bond.color |= 0x1000;
                    bond.color |= 0x80;
                    bond.color |= 1;
                    continue block11;
                }
                case 16: {
                    bond.color |= 0x80;
                    bond.color |= 1;
                    continue block11;
                }
                default: {
                    bond.color |= 0x80;
                }
            }
        }
    }

    String AttributesToString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 != 0) {
            stringBuffer.append("*");
        }
        if (Math.abs(n) > 1) {
            stringBuffer.append("" + Math.abs(n));
        }
        if (n > 0) {
            stringBuffer.append("+");
        } else if (n < 0) {
            stringBuffer.append("-");
        }
        if (n2 == 1) {
            stringBuffer.append("|");
        } else if (n2 == 2) {
            stringBuffer.append(".");
        } else if (n2 == 4) {
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private String freeDirection(Atom atom, Atom[] atomArray) {
        int n;
        if (atom.atomList != null) {
            return "E";
        }
        if (atom.getStringProperty("A") != null && !atom.getStringProperty("A").matches(".*[0-9].*")) {
            return "E";
        }
        if (atom.getStringProperty("A") != null && atom.getStringProperty("A").matches(".*[A-Z][A-Z].*")) {
            return "E";
        }
        if (atom.getIntProperty("SUB", 0) != 0) {
            return "E";
        }
        for (n = 0; n < atomArray.length && !(atomArray[n].x - atom.x > 0.0); ++n) {
        }
        if (n >= atomArray.length) {
            return "E";
        }
        for (n = 0; n < atomArray.length && !(atomArray[n].x - atom.x < 0.0); ++n) {
        }
        if (n >= atomArray.length) {
            return "W";
        }
        for (n = 0; n < atomArray.length && !(atomArray[n].y - atom.y < 0.0); ++n) {
        }
        if (n >= atomArray.length) {
            return "S";
        }
        for (n = 0; n < atomArray.length && !(atomArray[n].y - atom.y > 0.0); ++n) {
        }
        if (n >= atomArray.length) {
            return "N";
        }
        for (n = 0; !(n >= atomArray.length || atomArray[n].x - atom.x > 0.0 && Math.abs(atomArray[n].x - atom.x) > Math.abs(atomArray[n].y - atom.y)); ++n) {
        }
        if (n >= atomArray.length) {
            return "e";
        }
        for (n = 0; !(n >= atomArray.length || atomArray[n].x - atom.x < 0.0 && Math.abs(atomArray[n].x - atom.x) > Math.abs(atomArray[n].y - atom.y)); ++n) {
        }
        if (n >= atomArray.length) {
            return "w";
        }
        for (n = 0; !(n >= atomArray.length || atomArray[n].y - atom.y < 0.0 && Math.abs(atomArray[n].x - atom.x) < Math.abs(atomArray[n].y - atom.y)); ++n) {
        }
        if (n >= atomArray.length) {
            return "s";
        }
        for (n = 0; !(n >= atomArray.length || atomArray[n].y - atom.y > 0.0 && Math.abs(atomArray[n].x - atom.x) < Math.abs(atomArray[n].y - atom.y)); ++n) {
        }
        if (n >= atomArray.length) {
            return "n";
        }
        return "e";
    }

    public String[] computeDepiction(Molecule molecule, int n, int n2, int n3, int[] nArray, String[] stringArray) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Bond bond;
        Box box = new Box(0.0, 0.0, 0.0, 0.0);
        boolean bl = true;
        String string = "";
        if (molecule == null) {
            return new String[0];
        }
        double d = MoleculeDepicter.getWorldWindow(molecule, box);
        this.setTransformation(504, box, d);
        int n9 = this.worldToMetaX(box.xmax) - this.worldToMetaX(box.xmin);
        int n10 = this.worldToMetaY(box.ymin) - this.worldToMetaY(box.ymax);
        n9 = (int)((double)n9 + 756.0);
        n10 = (int)((double)n10 + 756.0);
        if (n > 0 && n2 > 0) {
            this.fixScale(n9, n10, n, n2);
            n9 = n;
            n10 = n2;
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("e " + n9 + " " + n10);
        vector.addElement("o " + -n9 / 2 + " " + -n10 / 2);
        int n11 = 0;
        vector.addElement("c " + colortable[n11 % colortable.length]);
        MoleculeDepicter.SetDrawFlags(molecule);
        for (int i = 0; i < molecule.bonds.length; ++i) {
            Atom atom;
            int n12;
            bond = molecule.bonds[i];
            double d2 = 0.0;
            d2 += (molecule.atoms[bond.atoms[0] - 1].x - molecule.atoms[bond.atoms[1] - 1].x) * (molecule.atoms[bond.atoms[0] - 1].x - molecule.atoms[bond.atoms[1] - 1].x);
            d2 += (molecule.atoms[bond.atoms[0] - 1].y - molecule.atoms[bond.atoms[1] - 1].y) * (molecule.atoms[bond.atoms[0] - 1].y - molecule.atoms[bond.atoms[1] - 1].y);
            d2 = Math.sqrt(d2);
            n8 = this.worldToMetaX(molecule.atoms[bond.atoms[0] - 1].x);
            n7 = this.worldToMetaY(molecule.atoms[bond.atoms[0] - 1].y);
            n6 = this.worldToMetaX(molecule.atoms[bond.atoms[1] - 1].x);
            n5 = this.worldToMetaY(molecule.atoms[bond.atoms[1] - 1].y);
            int n13 = molecule.atoms[bond.atoms[0] - 1].color;
            int n14 = molecule.atoms[bond.atoms[1] - 1].color;
            if ((double)Math.abs(n7 - n5) < 0.001 * (double)Math.abs(n8 - n6) && 1461.6 > (double)Math.abs(n8 - n6) && bond.bond_type == 2) {
                n12 = 0;
                atom = molecule.atoms[bond.atoms[0] - 1];
                if ((atom.symbol.equals("R") || atom.symbol.equals("A")) && null != atom.getStringProperty("A")) {
                    n12 = 1;
                }
                atom = molecule.atoms[bond.atoms[1] - 1];
                if ((atom.symbol.equals("R") || atom.symbol.equals("A")) && null != atom.getStringProperty("A")) {
                    n12 = 1;
                }
                if (null == (atom = molecule.atoms[bond.atoms[0] - 1]).getStringProperty("A")) {
                    n12 = 0;
                }
                if (!atom.symbol.equals("R") && !atom.symbol.equals("A") && atom.symbol.length() > 1) {
                    n12 = 0;
                }
                if (null == (atom = molecule.atoms[bond.atoms[1] - 1]).getStringProperty("A")) {
                    n12 = 0;
                }
                if (!atom.symbol.equals("R") && !atom.symbol.equals("A") && atom.symbol.length() > 1) {
                    n12 = 0;
                }
                if (n12 != 0) continue;
            }
            if (nArray != null) {
                n12 = Math.min(nArray[bond.atoms[0] - 1], nArray[bond.atoms[1] - 1]);
                if (n12 < colortable.length) {
                    if (n11 != n12) {
                        n11 = n12;
                        vector.addElement("c " + colortable[n11 % colortable.length]);
                    }
                } else if (n11 != 0) {
                    n11 = 0;
                    vector.addElement("c " + colortable[n11 % colortable.length]);
                }
            } else if (d2 > d * 2.0) {
                n12 = 1;
                atom = molecule.atoms[bond.atoms[0] - 1];
                if (!atom.symbol.equals("R") && !atom.symbol.equals("A") || null == atom.getStringProperty("A")) {
                    n12 = 0;
                }
                atom = molecule.atoms[bond.atoms[1] - 1];
                if (!atom.symbol.equals("R") && !atom.symbol.equals("A") || null == atom.getStringProperty("A")) {
                    n12 = 0;
                }
                if (n12 != 0) {
                    vector.addElement("c " + colortable[9]);
                    n11 = 9;
                    bond.color |= 0x2000;
                } else {
                    vector.addElement("c " + colortable[0]);
                    n11 = 0;
                }
            } else if ((n3 & 2) != 0) {
                n12 = 0;
                if (bond.reaction_mark > 0) {
                    n12 = 1;
                }
                if (n11 != n12) {
                    n11 = n12;
                    vector.addElement("c " + colortable[n12]);
                }
            } else if (n11 != 0) {
                n11 = 0;
                vector.addElement("c " + colortable[n11 % colortable.length]);
            }
            if (!MoleculeDepicter.plotBond(vector, n8, n7, n6, n5, (int)(this.fontscale * 260.0), bond.color, n13, n14)) continue;
            vector.addElement("c " + colortable[n11]);
        }
        n11 = 0;
        vector.addElement("c " + colortable[n11]);
        MoleculeDepicter.ChooseFont(vector, this.fontscale, HELVETICA);
        int[] nArray2 = molecule.ComputeImplicitH();
        n11 = 0;
        vector.addElement("c " + colortable[0]);
        bl = false;
        String string2 = "";
        for (n4 = 0; n4 < molecule.atoms.length; ++n4) {
            String string3;
            Atom atom = molecule.atoms[n4];
            vector.addElement("ac " + (n4 + 1) + " " + this.worldToMetaX(atom.x) + " " + this.worldToMetaY(atom.y));
            if (atom.symbol.equals("C") && atom.charge == 0 && atom.radical == 0 && atom.isotope == 0 && molecule.atoms.length != 1 && (stringArray == null || stringArray[n4] == null || stringArray[n4].equals("")) && atom.getIntProperty("SUB", 0) == 0 && atom.atomList == null) continue;
            if (atom.charge == 0 && atom.radical == 0 && atom.isotope == 0 && atom.atomList == null) {
                if (atom.symbol.equals("Cl") && nArray2[n4 + 1] == 1) {
                    string = "HCl";
                } else if (atom.symbol.equals("Br") && nArray2[n4 + 1] == 1) {
                    string = "HBr";
                } else if (atom.symbol.equals("I") && nArray2[n4 + 1] == 1) {
                    string = "HI";
                } else if (atom.symbol.equals("F") && nArray2[n4 + 1] == 1) {
                    string = "HF";
                } else if (atom.symbol.equals("O") && nArray2[n4 + 1] == 2) {
                    string = "H2O";
                } else if (atom.symbol.equals("S") && nArray2[n4 + 1] == 2) {
                    string = "H2S";
                } else if ((atom.symbol.equals("R") || atom.symbol.equals("A")) && null != atom.getStringProperty("A")) {
                    string = atom.getStringProperty("A");
                } else if (nArray2[n4 + 1] == 0 || atom.getIntProperty("SUB", 0) != 0) {
                    string = atom.symbol;
                } else if (nArray2[n4 + 1] == 1) {
                    string = atom.symbol + "H";
                } else if (nArray2[n4 + 1] > 1) {
                    string = atom.symbol + "H" + nArray2[n4 + 1];
                }
            } else if (atom.atomList != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < atom.atomList.length; ++i) {
                    if (i == 0) {
                        stringBuffer.append("[");
                    } else if (atom.notLogic) {
                        stringBuffer.append(";");
                    } else {
                        stringBuffer.append(",");
                    }
                    if (atom.notLogic) {
                        stringBuffer.append("!");
                    }
                    stringBuffer.append(atom.atomList[i]);
                }
                stringBuffer.append("]");
                string = stringBuffer.toString();
            } else if (nArray2[n4 + 1] == 0) {
                string = atom.symbol;
            } else if (nArray2[n4 + 1] == 1) {
                string = atom.symbol + "H";
            } else if (nArray2[n4 + 1] > 1) {
                string = atom.symbol + "H" + nArray2[n4 + 1];
            }
            if (atom.getIntProperty("SUB", 0) != 0) {
                int n15 = atom.getIntProperty("SUB", 0);
                if (n15 == -2) {
                    string = string + "(s*)";
                } else if (n15 == -1) {
                    string = string + "(s0)";
                } else if (n15 > 0) {
                    string = string + "(s" + n15 + ")";
                }
            }
            Atom[] atomArray = molecule.atoms[n4].neighbour_atoms;
            string2 = this.freeDirection(atom, atomArray);
            int n16 = atom.charge;
            if (atom.atomic_number == 123) {
                if (n16 == -1) {
                    string = "From";
                } else if (n16 == -2) {
                    string = "To";
                } else if (n16 < 0) {
                    string = "R?";
                } else {
                    n16 = IntProperty.findValue(atom.int_properties, "RGP", 0);
                    string = "R" + n16;
                    n16 = 0;
                }
            }
            if ((n3 & 1) != 0 && nArray == null) {
                bl = true;
                if (atom.symbol.equals("N")) {
                    vector.addElement("c " + colortable[2]);
                } else if (atom.symbol.equals("O")) {
                    vector.addElement("c " + colortable[1]);
                } else if (atom.symbol.equals("S")) {
                    vector.addElement("c " + colortable[4]);
                } else if (atom.symbol.equals("P")) {
                    vector.addElement("c " + colortable[8]);
                } else if (atom.symbol.equals("I")) {
                    vector.addElement("c " + colortable[5]);
                } else if (atom.symbol.equals("F")) {
                    vector.addElement("c " + colortable[3]);
                } else if (atom.symbol.equals("Cl")) {
                    vector.addElement("c " + colortable[3]);
                } else if (atom.symbol.equals("Br")) {
                    vector.addElement("c " + colortable[3]);
                } else if (atom.symbol.equals("R") && 0 == (n3 & 4)) {
                    String string4 = atom.getStringProperty("A");
                    if (string4 == null) {
                        vector.addElement("c " + colortable[0]);
                    } else if (string4.equals("E") || string4.matches(".*\\b[D]?(Me)?Glu") || string4.equals("D") || string4.matches(".*\\b[D]?(Me)?Asp")) {
                        vector.addElement("c " + rasmol_colors[0]);
                    } else if (string4.equals("R") || string4.matches(".*\\b[D]?(Me)?Arg") || string4.equals("K") || string4.matches(".*\\b[D]?(Me)?Lys")) {
                        vector.addElement("c " + rasmol_colors[1]);
                    } else if (string4.equals("F") || string4.matches(".*\\b[D]?(Me)?Phe") || string4.matches(".*\\b[D]?(Me)?aNal") || string4.matches(".*\\b[D]?bNal") || string4.equals("Y") || string4.matches(".*\\b[D]?(Me)?Tyr")) {
                        vector.addElement("c " + rasmol_colors[2]);
                    } else if (string4.equals("G") || string4.matches(".*\\bGly")) {
                        vector.addElement("c " + rasmol_colors[3]);
                    } else if (string4.equals("A") || string4.matches(".*\\b[D]?(Me)?Ala")) {
                        vector.addElement("c " + rasmol_colors[4]);
                    } else if (string4.equals("H") || string4.matches(".*\\b[D]?(Me)?His")) {
                        vector.addElement("c " + rasmol_colors[5]);
                    } else if (string4.equals("C") || string4.matches(".*\\b[D]?(Me)?Cys") || string4.equals("M") || string4.matches(".*\\b[D]?(Me)?Met")) {
                        vector.addElement("c " + rasmol_colors[6]);
                    } else if (string4.equals("S") || string4.matches(".*\\b[D]?(Me)?Ser") || string4.equals("T") || string4.matches(".*\\b[D]?(Me)?Thr")) {
                        vector.addElement("c " + rasmol_colors[7]);
                    } else if (string4.equals("N") || string4.matches(".*\\b[D]?(Me)?Asn") || string4.equals("Q") || string4.matches(".*\\b[D]?(Me)?Gln")) {
                        vector.addElement("c " + rasmol_colors[8]);
                    } else if (string4.equals("L") || string4.matches(".*\\b[D]?(Me)?Leu") || string4.equals("I") || string4.matches(".*\\b[D]?(Me)?Ile") || string4.matches(".*\\b[D]?(Me)?Nle") || string4.matches(".*\\b[D]?(Me)?Cha") || string4.equals("V") || string4.matches(".*\\b[D]?(Me)?Val") || string4.matches(".*\\b[D]?(Me)?Nva")) {
                        vector.addElement("c " + rasmol_colors[9]);
                    } else if (string4.equals("W") || string4.matches(".*\\b[D]?(Me)?Trp")) {
                        vector.addElement("c " + rasmol_colors[10]);
                    } else if (string4.equals("P") || string4.matches(".*\\b[D]?(Me)?Pro")) {
                        vector.addElement("c " + rasmol_colors[11]);
                    } else {
                        vector.addElement("c " + colortable[0]);
                    }
                } else if (atom.symbol.equals("R") && 0 != (n3 & 4)) {
                    String string5 = atom.getStringProperty("A");
                    if (string5 == null) {
                        vector.addElement("c " + colortable[0]);
                    } else if (string5.equals("G") || string5.matches(".*\\bGly")) {
                        vector.addElement("c " + clustal_colors[0]);
                    } else if (string5.equals("P") || string5.matches(".*\\b[D]?(Me)?Pro")) {
                        vector.addElement("c " + clustal_colors[1]);
                    } else if (string5.equals("A") || string5.matches(".*\\b[D]?(Me)?Ala") || string5.equals("I") || string5.matches(".*\\b[D]?(Me)?Ile") || string5.equals("L") || string5.matches(".*\\b[D]?(Me)?Leu") || string5.equals("M") || string5.matches(".*\\b[D]?(Me)?Met") || string5.equals("F") || string5.matches(".*\\b[D]?(Me)?Phe") || string5.equals("W") || string5.matches(".*\\b[D]?(Me)?Trp") || string5.equals("V") || string5.matches(".*\\b[D]?(Me)?Val")) {
                        vector.addElement("c " + clustal_colors[2]);
                    } else if (string5.equals("R") || string5.matches(".*\\b[D]?(Me)?Arg") || string5.equals("K") || string5.matches(".*\\b[D]?(Me)?Lys")) {
                        vector.addElement("c " + clustal_colors[3]);
                    } else if (string5.equals("N") || string5.matches(".*\\b[D]?(Me)?Asn") || string5.equals("Q") || string5.matches(".*\\b[D]?(Me)?Gln") || string5.equals("S") || string5.matches(".*\\b[D]?(Me)?Ser") || string5.equals("T") || string5.matches(".*\\b[D]?(Me)?Thr")) {
                        vector.addElement("c " + clustal_colors[4]);
                    } else if (string5.equals("C") || string5.matches(".*\\b[D]?(Me)?Cys")) {
                        vector.addElement("c " + clustal_colors[5]);
                    } else if (string5.equals("E") || string5.matches(".*\\b[D]?(Me)?Glu") || string5.equals("D") || string5.matches(".*\\b[D]?(Me)?Asp")) {
                        vector.addElement("c " + clustal_colors[6]);
                    } else if (string5.equals("H") || string5.matches(".*\\b[D]?(Me)?His") || string5.equals("Y") || string5.matches(".*\\b[D]?(Me)?Tyr")) {
                        vector.addElement("c " + clustal_colors[7]);
                    } else {
                        vector.addElement("c " + colortable[0]);
                    }
                } else if (!atom.symbol.equals("C")) {
                    vector.addElement("c " + colortable[6]);
                } else {
                    bl = false;
                }
            } else if ((n3 & 1) != 0 && nArray != null) {
                bl = !colortable[nArray[n4]].equals(colortable[0]);
                vector.addElement("c " + colortable[nArray[n4]]);
            }
            if (stringArray != null && stringArray[n4] != null && !stringArray[n4].equals("")) {
                string3 = stringArray[n4];
            } else if (atom.isotope != 0 && atom.symbol.equals("H")) {
                string3 = atom.isotope == 2 ? "D" : (atom.isotope == 3 ? "T" : string);
                System.err.println("Setting atom symbol = " + string3);
            } else {
                string3 = string;
            }
            if (n16 != 0 || atom.radical != 0 || atom.isotope != 0 && !atom.symbol.equals("H")) {
                vector.addElement("t " + string2 + "01 " + this.worldToMetaX(atom.x) + " " + this.worldToMetaY(atom.y) + " " + string3 + " " + this.AttributesToString(n16, atom.radical, atom.isotope));
            } else {
                vector.addElement("t " + string2 + "0 " + this.worldToMetaX(atom.x) + " " + this.worldToMetaY(atom.y) + " " + string3);
            }
            if (!bl || (n3 & 1) == 0) continue;
            vector.addElement("c " + colortable[0]);
        }
        for (n4 = 0; n4 < molecule.bonds.length; ++n4) {
            bond = molecule.bonds[n4];
            if (bond.stereo_symbol != 4 && (bond.bond_type != 2 || bond.stereo_symbol != 3)) continue;
            n8 = this.worldToMetaX(molecule.atoms[bond.atoms[0] - 1].x);
            n7 = this.worldToMetaY(molecule.atoms[bond.atoms[0] - 1].y);
            n6 = this.worldToMetaX(molecule.atoms[bond.atoms[1] - 1].x);
            n5 = this.worldToMetaY(molecule.atoms[bond.atoms[1] - 1].y);
            vector.addElement("t 0 " + (n8 + n6) / 2 + " " + (n7 + n5) / 2 + " ?");
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = vector.elementAt(i).toString();
        }
        return stringArray2;
    }
}

