/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.io.IOException;
import java.util.Vector;
import novartis.chemistry.molecule.Atom;
import novartis.chemistry.molecule.AtomConstraint;
import novartis.chemistry.molecule.Bond;
import novartis.chemistry.molecule.PTable;
import novartis.chemistry.molecule.SetProperty;
import novartis.chemistry.molecule.StereoDescription;
import novartis.utilities.CountedBitSet;
import novartis.utilities.FortranInputStream;
import novartis.utilities.Graph;
import novartis.utilities.HigherMath;

public class Molecule {
    boolean being_modified = false;
    Atom[] atoms = null;
    Bond[] bonds = null;
    StereoDescription[] stereodescs = null;
    SetProperty[] setprops = null;
    CountedBitSet[] ringlist = null;

    public int getNAtoms() {
        if (this.atoms == null) {
            return 0;
        }
        return this.atoms.length;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Object clone() {
        int n;
        Molecule molecule = new Molecule();
        if (this.atoms != null) {
            molecule.atoms = new Atom[this.atoms.length];
            for (n = 0; n < this.atoms.length; ++n) {
                molecule.atoms[n] = (Atom)this.atoms[n].clone();
            }
        }
        if (this.bonds != null) {
            molecule.bonds = new Bond[this.bonds.length];
            for (n = 0; n < this.bonds.length; ++n) {
                molecule.bonds[n] = (Bond)this.bonds[n].clone();
            }
        }
        if (this.stereodescs != null) {
            molecule.stereodescs = new StereoDescription[this.stereodescs.length];
            for (n = 0; n < this.stereodescs.length; ++n) {
                molecule.stereodescs[n] = (StereoDescription)this.stereodescs[n].clone(molecule);
            }
        }
        if (this.setprops != null) {
            molecule.setprops = new SetProperty[this.setprops.length];
            for (n = 0; n < this.setprops.length; ++n) {
                molecule.setprops[n] = (SetProperty)this.setprops[n].clone();
            }
        }
        return molecule;
    }

    public void resetColors() {
        int n;
        for (n = 0; this.atoms != null && n < this.atoms.length; ++n) {
            this.atoms[n].color = 0;
        }
        for (n = 0; this.bonds != null && n < this.bonds.length; ++n) {
            this.bonds[n].color = 0;
        }
    }

    public void recolor() {
        int n;
        int n2 = 1;
        for (n = 0; n < this.atoms.length; ++n) {
            this.atoms[n].color = n2++;
        }
        for (n = 0; n < this.bonds.length; ++n) {
            this.bonds[n].color = n2++;
        }
    }

    public int floodColor(Atom atom, int n) {
        atom.color = n;
        int n2 = 1;
        for (int i = 0; i < atom.neighbour_atoms.length; ++i) {
            if (atom.neighbour_atoms[i].color != 0 || (atom.neighbour_bonds[i].flags & 0x100) != 0) continue;
            n2 += this.floodColor(atom.neighbour_atoms[i], n);
        }
        return n2;
    }

    public int floodClearColor(Atom atom, int n) {
        if (atom.color != n) {
            return 0;
        }
        atom.color = 0;
        int n2 = 1;
        for (int i = 0; i < atom.neighbour_atoms.length; ++i) {
            if (atom.neighbour_atoms[i].color != n || (atom.neighbour_bonds[i].flags & 0x100) != 0) continue;
            n2 += this.floodClearColor(atom.neighbour_atoms[i], n);
        }
        return n2;
    }

    public int[] removeAtomColors() {
        int[] nArray = new int[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            nArray[i] = this.atoms[i].color;
            this.atoms[i].color = 0;
        }
        return nArray;
    }

    public void restoreAtomColors(int[] nArray) {
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i].color = nArray[i];
        }
    }

    public void removePerceivedInformation() {
        if (this.atoms != null) {
            for (int i = 0; i < this.atoms.length; ++i) {
                this.atoms[i].neighbour_atoms = null;
                this.atoms[i].neighbour_bonds = null;
            }
        }
        this.ringlist = null;
    }

    public void setupNeighbourhood() {
        int n;
        if (this.atoms == null || this.bonds == null) {
            return;
        }
        int[] nArray = new int[this.atoms.length];
        int[] nArray2 = new int[this.bonds.length];
        for (n = 0; n < this.bonds.length; ++n) {
            int n2 = this.bonds[n].atoms[0] - 1;
            nArray[n2] = nArray[n2] + 1;
            int n3 = this.bonds[n].atoms[1] - 1;
            nArray[n3] = nArray[n3] + 1;
        }
        for (n = 0; n < this.atoms.length; ++n) {
            this.atoms[n].index = n;
            this.atoms[n].neighbour_atoms = new Atom[nArray[n]];
            this.atoms[n].neighbour_bonds = new Bond[nArray[n]];
            nArray[n] = 0;
        }
        for (n = 0; n < this.bonds.length; ++n) {
            this.atoms[this.bonds[n].atoms[0] - 1].neighbour_atoms[nArray[this.bonds[n].atoms[0] - 1]] = this.atoms[this.bonds[n].atoms[1] - 1];
            this.atoms[this.bonds[n].atoms[0] - 1].neighbour_bonds[nArray[this.bonds[n].atoms[0] - 1]] = this.bonds[n];
            this.atoms[this.bonds[n].atoms[1] - 1].neighbour_atoms[nArray[this.bonds[n].atoms[1] - 1]] = this.atoms[this.bonds[n].atoms[0] - 1];
            this.atoms[this.bonds[n].atoms[1] - 1].neighbour_bonds[nArray[this.bonds[n].atoms[1] - 1]] = this.bonds[n];
            int n4 = this.bonds[n].atoms[0] - 1;
            nArray[n4] = nArray[n4] + 1;
            int n5 = this.bonds[n].atoms[1] - 1;
            nArray[n5] = nArray[n5] + 1;
        }
        for (n = 0; n < this.bonds.length; ++n) {
            int n6;
            int n7 = this.bonds[n].atoms[0] - 1;
            int n8 = this.bonds[n].atoms[1] - 1;
            nArray2[n] = this.atoms[this.bonds[n].atoms[0] - 1].neighbour_atoms.length + this.atoms[this.bonds[n].atoms[1] - 1].neighbour_atoms.length - 2;
            this.bonds[n].neighbourbonds = new Bond[nArray2[n]];
            nArray2[n] = 0;
            for (n6 = 0; n6 < nArray[this.bonds[n].atoms[0] - 1]; ++n6) {
                if (n7 == this.atoms[this.bonds[n].atoms[0] - 1].neighbour_bonds[n6].atoms[0] - 1 && n8 == this.atoms[this.bonds[n].atoms[0] - 1].neighbour_bonds[n6].atoms[1] - 1) continue;
                this.bonds[n].neighbourbonds[nArray2[n]] = this.atoms[this.bonds[n].atoms[0] - 1].neighbour_bonds[n6];
                int n9 = n;
                nArray2[n9] = nArray2[n9] + 1;
            }
            for (n6 = 0; n6 < nArray[this.bonds[n].atoms[1] - 1]; ++n6) {
                if (n7 == this.atoms[this.bonds[n].atoms[1] - 1].neighbour_bonds[n6].atoms[0] - 1 && n8 == this.atoms[this.bonds[n].atoms[1] - 1].neighbour_bonds[n6].atoms[1] - 1) continue;
                this.bonds[n].neighbourbonds[nArray2[n]] = this.atoms[this.bonds[n].atoms[1] - 1].neighbour_bonds[n6];
                int n10 = n;
                nArray2[n10] = nArray2[n10] + 1;
            }
        }
    }

    public void clearTopography() {
        int n;
        for (n = 0; n < this.atoms.length; ++n) {
            this.atoms[n].topography = 2;
        }
        for (n = 0; n < this.bonds.length; ++n) {
            this.bonds[n].topography = 0;
            this.bonds[n].ring_sizes = 0;
        }
    }

    public void perceiveRingBonds() {
        CountedBitSet countedBitSet;
        int n;
        Graph graph = new Graph(this.bonds);
        if (this.ringlist == null) {
            this.ringlist = graph.ringList();
            this.ringlist = graph.combineRings(this.ringlist);
        }
        for (n = 1; n < this.ringlist.length; ++n) {
            for (int i = n; i > 0 && (this.ringlist[i].getCardinality() == 6 && this.ringlist[i - 1].getCardinality() != 6 || this.ringlist[i].getCardinality() < this.ringlist[i - 1].getCardinality()); --i) {
                countedBitSet = this.ringlist[i];
                this.ringlist[i] = this.ringlist[i - 1];
                this.ringlist[i - 1] = countedBitSet;
            }
        }
        for (n = 0; n < this.atoms.length; ++n) {
            this.atoms[n].topography = 2;
        }
        for (n = 0; n < this.bonds.length; ++n) {
            this.bonds[n].topography = 2;
            this.bonds[n].ring_sizes = 0;
        }
        for (int i = 0; i < this.ringlist.length; ++i) {
            countedBitSet = this.ringlist[i];
            for (n = 0; n < this.bonds.length; ++n) {
                if (!countedBitSet.get(n)) continue;
                this.bonds[n].topography = 1;
                this.bonds[n].ring_sizes |= 1 << Math.min(15, countedBitSet.getCardinality());
                this.atoms[this.bonds[n].atoms[0] - 1].topography = 1;
                this.atoms[this.bonds[n].atoms[1] - 1].topography = 1;
            }
        }
    }

    public void makeRingsClockwise() {
        this.perceiveRingBonds();
        if (this.ringlist == null) {
            return;
        }
        for (int i = this.ringlist.length - 1; i >= 0; --i) {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                CountedBitSet countedBitSet = this.ringlist[i];
                int[][] nArrayArray = new int[this.bonds.length][];
                int n5 = 0;
                for (n4 = 0; n4 < this.bonds.length; ++n4) {
                    if (!countedBitSet.get(n4)) continue;
                    nArrayArray[n5] = new int[2];
                    nArrayArray[n5][0] = this.bonds[n4].atoms[0];
                    nArrayArray[n5][1] = this.bonds[n4].atoms[1];
                    ++n5;
                }
                int[] nArray = new int[n5];
                nArray[0] = nArrayArray[0][0];
                nArray[1] = nArrayArray[0][1];
                block4: for (n4 = 2; n4 < n5; ++n4) {
                    for (n3 = 1; n3 < n5; ++n3) {
                        if (nArrayArray[n3][0] == nArray[n4 - 1] && nArrayArray[n3][1] != nArray[n4 - 2]) {
                            nArray[n4] = nArrayArray[n3][1];
                            continue block4;
                        }
                        if (nArrayArray[n3][1] != nArray[n4 - 1] || nArrayArray[n3][0] == nArray[n4 - 2]) continue;
                        nArray[n4] = nArrayArray[n3][0];
                        continue block4;
                    }
                }
                double d = 0.0;
                for (n4 = 0; n4 < n5; ++n4) {
                    n2 = nArray[n4];
                    n = nArray[(n4 + 1) % n5];
                    int n6 = nArray[(n4 + 2) % n5];
                    d += HigherMath.Angle(this.atoms[n2 - 1].x - this.atoms[n - 1].x, this.atoms[n2 - 1].y - this.atoms[n - 1].y, this.atoms[n6 - 1].x - this.atoms[n - 1].x, this.atoms[n6 - 1].y - this.atoms[n - 1].y);
                }
                if (d > ((double)n5 - 1.5) * Math.PI) {
                    for (n4 = 0; n4 < n5 / 2; ++n4) {
                        n3 = nArray[n4];
                        nArray[n4] = nArray[n5 - 1 - n4];
                        nArray[n5 - 1 - n4] = n3;
                    }
                }
                block8: for (n4 = 0; n4 < n5; ++n4) {
                    n2 = nArray[n4];
                    n = nArray[(n4 + 1) % n5];
                    for (n3 = 0; n3 < this.bonds.length; ++n3) {
                        Bond bond = this.bonds[n3];
                        if (bond.atoms[1] != n2 || bond.atoms[0] != n || bond.stereo_symbol != 0) continue;
                        bond.atoms[0] = n2;
                        bond.atoms[1] = n;
                        continue block8;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                System.err.println("Warning: makeRingsClockwise failed on ring " + i + " of " + this.ringlist.length + " rings");
            }
        }
    }

    public void readMDLCTable(FortranInputStream fortranInputStream) throws IOException {
        int n;
        int n2 = fortranInputStream.i(3);
        int n3 = fortranInputStream.i(3);
        int n4 = fortranInputStream.i(3);
        fortranInputStream.x(3);
        int n5 = fortranInputStream.i(3);
        int n6 = fortranInputStream.i(3);
        fortranInputStream.x(12);
        int n7 = fortranInputStream.i(3);
        String string = fortranInputStream.a(6);
        fortranInputStream.getBuffer();
        this.atoms = new Atom[n2];
        for (n = 0; n < n2; ++n) {
            this.atoms[n] = this.parseMDLAtom(fortranInputStream);
            fortranInputStream.getBuffer();
        }
        this.bonds = new Bond[n3];
        for (n = 0; n < n3; ++n) {
            this.bonds[n] = this.parseMDLBond(fortranInputStream);
            fortranInputStream.getBuffer();
        }
        for (n = 0; n < n4; ++n) {
            int n8 = fortranInputStream.i(3);
            boolean bl = fortranInputStream.a(2).trim().equals("T");
            int n9 = fortranInputStream.i(5);
            String[] stringArray = new String[n9];
            for (int i = 0; i < n9; ++i) {
                stringArray[i] = PTable.AtomicNumberToSymbol(fortranInputStream.i(4));
            }
            this.atoms[n8 - 1].atomList = stringArray;
            this.atoms[n8 - 1].notLogic = bl;
            fortranInputStream.getBuffer();
        }
        for (n = 0; n < n6; ++n) {
            fortranInputStream.getBuffer();
        }
        if (!string.equals("")) {
            n7 = Integer.MAX_VALUE;
        }
        this.readProperties(fortranInputStream, n7);
    }

    public Atom parseMDLAtom(FortranInputStream fortranInputStream) {
        int n = -1;
        double d = fortranInputStream.f(10);
        double d2 = fortranInputStream.f(10);
        double d3 = fortranInputStream.f(10);
        fortranInputStream.x(1);
        String string = fortranInputStream.a(3);
        int n2 = fortranInputStream.i(2);
        int n3 = fortranInputStream.i(3);
        fortranInputStream.x(21);
        int n4 = fortranInputStream.i(3);
        return new Atom(d, d2, d3, string, null, false, n, PTable.mdiffToIsotope(string, n2), Atom.MDLChargeRadicalToCharge(n3), Atom.MDLChargeRadicalToRadical(n3), n4);
    }

    public Bond parseMDLBond(FortranInputStream fortranInputStream) {
        int n = fortranInputStream.i(3);
        int n2 = fortranInputStream.i(3);
        int n3 = fortranInputStream.i(3);
        int n4 = fortranInputStream.i(3);
        fortranInputStream.x(3);
        int n5 = fortranInputStream.i(3);
        int n6 = fortranInputStream.i(3);
        return new Bond(n, n2, Bond.interpretMDLBondType(n3), Bond.interpretMDLStereoSymbol(n4), Bond.interpretMDLTopography(n5), Bond.interpretMDLReactionMark(n6));
    }

    protected void readProperties(FortranInputStream fortranInputStream, int n) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (fortranInputStream.buffer != null && !fortranInputStream.buffer.startsWith("M  END")) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (fortranInputStream.buffer.startsWith("G  ")) {
                n -= 2;
                fortranInputStream.getBuffer();
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("A  ")) {
                n -= 2;
                fortranInputStream.x(3);
                n5 = fortranInputStream.i(3);
                fortranInputStream.getBuffer();
                this.atoms[n5 - 1].setStringProperty("A", fortranInputStream.a(80).trim());
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("V  ")) {
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("S  SKP")) {
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                n -= n5;
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.getBuffer();
                }
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  CHG")) {
                if (!bl) {
                    bl = true;
                    for (n5 = 0; n5 < this.atoms.length; ++n5) {
                        this.atoms[n5].charge = 0;
                    }
                }
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.x(1);
                    n3 = fortranInputStream.i(3);
                    fortranInputStream.x(1);
                    this.atoms[n3 - 1].charge = n2 = fortranInputStream.i(3);
                }
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  SUB")) {
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.x(1);
                    n3 = fortranInputStream.i(3);
                    fortranInputStream.x(1);
                    n2 = fortranInputStream.i(3);
                    this.atoms[n3 - 1].setIntProperty("SUB", n2);
                }
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  ALS")) {
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  ISO")) {
                if (!bl3) {
                    bl3 = true;
                    for (n5 = 0; n5 < this.atoms.length; ++n5) {
                        this.atoms[n5].isotope = 0;
                    }
                }
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.x(1);
                    n3 = fortranInputStream.i(3);
                    fortranInputStream.x(1);
                    this.atoms[n3 - 1].isotope = n2 = fortranInputStream.i(3);
                }
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  RGP")) {
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.x(1);
                    n3 = fortranInputStream.i(3);
                    fortranInputStream.x(1);
                    n2 = fortranInputStream.i(3);
                    this.atoms[n3 - 1].setIntProperty("RGP", n2);
                }
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            if (fortranInputStream.buffer.startsWith("M  RAD")) {
                if (!bl2) {
                    bl2 = true;
                    for (n5 = 0; n5 < this.atoms.length; ++n5) {
                        this.atoms[n5].radical = 0;
                    }
                }
                fortranInputStream.x(6);
                n5 = fortranInputStream.i(3);
                for (n4 = 0; n4 < n5; ++n4) {
                    fortranInputStream.x(1);
                    n3 = fortranInputStream.i(3);
                    fortranInputStream.x(1);
                    n2 = fortranInputStream.i(3);
                    if (n2 >= 3) {
                        n2 = 4;
                    }
                    this.atoms[n3 - 1].radical = n2;
                }
                --n;
                fortranInputStream.getBuffer();
                continue;
            }
            --n;
            fortranInputStream.getBuffer();
        }
    }

    public void modifyOn() {
        this.being_modified = true;
        this.removePerceivedInformation();
    }

    public void modifyOff() {
        this.being_modified = false;
    }

    public int[] ComputeImplicitH() {
        int n;
        int[] nArray = new int[this.atoms.length + 1];
        int[] nArray2 = new int[this.atoms.length + 1];
        int[] nArray3 = new int[this.atoms.length + 1];
        int[] nArray4 = new int[this.atoms.length + 1];
        int[] nArray5 = new int[this.atoms.length + 1];
        int[] nArray6 = new int[this.atoms.length + 1];
        int[] nArray7 = new int[this.atoms.length + 1];
        for (n = 0; n < this.atoms.length; ++n) {
            nArray6[n + 1] = this.atoms[n].radical;
            nArray7[n + 1] = this.atoms[n].charge;
        }
        for (n = 0; n <= this.atoms.length; ++n) {
            nArray5[n] = 0;
            nArray4[n] = 0;
            nArray3[n] = 0;
            nArray2[n] = 0;
        }
        block8: for (n = 0; n < this.bonds.length; ++n) {
            Bond bond = this.bonds[n];
            switch (bond.bond_type) {
                case 2: {
                    int n2 = bond.atoms[0];
                    nArray2[n2] = nArray2[n2] + 1;
                    int n3 = bond.atoms[1];
                    nArray2[n3] = nArray2[n3] + 1;
                    continue block8;
                }
                case 4: {
                    int n4 = bond.atoms[0];
                    nArray4[n4] = nArray4[n4] + 1;
                    int n5 = bond.atoms[1];
                    nArray4[n5] = nArray4[n5] + 1;
                    continue block8;
                }
                case 8: {
                    int n6 = bond.atoms[0];
                    nArray5[n6] = nArray5[n6] + 1;
                    int n7 = bond.atoms[1];
                    nArray5[n7] = nArray5[n7] + 1;
                    continue block8;
                }
                case 16: {
                    int n8 = bond.atoms[0];
                    nArray3[n8] = nArray3[n8] + 1;
                    int n9 = bond.atoms[1];
                    nArray3[n9] = nArray3[n9] + 1;
                    continue block8;
                }
                default: {
                    int n10 = bond.atoms[0];
                    nArray2[n10] = nArray2[n10] + 1;
                    int n11 = bond.atoms[1];
                    nArray2[n11] = nArray2[n11] + 1;
                }
            }
        }
        for (n = 0; n < this.atoms.length; ++n) {
            nArray[n + 1] = PTable.implicitHydrogens(this.atoms[n].symbol, nArray2[n + 1], nArray3[n + 1], nArray4[n + 1], nArray5[n + 1], nArray6[n + 1], nArray7[n + 1]);
            if (this.atoms[n].implicit_H_count <= nArray[n + 1]) continue;
            nArray[n + 1] = this.atoms[n].implicit_H_count;
        }
        return nArray;
    }

    public void flipStereoSymbols(int n) {
        for (int i = 0; i < this.bonds.length; ++i) {
            Bond bond = this.bonds[i];
            if (n != 0 && (this.atoms[bond.atoms[0] - 1].color != n || this.atoms[bond.atoms[1] - 1].color != n)) continue;
            if (bond.stereo_symbol == 1) {
                bond.stereo_symbol = 2;
                continue;
            }
            if (bond.stereo_symbol != 2) continue;
            bond.stereo_symbol = 1;
        }
    }

    public void flipMolecule(int n) {
        int n2;
        double d = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < this.atoms.length; ++n2) {
            if (n != 0 && this.atoms[n2].color != n) continue;
            d += this.atoms[n2].x;
            ++n3;
        }
        if (n3 == 0) {
            return;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < this.atoms.length; ++n2) {
            if (n != 0 && this.atoms[n2].color != n) continue;
            this.atoms[n2].x = d - this.atoms[n2].x;
        }
        this.flipStereoSymbols(n);
    }

    public int[][] getColoredEdges(int n, int[] nArray) {
        int n2;
        int n3;
        Vector<int[]> vector = new Vector<int[]>();
        for (n3 = 0; n3 < this.bonds.length; ++n3) {
            Bond bond = this.bonds[n3];
            if ((bond.flags & 0x100) != 0 || this.atoms[bond.atoms[0] - 1].color != n || this.atoms[bond.atoms[1] - 1].color != n) continue;
            vector.addElement(bond.getAtomNumbers());
        }
        n3 = 0;
        for (n2 = 0; n2 < this.atoms.length; ++n2) {
            if (this.atoms[n2].color != n) continue;
            nArray[n2] = n3++;
        }
        int[][] nArrayArray = new int[vector.size()][];
        for (n2 = 0; n2 < nArrayArray.length; ++n2) {
            nArrayArray[n2] = (int[])vector.elementAt(n2);
            nArrayArray[n2][0] = nArray[nArrayArray[n2][0] - 1];
            nArrayArray[n2][1] = nArray[nArrayArray[n2][1] - 1];
        }
        return nArrayArray;
    }

    public double[][] getColoredCoordinates(int n, int[] nArray) {
        Vector<double[]> vector = new Vector<double[]>();
        int n2 = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i].color != n) continue;
            double[] dArray = new double[]{this.atoms[i].x, this.atoms[i].y};
            vector.addElement(dArray);
            nArray[i] = n2++;
        }
        double[][] dArrayArray = new double[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            dArrayArray[i] = (double[])vector.elementAt(i);
        }
        return dArrayArray;
    }

    public int countColor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i].color != n) continue;
            ++n2;
        }
        return n2;
    }

    public boolean denormalize() {
        boolean bl = true;
        this.setupNeighbourhood();
        this.perceiveRingBonds();
        AtomConstraint[] atomConstraintArray = this.perceiveAtomConstraints();
        this.colorNormalizedFragments();
        for (int i = 0; i < this.atoms.length; ++i) {
            Atom atom = this.atoms[i];
            if (!atomConstraintArray[i].is_open) continue;
            Bond[] bondArray = this.denormalizeStep(this.bonds, atomConstraintArray, atom.color);
            if (bondArray != null) {
                this.bonds = bondArray;
            }
            for (int j = 0; j < atomConstraintArray.length; ++j) {
                if (this.atoms[j].color != atom.color) continue;
                atomConstraintArray[j].is_open = false;
            }
        }
        return bl;
    }

    boolean refineBonds(Bond[] bondArray, AtomConstraint[] atomConstraintArray, int n) {
        boolean bl;
        Object object;
        int n2;
        int[] nArray = new int[this.atoms.length];
        int[] nArray2 = new int[this.atoms.length];
        int[] nArray3 = new int[this.atoms.length];
        int[] nArray4 = new int[this.atoms.length];
        for (n2 = 0; n2 < bondArray.length; ++n2) {
            object = bondArray[n2];
            if (((Bond)object).bond_type == 2) {
                int n3 = ((Bond)object).atoms[0] - 1;
                nArray[n3] = nArray[n3] + 1;
                int n4 = ((Bond)object).atoms[1] - 1;
                nArray[n4] = nArray[n4] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 4) {
                int n5 = ((Bond)object).atoms[0] - 1;
                nArray2[n5] = nArray2[n5] + 1;
                int n6 = ((Bond)object).atoms[1] - 1;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 8) {
                int n7 = ((Bond)object).atoms[0] - 1;
                nArray3[n7] = nArray3[n7] + 1;
                int n8 = ((Bond)object).atoms[1] - 1;
                nArray3[n8] = nArray3[n8] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 1) continue;
            int n9 = ((Bond)object).atoms[0] - 1;
            nArray4[n9] = nArray4[n9] + 1;
            int n10 = ((Bond)object).atoms[1] - 1;
            nArray4[n10] = nArray4[n10] + 1;
        }
        do {
            bl = false;
            for (n2 = 0; n2 < this.atoms.length; ++n2) {
                Bond bond;
                int n11;
                object = this.atoms[n2];
                if (((Atom)object).color != n) continue;
                if (nArray4[n2] == 0 && (nArray2[n2] < atomConstraintArray[n2].dbl_min || nArray2[n2] > atomConstraintArray[n2].dbl_max)) {
                    return false;
                }
                if (nArray4[n2] != 0 && nArray2[n2] == atomConstraintArray[n2].dbl_max) {
                    bl = true;
                    for (n11 = 0; n11 < bondArray.length; ++n11) {
                        bond = bondArray[n11];
                        if (bond.atoms[0] - 1 != n2 && bond.atoms[1] - 1 != n2 || bond.bond_type != 16 && bond.bond_type != 6) continue;
                        bond.bond_type = 2;
                        int n12 = bond.atoms[0] - 1;
                        nArray4[n12] = nArray4[n12] - 1;
                        int n13 = bond.atoms[0] - 1;
                        nArray[n13] = nArray[n13] + 1;
                        int n14 = bond.atoms[1] - 1;
                        nArray4[n14] = nArray4[n14] - 1;
                        int n15 = bond.atoms[1] - 1;
                        nArray[n15] = nArray[n15] + 1;
                    }
                    continue;
                }
                if (nArray4[n2] == 0 || nArray2[n2] + nArray4[n2] != atomConstraintArray[n2].dbl_min) continue;
                bl = true;
                for (n11 = 0; n11 < bondArray.length; ++n11) {
                    bond = bondArray[n11];
                    if (bond.atoms[0] - 1 != n2 && bond.atoms[1] - 1 != n2 || bond.bond_type != 16 && bond.bond_type != 6) continue;
                    bond.bond_type = 4;
                    int n16 = bond.atoms[1] - 1;
                    nArray4[n16] = nArray4[n16] - 1;
                    int n17 = bond.atoms[1] - 1;
                    nArray2[n17] = nArray2[n17] + 1;
                    int n18 = bond.atoms[0] - 1;
                    nArray4[n18] = nArray4[n18] - 1;
                    int n19 = bond.atoms[0] - 1;
                    nArray2[n19] = nArray2[n19] + 1;
                }
            }
        } while (bl);
        return true;
    }

    int compareDenormalizations(Bond[] bondArray, Bond[] bondArray2) {
        if (bondArray2 == null) {
            return 1;
        }
        if (bondArray == null) {
            return -1;
        }
        return 1;
    }

    Bond[] denormalizeStep(Bond[] bondArray, AtomConstraint[] atomConstraintArray, int n) {
        if (bondArray == null) {
            return null;
        }
        if (!this.refineBonds(bondArray, atomConstraintArray, n)) {
            return null;
        }
        for (int i = 0; i < bondArray.length; ++i) {
            Bond bond = bondArray[i];
            if (bond.bond_type != 16 && bond.bond_type != 6 || bond.color != n) continue;
            Bond[] bondArray2 = new Bond[bondArray.length];
            for (int j = 0; j < bondArray.length; ++j) {
                bondArray2[j] = (Bond)bondArray[j].clone();
            }
            bondArray2[i].bond_type = 2;
            if ((bondArray2 = this.denormalizeStep(bondArray2, atomConstraintArray, n)) != null) {
                return bondArray2;
            }
            Bond[] bondArray3 = new Bond[bondArray.length];
            for (int j = 0; j < bondArray.length; ++j) {
                bondArray3[j] = (Bond)bondArray[j].clone();
            }
            bondArray3[i].bond_type = 4;
            if ((bondArray3 = this.denormalizeStep(bondArray3, atomConstraintArray, n)) != null) {
                return bondArray3;
            }
            if (bondArray2 != null || bondArray3 != null) continue;
            return null;
        }
        return bondArray;
    }

    void colorNormalizedFragments() {
        this.recolor();
        for (int i = 0; i < this.bonds.length; ++i) {
            int n;
            Bond bond = this.bonds[i];
            if (bond.bond_type != 16 && bond.bond_type != 6 && bond.bond_type != 3) continue;
            int n2 = this.atoms[bond.atoms[0] - 1].color;
            int n3 = this.atoms[bond.atoms[1] - 1].color;
            int n4 = bond.color;
            int n5 = Math.max(n2, Math.max(n3, n4));
            if (n2 == n3 && n2 == n4) continue;
            for (n = 0; n < this.atoms.length; ++n) {
                if (this.atoms[n].color != n2 && this.atoms[n].color != n3 && this.atoms[n].color != n4) continue;
                this.atoms[n].color = n5;
            }
            for (n = 0; n < this.bonds.length; ++n) {
                if (this.bonds[n].color != n2 && this.bonds[n].color != n3 && this.bonds[n].color != n4) continue;
                this.bonds[n].color = n5;
            }
        }
    }

    AtomConstraint[] perceiveAtomConstraints() {
        Object object;
        int n;
        AtomConstraint[] atomConstraintArray = new AtomConstraint[this.atoms.length];
        int[] nArray = new int[this.atoms.length];
        int[] nArray2 = new int[this.atoms.length];
        int[] nArray3 = new int[this.atoms.length];
        int[] nArray4 = new int[this.atoms.length];
        for (n = 0; n < this.bonds.length; ++n) {
            object = this.bonds[n];
            if (((Bond)object).bond_type == 2) {
                int n2 = ((Bond)object).atoms[0] - 1;
                nArray[n2] = nArray[n2] + 1;
                int n3 = ((Bond)object).atoms[1] - 1;
                nArray[n3] = nArray[n3] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 4) {
                int n4 = ((Bond)object).atoms[0] - 1;
                nArray2[n4] = nArray2[n4] + 1;
                int n5 = ((Bond)object).atoms[1] - 1;
                nArray2[n5] = nArray2[n5] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 8) {
                int n6 = ((Bond)object).atoms[0] - 1;
                nArray3[n6] = nArray3[n6] + 1;
                int n7 = ((Bond)object).atoms[1] - 1;
                nArray3[n7] = nArray3[n7] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 16) {
                int n8 = ((Bond)object).atoms[0] - 1;
                nArray4[n8] = nArray4[n8] + 1;
                int n9 = ((Bond)object).atoms[1] - 1;
                nArray4[n9] = nArray4[n9] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 6) {
                int n10 = ((Bond)object).atoms[0] - 1;
                nArray4[n10] = nArray4[n10] + 1;
                int n11 = ((Bond)object).atoms[1] - 1;
                nArray4[n11] = nArray4[n11] + 1;
                continue;
            }
            if (((Bond)object).bond_type == 1) continue;
            if ((((Bond)object).bond_type & 8) != 0) {
                int n12 = ((Bond)object).atoms[0] - 1;
                nArray3[n12] = nArray3[n12] + 1;
                int n13 = ((Bond)object).atoms[1] - 1;
                nArray3[n13] = nArray3[n13] + 1;
                continue;
            }
            if ((((Bond)object).bond_type & 4) != 0) {
                int n14 = ((Bond)object).atoms[0] - 1;
                nArray2[n14] = nArray2[n14] + 1;
                int n15 = ((Bond)object).atoms[1] - 1;
                nArray2[n15] = nArray2[n15] + 1;
                continue;
            }
            if ((((Bond)object).bond_type & 0x10) != 0) {
                int n16 = ((Bond)object).atoms[0] - 1;
                nArray4[n16] = nArray4[n16] + 1;
                int n17 = ((Bond)object).atoms[1] - 1;
                nArray4[n17] = nArray4[n17] + 1;
                continue;
            }
            int n18 = ((Bond)object).atoms[0] - 1;
            nArray[n18] = nArray[n18] + 1;
            int n19 = ((Bond)object).atoms[1] - 1;
            nArray[n19] = nArray[n19] + 1;
        }
        for (n = 0; n < this.atoms.length; ++n) {
            object = this.atoms[n];
            atomConstraintArray[n] = new AtomConstraint(((Atom)object).symbol, nArray[n], nArray2[n], nArray3[n], nArray4[n], ((Atom)object).charge, ((Atom)object).radical, ((Atom)object).implicit_H_count);
        }
        return atomConstraintArray;
    }

    public static void perceiveReaction(Molecule molecule, Molecule molecule2) {
        int[] nArray;
        int n;
        Bond bond;
        int n2;
        int n3;
        int[] nArray2;
        Bond bond2;
        int n4;
        for (n4 = 0; n4 < molecule.bonds.length; ++n4) {
            bond2 = molecule.bonds[n4];
            nArray2 = bond2.getAtomNumbers();
            n3 = molecule.atoms[nArray2[0] - 1].reaction_mapping;
            n2 = molecule.atoms[nArray2[1] - 1].reaction_mapping;
            if (n3 == 0 && n2 != 0 || n3 != 0 && n2 == 0) {
                bond2.reaction_mark = 2;
                continue;
            }
            if (n3 == 0 || n2 == 0) continue;
            bond2.reaction_mark = 0;
            bond = null;
            for (n = 0; n < molecule2.bonds.length; ++n) {
                bond = molecule2.bonds[n];
                nArray = bond.getAtomNumbers();
                if (n3 == molecule2.atoms[nArray[0] - 1].reaction_mapping && n2 == molecule2.atoms[nArray[1] - 1].reaction_mapping || n3 == molecule2.atoms[nArray[1] - 1].reaction_mapping && n2 == molecule2.atoms[nArray[0] - 1].reaction_mapping) break;
            }
            if (n == molecule2.bonds.length) {
                bond2.reaction_mark = 2;
                continue;
            }
            if (bond2.bond_type == bond.bond_type) continue;
            bond2.reaction_mark = 1;
        }
        for (n4 = 0; n4 < molecule2.bonds.length; ++n4) {
            bond2 = molecule2.bonds[n4];
            nArray2 = bond2.getAtomNumbers();
            n3 = molecule2.atoms[nArray2[0] - 1].reaction_mapping;
            n2 = molecule2.atoms[nArray2[1] - 1].reaction_mapping;
            if (n3 == 0 && n2 != 0 || n3 != 0 && n2 == 0) {
                bond2.reaction_mark = 2;
                continue;
            }
            if (n3 == 0 || n2 == 0) continue;
            bond2.reaction_mark = 0;
            bond = null;
            for (n = 0; n < molecule.bonds.length; ++n) {
                bond = molecule.bonds[n];
                nArray = bond.getAtomNumbers();
                if (n3 == molecule.atoms[nArray[0] - 1].reaction_mapping && n2 == molecule.atoms[nArray[1] - 1].reaction_mapping || n3 == molecule.atoms[nArray[1] - 1].reaction_mapping && n2 == molecule.atoms[nArray[0] - 1].reaction_mapping) break;
            }
            if (n == molecule.bonds.length) {
                bond2.reaction_mark = 2;
                continue;
            }
            if (bond.bond_type == bond2.bond_type) continue;
            bond2.reaction_mark = 1;
        }
    }
}

