/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import novartis.chemistry.molecule.Layout;
import novartis.chemistry.molecule.Molecule;
import novartis.chemistry.molecule.MoleculeDepicter;
import novartis.chemistry.molecule.StandardMOL;
import novartis.utilities.FortranInputStream;
import novartis.utilities.MetaDraw;

public class MOLCanvas
extends JPanel {
    String molfile;
    String[] commands;
    boolean new_layout = false;
    boolean colored = true;
    Dimension minBox;
    Dimension myBox;
    MyJLabel noStructure = new MyJLabel("No Structure");

    public synchronized String[] getCommands() {
        return this.commands;
    }

    public void setColored(boolean bl) {
        this.colored = bl;
    }

    public boolean getColored() {
        return this.colored;
    }

    public MOLCanvas(String string, int n, int n2, boolean bl) {
        this.setOpaque(false);
        this.minBox = this.myBox = new Dimension(n, n2);
        this.molfile = string;
        this.new_layout = bl;
        this.setLayout(new BorderLayout());
        this.noStructure.setHorizontalAlignment(0);
        this.noStructure.setVerticalAlignment(0);
        this.noStructure.setForeground(Color.black);
        if (string == null) {
            this.add((Component)this.noStructure, "Center");
            this.noStructure.setVisible(true);
            return;
        }
        this.noStructure.setVisible(false);
        this.createDepictionCommands(string, null, "MOLCanvas");
        this.invalidate();
    }

    @Override
    public synchronized void setSize(int n, int n2) {
        this.myBox = new Dimension(Math.max(n, this.minBox.width), Math.max(n2, this.minBox.height));
        this.repaint();
    }

    private void createDepictionCommands(String string, int[] nArray, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            FortranInputStream fortranInputStream = new FortranInputStream(bufferedReader);
            StandardMOL standardMOL = new StandardMOL();
            standardMOL.readMOLFile(fortranInputStream);
            bufferedReader.close();
            standardMOL.recolor();
            Molecule molecule = this.new_layout ? Layout.layoutMolecule(standardMOL) : standardMOL;
            this.commands = new MoleculeDepicter().computeDepiction(molecule, 0, 0, 3, nArray, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string2 + ": Caught " + exception);
        }
    }

    public synchronized String getMOLFile() {
        return this.molfile;
    }

    public synchronized void setMOLFile(String string) {
        this.setMOLFile(string, null);
    }

    public synchronized void setMOLFile(String string, int[] nArray) {
        this.molfile = string;
        if (string != null && !string.equals("")) {
            if (string.startsWith("sRNA:")) {
                this.commands = null;
                this.noStructure.setText(string.substring(4, string.length()));
                this.noStructure.setVisible(true);
            } else {
                this.createDepictionCommands(string, nArray, "setMolFile");
            }
            this.noStructure.setVisible(false);
            this.invalidate();
        } else {
            this.commands = null;
            this.noStructure.setVisible(true);
            this.invalidate();
        }
        this.repaint();
    }

    public synchronized void setBlank() {
        this.molfile = null;
        this.commands = null;
        this.noStructure.setVisible(false);
        this.invalidate();
        this.repaint();
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        return this.minBox;
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        return this.minBox;
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.commands != null) {
            MetaDraw.depictCommands(graphics, this.commands, new Rectangle(this.getSize()), this.colored, false);
        }
        super.paintBorder(graphics);
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 0) {
            object2 = new BufferedReader(new InputStreamReader(System.in));
            while (null != (object = ((BufferedReader)object2).readLine())) {
                stringBuffer.append((String)object);
                stringBuffer.append("\n");
            }
        }
        object2 = new JFrame();
        ((Window)object2).setSize(400, 400);
        object = null;
        object = stringBuffer.length() > 0 ? new MOLCanvas(stringBuffer.toString(), 300, 300, false) : new MOLCanvas(null, 300, 300, false);
        ((JFrame)object2).getContentPane().add((Component)object);
        ((Window)object2).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        ((Window)object2).setVisible(true);
    }

    class MyJLabel
    extends JLabel {
        public MyJLabel(String string) {
            super(string);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }
}

