/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.util.Random;
import novartis.chemistry.molecule.Atom;
import novartis.chemistry.molecule.Bond;
import novartis.chemistry.molecule.FragmentDesc;
import novartis.chemistry.molecule.Molecule;
import novartis.chemistry.molecule.PTable;
import novartis.chemistry.molecule.RingNode;
import novartis.chemistry.molecule.StereoDescription;
import novartis.utilities.CountedBitSet;
import novartis.utilities.HigherMath;

public class Layout {
    public static final int DONT_FLIP_BOND = 512;
    public static final int RUBBER_BOND = 256;
    public static final int ATOM_USED = 1;
    public static final int KEEP_POSITION = 2;
    public static final double STDBOND = 1.514;
    public static final double STRETCH = 1.4;
    static final double CHAIN_ATOM_Z = 0.1;
    static final double RING_ATOM_Z = 0.01;
    static final double PREFER_WEDGE = 1.01;
    static final double STEREO_NEIGHBOUR = 1.01;
    static final int IS_STEREO = 1;

    public static Molecule layoutMolecule(Molecule molecule) {
        int n;
        Molecule molecule2 = (Molecule)molecule.clone();
        Layout.randomCoordinates(molecule2);
        molecule2.setupNeighbourhood();
        molecule2.perceiveRingBonds();
        boolean[] blArray = new boolean[molecule2.atoms.length];
        int[] nArray = new int[molecule2.bonds.length];
        int[] nArray2 = new int[molecule2.bonds.length];
        for (n = 0; n < molecule2.atoms.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < molecule2.bonds.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < molecule2.bonds.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < molecule2.ringlist.length; ++n) {
            CountedBitSet countedBitSet = molecule2.ringlist[n];
            for (int i = 0; i < molecule2.bonds.length; ++i) {
                Bond bond = molecule2.bonds[i];
                if (!countedBitSet.get(i)) continue;
                blArray[bond.atoms[0] - 1] = true;
                blArray[bond.atoms[1] - 1] = true;
                if (nArray[i] == 0 || nArray[i] > countedBitSet.getCardinality()) {
                    nArray[i] = countedBitSet.getCardinality();
                }
                int n2 = i;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
        molecule2.removePerceivedInformation();
        Layout.hideMetalComplexProblems(molecule2, nArray2);
        molecule2.setupNeighbourhood();
        molecule2.perceiveRingBonds();
        Layout.layoutRings(molecule2, nArray2);
        Layout.linkRingFragments(molecule2);
        Layout.sproutRingSubstituents(molecule2);
        Layout.layoutChainAtoms(molecule2);
        Layout.improveSPAtoms(molecule2, 0);
        Layout.layoutFragments(molecule2, nArray, nArray2);
        Layout.layoutAtomStereo(molecule2);
        return molecule2;
    }

    public static void adjustReaction(Molecule molecule, Molecule molecule2) {
        System.err.println("adjustReaction not yet implemented!");
    }

    public static void randomCoordinates(Molecule molecule) {
        Random random = new Random();
        for (int i = 0; i < molecule.atoms.length; ++i) {
            if ((molecule.atoms[i].flags & 2) != 0) continue;
            molecule.atoms[i].x = 1.514 * Math.sqrt(molecule.atoms.length) * random.nextDouble();
            molecule.atoms[i].y = 1.514 * Math.sqrt(molecule.atoms.length) * random.nextDouble();
            molecule.atoms[i].z = 0.0;
        }
    }

    private static void hideMetalComplexProblems(Molecule molecule, int[] nArray) {
        int n;
        if (molecule.bonds.length == 0) {
            return;
        }
        boolean bl = false;
        for (n = 0; n < molecule.atoms.length; ++n) {
            if (!PTable.atomSymbolMatch(molecule.atoms[n].symbol, "trn")) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        for (n = 0; n < molecule.bonds.length; ++n) {
            Bond bond = molecule.bonds[n];
            if (nArray[n] <= 1 || !PTable.atomSymbolMatch(molecule.atoms[bond.atoms[0] - 1].symbol, "trn") && !PTable.atomSymbolMatch(molecule.atoms[bond.atoms[1] - 1].symbol, "trn")) continue;
            bond.flags |= 0x100;
        }
    }

    private static int fillRingNodeTable(RingNode[] ringNodeArray, CountedBitSet countedBitSet, Molecule molecule) {
        int n;
        if (molecule.bonds.length <= 0) {
            return 0;
        }
        int[][] nArrayArray = new int[molecule.bonds.length][];
        for (n = 0; n < molecule.bonds.length; ++n) {
            nArrayArray[n] = molecule.bonds[n].getAtomNumbers();
        }
        int n2 = 0;
        for (n = 0; n < molecule.bonds.length; ++n) {
            if (!countedBitSet.get(n)) continue;
            nArrayArray[n2] = nArrayArray[n];
            ++n2;
        }
        int n3 = n2;
        for (n = n2 + 1; n < molecule.bonds.length; ++n) {
            nArrayArray[n] = null;
        }
        block3: for (n = 1; n < n3; ++n) {
            for (n2 = n; n2 < n3; ++n2) {
                int n4;
                if (nArrayArray[n2][0] == nArrayArray[n - 1][1]) {
                    n4 = nArrayArray[n][0];
                    nArrayArray[n][0] = nArrayArray[n2][0];
                    nArrayArray[n2][0] = n4;
                    n4 = nArrayArray[n][1];
                    nArrayArray[n][1] = nArrayArray[n2][1];
                    nArrayArray[n2][1] = n4;
                    continue block3;
                }
                if (nArrayArray[n2][1] != nArrayArray[n - 1][1]) continue;
                n4 = nArrayArray[n2][0];
                nArrayArray[n2][0] = nArrayArray[n2][1];
                nArrayArray[n2][1] = n4;
                n4 = nArrayArray[n][0];
                nArrayArray[n][0] = nArrayArray[n2][0];
                nArrayArray[n2][0] = n4;
                n4 = nArrayArray[n][1];
                nArrayArray[n][1] = nArrayArray[n2][1];
                nArrayArray[n2][1] = n4;
                continue block3;
            }
        }
        for (n = 1; n < n3 && molecule.atoms[nArrayArray[n - 1][0] - 1].color == molecule.atoms[nArrayArray[n][0] - 1].color; ++n) {
        }
        if (n == n3) {
            return 0;
        }
        int n5 = n - 1;
        for (n = n3 - 1; n > n5 && molecule.atoms[nArrayArray[n][0] - 1].color == molecule.atoms[nArrayArray[n5][0] - 1].color; --n) {
        }
        int n6 = n;
        ringNodeArray[0] = new RingNode();
        ringNodeArray[0].aifirst = nArrayArray[n6][1];
        ringNodeArray[0].ailast = nArrayArray[n5][0];
        ringNodeArray[0].color = molecule.atoms[nArrayArray[n5][0] - 1].color;
        n3 = 1;
        for (n = n5 + 1; n <= n6; ++n) {
            if (molecule.atoms[nArrayArray[n][0] - 1].color == molecule.atoms[nArrayArray[n - 1][0] - 1].color) continue;
            for (n2 = n; n2 < n6 && molecule.atoms[nArrayArray[n2][0] - 1].color == molecule.atoms[nArrayArray[n2][1] - 1].color; ++n2) {
            }
            ringNodeArray[n3] = new RingNode();
            ringNodeArray[n3].aifirst = nArrayArray[n][0];
            ringNodeArray[n3].ailast = nArrayArray[n2][0];
            ringNodeArray[n3].color = molecule.atoms[nArrayArray[n][0] - 1].color;
            ++n3;
        }
        for (n = 0; n < n3; ++n) {
            ringNodeArray[n].xfirst = molecule.atoms[ringNodeArray[n].aifirst - 1].x;
            ringNodeArray[n].yfirst = molecule.atoms[ringNodeArray[n].aifirst - 1].y;
            ringNodeArray[n].xlast = molecule.atoms[ringNodeArray[n].ailast - 1].x;
            ringNodeArray[n].ylast = molecule.atoms[ringNodeArray[n].ailast - 1].y;
        }
        return n3;
    }

    private static void layoutRingSort(CountedBitSet[] countedBitSetArray) {
        block0: for (int i = 1; i < countedBitSetArray.length; ++i) {
            for (int j = i - 1; j >= 0; --j) {
                CountedBitSet countedBitSet;
                if (countedBitSetArray[j].getCardinality() != 6 && countedBitSetArray[j + 1].getCardinality() == 6) {
                    countedBitSet = countedBitSetArray[j];
                    countedBitSetArray[j] = countedBitSetArray[j + 1];
                    countedBitSetArray[j + 1] = countedBitSet;
                    continue;
                }
                if (countedBitSetArray[j].getCardinality() == 6 || countedBitSetArray[j].getCardinality() <= countedBitSetArray[j + 1].getCardinality()) continue block0;
                countedBitSet = countedBitSetArray[j];
                countedBitSetArray[j] = countedBitSetArray[j + 1];
                countedBitSetArray[j + 1] = countedBitSet;
            }
        }
    }

    private static void layoutRingSegment(Molecule molecule, RingNode[] ringNodeArray, int n) {
        int n2;
        int n3;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        for (n3 = 1; n3 < n; ++n3) {
            for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                if (molecule.atoms[n2].color != ringNodeArray[n3].color) continue;
                d2 += molecule.atoms[n2].x;
                d += molecule.atoms[n2].y;
                ++n4;
            }
        }
        d2 /= (double)n4;
        d /= (double)n4;
        double d3 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            d3 += 1.514;
            ringNodeArray[n3].d = Math.sqrt(HigherMath.sqr(ringNodeArray[n3].xfirst - ringNodeArray[n3].xlast) + HigherMath.sqr(ringNodeArray[n3].yfirst - ringNodeArray[n3].ylast));
            d3 += ringNodeArray[n3].d;
        }
        double d4 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            d4 += 1.514 * (4.756371277534947 / d3) / Math.sin(4.756371277534947 / d3);
            ringNodeArray[n3].angle = Math.PI * 2 * ringNodeArray[n3].d / d3;
            if (!(ringNodeArray[n3].angle > 1.0E-4)) continue;
            d4 += ringNodeArray[n3].d * (ringNodeArray[n3].angle / 2.0) / Math.sin(ringNodeArray[n3].angle / 2.0);
        }
        double d5 = d4 / (Math.PI * 2);
        double[][] dArrayArray = new double[molecule.atoms.length][];
        for (n3 = 0; n3 < molecule.atoms.length; ++n3) {
            dArrayArray[n3] = new double[2];
        }
        double d6 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            Object object;
            double d7 = d5 * Math.sin(d6) + d2;
            double d8 = d5 * Math.cos(d6) + d;
            double d9 = d5 * Math.sin(d6 += ringNodeArray[n3].angle) + d2;
            double d10 = d5 * Math.cos(d6) + d;
            d6 += 9.512742555069893 / d3;
            dArray[0] = ringNodeArray[n3].xfirst;
            dArray[1] = ringNodeArray[n3].yfirst;
            dArray2[0] = ringNodeArray[n3].xlast;
            dArray2[1] = ringNodeArray[n3].ylast;
            dArray4[0] = d7;
            dArray4[1] = d8;
            dArray5[0] = d9;
            dArray5[1] = d10;
            int n5 = 0;
            for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                object = molecule.atoms[n2];
                if (((Atom)object).color != ringNodeArray[n3].color) continue;
                dArrayArray[n5][0] = ((Atom)object).x;
                dArrayArray[n5][1] = ((Atom)object).y;
                ++n5;
            }
            if (HigherMath.sqr(dArray[0] - dArray2[0]) + HigherMath.sqr(dArray[1] - dArray2[1]) > 0.01 * HigherMath.sqr(1.514)) {
                dArray3[1] = 0.0;
                dArray3[0] = 0.0;
                n5 = 0;
                for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                    object = molecule.atoms[n2];
                    if (((Atom)object).color != ringNodeArray[n3].color) continue;
                    dArray3[0] = dArray3[0] + ((Atom)object).x;
                    dArray3[1] = dArray3[1] + ((Atom)object).y;
                    ++n5;
                }
                dArray3[0] = dArray3[0] / (double)n5;
                dArray3[1] = dArray3[1] / (double)n5;
                if ((dArray3[0] - dArray[0]) * (dArray2[1] - dArray[1]) - (dArray3[1] - dArray[1]) * (dArray2[0] - dArray[0]) > 0.0) {
                    dArray[1] = dArray[1] * -1.0;
                    dArray2[1] = dArray2[1] * -1.0;
                    for (n2 = 0; n2 < n5; ++n2) {
                        double[] dArray6 = dArrayArray[n2];
                        dArray6[1] = dArray6[1] * -1.0;
                    }
                    molecule.flipStereoSymbols(ringNodeArray[n3].color);
                }
            } else {
                dArray3[1] = 0.0;
                dArray3[0] = 0.0;
                n5 = 0;
                for (n2 = 0; n2 < molecule.bonds.length; ++n2) {
                    object = molecule.bonds[n2];
                    if (!(((Bond)object).atoms[0] == ringNodeArray[n3].aifirst && molecule.atoms[((Bond)object).atoms[1] - 1].color == ringNodeArray[n3].color || ((Bond)object).atoms[1] == ringNodeArray[n3].aifirst && molecule.atoms[((Bond)object).atoms[0] - 1].color == ringNodeArray[n3].color || ((Bond)object).atoms[0] == ringNodeArray[n3].ailast && molecule.atoms[((Bond)object).atoms[1] - 1].color == ringNodeArray[n3].color) && (((Bond)object).atoms[1] != ringNodeArray[n3].ailast || molecule.atoms[((Bond)object).atoms[0] - 1].color != ringNodeArray[n3].color)) continue;
                    dArray3[0] = dArray3[0] + molecule.atoms[((Bond)object).atoms[0] - 1].x;
                    dArray3[1] = dArray3[1] + molecule.atoms[((Bond)object).atoms[0] - 1].y;
                    ++n5;
                    dArray3[0] = dArray3[0] + molecule.atoms[((Bond)object).atoms[1] - 1].x;
                    dArray3[1] = dArray3[1] + molecule.atoms[((Bond)object).atoms[1] - 1].y;
                    ++n5;
                }
                if (n5 > 0) {
                    dArray3[0] = dArray3[0] / (double)n5;
                    dArray3[1] = dArray3[1] / (double)n5;
                    dArray2[0] = dArray3[0];
                    dArray2[1] = dArray3[1];
                    dArray5[0] = dArray4[0] + (dArray4[0] - d2) * Math.sqrt(HigherMath.sqr(dArray3[0] - dArray[0]) + HigherMath.sqr(dArray3[1] - dArray[1])) / Math.sqrt(HigherMath.sqr(dArray4[0] - d2) + HigherMath.sqr(dArray4[1] - d));
                    dArray5[1] = dArray4[1] + (dArray4[1] - d) * Math.sqrt(HigherMath.sqr(dArray3[0] - dArray[0]) + HigherMath.sqr(dArray3[1] - dArray[1])) / Math.sqrt(HigherMath.sqr(dArray4[0] - d2) + HigherMath.sqr(dArray4[1] - d));
                }
            }
            HigherMath.transformPoints(dArrayArray, molecule.atoms.length, dArray, dArray2, dArray4, dArray5);
            n5 = 0;
            for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                object = molecule.atoms[n2];
                if (((Atom)object).color != ringNodeArray[n3].color) continue;
                ((Atom)object).x = dArrayArray[n5][0];
                ((Atom)object).y = dArrayArray[n5][1];
                ++n5;
            }
        }
    }

    private static void mergeColors(Molecule molecule, RingNode[] ringNodeArray, int n) {
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < molecule.atoms.length; ++j) {
                if (molecule.atoms[j].color != ringNodeArray[i].color) continue;
                molecule.atoms[j].color = ringNodeArray[0].color;
            }
        }
    }

    private static void layoutRings(Molecule molecule, int[] nArray) {
        Layout.layoutRingSort(molecule.ringlist);
        int n = 0;
        while (n < molecule.ringlist.length) {
            RingNode[] ringNodeArray = new RingNode[molecule.atoms.length];
            CountedBitSet countedBitSet = molecule.ringlist[n];
            int n2 = Layout.fillRingNodeTable(ringNodeArray, countedBitSet, molecule);
            if (n2 == 0) {
                ++n;
                continue;
            }
            Layout.layoutRingSegment(molecule, ringNodeArray, n2);
            Layout.mergeColors(molecule, ringNodeArray, n2);
        }
    }

    private static double volume(double[][] dArray) {
        double d = dArray[1][0] - dArray[0][0];
        double d2 = dArray[1][1] - dArray[0][1];
        double d3 = dArray[1][2] - dArray[0][2];
        double d4 = dArray[2][0] - dArray[0][0];
        double d5 = dArray[2][1] - dArray[0][1];
        double d6 = dArray[2][2] - dArray[0][2];
        double d7 = dArray[3][0] - dArray[0][0];
        double d8 = dArray[3][1] - dArray[0][1];
        double d9 = dArray[3][2] - dArray[0][2];
        return d * (d5 * d9 - d6 * d8) + d2 * (d6 * d7 - d4 * d9) + d3 * (d4 * d8 - d5 * d7);
    }

    private static void layoutAtomStereo(Molecule molecule) {
        StereoDescription stereoDescription;
        int n;
        int[] nArray = molecule.removeAtomColors();
        if (molecule.stereodescs == null) {
            return;
        }
        for (n = 0; n < molecule.stereodescs.length; ++n) {
            stereoDescription = molecule.stereodescs[n];
            if (!(stereoDescription.depictor instanceof Atom)) continue;
            ((Atom)stereoDescription.depictor).color |= 1;
        }
        for (n = 0; n < molecule.stereodescs.length; ++n) {
            int n2;
            int n3;
            stereoDescription = molecule.stereodescs[n];
            if (stereoDescription.stereoclass != 1) continue;
            Atom atom = (Atom)stereoDescription.depictor;
            double[][] dArrayArray = new double[4][];
            Bond[] bondArray = new Bond[4];
            int n4 = 0;
            for (int i = 0; i < stereoDescription.atoms.length; ++i) {
                int n5;
                if (stereoDescription.atoms[i] == Integer.MAX_VALUE) {
                    dArrayArray[n4] = new double[3];
                    dArrayArray[n4][0] = atom.x;
                    dArrayArray[n4][1] = atom.y;
                    dArrayArray[n4][2] = 0.0;
                    bondArray[n4] = null;
                    ++n4;
                    continue;
                }
                for (n5 = 0; n5 < atom.neighbour_atoms.length && atom.neighbour_atoms[n5].index != stereoDescription.atoms[i] - 1; ++n5) {
                }
                dArrayArray[n4] = new double[3];
                dArrayArray[n4][0] = atom.neighbour_atoms[n5].x;
                dArrayArray[n4][1] = atom.neighbour_atoms[n5].y;
                dArrayArray[n4][2] = 0.0;
                bondArray[n4] = atom.neighbour_bonds[n5];
                ++n4;
            }
            double d = 0.0;
            int n6 = -1;
            for (n3 = 1; n3 < 81; ++n3) {
                n2 = n3;
                int n7 = 0;
                for (int i = 0; i < 4; ++i) {
                    if (stereoDescription.atoms[i] == Integer.MAX_VALUE || bondArray[i].stereo_symbol != 0) {
                        n2 /= 3;
                        continue;
                    }
                    if (n2 % 3 != 0) {
                        ++n7;
                    }
                    switch (n2 % 3) {
                        case 0: {
                            dArrayArray[i][2] = 0.0;
                            break;
                        }
                        case 1: {
                            dArrayArray[i][2] = 1.01;
                            break;
                        }
                        case 2: {
                            dArrayArray[i][2] = -1.0;
                        }
                    }
                    if (bondArray[i].topography == 1) {
                        double[] dArray = dArrayArray[i];
                        dArray[2] = dArray[2] * 0.01;
                    } else {
                        double[] dArray = dArrayArray[i];
                        dArray[2] = dArray[2] * 0.1;
                    }
                    if ((molecule.atoms[stereoDescription.atoms[i] - 1].color & 1) != 0) {
                        double[] dArray = dArrayArray[i];
                        dArray[2] = dArray[2] * 1.01;
                    }
                    double[] dArray = dArrayArray[i];
                    dArray[2] = dArray[2] / (double)molecule.atoms[stereoDescription.atoms[i] - 1].neighbour_atoms.length;
                    n2 /= 3;
                }
                if (!(Layout.volume(dArrayArray) > d * (double)n7)) continue;
                d = Layout.volume(dArrayArray) / (double)n7;
                n6 = n3;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                if (n6 % 3 == 0) {
                    n6 /= 3;
                    continue;
                }
                bondArray[n3].stereo_symbol = n6 % 3 == 1 ? 1 : 2;
                n6 /= 3;
                if (atom.index == bondArray[n3].atoms[0] - 1) continue;
                n2 = bondArray[n3].atoms[0];
                bondArray[n3].atoms[0] = bondArray[n3].atoms[1];
                bondArray[n3].atoms[1] = n2;
            }
        }
        molecule.restoreAtomColors(nArray);
    }

    private static void linkRingFragments(Molecule molecule) {
        if (molecule.bonds == null || molecule.bonds.length < 1) {
            return;
        }
        int[] nArray = new int[molecule.atoms.length];
        for (int i = 0; i < molecule.bonds.length; ++i) {
            int n;
            Bond bond = molecule.bonds[i];
            if (molecule.atoms[bond.atoms[0] - 1].color == molecule.atoms[bond.atoms[1] - 1].color || (bond.flags & 0x100) != 0 || molecule.atoms[bond.atoms[0] - 1].topography != 1 || molecule.atoms[bond.atoms[1] - 1].topography != 1) continue;
            int n2 = molecule.atoms[bond.atoms[0] - 1].color;
            int n3 = molecule.atoms[bond.atoms[1] - 1].color;
            int n4 = 0;
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n2) continue;
                ++n4;
            }
            int n5 = 0;
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n3) continue;
                ++n5;
            }
            if (n4 > n5) {
                int n6 = bond.atoms[0];
                bond.atoms[0] = bond.atoms[1];
                bond.atoms[1] = n6;
                n6 = n2;
                n2 = n3;
                n3 = n6;
                n6 = n4;
                n4 = n5;
                n5 = n6;
            }
            int[][] nArray2 = molecule.getColoredEdges(n3, nArray);
            double[][] dArray = molecule.getColoredCoordinates(n3, nArray);
            int n7 = nArray[bond.atoms[1] - 1];
            double[] dArray2 = new double[]{dArray[n7][0], dArray[n7][1]};
            double[] dArray3 = HigherMath.nextSubstituentPoint(dArray, nArray2, n7, false);
            nArray2 = molecule.getColoredEdges(n2, nArray);
            dArray = molecule.getColoredCoordinates(n2, nArray);
            n7 = nArray[bond.atoms[0] - 1];
            double[] dArray4 = new double[]{dArray[n7][0], dArray[n7][1]};
            double[] dArray5 = HigherMath.nextSubstituentPoint(dArray, nArray2, n7, false);
            HigherMath.transformPoints(dArray, dArray.length, dArray4, dArray5, dArray3, dArray2);
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n2) continue;
                molecule.atoms[n].x = dArray[nArray[n]][0];
                molecule.atoms[n].y = dArray[nArray[n]][1];
            }
            Layout.improveBondByFlip(molecule, bond, 0.01);
            Layout.improveBondByStretch(molecule, bond);
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n3) continue;
                molecule.atoms[n].color = n2;
            }
        }
    }

    private static double colorStrain(Molecule molecule, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < molecule.atoms.length; ++i) {
            Atom atom = molecule.atoms[i];
            if (atom.color != n) continue;
            for (int j = 0; j < molecule.atoms.length; ++j) {
                Atom atom2 = molecule.atoms[j];
                if (atom2.color != n2) continue;
                d += 1.0 / (0.01 + (atom.x - atom2.x) * (atom.x - atom2.x) + (atom.y - atom2.y) * (atom.y - atom2.y));
            }
        }
        return d;
    }

    public static boolean improveBondByFlip(Molecule molecule, Bond bond, double d) {
        double d2;
        Atom atom;
        int n;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        if ((bond.flags & 0x200) != 0) {
            return false;
        }
        double d3 = Layout.colorStrain(molecule, molecule.atoms[bond.atoms[0] - 1].color, molecule.atoms[bond.atoms[1] - 1].color);
        dArray[0] = molecule.atoms[bond.atoms[0] - 1].x;
        dArray[1] = molecule.atoms[bond.atoms[0] - 1].y;
        dArray2[0] = molecule.atoms[bond.atoms[1] - 1].x;
        dArray2[1] = molecule.atoms[bond.atoms[1] - 1].y;
        dArray5[0] = dArray2[0] - dArray[0];
        dArray5[1] = dArray2[1] - dArray[1];
        for (n = 0; n < molecule.atoms.length; ++n) {
            atom = molecule.atoms[n];
            if (atom.color != molecule.atoms[bond.atoms[1] - 1].color) continue;
            dArray3[0] = atom.x;
            dArray3[1] = atom.y;
            d2 = ((dArray3[0] - dArray[0]) * dArray5[0] + (dArray3[1] - dArray[1]) * dArray5[1]) / (dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
            dArray4[0] = dArray[0] - (dArray3[0] - dArray[0]) + 2.0 * dArray5[0] * d2;
            dArray4[1] = dArray[1] - (dArray3[1] - dArray[1]) + 2.0 * dArray5[1] * d2;
            atom.x = dArray4[0];
            atom.y = dArray4[1];
        }
        double d4 = Layout.colorStrain(molecule, molecule.atoms[bond.atoms[0] - 1].color, molecule.atoms[bond.atoms[1] - 1].color);
        if (d3 <= d4 + d) {
            for (n = 0; n < molecule.atoms.length; ++n) {
                atom = molecule.atoms[n];
                if (atom.color != molecule.atoms[bond.atoms[1] - 1].color) continue;
                dArray3[0] = atom.x;
                dArray3[1] = atom.y;
                d2 = ((dArray3[0] - dArray[0]) * dArray5[0] + (dArray3[1] - dArray[1]) * dArray5[1]) / (dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                dArray4[0] = dArray[0] - (dArray3[0] - dArray[0]) + 2.0 * dArray5[0] * d2;
                dArray4[1] = dArray[1] - (dArray3[1] - dArray[1]) + 2.0 * dArray5[1] * d2;
                atom.x = dArray4[0];
                atom.y = dArray4[1];
            }
            return false;
        }
        return true;
    }

    public static void improveBondByStretch(Molecule molecule, Bond bond) {
        Atom atom;
        double[] dArray = new double[2];
        int n = molecule.atoms[bond.atoms[0] - 1].color;
        int n2 = molecule.atoms[bond.atoms[1] - 1].color;
        boolean bl = false;
        block0: for (int i = 0; i < molecule.atoms.length; ++i) {
            atom = molecule.atoms[i];
            if (atom.color != n) continue;
            for (int j = 0; j < molecule.atoms.length; ++j) {
                Atom atom2 = molecule.atoms[j];
                if (atom2.color != n2 || !((atom.x - atom2.x) * (atom.x - atom2.x) + (atom.y - atom2.y) * (atom.y - atom2.y) < 0.11460980000000001)) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            return;
        }
        dArray[0] = molecule.atoms[bond.atoms[1] - 1].x - molecule.atoms[bond.atoms[0] - 1].x;
        dArray[1] = molecule.atoms[bond.atoms[1] - 1].y - molecule.atoms[bond.atoms[0] - 1].y;
        for (int i = 0; i < molecule.atoms.length; ++i) {
            atom = molecule.atoms[i];
            if (atom.color != molecule.atoms[bond.atoms[1] - 1].color) continue;
            atom.x += 0.2 * dArray[0] + 0.2 * dArray[1];
            atom.y += 0.2 * dArray[1] - 0.2 * dArray[0];
        }
    }

    private static void sproutRingSubstituents(Molecule molecule) {
        if (molecule.bonds == null || molecule.bonds.length < 1) {
            return;
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        int[] nArray = new int[molecule.atoms.length];
        Atom[] atomArray = new Atom[molecule.atoms.length];
        for (int i = 0; i < molecule.atoms.length; ++i) {
            double d;
            double d2;
            int n;
            Atom atom = molecule.atoms[i];
            if (atom.topography != 1) continue;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = Integer.MAX_VALUE;
            for (n = 0; n < atom.neighbour_bonds.length; ++n) {
                if (0 != (atom.neighbour_bonds[n].flags & 0x100)) continue;
                if (atom.neighbour_bonds[n].smallestRing() != 0) {
                    if (atom.neighbour_bonds[n].smallestRing() < n4) {
                        n4 = atom.neighbour_bonds[n].smallestRing();
                    }
                    ++n3;
                    continue;
                }
                if (atom.neighbour_atoms[n].topography == 1) {
                    bl = true;
                    continue;
                }
                if (molecule.countColor(atom.neighbour_atoms[n].color) != 1) {
                    bl = true;
                }
                atomArray[n2] = atom.neighbour_atoms[n];
                ++n2;
            }
            if (n2 == 0 || n3 != 2 || bl) continue;
            int[][] nArray2 = molecule.getColoredEdges(atom.color, nArray);
            double[][] dArray6 = molecule.getColoredCoordinates(atom.color, nArray);
            int n5 = nArray[i];
            dArray[0] = dArray6[n5][0];
            dArray[1] = dArray6[n5][1];
            dArray2 = n4 <= 8 ? HigherMath.nextSubstituentPoint(dArray6, nArray2, n5, false) : HigherMath.nextSubstituentPoint(dArray6, nArray2, n5, true);
            dArray3[0] = dArray2[0] - dArray[0];
            dArray3[1] = dArray2[1] - dArray[1];
            if (n2 > 1) {
                Atom atom2;
                for (n = 1; n < n2; ++n) {
                    for (int j = n - 1; j >= 0 && atomArray[j].neighbour_atoms.length < atomArray[j + 1].neighbour_atoms.length; --j) {
                        atom2 = atomArray[j];
                        atomArray[j] = atomArray[j + 1];
                        atomArray[j + 1] = atom2;
                    }
                }
                d2 = Math.cos((1.5707963267948966 / (double)n2 - 1.5707963267948966) * 80.0 / 90.0);
                d = Math.sin((1.5707963267948966 / (double)n2 - 1.5707963267948966) * 80.0 / 90.0);
                dArray4[0] = d2 * dArray3[0] - d * dArray3[1] + dArray[0];
                dArray4[1] = d * dArray3[0] + d2 * dArray3[1] + dArray[1];
                dArray5[1] = 0.0;
                dArray5[0] = 0.0;
                for (n = 0; n < dArray6.length; ++n) {
                    dArray5[0] = dArray5[0] + dArray6[n][0];
                    dArray5[1] = dArray5[1] + dArray6[n][1];
                }
                dArray5[0] = dArray5[0] / (double)dArray6.length;
                dArray5[1] = dArray5[1] / (double)dArray6.length;
                if ((dArray4[0] - dArray5[0]) * (dArray4[0] - dArray5[0]) + (dArray4[1] - dArray5[1]) * (dArray4[1] - dArray5[1]) < (dArray2[0] - dArray5[0]) * (dArray2[0] - dArray5[0]) + (dArray2[1] - dArray5[1]) * (dArray2[1] - dArray5[1])) {
                    atom2 = atomArray[0];
                    atomArray[0] = atomArray[n2 - 1];
                    atomArray[n2 - 1] = atom2;
                }
            }
            for (n = 0; n < n2; ++n) {
                d2 = Math.cos((((double)n + 0.5) * Math.PI / (double)n2 - 1.5707963267948966) * 80.0 / 90.0);
                d = Math.sin((((double)n + 0.5) * Math.PI / (double)n2 - 1.5707963267948966) * 80.0 / 90.0);
                dArray4[0] = d2 * dArray3[0] - d * dArray3[1] + dArray[0];
                dArray4[1] = d * dArray3[0] + d2 * dArray3[1] + dArray[1];
                atomArray[n].x = dArray4[0];
                atomArray[n].y = dArray4[1];
                atomArray[n].color = atom.color;
            }
        }
    }

    private static int branchQuality(Molecule molecule, Atom atom) {
        int n;
        int[] nArray = new int[atom.neighbour_atoms.length];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < atom.neighbour_atoms.length; ++n) {
            nArray[n] = 0;
            if ((atom.neighbour_bonds[n].flags & 0x100) != 0) continue;
            if (atom.color != atom.neighbour_atoms[n].color) {
                bl = true;
            } else {
                ++n2;
            }
            if ((atom.neighbour_atoms[n].flags & 1) != 0) {
                bl2 = true;
            }
            Atom atom2 = atom.neighbour_atoms[n];
            for (int i = 0; i < atom2.neighbour_bonds.length; ++i) {
                if (0 != (atom2.neighbour_bonds[i].flags & 0x100)) continue;
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        if (!bl || n2 > 1) {
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < atom.neighbour_atoms.length; ++n) {
            if (nArray[n] == 1) {
                ++n6;
            } else if (nArray[n] > 0) {
                ++n5;
            }
            n4 += nArray[n];
        }
        if (bl2) {
            return 1000 + n6 * 100 + n5 * 10 + n4;
        }
        return n6 * 100 + n5 * 10 + n4;
    }

    private static void layoutChainAtoms(Molecule molecule) {
        Object object;
        int n;
        if (molecule.bonds == null || molecule.bonds.length == 0) {
            return;
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        int[] nArray = new int[molecule.atoms.length];
        for (n = 0; n < molecule.atoms.length; ++n) {
            molecule.atoms[n].flags &= 0xFFFFFFFE;
        }
        while (true) {
            int n2;
            int n3;
            int n4;
            Bond bond;
            Atom atom;
            int n5 = -1;
            int n6 = -1;
            for (n = 0; n < molecule.atoms.length; ++n) {
                object = molecule.atoms[n];
                if (((Atom)object).topography == 1 || n5 >= Layout.branchQuality(molecule, (Atom)object)) continue;
                n6 = n;
                n5 = Layout.branchQuality(molecule, (Atom)object);
            }
            if (n5 < 0) break;
            molecule.atoms[n6].flags |= 1;
            object = molecule.atoms[n6];
            int n7 = 0;
            int[] nArray2 = new int[((Atom)object).neighbour_atoms.length];
            int[] nArray3 = new int[((Atom)object).neighbour_atoms.length];
            Atom[] atomArray = new Atom[((Atom)object).neighbour_atoms.length];
            Bond[] bondArray = new Bond[((Atom)object).neighbour_atoms.length];
            int n8 = ((Atom)object).color;
            ((Atom)object).color = -1;
            for (n = 0; n < ((Atom)object).neighbour_bonds.length; ++n) {
                if ((((Atom)object).neighbour_bonds[n].flags & 0x100) != 0) continue;
                atomArray[n7] = ((Atom)object).neighbour_atoms[n];
                bondArray[n7] = ((Atom)object).neighbour_bonds[n];
                nArray2[n7] = atomArray[n7].color;
                nArray3[n7] = 100 * molecule.countColor(nArray2[n7]) + atomArray[n7].neighbour_atoms.length;
                ++n7;
            }
            for (n = 1; n < n7; ++n) {
                if (nArray2[n] != n8) continue;
                atom = atomArray[n];
                atomArray[n] = atomArray[0];
                atomArray[0] = atom;
                bond = bondArray[n];
                bondArray[n] = bondArray[0];
                bondArray[0] = bond;
                n4 = nArray2[n];
                nArray2[n] = nArray2[0];
                nArray2[0] = n4;
                n4 = nArray3[n];
                nArray3[n] = nArray3[0];
                nArray3[0] = n4;
            }
            block5: do {
                for (n = 1; n < n7 - 1; ++n) {
                    if (Math.abs(nArray3[n] - nArray3[n - 1]) + Math.abs(nArray3[n + 1] - nArray3[(n + 2) % n7]) >= Math.abs(nArray3[n] - nArray3[(n + 2) % n7]) + Math.abs(nArray3[n + 1] - nArray3[n - 1])) continue;
                    atom = atomArray[n];
                    atomArray[n] = atomArray[n + 1];
                    atomArray[n + 1] = atom;
                    bond = bondArray[n];
                    bondArray[n] = bondArray[n + 1];
                    bondArray[n + 1] = bond;
                    n4 = nArray2[n];
                    nArray2[n] = nArray2[n + 1];
                    nArray2[n + 1] = n4;
                    n4 = nArray3[n];
                    nArray3[n] = nArray3[n + 1];
                    nArray3[n + 1] = n4;
                    continue block5;
                }
            } while (n < n7 - 1);
            int[][] nArray4 = molecule.getColoredEdges(nArray2[0], nArray);
            double[][] dArray5 = molecule.getColoredCoordinates(nArray2[0], nArray);
            dArray3[0] = Math.cos(0.0 / (double)n7) * 1.514;
            dArray3[1] = Math.sin(0.0 / (double)n7) * 1.514;
            dArray4[0] = 0.0;
            dArray4[1] = 0.0;
            dArray[0] = atomArray[0].x;
            dArray[1] = atomArray[0].y;
            if (nArray2[0] == n8) {
                dArray2[0] = molecule.atoms[n6].x;
                dArray2[1] = molecule.atoms[n6].y;
            } else {
                n3 = nArray[0];
                for (int i = 0; i < molecule.atoms.length; ++i) {
                    if (molecule.atoms[i] != atomArray[0]) continue;
                    n3 = nArray[i];
                    break;
                }
                dArray2 = HigherMath.nextSubstituentPoint(dArray5, nArray4, n3, true);
            }
            HigherMath.transformPoints(dArray5, dArray5.length, dArray, dArray2, dArray3, dArray4);
            for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                if (molecule.atoms[n2].color != nArray2[0]) continue;
                molecule.atoms[n2].x = dArray5[nArray[n2]][0];
                molecule.atoms[n2].y = dArray5[nArray[n2]][1];
            }
            molecule.atoms[n6].x = 0.0;
            molecule.atoms[n6].y = 0.0;
            for (n = 1; n < n7; ++n) {
                nArray4 = molecule.getColoredEdges(nArray2[n], nArray);
                dArray5 = molecule.getColoredCoordinates(nArray2[n], nArray);
                dArray3[0] = Math.cos(Math.PI * 2 * (double)n / (double)Math.max(n7, 3)) * 1.514;
                dArray3[1] = Math.sin(Math.PI * 2 * (double)n / (double)Math.max(n7, 3)) * 1.514;
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray[0] = atomArray[n].x;
                dArray[1] = atomArray[n].y;
                n3 = nArray[0];
                for (int i = 0; i < molecule.atoms.length; ++i) {
                    if (molecule.atoms[i] != atomArray[n]) continue;
                    n3 = nArray[i];
                    break;
                }
                dArray2 = HigherMath.nextSubstituentPoint(dArray5, nArray4, n3, true);
                HigherMath.transformPoints(dArray5, dArray5.length, dArray, dArray2, dArray3, dArray4);
                for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                    if (molecule.atoms[n2].color != nArray2[n]) continue;
                    molecule.atoms[n2].x = dArray5[nArray[n2]][0];
                    molecule.atoms[n2].y = dArray5[nArray[n2]][1];
                }
            }
            for (n = 0; n < n7; ++n) {
                for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
                    Atom atom2 = molecule.atoms[n2];
                    if (atom2.color != nArray2[n]) continue;
                    atom2.color = n8;
                }
            }
            molecule.atoms[n6].color = n8;
        }
        for (n = 0; n < molecule.bonds.length; ++n) {
            object = molecule.bonds[n];
            if (((Bond)object).topography != 2) continue;
            Layout.makeBondTrans(molecule, (Bond)object);
        }
        for (n = 0; n < molecule.atoms.length; ++n) {
            molecule.atoms[n].flags &= 0xFFFFFFFE;
        }
    }

    private static void improveSPAtoms(Molecule molecule, int n) {
        int n2;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        int[] nArray = new int[molecule.atoms.length];
        for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
            nArray[n2] = molecule.atoms[n2].color;
        }
        for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
            boolean bl;
            int n3;
            Atom atom = molecule.atoms[n2];
            if (atom.neighbour_atoms.length != 2 || !atom.symbol.equals("C") && !atom.symbol.equals("N") || !(atom.neighbour_bonds[0].bond_type == 2 && atom.neighbour_bonds[1].bond_type == 8 || atom.neighbour_bonds[1].bond_type == 2 && atom.neighbour_bonds[0].bond_type == 8) && (atom.neighbour_bonds[0].bond_type != 4 || atom.neighbour_bonds[1].bond_type != 4) || n != 0 && n != n2 + 1) continue;
            for (n3 = 0; n3 < molecule.atoms.length; ++n3) {
                molecule.atoms[n3].color = 0;
            }
            atom.color = 1;
            atom.neighbour_atoms[0].color = 2;
            atom.neighbour_atoms[1].color = 3;
            do {
                bl = false;
                for (n3 = 0; n3 < molecule.bonds.length; ++n3) {
                    Bond bond = molecule.bonds[n3];
                    if (molecule.atoms[bond.atoms[0] - 1].color > 0 && molecule.atoms[bond.atoms[1] - 1].color == 0) {
                        bl = true;
                        molecule.atoms[bond.atoms[1] - 1].color = molecule.atoms[bond.atoms[0] - 1].color;
                        continue;
                    }
                    if (molecule.atoms[bond.atoms[1] - 1].color <= 0 || molecule.atoms[bond.atoms[0] - 1].color != 0) continue;
                    bl = true;
                    molecule.atoms[bond.atoms[0] - 1].color = molecule.atoms[bond.atoms[1] - 1].color;
                }
            } while (bl);
            if (atom.neighbour_atoms[0].color == atom.neighbour_atoms[1].color) continue;
            dArray[0] = atom.x;
            dArray[1] = atom.y;
            dArray2[0] = atom.neighbour_atoms[0].x;
            dArray2[1] = atom.neighbour_atoms[0].y;
            dArray3[0] = atom.x;
            dArray3[1] = atom.y;
            dArray4[0] = 2.0 * dArray3[0] - atom.neighbour_atoms[1].x;
            dArray4[1] = 2.0 * dArray3[1] - atom.neighbour_atoms[1].y;
            int[] nArray2 = new int[molecule.atoms.length];
            int[][] nArray3 = molecule.getColoredEdges(2, nArray2);
            double[][] dArray5 = molecule.getColoredCoordinates(2, nArray2);
            HigherMath.transformPoints(dArray5, dArray5.length, dArray, dArray2, dArray3, dArray4);
            for (n3 = 0; n3 < molecule.atoms.length; ++n3) {
                if (molecule.atoms[n3].color != 2) continue;
                molecule.atoms[n3].x = dArray5[nArray2[n3]][0];
                molecule.atoms[n3].y = dArray5[nArray2[n3]][1];
            }
        }
        for (n2 = 0; n2 < molecule.atoms.length; ++n2) {
            molecule.atoms[n2].color = nArray[n2];
        }
    }

    public static void makeBondTrans(Molecule molecule, Bond bond) {
        double d;
        int n;
        int[] nArray = molecule.removeAtomColors();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        Atom atom = molecule.atoms[bond.atoms[0] - 1];
        Atom atom2 = molecule.atoms[bond.atoms[1] - 1];
        atom.color = 1;
        atom2.color = 2;
        int n2 = 0;
        int[] nArray2 = new int[atom.neighbour_atoms.length];
        for (n = 0; n < atom.neighbour_atoms.length; ++n) {
            nArray2[n2] = atom.neighbour_atoms[n].neighbour_atoms.length;
            ++n2;
        }
        int n3 = 0;
        int[] nArray3 = new int[atom2.neighbour_atoms.length];
        for (n = 0; n < atom2.neighbour_atoms.length; ++n) {
            nArray3[n3] = atom2.neighbour_atoms[n].neighbour_atoms.length;
            ++n3;
        }
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                d2 += (double)(nArray2[n] * nArray3[i]) / (1.0 + HigherMath.distSquare(atom.neighbour_atoms[n].x, atom.neighbour_atoms[n].y, atom2.neighbour_atoms[i].x, atom2.neighbour_atoms[i].y));
            }
        }
        dArray[0] = atom.x;
        dArray[1] = atom.y;
        dArray2[0] = atom2.x;
        dArray2[1] = atom2.y;
        dArray4[0] = dArray2[0] - dArray[0];
        dArray4[1] = dArray2[1] - dArray[1];
        for (n = 0; n < n2; ++n) {
            Atom atom3 = atom.neighbour_atoms[n];
            dArray3[0] = atom3.x;
            dArray3[1] = atom3.y;
            d = ((dArray3[0] - dArray[0]) * dArray4[0] + (dArray3[1] - dArray[1]) * dArray4[1]) / (dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
            atom3.x = dArray[0] - (dArray3[0] - dArray[0]) + 2.0 * dArray4[0] * d;
            atom3.y = dArray[1] - (dArray3[1] - dArray[1]) + 2.0 * dArray4[1] * d;
        }
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                d3 += (double)(nArray2[n] * nArray3[i]) / (1.0 + HigherMath.distSquare(atom.neighbour_atoms[n].x, atom.neighbour_atoms[n].y, atom2.neighbour_atoms[i].x, atom2.neighbour_atoms[i].y));
            }
        }
        for (n = 0; n < n2; ++n) {
            Atom atom4 = atom.neighbour_atoms[n];
            dArray3[0] = atom4.x;
            dArray3[1] = atom4.y;
            d = ((dArray3[0] - dArray[0]) * dArray4[0] + (dArray3[1] - dArray[1]) * dArray4[1]) / (dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
            atom4.x = dArray[0] - (dArray3[0] - dArray[0]) + 2.0 * dArray4[0] * d;
            atom4.y = dArray[1] - (dArray3[1] - dArray[1]) + 2.0 * dArray4[1] * d;
        }
        if (d2 > d3) {
            for (n = 0; n < n2; ++n) {
                molecule.floodColor(atom, 3);
            }
            for (n = 0; n < molecule.atoms.length; ++n) {
                Atom atom5 = molecule.atoms[n];
                if (atom5.color != 3) continue;
                dArray3[0] = atom5.x;
                dArray3[1] = atom5.y;
                d = ((dArray3[0] - dArray[0]) * dArray4[0] + (dArray3[1] - dArray[1]) * dArray4[1]) / (dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
                atom5.x = dArray[0] - (dArray3[0] - dArray[0]) + 2.0 * dArray4[0] * d;
                atom5.y = dArray[1] - (dArray3[1] - dArray[1]) + 2.0 * dArray4[1] * d;
            }
        }
        molecule.restoreAtomColors(nArray);
    }

    private static void linkRemainingFragments(Molecule molecule) {
        if (molecule.bonds == null || molecule.bonds.length < 1) {
            return;
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        for (int i = 0; i < molecule.bonds.length; ++i) {
            int n;
            Bond bond = molecule.bonds[i];
            if (molecule.atoms[bond.atoms[0] - 1].color == molecule.atoms[bond.atoms[1] - 1].color || (bond.flags & 0x100) != 0) continue;
            int n2 = molecule.atoms[bond.atoms[0] - 1].color;
            int n3 = molecule.atoms[bond.atoms[1] - 1].color;
            int n4 = 0;
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n2) continue;
                ++n4;
            }
            int n5 = 0;
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n3) continue;
                ++n5;
            }
            if (n4 > n5) {
                int n6 = bond.atoms[0];
                bond.atoms[0] = bond.atoms[1];
                bond.atoms[1] = n6;
                n6 = n2;
                n2 = n3;
                n3 = n6;
                n6 = n4;
                n4 = n5;
                n5 = n6;
            }
            int[] nArray = new int[molecule.atoms.length];
            int[][] nArray2 = molecule.getColoredEdges(n3, nArray);
            double[][] dArray5 = molecule.getColoredCoordinates(n3, nArray);
            int n7 = nArray[bond.atoms[1] - 1];
            dArray4[0] = dArray5[n7][0];
            dArray4[1] = dArray5[n7][1];
            dArray3 = HigherMath.nextSubstituentPoint(dArray5, nArray2, n7, true);
            nArray2 = molecule.getColoredEdges(n2, nArray);
            dArray5 = molecule.getColoredCoordinates(n2, nArray);
            n7 = nArray[bond.atoms[0] - 1];
            dArray[0] = dArray5[n7][0];
            dArray[1] = dArray5[n7][1];
            dArray2 = HigherMath.nextSubstituentPoint(dArray5, nArray2, n7, true);
            HigherMath.transformPoints(dArray5, dArray5.length, dArray, dArray2, dArray3, dArray4);
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n2) continue;
                molecule.atoms[n].x = dArray5[nArray[n]][0];
                molecule.atoms[n].y = dArray5[nArray[n]][1];
            }
            for (n = 0; n < molecule.atoms.length; ++n) {
                if (molecule.atoms[n].color != n3) continue;
                molecule.atoms[n].color = n2;
            }
        }
    }

    private static void layoutFragments(Molecule molecule, int[] nArray, int[] nArray2) {
        FragmentDesc fragmentDesc;
        Atom atom;
        int n;
        FragmentDesc fragmentDesc2 = null;
        for (n = 0; n < molecule.atoms.length; ++n) {
            atom = molecule.atoms[n];
            fragmentDesc = fragmentDesc2;
            while (fragmentDesc != null && fragmentDesc.color != atom.color) {
                fragmentDesc = fragmentDesc.next;
            }
            if (fragmentDesc != null) {
                ++fragmentDesc.natoms;
                continue;
            }
            fragmentDesc = new FragmentDesc(1.0E7, 1.0E7, -1.0E7, -1.0E7, atom.color, 1);
            fragmentDesc.next = fragmentDesc2;
            fragmentDesc2 = fragmentDesc;
        }
        FragmentDesc fragmentDesc3 = fragmentDesc2;
        while (fragmentDesc3 != null && fragmentDesc3.next != null) {
            fragmentDesc = fragmentDesc2;
            while (fragmentDesc != null && fragmentDesc.next != null) {
                if (fragmentDesc.natoms < fragmentDesc.next.natoms) {
                    int n2 = fragmentDesc.next.natoms;
                    fragmentDesc.next.natoms = fragmentDesc.natoms;
                    fragmentDesc.natoms = n2;
                    n2 = fragmentDesc.next.color;
                    fragmentDesc.next.color = fragmentDesc.color;
                    fragmentDesc.color = n2;
                }
                fragmentDesc = fragmentDesc.next;
            }
            fragmentDesc3 = fragmentDesc3.next;
        }
        fragmentDesc = fragmentDesc2;
        while (fragmentDesc != null) {
            for (n = 0; n < molecule.atoms.length; ++n) {
                atom = molecule.atoms[n];
                if (atom.color != fragmentDesc.color) continue;
                if (atom.x < fragmentDesc.xll) {
                    fragmentDesc.xll = atom.x;
                }
                if (atom.y < fragmentDesc.yll) {
                    fragmentDesc.yll = atom.y;
                }
                if (atom.x > fragmentDesc.xur) {
                    fragmentDesc.xur = atom.x;
                }
                if (!(atom.y > fragmentDesc.yur)) continue;
                fragmentDesc.yur = atom.y;
            }
            fragmentDesc = fragmentDesc.next;
        }
        fragmentDesc = fragmentDesc2;
        while (fragmentDesc != null) {
            fragmentDesc.xll -= 0.757;
            fragmentDesc.yll -= 0.757;
            fragmentDesc.xur += 0.757;
            fragmentDesc.yur += 0.757;
            fragmentDesc.xoffset = -fragmentDesc.xll;
            fragmentDesc.yoffset = -fragmentDesc.yll;
            fragmentDesc = fragmentDesc.next;
        }
        double d = 0.0;
        fragmentDesc = fragmentDesc2;
        while (fragmentDesc != null) {
            fragmentDesc.xoffset += d;
            d += fragmentDesc.xur - fragmentDesc.xll;
            fragmentDesc = fragmentDesc.next;
        }
        for (n = 0; n < molecule.atoms.length; ++n) {
            atom = molecule.atoms[n];
            fragmentDesc = fragmentDesc2;
            while (fragmentDesc != null && fragmentDesc.color != atom.color) {
                fragmentDesc = fragmentDesc.next;
            }
            if (fragmentDesc == null) continue;
            atom.x += fragmentDesc.xoffset;
            atom.y += fragmentDesc.yoffset;
        }
    }
}

