/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

public class Bond {
    int[] atoms = new int[2];
    int bond_type;
    public static final int NOBOND = 1;
    public static final int SINGLE = 2;
    public static final int DOUBLE = 4;
    public static final int TRIPLE = 8;
    public static final int AROMATIC = 16;
    int stereo_symbol;
    public static final int NORMAL = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int EITHER = 3;
    public static final int DBL_EITHER = 4;
    public static final int CIS = 5;
    public static final int TRANS = 6;
    int topography;
    public static final int UNDEFINED = 0;
    public static final int RING = 1;
    public static final int CHAIN = 2;
    int reaction_mark;
    public static final int CHANGED = 1;
    public static final int MAKE_BRAKE = 2;
    public static final int UNCHANGED = 4;
    public static final int ANY_CHANGE = 3;
    public static final int UNKNOWN = 7;
    int ring_sizes;
    float value = 0.0f;
    int color = 0;
    int flags = 0;
    int number = 0;
    Bond[] neighbourbonds = null;

    public int[] getAtomNumbers() {
        int[] nArray = new int[]{this.atoms[0], this.atoms[1]};
        return nArray;
    }

    public int getBondType() {
        return this.bond_type;
    }

    public int getBondFlags() {
        return this.flags;
    }

    public static int interpretMDLBondType(int n) {
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 4;
        }
        if (n == 3) {
            return 8;
        }
        if (n == 4) {
            return 16;
        }
        if (n == 5) {
            return 6;
        }
        if (n == 6) {
            return 18;
        }
        if (n == 7) {
            return 20;
        }
        if (n == 8) {
            return 31;
        }
        return 1;
    }

    public static int interpretMDLStereoSymbol(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 6) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 3) {
            return 4;
        }
        return 0;
    }

    public static int interpretMDLTopography(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    public static int interpretMDLReactionMark(int n) {
        if (n == 1) {
            return 3;
        }
        if (n == 2) {
            return 4;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 6) {
            return 7;
        }
        if (n == 8) {
            return 1;
        }
        if (n == -1) {
            return 4;
        }
        return 0;
    }

    public int smallestRing() {
        if (this.ring_sizes == 0) {
            return 0;
        }
        for (int i = 3; i <= 15; ++i) {
            if ((this.ring_sizes & 1 << i) == 0) continue;
            return i;
        }
        return 15;
    }

    public Bond(int n, int n2, int n3, int n4, int n5, int n6) {
        this.atoms[0] = n;
        this.atoms[1] = n2;
        this.bond_type = n3;
        this.stereo_symbol = n4;
        this.topography = n5;
        this.reaction_mark = n6;
    }

    public Object clone() {
        Bond bond = new Bond(this.atoms[0], this.atoms[1], this.bond_type, this.stereo_symbol, this.topography, this.reaction_mark);
        bond.value = this.value;
        bond.color = this.color;
        bond.flags = this.flags;
        bond.number = this.number;
        return bond;
    }
}

