/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import novartis.chemistry.molecule.PTable;

public class AtomConstraint {
    int dbl_min;
    int dbl_max;
    boolean is_open;

    public AtomConstraint(AtomConstraint atomConstraint) {
        this.dbl_min = atomConstraint.dbl_min;
        this.dbl_max = atomConstraint.dbl_max;
        this.is_open = atomConstraint.is_open;
    }

    public AtomConstraint(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = this.is_open = n4 > 0;
        if (n4 == 0) {
            this.dbl_min = n2;
            this.dbl_max = n2;
            this.is_open = false;
        } else if (n2 > 0 && n4 > 0 && n5 == 0 && n6 == 0 && string.equals("C")) {
            this.dbl_min = n2;
            this.dbl_max = n2;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 2 && n5 == 0 && n6 == 0 && string.equals("C") && (n7 == -1 || n7 == 1)) {
            this.dbl_min = 1;
            this.dbl_max = 1;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 2 && n5 == 0 && n6 == 0 && string.equals("N") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 1;
            this.dbl_max = 1;
            this.is_open = true;
        } else if (n2 == 0 && n3 == 0 && n4 == 2 && n5 == 0 && n6 == 0 && string.equals("N") && (n == 0 && n7 == 1 || n == 1)) {
            this.dbl_min = 0;
            this.dbl_max = 0;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 2 && n5 == 0 && n6 == 0 && string.equals("O") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 0;
            this.dbl_max = 0;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 1 && n5 == 0 && n6 == 0 && string.equals("O") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 0;
            this.dbl_max = 1;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 1 && n5 == 0 && n6 == 0 && string.equals("N") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 0;
            this.dbl_max = 1;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 3 && n5 == 0 && n6 == 0 && string.equals("C") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 1;
            this.dbl_max = 1;
            this.is_open = true;
        } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 4 && n5 == 0 && n6 == 0 && string.equals("S") && (n7 == -1 || n7 == 0)) {
            this.dbl_min = 2;
            this.dbl_max = 2;
            this.is_open = true;
        } else if (n7 == -1) {
            this.dbl_min = n2 + n4 / 2;
            this.dbl_max = n2 + n4 / 2;
            this.is_open = true;
        } else {
            int n8 = PTable.implicitHydrogens(string, n, n4, n2, n3, n6, n5);
            if (n7 >= 0 && n8 > n7) {
                this.dbl_min = n2 + n4 / 2 - (n8 - n7);
                this.dbl_max = n2 + n4 / 2 - (n8 - n7);
            } else {
                this.dbl_min = n2 + n4 / 2;
                this.dbl_max = n2 + n4 / 2;
            }
        }
    }

    public Object clone() {
        AtomConstraint atomConstraint = new AtomConstraint(this);
        return atomConstraint;
    }
}

