/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.util.HashMap;
import novartis.chemistry.molecule.Bond;
import novartis.chemistry.molecule.PTable;
import novartis.utilities.IntProperty;

public class Atom {
    double x;
    double y;
    double z;
    int atomic_number;
    String symbol;
    String[] atomList = null;
    boolean notLogic = false;
    int isotope;
    public static final int NATURAL = 0;
    int charge;
    int radical;
    public static final int NO_RADICAL = 0;
    public static final int SINGLET = 1;
    public static final int DOUBLET = 2;
    public static final int TRIPLET = 4;
    public static final int ANY_RADICAL = 7;
    public static final int NO_MAPPING = 0;
    int reaction_mapping = 0;
    IntProperty int_properties = null;
    HashMap<String, String> stringProperties = new HashMap();
    static final int DEFAULT_HCOUNT = -1;
    int implicit_H_count = -1;
    public static final int UNDEFINED = 0;
    public static final int RING = 1;
    public static final int CHAIN = 2;
    int topography = 0;
    Atom[] neighbour_atoms = null;
    Bond[] neighbour_bonds = null;
    int index = -1;
    float value = 0.0f;
    int color = 0;
    int flags = 0;
    int number = 0;

    public String getSymbol() {
        return this.symbol;
    }

    public static int MDLChargeRadicalToCharge(int n) {
        if (n == 1) {
            return 3;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 1;
        }
        if (n == 5) {
            return -1;
        }
        if (n == 6) {
            return -2;
        }
        if (n == 7) {
            return -3;
        }
        return 0;
    }

    public static int MDLChargeRadicalToRadical(int n) {
        if (n == 4) {
            return 2;
        }
        return 0;
    }

    public void setIntProperty(String string, int n) {
        this.int_properties = IntProperty.setPropertyInList(this.int_properties, string, n);
    }

    public void removeIntProperty(String string) {
        this.int_properties = IntProperty.removePropertyFromList(this.int_properties, string);
    }

    public int getIntProperty(String string, int n) {
        return IntProperty.findValue(this.int_properties, string, n);
    }

    public void setStringProperty(String string, String string2) {
        this.stringProperties.put(string, string2);
    }

    public String getStringProperty(String string) {
        return this.stringProperties.get(string);
    }

    public Atom(double d, double d2, double d3, String string, String[] stringArray, boolean bl, int n, int n2, int n3, int n4, int n5) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.symbol = string;
        this.atomList = stringArray;
        this.notLogic = bl;
        this.implicit_H_count = n;
        this.atomic_number = PTable.SymbolToAtomicNumber(string);
        this.isotope = n2;
        this.charge = n3;
        this.radical = n4;
        this.reaction_mapping = n5;
    }

    public Atom(String string, int n, int n2, int n3, int n4) {
        this(0.0, 0.0, 0.0, string, null, false, -1, n, n2, n3, n4);
    }

    public Object clone() {
        Atom atom = new Atom(this.x, this.y, this.z, this.symbol, this.atomList, this.notLogic, this.implicit_H_count, this.isotope, this.charge, this.radical, this.reaction_mapping);
        atom.value = this.value;
        atom.color = this.color;
        atom.flags = this.flags;
        atom.number = this.number;
        Object object = this.int_properties;
        while (object != null) {
            IntProperty intProperty = new IntProperty((IntProperty)object);
            intProperty.next = atom.int_properties;
            atom.int_properties = intProperty;
            object = ((IntProperty)object).next;
        }
        object = new HashMap();
        for (String string : this.stringProperties.keySet()) {
            atom.stringProperties.put(string, this.stringProperties.get(string));
        }
        return atom;
    }
}

