/*
 * Decompiled with CFR 0.152.
 */
package avalon.jsp.servlets;

import avalon.jni.JNISmi2Mol;
import avalon.tools.Base64;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jni.JNIDepict;
import jni.JNIMatch;
import novartis.chemistry.molecule.MOLCanvas;
import novartis.chemistry.molecule.Molecule;
import novartis.chemistry.molecule.MoleculeDepicter;
import novartis.chemistry.molecule.StandardMOL;
import novartis.utilities.FortranInputStream;
import novartis.utilities.MetaDraw;
import org.apache.log4j.Logger;

public class Mol2ImageServlet
extends HttpServlet {
    static Logger log = Logger.getLogger((String)Mol2ImageServlet.class.getName());
    static MOLCache<String, byte[]> cache = new MOLCache(100, 0.8f, true);
    static int nPNG = 0;
    static int nMD5 = 0;
    static int nGIF = 0;
    static int nWithScaffold = 0;
    static int nWithTplMOL = 0;
    static int nFPLabels = 0;
    static int nHEX = 0;
    static int nBIN = 0;
    static int nLST = 0;
    static int nPLT = 0;
    static int nFlags = 0;
    static int nB64 = 0;
    static int nMOL = 0;
    static int nHealth = 0;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doService(httpServletRequest, httpServletResponse, false);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doService(httpServletRequest, httpServletResponse, true);
    }

    public void init() {
        ImageIO.setUseCache(false);
    }

    public synchronized void reportHealth(HttpServletResponse httpServletResponse) throws IOException {
        ++nHealth;
        httpServletResponse.setContentType("text/xml");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        Runtime runtime = Runtime.getRuntime();
        printWriter.println("<health>");
        printWriter.println("    <heapSize>" + runtime.totalMemory() + "</heapSize>");
        printWriter.println("    <heapMaxSize>" + runtime.maxMemory() + "</heapMaxSize>");
        printWriter.println("    <heapFreeSize>" + runtime.freeMemory() + "</heapFreeSize>");
        runtime.gc();
        printWriter.println("    <afterGC total='" + runtime.totalMemory() + "' free='" + runtime.freeMemory() + "' used='" + (runtime.totalMemory() - runtime.freeMemory()) + "'/>");
        printWriter.println("    <molCache size='" + cache.size() + "'/>");
        printWriter.println("    <counters");
        printWriter.println("       nHealth='" + nHealth + "' ");
        printWriter.println("       nPNG='" + nPNG + "' ");
        printWriter.println("       nMD5='" + nMD5 + "' ");
        printWriter.println("       nGIF='" + nGIF + "' ");
        printWriter.println("       nBIN='" + nBIN + "' ");
        printWriter.println("       nHEX='" + nHEX + "' ");
        printWriter.println("       nLST='" + nLST + "' ");
        printWriter.println("       nPLT='" + nPLT + "' ");
        printWriter.println("       nFlags='" + nFlags + "' ");
        printWriter.println("       nMOL='" + nMOL + "' ");
        printWriter.println("       nB64='" + nB64 + "' ");
        printWriter.println("       nFPLabels='" + nFPLabels + "' ");
        printWriter.println("       nWithTplMOL='" + nWithTplMOL + "' ");
        printWriter.println("       nWithScaffold='" + nWithScaffold + "' " + "/>");
        printWriter.println("    <version>1.2.0</version>");
        printWriter.println("    <build>#BUILD_NUMBER#</build>");
        printWriter.println("</health>");
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doService(HttpServletRequest var1_1, HttpServletResponse var2_2, boolean var3_3) throws IOException {
        block96: {
            block94: {
                block95: {
                    var4_4 = var1_1.getPathInfo();
                    if (var4_4.endsWith("health.xml")) {
                        this.reportHealth(var2_2);
                        return;
                    }
                    var5_5 = var1_1.getParameter("footer");
                    var6_6 = var1_1.getParameter("title");
                    var7_7 = var1_1.getParameter("smiles");
                    var8_8 = null;
                    if (var7_7 != null) {
                        var7_7 = var7_7.replaceAll("\\;v\\d+", "");
                        var7_7 = var7_7.replaceAll("\\[R(\\d+)\\]", "[$1R]");
                        var7_7 = var7_7.replaceAll("\\[([A-Z][a-z]*)\\*\\]", "[$1](*)");
                        Mol2ImageServlet.log.info((Object)("pruned smiles = '" + var7_7 + "'"));
                    }
                    if (var7_7 != null && var7_7.trim().matches("[^>]+>[^>]*>[^>]+")) {
                        var8_8 = var7_7;
                    }
                    var9_9 = "true".equalsIgnoreCase(var1_1.getParameter("chains"));
                    var10_10 = var1_1.getParameter("molfile");
                    if (var10_10 != null) {
                        Mol2ImageServlet.log.info((Object)("molfile =\n" + var10_10));
                    }
                    if ((var11_11 = var1_1.getParameter("scaffold")) != null && var11_11.trim().length() == 0) {
                        var11_11 = null;
                    }
                    if (var11_11 != null) {
                        ++Mol2ImageServlet.nWithScaffold;
                        Mol2ImageServlet.log.info((Object)("scaffold =\n" + var11_11));
                    }
                    if ((var12_12 = var1_1.getParameter("tplMOL")) != null && var12_12.trim().length() == 0) {
                        var12_12 = null;
                    }
                    if (var12_12 != null) {
                        ++Mol2ImageServlet.nWithTplMOL;
                        Mol2ImageServlet.log.info((Object)("tplMOL =\n" + var12_12));
                    }
                    if ((var13_13 = var1_1.getParameter("width")) == null) {
                        var13_13 = var1_1.getParameter("w");
                    }
                    var14_14 = 300;
                    if (var13_13 != null) {
                        try {
                            var14_14 = Integer.parseInt(var13_13);
                        }
                        catch (RuntimeException var15_15) {
                            // empty catch block
                        }
                    }
                    if ((var15_16 = var1_1.getParameter("height")) == null) {
                        var15_16 = var1_1.getParameter("h");
                    }
                    var16_17 = 250;
                    if (var15_16 != null) {
                        try {
                            var16_17 = Integer.parseInt(var15_16);
                        }
                        catch (RuntimeException var17_18) {
                            // empty catch block
                        }
                    }
                    var17_19 = var1_1.getParameter("md5");
                    var18_20 = var1_1.getParameter("nbits");
                    var19_21 = 512;
                    try {
                        var19_21 = Integer.parseInt(var18_20);
                    }
                    catch (Exception var20_22) {
                        // empty catch block
                    }
                    var20_23 = false;
                    if ("true".equalsIgnoreCase(var1_1.getParameter("asquery"))) {
                        var20_23 = true;
                    }
                    var21_24 = false;
                    if ("true".equalsIgnoreCase(var1_1.getParameter("usefplabels"))) {
                        ++Mol2ImageServlet.nFPLabels;
                        var21_24 = true;
                    }
                    var22_25 = var1_1.getParameter("bits");
                    var23_26 = new byte[var19_21 / 8];
                    var24_27 = new byte[var19_21 / 8];
                    var25_28 = null;
                    var26_29 = "true".equalsIgnoreCase(var1_1.getParameter("cb"));
                    if (var22_25 != null) {
                        var27_30 /* !! */  = var22_25.split(",");
                        var25_28 = new int[var27_30 /* !! */ .length];
                        var28_31 = 0;
                        for (var29_33 = false; var29_33 < var27_30 /* !! */ .length; var29_33 += 1) {
                            try {
                                var30_35 = Integer.parseInt(var27_30 /* !! */ [var29_33]);
                                if (var30_35 >= var19_21) continue;
                                var25_28[var28_31] = var30_35;
                                v0 = var30_35 / 8;
                                var23_26[v0] = (byte)(var23_26[v0] | (byte)(1 << var30_35 % 8));
                                if (var28_31 == 0) {
                                    v1 = var30_35 / 8;
                                    var24_27[v1] = (byte)(var24_27[v1] | (byte)(1 << var30_35 % 8));
                                }
                                ++var28_31;
                                continue;
                            }
                            catch (Exception var30_36) {
                                // empty catch block
                            }
                        }
                        if (var28_31 < var27_30 /* !! */ .length) {
                            var29_34 = new int[var28_31];
                            for (var30_35 = 0; var30_35 < var28_31; ++var30_35) {
                                var29_34[var30_35] = var25_28[var30_35];
                            }
                            var25_28 = var29_34;
                        }
                    }
                    var27_30 /* !! */  = var1_1.getParameter("colored");
                    var28_32 = var1_1.getParameter("tpl_coords");
                    var29_33 = null != var1_1.getParameter("b");
                    var30_37 = var1_1.getParameter("bg");
                    var31_38 = var1_1.getParameter("t");
                    var32_39 = var1_1.getParameter("flags");
                    if (var32_39 != null && var32_39.matches(".*\\bchains\\b.*")) {
                        var9_9 = true;
                    }
                    var33_40 = 0;
                    if (var32_39 != null && var32_39.matches(".*\\baminoacids\\b.*")) {
                        var33_40 |= 1;
                    }
                    if (var32_39 != null && var32_39.matches(".*\\bprotecting-groups\\b.*")) {
                        var33_40 |= 2;
                    }
                    if (var32_39 != null && var32_39.matches(".*\\bextended\\b.*")) {
                        var33_40 |= 256;
                    }
                    if (var32_39 != null && var32_39.matches(".*\\bnon-standard\\b.*")) {
                        var33_40 |= 512;
                    }
                    if (var32_39 != null && var32_39.matches(".*\\bcatch-all\\b.*")) {
                        var33_40 |= 32768;
                    }
                    if (var32_39 != null && var32_39.trim().length() > 0) {
                        Mol2ImageServlet.log.info((Object)("flagString = '" + var32_39 + "', flags = " + var33_40));
                    }
                    if (var33_40 != 0) {
                        ++Mol2ImageServlet.nFlags;
                    }
                    var34_41 = System.currentTimeMillis();
                    var2_2.setDateHeader("Expires", var34_41 + 86400000L);
                    if (var12_12 == null && var11_11 != null && !var11_11.trim().equals("")) {
                        var36_42 = Mol2ImageServlet.class;
                        // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                        var12_12 = JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags(var11_11, 65536);
                        // MONITOREXIT : var36_42
                    }
                    if (var10_10 == null && var7_7 != null && !var7_7.equals("")) {
                        if (var9_9) {
                            var7_7 = Mol2ImageServlet.abbreviateChains(var7_7);
                            Mol2ImageServlet.log.info((Object)("after useChains: smiles = '" + var7_7 + "'"));
                        }
                        var36_42 = Mol2ImageServlet.class;
                        // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                        var10_10 = var12_12 != null && !var12_12.trim().equals("") ? (var28_32 != null && var28_32.equalsIgnoreCase("rotate") ? JNIDepict.getDepictor().smiToMOLWithTemplate(var7_7, var12_12) : (var28_32 != null && var28_32.equalsIgnoreCase("force") ? JNISmi2Mol.getSmi2Mol().smiToMOLWithTemplate(var7_7, var12_12) : JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags(var7_7, var33_40))) : JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags(var7_7, var33_40);
                        // MONITOREXIT : var36_42
                    }
                    if (var10_10 == null) {
                        var10_10 = "";
                    }
                    if (var4_4.endsWith(".smi")) {
                        var2_2.setContentType("text/plain");
                        var36_42 = var2_2.getWriter();
                        var37_43 = Mol2ImageServlet.class;
                        // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                        if (var10_10.length() < 30) {
                            var36_42.println("Broken MOL file\n" + var10_10);
                            return;
                        }
                        var36_42.println(JNISmi2Mol.getSmi2Mol().getSMILESFromCT(var10_10));
                        // MONITOREXIT : var37_43
                        return;
                    }
                    var36_42 = null;
                    var37_44 = null;
                    if (var10_10.length() <= 0) break block94;
                    var36_42 = new MOLCanvas(var10_10.toString(), var14_14, var16_17, false);
                    if (var12_12 == null || !"yes".equalsIgnoreCase((String)var27_30 /* !! */ ) && !"true".equalsIgnoreCase((String)var27_30 /* !! */ )) break block95;
                    try {
                        var38_45 = new BufferedReader(new StringReader(var10_10.toString()));
                        var39_47 /* !! */  = new FortranInputStream((BufferedReader)var38_45);
                        var40_49 = new StandardMOL();
                        var40_49.readMOLFile((FortranInputStream)var39_47 /* !! */ );
                        var41_51 = JNIMatch.getMatcher();
                        var42_53 = JNIMatch.getMatchColoring((String)var10_10.toString(), (String)var12_12, (int)2);
                        var36_42.setMOLFile(var10_10.toString(), var42_53);
                        Mol2ImageServlet.log.info((Object)"colorIndices computed");
                    }
                    catch (Throwable var38_46) {
                        System.err.println("Exception " + var38_46 + " ignored");
                    }
                    ** GOTO lbl232
                }
                if (var19_21 <= 0 || var25_28 == null || var7_7 == null) ** GOTO lbl232
                var38_45 = new int[var7_7.length()];
                var39_47 /* !! */  = JNIMatch.getMatcher();
                var40_50 = 0;
                var41_52 = Mol2ImageServlet.class;
                // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                break block96;
            }
            var36_42 = new MOLCanvas(null, var14_14, var16_17, false);
            ** GOTO lbl232
        }
        for (var42_54 = 0; var42_54 < 31; ++var42_54) {
            var43_56 = var39_47 /* !! */ .getFingerprintFromCT(var10_10, false, 1 << var42_54, var23_26.length);
            for (var44_58 = 0; var44_58 < var23_26.length; ++var44_58) {
                if (var23_26[var44_58] == 0 || 0 == (var43_56[var44_58] & var23_26[var44_58])) continue;
                var40_50 |= 1 << var42_54;
            }
        }
        // MONITOREXIT : var41_52
        var41_52 = new HashSet<E>();
        var42_55 = new ArrayList<String>();
        var43_57 = 0;
        while (true) {
            block98: {
                block99: {
                    block97: {
                        if (var43_57 >= 31) break block97;
                        var44_60 = new int[((Object)var38_45).length];
                        if (0 == (var40_50 & 1 << var43_57)) break block98;
                        var45_63 = Mol2ImageServlet.class;
                        // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                        var39_47 /* !! */ .setFingerprintColorsForCT(var10_10, var24_27, false, 1 << var43_57, var44_60);
                        // MONITOREXIT : var45_63
                        break block99;
                    }
                    for (var43_57 = 0; var43_57 < var23_26.length; ++var43_57) {
                        v2 = var43_57;
                        var23_26[v2] = (byte)(var23_26[v2] ^ var24_27[var43_57]);
                    }
                    break;
                }
                for (var45_62 = 0; var45_62 < var44_60.length; ++var45_62) {
                    if (var44_60[var45_62] <= 0 || var38_45[var45_62] != false) continue;
                    for (var46_65 = 0; var46_65 < var24_27.length * 8; ++var46_65) {
                        if ((var24_27[var46_65 / 8] & (byte)(1 << var46_65 % 8)) == 0 || var41_52.contains(var47_66 = JNIMatch.maskToString((int)(1 << var43_57)) + "(" + var46_65 + ")")) continue;
                        var41_52.add(var47_66);
                        var42_55.add(var47_66);
                    }
                    var38_45[var45_62] = true;
                }
            }
            ++var43_57;
        }
        var43_57 = 0;
        while (true) {
            block101: {
                block102: {
                    block100: {
                        if (var43_57 >= 31) break block100;
                        var44_61 = new int[((Object)var38_45).length];
                        if (0 == (var40_50 & 1 << var43_57)) break block101;
                        var45_64 = Mol2ImageServlet.class;
                        // MONITORENTER : avalon.jsp.servlets.Mol2ImageServlet.class
                        var39_47 /* !! */ .setFingerprintColorsForCT(var10_10, var23_26, false, 1 << var43_57, var44_61);
                        // MONITOREXIT : var45_64
                        break block102;
                    }
                    var36_42.setMOLFile(var10_10.toString(), (int[])var38_45);
                    if (var21_24) {
                        var37_44 = var42_55.toArray(new String[0]);
                    }
lbl232:
                    // 7 sources

                    var36_42.setBackground(Color.white);
                    var36_42.setOpaque(true);
                    var36_42.setSize(var14_14, var16_17);
                    var38_45 = Color.white;
                    if (var30_37 != null) {
                        try {
                            var38_45 = new Color(Integer.parseInt(var30_37, 16));
                        }
                        catch (Exception var39_48) {
                            System.err.println("bg = " + var30_37);
                            var39_48.printStackTrace();
                        }
                    }
                    if (var4_4.endsWith(".gif")) {
                        ++Mol2ImageServlet.nGIF;
                    } else if (var4_4.endsWith(".png")) {
                        ++Mol2ImageServlet.nPNG;
                    } else if (var4_4.endsWith(".hex")) {
                        ++Mol2ImageServlet.nHEX;
                    } else if (var4_4.endsWith(".bin")) {
                        ++Mol2ImageServlet.nBIN;
                    } else if (var4_4.endsWith(".lst")) {
                        ++Mol2ImageServlet.nLST;
                    } else if (var4_4.endsWith(".plt")) {
                        ++Mol2ImageServlet.nPLT;
                    } else if (var4_4.endsWith(".b64")) {
                        ++Mol2ImageServlet.nB64;
                    } else if (var4_4.endsWith(".md5")) {
                        ++Mol2ImageServlet.nMD5;
                    } else if (var4_4.endsWith(".mol")) {
                        ++Mol2ImageServlet.nMOL;
                    }
                    if (var4_4.endsWith(".gif") || var4_4.endsWith(".png")) {
                        if (var4_4.endsWith(".gif")) {
                            var2_2.setContentType("image/gif");
                        } else {
                            var2_2.setContentType("image/png");
                        }
                        var39_47 /* !! */  = var2_2.getOutputStream();
                        this.sendBinaryOutput((OutputStream)var39_47 /* !! */ , var4_4, var7_7, (MOLCanvas)var36_42, var8_8, var17_19, Mol2ImageServlet.cache, var14_14, var16_17, var29_33, (Color)var38_45, var31_38 != null, var37_44, var6_6, var5_5, var26_29);
                        return;
                    }
                    if (var4_4.endsWith(".hex") || var4_4.endsWith(".bin") || var4_4.endsWith(".lst") || var4_4.endsWith(".plt") || var4_4.endsWith(".b64") || var4_4.endsWith(".md5")) {
                        var2_2.setContentType("text/plain");
                    } else if (var4_4.endsWith(".mol")) {
                        var2_2.setContentType("chemical/x-mdl-molfile");
                    } else {
                        var2_2.setContentType("text/html");
                    }
                    var39_47 /* !! */  = var2_2.getWriter();
                    this.sendTextOutput((PrintWriter)var39_47 /* !! */ , var4_4, var7_7, var10_10, (MOLCanvas)var36_42, var8_8, var19_21, var20_23, var17_19, var14_14, var16_17, var29_33, (Color)var38_45, var31_38 != null, var37_44, var6_6, var5_5, var1_1.getRequestURL().toString(), var26_29);
                    return;
                }
                for (var45_62 = 0; var45_62 < var44_61.length; ++var45_62) {
                    if (var44_61[var45_62] > 0) {
                        for (var46_65 = 0; var46_65 < var23_26.length * 8; ++var46_65) {
                            if ((var23_26[var46_65 / 8] & (byte)(1 << var46_65 % 8)) == 0 || var41_52.contains(var47_66 = JNIMatch.maskToShortString((int)(1 << var43_57)))) continue;
                            var41_52.add(var47_66);
                            var42_55.add(var47_66);
                        }
                    }
                    if (var44_61[var45_62] == 1 && var38_45[var45_62] != true) {
                        var38_45[var45_62] = 2;
                        continue;
                    }
                    if (var44_61[var45_62] != 2 || var38_45[var45_62] != false) continue;
                    var38_45[var45_62] = 7;
                }
            }
            ++var43_57;
        }
    }

    private void copyFile(BufferedReader bufferedReader, PrintWriter printWriter) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
            printWriter.write(cArray, 0, n);
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendGif(MOLCanvas mOLCanvas, String string, OutputStream outputStream, int n, int n2, String[] stringArray, String string2, String string3, boolean bl) {
        Graphics graphics = null;
        try {
            String[] stringArray2;
            Object object;
            Object object2;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 13);
            graphics = bufferedImage.createGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            if (string != null) {
                object2 = string.substring(0, string.indexOf(62));
                object = string.substring(string.lastIndexOf(62) + 1);
                StandardMOL standardMOL = null;
                StandardMOL standardMOL2 = null;
                stringArray2 = Mol2ImageServlet.class;
                synchronized (Mol2ImageServlet.class) {
                    String[] stringArray3 = JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags((String)object2, 0);
                    Object object3 = new BufferedReader(new StringReader((String)stringArray3));
                    Object object4 = new FortranInputStream((BufferedReader)object3);
                    standardMOL = new StandardMOL();
                    standardMOL.readMOLFile((FortranInputStream)object4);
                    ((BufferedReader)object3).close();
                    standardMOL.recolor();
                    standardMOL.clearTopography();
                    stringArray3 = JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags((String)object, 0);
                    object3 = new BufferedReader(new StringReader((String)stringArray3));
                    object4 = new FortranInputStream((BufferedReader)object3);
                    standardMOL2 = new StandardMOL();
                    standardMOL2.readMOLFile((FortranInputStream)object4);
                    ((BufferedReader)object3).close();
                    standardMOL2.recolor();
                    standardMOL2.clearTopography();
                    // ** MonitorExit[var16_23] (shouldn't be in output)
                    Molecule.perceiveReaction(standardMOL, standardMOL2);
                    stringArray2 = new MoleculeDepicter().computeDepiction(standardMOL, 0, 0, 3, null, null);
                    stringArray3 = new MoleculeDepicter().computeDepiction(standardMOL2, 0, 0, 3, null, null);
                    object3 = MetaDraw.preferredPlotSize(stringArray2);
                    object4 = MetaDraw.preferredPlotSize(stringArray3);
                    Rectangle rectangle = new Rectangle(n * 2 / 5, n2);
                    MetaDraw.depictCommands(graphics, stringArray2, rectangle, true, bl);
                    rectangle = new Rectangle(n * 3 / 5, 0, n * 2 / 5, n2);
                    MetaDraw.depictCommands(graphics, stringArray3, rectangle, true, bl);
                    graphics.drawLine(n * 21 / 50, n2 * 25 / 50, n * 29 / 50, n2 * 25 / 50);
                    graphics.drawLine(n * 28 / 50, n2 * 24 / 50, n * 29 / 50, n2 * 25 / 50);
                    graphics.drawLine(n * 28 / 50, n2 * 26 / 50, n * 29 / 50, n2 * 25 / 50);
                }
            } else {
                object2 = mOLCanvas.getCommands();
                MetaDraw.depictCommands(graphics, (String[])object2, new Rectangle(n, n2), true, bl);
            }
            {
                if (stringArray != null) {
                    object2 = graphics.getFont();
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    int n3 = -1;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2 = ((Font)object2).getStringBounds(stringArray[i], (FontRenderContext)object);
                        graphics.drawString(stringArray[i], 2, n2 + n3);
                        n3 -= (int)stringArray2.getHeight();
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    object2 = graphics.getFont();
                    graphics.setFont(((Font)object2).deriveFont((float)Math.min(12.0, (double)((Font)object2).getSize2D() * 2.5)));
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string2, (FontRenderContext)object);
                    graphics.drawString(string2, (int)((double)(n / 2) - rectangle2D.getWidth() / 2.0), (int)(3.0 * rectangle2D.getHeight() / 2.0));
                    graphics.setFont((Font)object2);
                }
                if (string3 != null && string3.trim().length() > 0) {
                    object2 = graphics.getFont();
                    graphics.setFont(((Font)object2).deriveFont((float)Math.min(10.0, (double)((Font)object2).getSize2D() * 1.6)));
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string3, (FontRenderContext)object);
                    graphics.drawString(string3, (int)((double)(n / 2) - rectangle2D.getWidth() / 2.0), (int)((double)n2 - rectangle2D.getHeight() / 2.0));
                    graphics.setFont((Font)object2);
                }
                graphics.dispose();
                graphics = null;
                object2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "gif", (OutputStream)object2);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                outputStream.write((byte[])object);
            }
        }
        catch (IOException iOException) {
            if (0 > iOException.toString().indexOf("Abort")) {
                System.err.println("sendGif(): Caught exception: " + iOException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                System.err.println("GIF: Out of bounds dispose()");
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getPngBytes(MOLCanvas mOLCanvas, String string, int n, int n2, boolean bl, Color color, boolean bl2, String[] stringArray, String string2, String string3, boolean bl3) {
        byte[] byArray = new byte[]{};
        Graphics graphics = null;
        try {
            String[] stringArray2;
            Object object;
            Object object2;
            BufferedImage bufferedImage = null;
            bufferedImage = bl2 ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 13);
            graphics = bufferedImage.createGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            if (bl) {
                graphics.setColor(Color.BLACK);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            }
            if (string != null) {
                object2 = string.substring(0, string.indexOf(62));
                object = string.substring(string.lastIndexOf(62) + 1);
                StandardMOL standardMOL = null;
                StandardMOL standardMOL2 = null;
                stringArray2 = Mol2ImageServlet.class;
                synchronized (Mol2ImageServlet.class) {
                    String[] stringArray3 = JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags((String)object2, 0);
                    Object object3 = new BufferedReader(new StringReader((String)stringArray3));
                    Object object4 = new FortranInputStream((BufferedReader)object3);
                    standardMOL = new StandardMOL();
                    standardMOL.readMOLFile((FortranInputStream)object4);
                    ((BufferedReader)object3).close();
                    standardMOL.recolor();
                    standardMOL.clearTopography();
                    stringArray3 = JNISmi2Mol.getSmi2Mol().smiToMOLWithFlags((String)object, 0);
                    object3 = new BufferedReader(new StringReader((String)stringArray3));
                    object4 = new FortranInputStream((BufferedReader)object3);
                    standardMOL2 = new StandardMOL();
                    standardMOL2.readMOLFile((FortranInputStream)object4);
                    ((BufferedReader)object3).close();
                    standardMOL2.recolor();
                    standardMOL2.clearTopography();
                    // ** MonitorExit[var19_24] (shouldn't be in output)
                    Molecule.perceiveReaction(standardMOL, standardMOL2);
                    stringArray2 = new MoleculeDepicter().computeDepiction(standardMOL, 0, 0, 3, null, null);
                    stringArray3 = new MoleculeDepicter().computeDepiction(standardMOL2, 0, 0, 3, null, null);
                    object3 = MetaDraw.preferredPlotSize(stringArray2);
                    object4 = MetaDraw.preferredPlotSize(stringArray3);
                    Rectangle rectangle = new Rectangle(n * 2 / 5, n2);
                    MetaDraw.depictCommands(graphics, stringArray2, rectangle, true, bl3);
                    rectangle = new Rectangle(n * 3 / 5, 0, n * 2 / 5, n2);
                    MetaDraw.depictCommands(graphics, stringArray3, rectangle, true, bl3);
                    graphics.drawLine(n * 21 / 50, n2 * 25 / 50, n * 29 / 50, n2 * 25 / 50);
                    graphics.drawLine(n * 28 / 50, n2 * 24 / 50, n * 29 / 50, n2 * 25 / 50);
                    graphics.drawLine(n * 28 / 50, n2 * 26 / 50, n * 29 / 50, n2 * 25 / 50);
                }
            } else {
                object2 = mOLCanvas.getCommands();
                MetaDraw.depictCommands(graphics, (String[])object2, new Rectangle(n, n2), true, bl3);
            }
            {
                if (stringArray != null) {
                    object2 = graphics.getFont();
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    int n3 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2 = ((Font)object2).getStringBounds(stringArray[i], (FontRenderContext)object);
                        graphics.drawString(stringArray[i], 2, n2 + (n3 -= (int)stringArray2.getHeight()));
                        --n3;
                    }
                }
                if (string2 != null) {
                    object2 = graphics.getFont();
                    graphics.setFont(((Font)object2).deriveFont((float)Math.min(12.0, (double)((Font)object2).getSize2D() * 2.5)));
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string2, (FontRenderContext)object);
                    graphics.drawString(string2, (int)((double)(n / 2) - rectangle2D.getWidth() / 2.0), (int)(3.0 * rectangle2D.getHeight() / 2.0));
                    graphics.setFont((Font)object2);
                }
                if (string3 != null && string3.trim().length() > 0) {
                    object2 = graphics.getFont();
                    graphics.setFont(((Font)object2).deriveFont((float)Math.min(10.0, (double)((Font)object2).getSize2D() * 1.6)));
                    object = ((Graphics2D)graphics).getFontRenderContext();
                    Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string3, (FontRenderContext)object);
                    graphics.drawString(string3, (int)((double)(n / 2) - rectangle2D.getWidth() / 2.0), (int)((double)n2 - rectangle2D.getHeight() / 2.0));
                    graphics.setFont((Font)object2);
                }
                graphics.dispose();
                graphics = null;
                object2 = new ByteArrayOutputStream();
                if (bl2) {
                    object = Mol2ImageServlet.imageToBufferedImage(Mol2ImageServlet.makeColorTransparent(bufferedImage, color));
                    ImageIO.write((RenderedImage)object, "png", (OutputStream)object2);
                    byArray = ((ByteArrayOutputStream)object2).toByteArray();
                } else {
                    ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)object2);
                    byArray = ((ByteArrayOutputStream)object2).toByteArray();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                System.err.println("PNG: Out of bounds dispose()");
            }
        }
        {
            return byArray;
        }
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image makeColorTransparent(BufferedImage bufferedImage, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFFFFFFFF;
            }

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    void sendPng(MOLCanvas mOLCanvas, String string, OutputStream outputStream, int n, int n2, boolean bl, Color color, boolean bl2, String[] stringArray, String string2, String string3, boolean bl3) {
        try {
            outputStream.write(this.getPngBytes(mOLCanvas, string, n, n2, bl, color, bl2, stringArray, string2, string3, bl3));
        }
        catch (IOException iOException) {
            if (0 > iOException.toString().indexOf("Abort")) {
                System.err.println("sendPng(): Caught exception: " + iOException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    private void sendBinaryOutput(OutputStream outputStream, String string, String string2, MOLCanvas mOLCanvas, String string3, String string4, MOLCache<String, byte[]> mOLCache, int n, int n2, boolean bl, Color color, boolean bl2, String[] stringArray, String string5, String string6, boolean bl3) throws IOException {
        if (string.endsWith(".png") && string4 != null) {
            byte[] byArray = mOLCache.get(string4);
            if (byArray != null) {
                outputStream.write(byArray);
                return;
            }
        } else {
            if (string.endsWith(".gif")) {
                this.sendGif(mOLCanvas, string3, outputStream, n, n2, stringArray, string5, string6, bl3);
                return;
            }
            if (string.endsWith(".png")) {
                if (string4 != null) {
                    byte[] byArray = mOLCache.get(string4);
                    if (byArray != null) {
                        outputStream.write(byArray);
                    }
                } else {
                    this.sendPng(mOLCanvas, string3, outputStream, n, n2, bl, color, bl2, stringArray, string5, string6, bl3);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTextOutput(PrintWriter printWriter, String string, String string2, String string3, MOLCanvas mOLCanvas, String string4, int n, boolean bl, String string5, int n2, int n3, boolean bl2, Color color, boolean bl3, String[] stringArray, String string6, String string7, String string8, boolean bl4) throws IOException {
        if (string.endsWith(".hex") || string.endsWith(".bin") || string.endsWith(".lst") || string.endsWith(".mol")) {
            for (int i = 3; i < 15; ++i) {
                if (n >= 1 << i) continue;
                n = 1 << i;
                break;
            }
            byte[] byArray = null;
            Class<Mol2ImageServlet> clazz = Mol2ImageServlet.class;
            synchronized (Mol2ImageServlet.class) {
                JNIMatch jNIMatch = JNIMatch.getMatcher();
                if (string3 == null && string2 != null && !string2.equals("")) {
                    string3 = JNISmi2Mol.getSmi2Mol().smiToMOL(string2);
                }
                byArray = jNIMatch.getFingerprintFromCT(string3, bl, Short.MAX_VALUE, n / 8);
                // ** MonitorExit[var21_25] (shouldn't be in output)
                if (string.endsWith(".hex")) {
                    printWriter.println(Mol2ImageServlet.bytesToHex(byArray));
                } else if (string.endsWith(".mol")) {
                    if (string3 == null || string3.trim().equals("")) {
                        string3 = "\n  -NONE-  12070108312D\n\n  0  0  0  0  0  0  0  0  0  0999 V2000\nM  END\n";
                    }
                    printWriter.println(string3);
                } else if (string.endsWith(".bin")) {
                    for (int i = 0; i < byArray.length; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            if ((byArray[i] & (byte)(1 << j)) != 0) {
                                printWriter.print('1');
                                continue;
                            }
                            printWriter.print('0');
                        }
                    }
                    printWriter.println();
                } else {
                    boolean bl5 = true;
                    for (int i = 0; i < byArray.length; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            if ((byArray[i] & (byte)(1 << j)) == 0) continue;
                            if (bl5) {
                                printWriter.print(8 * i + j);
                            } else {
                                printWriter.print("," + (8 * i + j));
                            }
                            bl5 = false;
                        }
                    }
                    printWriter.println();
                }
                return;
            }
        }
        if (string.endsWith(".plt")) {
            String[] stringArray2 = mOLCanvas.getCommands();
            for (int i = 0; i < stringArray2.length; ++i) {
                printWriter.println(stringArray2[i]);
            }
            return;
        }
        if (string.endsWith(".b64")) {
            byte[] byArray = this.getPngBytes(mOLCanvas, string4, n2, n3, bl2, color, bl3, stringArray, string6, string7, bl4);
            printWriter.print(Base64.encodeBytes(byArray));
        } else {
            if (string.endsWith(".md5") || string.endsWith(".html")) {
                byte[] byArray = this.getPngBytes(mOLCanvas, string4, n2, n3, bl2, color, bl3, stringArray, string6, string7, bl4);
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.reset();
                    messageDigest.update(byArray);
                    byte[] byArray2 = messageDigest.digest();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < byArray2.length; ++i) {
                        stringBuffer.append(Integer.toHexString(0xFF & byArray2[i]));
                    }
                    string5 = stringBuffer.toString();
                    cache.put(string5, byArray);
                    if (string.endsWith(".md5")) {
                        printWriter.println(string5);
                    } else {
                        printWriter.println("<html><body>");
                        printWriter.println("<img src='" + string8.replaceFirst(".html", ".png") + "?md5=" + string5 + "'>");
                        printWriter.println("</body></html>");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            if (string.endsWith("/") || string.contains("version")) {
                printWriter.print("version number = 1.2.0");
                printWriter.println(", build number = #BUILD_NUMBER#");
            } else {
                printWriter.print("path = " + string);
            }
        }
    }

    static String abbreviateChains(String string) {
        int n;
        int n2;
        String string2;
        Matcher matcher;
        Pattern pattern;
        boolean bl;
        if (string == null || string.length() < 5) {
            return string;
        }
        do {
            bl = false;
            pattern = Pattern.compile("^(C{5,99})C\\(");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 1;
            n = string2.length();
            string = matcher.replaceFirst("{C" + n + "H" + n2 + "}C(");
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("\\.(C{5,99})C\\(");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 1;
            n = string2.length();
            string = matcher.replaceFirst(".{C" + n + "H" + n2 + "}C(");
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("^(C{5,99})([NOS])");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 1;
            n = string2.length();
            string = matcher.replaceFirst("{C" + n + "H" + n2 + "}" + matcher.group(2));
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("\\.(C{5,99})([NOS])");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 1;
            n = string2.length();
            string = matcher.replaceFirst(".{C" + n + "H" + n2 + "}" + matcher.group(2));
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("(C{5,99})C\\)");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 3;
            n = string2.length() + 1;
            string = matcher.replaceFirst("{C" + n + "H" + n2 + "})");
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("(C{5,99})C$");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 3;
            n = string2.length() + 1;
            string = matcher.replaceFirst("{C" + n + "H" + n2 + "}");
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("(C{5,99})C\\.");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
            n2 = 2 * string2.length() + 3;
            n = string2.length() + 1;
            string = matcher.replaceFirst("{C" + n + "H" + n2 + "}.");
            bl = true;
        } while (bl);
        do {
            bl = false;
            pattern = Pattern.compile("(CCO){4,99}C");
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(0);
            n2 = (string2.length() - 1) / 3;
            string = matcher.replaceFirst("{PEG" + n2 + "}");
            bl = true;
        } while (bl);
        return string;
    }

    public static void main(String[] stringArray) {
    }

    static class MOLCache<K, V>
    extends LinkedHashMap<K, V> {
        private static int MAX_ENTRIES = 500;

        public MOLCache(int n, float f, boolean bl) {
            super(n, f, bl);
            if (MAX_ENTRIES < 5 * n) {
                MAX_ENTRIES = 5 * n;
            }
        }

        @Override
        public synchronized V put(K k, V v) {
            return super.put(k, v);
        }

        public synchronized V get(String string) {
            return super.get(string);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > MAX_ENTRIES;
        }
    }
}

