/*
 * Decompiled with CFR 0.152.
 */
package jni;

import avalon.tools.LibraryToolbox;
import avalon.tools.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ResourceBundle;

public class JNIMatch {
    static JNIMatch matcher = null;
    public static final int USE_RING_PATTERN = 1;
    public static final int USE_RING_PATH = 2;
    public static final int USE_ATOM_SYMBOL_PATH = 4;
    public static final int USE_ATOM_CLASS_PATH = 8;
    public static final int USE_ATOM_COUNT = 16;
    public static final int USE_AUGMENTED_ATOM = 32;
    public static final int USE_HCOUNT_PATH = 64;
    public static final int USE_HCOUNT_CLASS_PATH = 128;
    public static final int USE_HCOUNT_PAIR = 256;
    public static final int USE_BOND_PATH = 512;
    public static final int USE_AUGMENTED_BOND = 1024;
    public static final int USE_RING_SIZE_COUNTS = 2048;
    public static final int USE_DEGREE_PATH = 4096;
    public static final int USE_CLASS_SPIDERS = 8192;
    public static final int USE_FEATURE_PAIRS = 16384;
    public static final int USE_ALL_BITS = Short.MAX_VALUE;
    public static final int USE_SCAFFOLD_IDS = 0x100000;
    public static final int USE_SCAFFOLD_COLORS = 0x200000;
    public static final int USE_SCAFFOLD_LINKS = 0x400000;
    public static final int USE_NON_SSS_BITS = 0xF00000;
    static String[] patternNames = new String[]{"RING_PATTERN", "RING_PATH", "ATOM_SYMBOL_PATH", "ATOM_CLASS_PATH", "ATOM_COUNT", "AUGMENTED_ATOM", "HCOUNT_PATH", "HCOUNT_CLASS_PATH", "HCOUNT_PAIR", "BOND_PATH", "AUGMENTED_BOND", "RING_SIZE_COUNTS", "DEGREE_PATH", "CLASS_SPIDERS", "FEATURE_PAIRS", "", "", "", "", "", "SCAFFOLD_IDS", "SCAFFOLD_COLORS", "SCAFFOLD_LINKS"};
    static String[] shortPatternNames = new String[]{"RPT", "RPH", "ASP", "ACP", "AC", "AA", "HPH", "HCP", "HP", "BP", "AB", "RSC", "DP", "CS", "FP", "", "", "", "", "", "SI", "SC", "SL"};
    private static final int DB_STEREO = 1;
    private static final int CENTER_STEREO = 2;
    private static final int COMPONENT_SET = 8;
    private static final int MAIN_PART = 16;
    private static final int FORCE_OCTET = 32;
    public static final int CANONIZE_AS_IS = 35;
    public static final int TO_COMPONENT_SET = 43;
    public static final int TO_MAIN_PARTS = 59;
    public static final int TO_NON_STEREO_MAIN = 56;
    static int[] bits_per_byte = null;
    static int DEFAULT_SIZE;

    public static String maskToString(int n) {
        String string = "";
        for (int i = 0; i < patternNames.length; ++i) {
            if (0 == (1 << i & n)) continue;
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + patternNames[i];
        }
        return string;
    }

    public static String maskToShortString(int n) {
        String string = "";
        for (int i = 0; i < patternNames.length; ++i) {
            if (0 == (1 << i & n)) continue;
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + shortPatternNames[i];
        }
        return string;
    }

    public static int stringToMask(String string) {
        int n = 0;
        for (int i = 0; i < patternNames.length; ++i) {
            if (patternNames[i].length() <= 0 || 0 > string.indexOf(patternNames[i])) continue;
            n |= 1 << i;
        }
        return n;
    }

    public synchronized native int canonicalSmilesNative(String var1, byte[] var2, int var3);

    public synchronized String canonicalSmiles(String string, int n) {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length() * 2];
        int n2 = this.canonicalSmilesNative(string, byArray, n);
        if (n2 <= 0) {
            return null;
        }
        return new String(byArray, 0, n2);
    }

    private JNIMatch() {
    }

    public static JNIMatch getMatcher() {
        return matcher;
    }

    static boolean loadFromDirectory(String string) {
        String string2 = string + "/JNIMatch.dll";
        System.err.println("trying to load '" + string2 + "'");
        try {
            if (new File(string2).exists()) {
                System.load(string2);
                System.err.println("Loaded from file '" + string2 + "'");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println("Can't load native library '" + string2 + "'!");
            exception.printStackTrace();
        }
        catch (Error error) {
            System.err.println("Can't load native library '" + string2 + "'!");
            error.printStackTrace();
        }
        return false;
    }

    static boolean loadFromClasspath(String string) {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        String string4 = System.getProperty("file.separator");
        String[] stringArray = StringTools.stringToArray(string2, string3.charAt(0));
        String string5 = "#NONE#";
        for (int i = 0; i < stringArray.length; ++i) {
            String string6;
            if (stringArray[i].lastIndexOf(string4) < 0) continue;
            if (stringArray[i].lastIndexOf(string4) > 0 && (stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip"))) {
                stringArray[i] = stringArray[i].substring(0, stringArray[i].lastIndexOf(string4));
            }
            if (string5.equals(string6 = stringArray[i] + "/" + string)) continue;
            string5 = string6;
            try {
                if (!new File(string6).isFile()) continue;
                System.load(string6);
                System.err.println("Loaded from file '" + string6 + "'");
                return true;
            }
            catch (Exception exception) {
                System.err.println("Can't load native library '" + string6 + "'!");
                continue;
            }
            catch (Error error) {
                System.err.println("Can't load native library '" + string6 + "'!");
            }
        }
        return false;
    }

    static synchronized void loadLibraries() {
        String string = null;
        if (LibraryToolbox.loadLibrary(JNIMatch.class, "JNIMatch")) {
            return;
        }
        if (JNIMatch.loadFromClasspath("JNIMatch.dll")) {
            return;
        }
        if (JNIMatch.loadFromDirectory(System.getProperty("user.dir"))) {
            return;
        }
        String string2 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("libraries");
            string2 = resourceBundle.getString("jnimatch");
            System.err.println("loading from bundle: trying to load " + string2);
            System.load(string2);
            System.err.println("Loaded from file '" + string2 + "'");
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Could not find " + string2);
            System.err.println("java.library.path: " + System.getProperty("java.library.path"));
            string = "JNIMatch";
            System.err.println("JNIMatch(1): " + string);
            try {
                System.loadLibrary(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LibraryToolbox.showError("Error loading " + string + "! \n\n" + "Avalon will exit now.\n", "Configuration Error", false);
                System.exit(1);
            }
            catch (Error error) {
                error.printStackTrace();
                System.err.println("Can't load native library!");
                LibraryToolbox.showError("Error loading " + string + "! \n\n" + "Avalon will exit now.\n", "Configuration Error", false);
                System.exit(1);
            }
            return;
        }
    }

    public synchronized boolean smilesMatchesQueryCT(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null || string2.length() < 3) {
            return true;
        }
        return this.smilesMatchesQueryCTNative(string, string2);
    }

    public synchronized byte[] getFingerprintFromCT(String string, boolean bl, int n) {
        byte[] byArray = new byte[DEFAULT_SIZE];
        matcher.computeFingerprintFromCT(string, byArray, bl, n);
        return byArray;
    }

    public synchronized byte[] getFingerprintFromCT(String string, boolean bl, int n, int n2) {
        byte[] byArray = new byte[n2];
        matcher.computeFingerprintFromCT(string, byArray, bl, n);
        return byArray;
    }

    public synchronized byte[] getFingerprintFromSmiles(String string, boolean bl, int n) {
        byte[] byArray = new byte[DEFAULT_SIZE];
        matcher.computeFingerprintFromSmiles(string, byArray, bl, n);
        return byArray;
    }

    public synchronized byte[] getFingerprintFromSmiles(String string, boolean bl, int n, int n2) {
        byte[] byArray = new byte[n2];
        matcher.computeFingerprintFromSmiles(string, byArray, bl, n);
        return byArray;
    }

    public synchronized native long querySmilesToHandleNative(String var1);

    public synchronized long querySmilesToHandle(String string) {
        return this.querySmilesToHandleNative(string);
    }

    public synchronized native long queryCTToHandleNative(String var1);

    public synchronized long queryCTToHandle(String string) {
        return this.queryCTToHandleNative(string);
    }

    public synchronized native void disposeCTHandleNative(long var1);

    public synchronized void disposeCTHandle(long l) {
        this.disposeCTHandleNative(l);
    }

    public synchronized native boolean smilesMatchesHandleNative(String var1, long var2);

    public synchronized boolean smilesMatchesHandle(String string, long l) {
        return this.smilesMatchesHandleNative(string, l);
    }

    public synchronized native boolean smilesMatchesQueryCTNative(String var1, String var2);

    public synchronized native boolean heapCheck();

    private static String fixCT(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("M  END");
        if (n > 0) {
            string = string.substring(0, n) + "M  END\n";
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        return string;
    }

    public synchronized native int computeFingerprintFromCT(String var1, byte[] var2, boolean var3, int var4);

    public synchronized native boolean computeMatchColorsForCT(String var1, String var2, int[] var3);

    public synchronized native int computeFingerprintColorsForCT(String var1, byte[] var2, boolean var3, int var4, int[] var5);

    public synchronized int setFingerprintColorsForCT(String string, byte[] byArray, boolean bl, int n, int[] nArray) {
        return this.computeFingerprintColorsForCT(string, byArray, bl, n, nArray);
    }

    private static void test(String string, String string2) {
        System.err.println("===== Testing ============");
        JNIMatch jNIMatch = JNIMatch.getMatcher();
        boolean bl = jNIMatch.smilesMatchesQueryCT(string, string2);
        System.err.println("test() returns " + bl);
        System.exit(1);
    }

    public synchronized native int computeFingerprintFromSmiles(String var1, byte[] var2, boolean var3, int var4);

    public static int[] getMatchColoring(String string, String string2, int n) {
        if (string == null) {
            return null;
        }
        int[] nArray = new int[string.split("\\r?\\n").length];
        int[] nArray2 = new int[nArray.length];
        matcher.computeMatchColorsForCT(string, string2, nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray2[i] != 0 ? n : 0;
        }
        return nArray;
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        int n2;
        String string;
        Object object;
        JNIMatch.loadLibraries();
        JNIMatch jNIMatch = JNIMatch.getMatcher();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        boolean bl = true;
        if (stringArray.length > 2) {
            bl = false;
        }
        if (stringArray.length > 3) {
            l = jNIMatch.querySmilesToHandle(stringArray[3]);
        }
        if (stringArray.length >= 1) {
            object = new BufferedReader(new InputStreamReader(System.in));
            while (null != (string = ((BufferedReader)object).readLine())) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        } else {
            System.err.println("usage: java jni.JNIMatch smiles-file label [no-detail] <query.mol");
            return;
        }
        if (stringArray.length > 1) {
            System.err.println("Query = " + stringArray[1]);
        }
        object = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int[] nArray = null;
        byte[][] byArrayArray = new byte[16][];
        byte[][] byArrayArray2 = new byte[16][];
        byte[] byArray = null;
        if (stringBuffer.length() > 10) {
            object = jNIMatch.getFingerprintFromCT(stringBuffer.toString(), true, Short.MAX_VALUE);
            if (l == 0L) {
                l = jNIMatch.queryCTToHandle(stringBuffer.toString());
            }
            nArray = new int[((Object)object).length];
            byArray = new byte[((Object)object).length];
            for (int i = 0; i < patternNames.length && i < 16; ++i) {
                int n7 = 1 << i;
                byArrayArray2[i] = jNIMatch.getFingerprintFromCT(stringBuffer.toString(), true, n7);
                n7 = Short.MAX_VALUE - (1 << i);
                byArrayArray[i] = jNIMatch.getFingerprintFromCT(stringBuffer.toString(), true, n7);
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        int[] nArray2 = new int[16];
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        double[] dArray3 = new double[16];
        double[] dArray4 = new double[16];
        double[] dArray5 = new double[16];
        boolean bl2 = false;
        System.err.println("doFingerprint = " + bl);
        while (null != (string = bufferedReader.readLine())) {
            Object object2;
            if (l == 0L) {
                object2 = jNIMatch.canonicalSmiles(string, 35);
                if (!string.equalsIgnoreCase((String)object2)) {
                    System.out.println(string + "\t" + (String)object2);
                }
                if (++n3 % 100 == 0) {
                    System.err.print('.');
                }
                if (n3 % 5000 != 0) continue;
                System.err.println(" " + n3);
                continue;
            }
            object2 = bl ? jNIMatch.getFingerprintFromSmiles(string, false, Short.MAX_VALUE) : byArray;
            n2 = JNIMatch.countBits(object2);
            d += (double)n2;
            n = JNIMatch.fingerTest(object2, (byte[])object);
            for (int i = 0; i < ((Object)object).length; ++i) {
                if ((object2[i] & object[i]) != object[i]) continue;
                int n8 = i;
                nArray[n8] = nArray[n8] + 1;
            }
            long l2 = System.currentTimeMillis();
            boolean bl3 = jNIMatch.smilesMatchesHandle(string, l);
            if (System.currentTimeMillis() - l2 > 1000L) {
                System.out.println(System.currentTimeMillis() - l2 + "\t" + string);
            }
            if (bl) {
                for (int i = 0; i < patternNames.length && i < 16; ++i) {
                    int n9 = 1 << i;
                    byte[] byArray2 = jNIMatch.getFingerprintFromSmiles(string, false, n9);
                    int n10 = JNIMatch.countBits(byArray2);
                    int n11 = i;
                    dArray3[n11] = dArray3[n11] + (double)n10;
                    if (JNIMatch.fingerTest(byArray2, byArrayArray2[i])) {
                        int n12 = i;
                        dArray[n12] = dArray[n12] + 1.0;
                    } else if (!bl3) {
                        int n13 = i;
                        dArray2[n13] = dArray2[n13] + 1.0;
                        int n14 = i;
                        dArray5[n14] = dArray5[n14] + (double)n10;
                    } else {
                        int n15 = i;
                        nArray2[n15] = nArray2[n15] + 1;
                    }
                    if (!bl3) continue;
                    int n16 = i;
                    dArray4[n16] = dArray4[n16] + (double)n10;
                }
            } else if (bl3) {
                System.out.println(stringArray[1] + "\t" + string);
            }
            if (n != 0 && !bl3) {
                d2 += (double)n2;
                d4 += 1.0;
            }
            if (++n3 % 100 == 0) {
                System.err.print('.');
            }
            if (n3 % 5000 == 0) {
                System.err.println(" " + n3);
            }
            if (n != 0) {
                ++n4;
            }
            if (bl3) {
                ++n5;
                d3 += (double)n2;
            }
            if (n != 0 || !bl3 || !bl) continue;
            ++n6;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream("conflict.smi", true), true);
            printWriter.println(stringArray[0] + "\t" + stringArray[1].replaceAll("_.*", "") + "\t" + string);
            printWriter.close();
        }
        if (l == 0L) {
            return;
        }
        jNIMatch.disposeCTHandle(l);
        bufferedReader.close();
        int n17 = n3;
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            if (nArray[n2] >= n17) continue;
            n17 = nArray[n2];
        }
        System.err.println(" " + n3);
        System.err.println("countQuery = " + JNIMatch.countBits((byte[])object));
        System.err.println("ntest = " + n3);
        System.err.println("nBestByteMatch = " + n17);
        System.err.println("nfpmatch = " + n4);
        System.err.println("nmatch = " + n5);
        System.err.println("nconflict = " + n6);
        System.err.println("avgBits = " + d / (double)n3);
        System.err.println("avgFailBits = " + d2 / d4);
        System.err.println("avgMatchBits = " + d3 / (double)n5);
        if (bl) {
            if (stringArray.length > 1) {
                System.out.print("Query");
                System.out.print("\t");
            }
            System.out.print("Pattern");
            System.out.print("\t");
            System.out.print("Bits in Query");
            System.out.print("\t");
            System.out.print("ntest");
            System.out.print("\t");
            System.out.print("nmatch");
            System.out.print("\t");
            System.out.print("nFPMatchAll");
            System.out.print("\t");
            System.out.print("nBestByteMatch");
            System.out.print("\t");
            System.out.print("nFPMatch");
            System.out.print("\t");
            System.out.print("nFPConflict");
            System.out.print("\t");
            System.out.print("avgBits");
            System.out.print("\t");
            System.out.print("yield");
            System.out.println();
            for (n2 = 0; n2 < patternNames.length && n2 < 16; ++n2) {
                if (patternNames[n2].length() < 1) continue;
                n = JNIMatch.countBits(byArrayArray2[n2]);
                if (stringArray.length > 1) {
                    System.out.print(stringArray[1]);
                    System.out.print("\t");
                }
                System.out.print(patternNames[n2]);
                System.out.print("\t");
                System.out.print(n);
                System.out.print("\t");
                System.out.print(n3);
                System.out.print("\t");
                System.out.print(n5);
                System.out.print("\t");
                System.out.print(n4);
                System.out.print("\t");
                System.out.print(n17);
                System.out.print("\t");
                System.out.print(dArray[n2]);
                System.out.print("\t");
                System.out.print(nArray2[n2]);
                System.out.print("\t");
                System.out.print(dArray3[n2] / (double)n3);
                System.out.print("\t");
                if (n > 0 && n4 > 0) {
                    double d5 = dArray[n2] / (double)n4;
                    d5 = (double)JNIMatch.countBits((byte[])object) * Math.log(d5) / (double)n;
                    System.out.print(d5);
                }
                System.out.println();
            }
            if (stringArray.length > 1) {
                System.out.print(stringArray[1]);
                System.out.print("\t");
            }
            System.out.print("ALL_PATTERNS");
            System.out.print("\t");
            System.out.print(JNIMatch.countBits((byte[])object));
            System.out.print("\t");
            System.out.print(n3);
            System.out.print("\t");
            System.out.print(n5);
            System.out.print("\t");
            System.out.print(n4);
            System.out.print("\t");
            System.out.print(n17);
            System.out.print("\t");
            System.out.print(n4);
            System.out.print("\t");
            System.out.print(n6);
            System.out.print("\t");
            System.out.print(d / (double)n3);
            System.out.print("\t1");
            System.out.println();
        }
        System.err.println();
    }

    public static boolean fingerTest(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & byArray2[i]) == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final int countBits(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == 0) continue;
            n += bits_per_byte[0xFF & byArray[i]];
        }
        return n;
    }

    public static final double similarity(byte[] byArray, byte[] byArray2) {
        int n = JNIMatch.countBits(byArray);
        int n2 = JNIMatch.countBits(byArray2);
        int n3 = 0;
        for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
            n3 += bits_per_byte[0xFF & (byArray[i] & byArray2[i])];
        }
        return (double)n3 / (double)(n + n2 - n3);
    }

    static {
        bits_per_byte = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            for (int j = 0; j < 8; ++j) {
                if ((i & 1 << j) == 0) continue;
                ++n;
            }
            JNIMatch.bits_per_byte[i] = n;
        }
        JNIMatch.loadLibraries();
        matcher = new JNIMatch();
        DEFAULT_SIZE = 64;
    }
}

