/*
 * Decompiled with CFR 0.152.
 */
package jni;

import avalon.tools.LibraryToolbox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class JNIDepict {
    static String tmpMolFilename = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "tmp.mol";
    static JNIDepict depictor = null;

    private JNIDepict() {
    }

    public static JNIDepict getDepictor() {
        return depictor;
    }

    static void loadLibraries() {
        String string = "JNIDepict";
        if (LibraryToolbox.loadLibrary(JNIDepict.class, string)) {
            return;
        }
        try {
            System.loadLibrary(string);
            return;
        }
        catch (SecurityException securityException) {
            System.err.println(string + ": Security exception, can't load native library from class path, " + securityException.getMessage());
        }
        catch (Throwable throwable) {
            System.err.println(string + ": Can't load native library via loadLibrary(), " + throwable.getMessage());
            new Exception("TRACE").printStackTrace();
        }
        String string2 = System.getProperty("user.dir") + "/JNIDepict.dll";
        System.err.println("trying to load '" + string2 + "'");
        if (new File(string2).exists()) {
            try {
                System.load(string2);
                return;
            }
            catch (Exception exception) {
                System.err.println("Can't load native library '" + string2 + "'!");
                exception.printStackTrace();
            }
            catch (Error error) {
                System.err.println("Can't load native library '" + string2 + "'!");
                error.printStackTrace();
            }
        }
    }

    public synchronized double MolecularWeightFromSmiles(String string) {
        if (string == null || string.trim().equals("")) {
            return 0.0;
        }
        System.err.println("Entering wrapper mwFromSmiles");
        System.err.println("SMILES = " + string);
        double d = this.mwFromSmiles(string);
        System.err.println("mw = " + d);
        return d;
    }

    private void assureTmpMoleFileIsWritable(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error opening " + string + " for writing! " + iOException);
            LibraryToolbox.showError("Error opening " + string + " for writing! " + "Avalon will exit now.", "File Error", false);
            System.exit(1);
        }
    }

    public synchronized String smiToMOL(String string) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        this.assureTmpMoleFileIsWritable(tmpMolFilename);
        this.smilesToMOLFile(string, tmpMolFilename);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tmpMolFilename));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        while (null != (string2 = bufferedReader.readLine())) {
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        if (stringBuffer.length() < 10) {
            return null;
        }
        return stringBuffer.toString();
    }

    public synchronized String smiToMOLWithTemplate(String string, String string2) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        this.assureTmpMoleFileIsWritable(tmpMolFilename);
        this.smilesToMOLFileWithTemplate(string, tmpMolFilename, string2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tmpMolFilename));
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        while (null != (string3 = bufferedReader.readLine())) {
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        if (stringBuffer.length() < 10) {
            return null;
        }
        return stringBuffer.toString();
    }

    public synchronized boolean smilesMatchesQueryCT(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null || string2.length() < 3) {
            return true;
        }
        return this.smilesMatchesQueryCTNative(string, string2);
    }

    public synchronized native boolean smilesMatchesQueryCTNative(String var1, String var2);

    public synchronized native int smilesToMOLFile(String var1, String var2);

    public synchronized native int smilesToMOLFileWithTemplate(String var1, String var2, String var3);

    private static String fixCT(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("M  END");
        if (n > 0) {
            string = string.substring(0, n) + "M  END\n";
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        return string;
    }

    public synchronized String getSMILESFromCT(String string) {
        return this.getSMILESFromCT(string, tmpMolFilename);
    }

    public synchronized String getSMILESFromCT(String string, String string2) {
        this.assureTmpMoleFileIsWritable(string2);
        try {
            string = JNIDepict.fixCT(string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
            printWriter.print(string);
            printWriter.close();
            byte[] byArray = new byte[1000];
            int n = this.MOLFileToSmilesBytes(byArray, string2);
            String string3 = 0 < n ? new String(byArray, 0, n) : null;
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public synchronized String getSMARTSFromCT(String string) {
        this.assureTmpMoleFileIsWritable(tmpMolFilename);
        try {
            string = JNIDepict.fixCT(string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(tmpMolFilename));
            printWriter.print(string);
            printWriter.close();
            byte[] byArray = new byte[1000];
            int n = this.MOLFileToSMARTSBytes(byArray, tmpMolFilename);
            String string2 = 0 < n ? new String(byArray, 0, n) : null;
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public synchronized native double mwFromSmiles(String var1);

    public synchronized native int MOLFileToSmilesBytes(byte[] var1, String var2);

    public synchronized native int MOLFileToSMARTSBytes(byte[] var1, String var2);

    public static void main(String[] stringArray) throws IOException {
        String string;
        BufferedReader bufferedReader;
        JNIDepict.loadLibraries();
        JNIDepict jNIDepict = new JNIDepict();
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 1) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (null != (string = bufferedReader.readLine())) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        } else {
            System.err.println("usage: java JNIDepict 'smiles' <molfile.mol");
            return;
        }
        bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        while (null != (string = bufferedReader.readLine())) {
            System.err.println("smilesMatchesQueryCT() yields " + jNIDepict.smilesMatchesQueryCT(string, stringBuffer.toString()));
        }
        bufferedReader.close();
    }

    static {
        JNIDepict.loadLibraries();
        depictor = new JNIDepict();
    }
}

