/*
 * Decompiled with CFR 0.152.
 */
package avalon.tools;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class LibraryToolbox {
    public static boolean loadLibraryFromClasspath(String string) {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        string = System.mapLibraryName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        String string4 = null;
        while (stringTokenizer.hasMoreTokens() && string4 == null) {
            String string5 = stringTokenizer.nextToken();
            if (!string5.toLowerCase().endsWith("avalon.jar")) continue;
            string4 = string5.substring(0, string5.length() - "avalon.jar".length()) + string;
        }
        try {
            System.load(string4);
            return true;
        }
        catch (Throwable throwable) {
            System.err.println("Could not load library via cCLASSPATH.");
            System.err.println("   CLASSPATH is: " + System.getProperty("java.class.path"));
            System.err.println("   Library Name is: " + string);
            System.err.println("   Library should be in: " + string4);
            return false;
        }
    }

    public static boolean loadLibrary(Class clazz, String string) {
        try {
            System.err.println("Java library path: " + System.getProperty("java.library.path"));
            System.err.println("using " + clazz + ".getProtectionDomain().getCodeSource().getLocation().getPath()");
            System.err.println("ClassLoader path: " + clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
            String string2 = new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent() + File.separatorChar;
            if (File.separatorChar == '\\') {
                try {
                    System.load(string2 + string + ".DLL");
                    System.err.println("Loaded '" + string2 + string + ".DLL'");
                    return true;
                }
                catch (Throwable throwable) {
                    System.err.println("Could not load '" + string2 + string + ".DLL'");
                    return false;
                }
            }
            try {
                System.load(string2 + string + ".so");
                System.err.println("Loaded '" + string2 + string + ".so'");
                return true;
            }
            catch (Throwable throwable) {
                try {
                    System.load(string2 + "lib" + string + ".so");
                    System.load(string2 + "lib" + string + ".so");
                    return true;
                }
                catch (Throwable throwable2) {
                    try {
                        System.load(string2 + string + ".jnilib");
                        System.load(string2 + string + ".jnilib");
                        return true;
                    }
                    catch (Throwable throwable3) {
                        System.err.println("Could not load library '" + string + "' from directory '" + string2 + "'");
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void showError(String string, String string2, boolean bl) {
        if (bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(null, string, string2, 0);
        } else {
            System.err.println(string2 + ": " + string);
        }
    }
}

