/*
 * Decompiled with CFR 0.152.
 */
package avalon.jni;

import avalon.tools.LibraryToolbox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;

public class JNISmi2Mol {
    static JNISmi2Mol smi2mol = null;
    static String tmpMolFileName = null;
    public static int NO_FLAGS;
    public static final int APPLY_SHORTCUTS = 255;
    public static final int APPLY_AMINO_ACIDS = 1;
    public static final int APPLY_PROTECTING_GROUPS = 2;
    public static final int APPLY_RNA_SHORTCUTS = 4;
    public static final int EXTENDED_SHORTCUTS = 256;
    public static final int NON_STANDARD_SHORTCUTS = 512;
    public static final int CATCH_ALL_SHORTCUTS = 32768;
    public static final int EXPECT_SMARTS = 65536;

    private JNISmi2Mol() {
    }

    private static void init() {
        if (smi2mol != null) {
            return;
        }
        JNISmi2Mol.loadLibraries();
        smi2mol = new JNISmi2Mol();
    }

    public static JNISmi2Mol getSmi2Mol() {
        JNISmi2Mol.init();
        return smi2mol;
    }

    static boolean loadFromDirectory(String string) {
        String string2 = string + "/avalon_jni_JNISmi2Mol.dll";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") < 0) {
            string2 = string + "/libJNISmi2Mol.so";
        }
        System.err.println("trying to load '" + string2 + "'");
        if (new File(string2).exists()) {
            try {
                System.load(string2);
                return true;
            }
            catch (Exception exception) {
                System.err.println("Can't load native library '" + string2 + "'!");
                exception.printStackTrace();
            }
            catch (Error error) {
                System.err.println("Can't load native library '" + string2 + "'!");
                error.printStackTrace();
            }
        }
        return false;
    }

    static void loadLibraries() {
        String string = "JNISmi2Mol";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            string = "avalon_jni_JNISmi2Mol";
        }
        if (LibraryToolbox.loadLibrary(JNISmi2Mol.class, string)) {
            return;
        }
        try {
            System.loadLibrary(string);
            return;
        }
        catch (SecurityException securityException) {
            System.err.println(string + ": Security exception, can't load native library from class path, " + securityException.getMessage());
        }
        catch (Throwable throwable) {
            System.err.println(string + ": Can't load native library via loadLibrary(), " + throwable.getMessage());
            new Exception("TRACE").printStackTrace();
        }
        if (JNISmi2Mol.loadFromDirectory(System.getProperty("user.dir"))) {
            return;
        }
        String string2 = null;
        try {
            System.err.println("looking up bundle");
            ResourceBundle resourceBundle = ResourceBundle.getBundle("libraries");
            System.err.println("trying to load key 'jnismi2mol' from bundle " + resourceBundle);
            string2 = resourceBundle.getString("jnismi2mol");
            System.err.println("Loading library " + string2);
            System.load(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LibraryToolbox.showError("Error loading " + string2 + "! \n\n" + "Avalon will exit now.\n", "Configuration Error", false);
            System.exit(1);
        }
        catch (Error error) {
            error.printStackTrace();
            System.err.println("Can't load native library!");
            LibraryToolbox.showError("Error loading " + string2 + "! \n\n" + "Avalon will exit now.\n", "Configuration Error", false);
            System.exit(1);
        }
    }

    public synchronized double MolecularWeightFromSmiles(String string) {
        if (string == null || string.trim().equals("")) {
            return 0.0;
        }
        System.err.println("Entering wrapper mwFromSmiles");
        System.err.println("SMILES = " + string);
        double d = this.mwFromSmiles(string);
        System.err.println("mw = " + d);
        return d;
    }

    private void assureTmpMoleFileIsWritable(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error opening " + string + " for writing! " + iOException);
            LibraryToolbox.showError("Error opening " + string + " for writing! " + "Avalon will exit now.", "File Error", false);
            System.exit(1);
        }
    }

    public synchronized String smiToMOL(String string) throws IOException {
        return this.smiToMOLWithFlags(string, NO_FLAGS);
    }

    public synchronized String smiToMOLWithFlags(String string, int n) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        this.assureTmpMoleFileIsWritable(tmpMolFileName);
        this.smilesToMOLFileWithFlags(string, tmpMolFileName, n);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tmpMolFileName));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        while (null != (string2 = bufferedReader.readLine())) {
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        if (stringBuffer.length() < 10) {
            return null;
        }
        return stringBuffer.toString();
    }

    public synchronized String smiToMOLWithTemplate(String string, String string2) throws IOException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        this.assureTmpMoleFileIsWritable(tmpMolFileName);
        this.smilesToMOLFileWithTemplate(string, tmpMolFileName, string2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tmpMolFileName));
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        while (null != (string3 = bufferedReader.readLine())) {
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        if (stringBuffer.length() < 10) {
            return null;
        }
        return stringBuffer.toString();
    }

    public synchronized native int smilesToMOLFile(String var1, String var2);

    public synchronized native int smilesToMOLFileWithFlags(String var1, String var2, int var3);

    public synchronized native int smilesToMOLFileWithTemplate(String var1, String var2, String var3);

    private static String fixCT(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("M  END");
        if (n > 0) {
            string = string.substring(0, n) + "M  END\n";
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        return string;
    }

    public synchronized String getSMILESFromCT(String string) {
        return this.getSMILESFromCT(string, tmpMolFileName);
    }

    public synchronized String getSMILESFromCT(String string, String string2) {
        this.assureTmpMoleFileIsWritable(string2);
        try {
            String string3;
            string = JNISmi2Mol.fixCT(string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
            printWriter.print(string);
            printWriter.close();
            byte[] byArray = new byte[1000];
            int n = this.MOLFileToSmilesBytes(byArray, string2);
            if (0 < n) {
                string3 = new String(byArray, 0, n);
            } else {
                int n2 = -n;
                if (n2 > 999 && n2 < 64000) {
                    byArray = new byte[10 + n2];
                    n = this.MOLFileToSmilesBytes(byArray, string2);
                }
                string3 = 0 < n ? new String(byArray, 0, n) : null;
            }
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public synchronized String getSMARTSFromCT(String string) {
        this.assureTmpMoleFileIsWritable(tmpMolFileName);
        try {
            string = JNISmi2Mol.fixCT(string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(tmpMolFileName));
            printWriter.print(string);
            printWriter.close();
            byte[] byArray = new byte[2000];
            int n = this.MOLFileToSMARTSBytes(byArray, tmpMolFileName);
            String string2 = 0 < n ? new String(byArray, 0, n) : null;
            System.err.println("SMARTS = " + string2);
            System.err.println("size = " + n);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public synchronized native double mwFromSmiles(String var1);

    public synchronized native int MOLFileToSmilesBytes(byte[] var1, String var2);

    public synchronized native int MOLFileToSMARTSBytes(byte[] var1, String var2);

    public static void main(String[] stringArray) throws IOException {
        String string = "CCO";
        System.err.println("MW(" + string + ") = " + JNISmi2Mol.getSmi2Mol().MolecularWeightFromSmiles("CCO"));
    }

    static {
        try {
            File file = File.createTempFile("JNI", ".mol");
            file.deleteOnExit();
            tmpMolFileName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        NO_FLAGS = 0;
    }
}

