# 🐨Tatua's Real Estate App🏁✨✨

## Description
🏡 The Real Estate App is a full-stack web application built using the MERN stack (MongoDB, Express, React, Node.js) and TypeScript. It is designed to help real estate agents and property managers manage their listings by providing them with a platform to create, read, update, and delete property data.

In addition, the Real Estate App also features Google OAuth authentication, allowing users to securely sign in using their Google credentials.

## How to add a property
To add a property to the application, hit the property button in the sider layout. Then click on add property and write a description and name title. Then upload an image from your device.
![yariga-ely netlify app_properties (1)](https://user-images.githubusercontent.com/84116117/222881949-c8c5824b-8842-4da4-918b-a4e5df69dae4.png)

 
## Installation
To install the Real Estate App locally, follow the steps below:

1. Clone the repository to your local machine using `git clone https://github.com/username/repo.git`
2. Navigate to the project directory and run `npm install` to install the dependencies
3. Create a `.env` file in the root directory and add the following environment variables:
```bash
MONGO_URI=<your_mongodb_uri>

GOOGLE_CLIENT_ID=<your_google_client_id>

GOOGLE_CLIENT_SECRET=<your_google_client_secret>

```

4. Run `npm start` to start the development server
5. Navigate to `http://localhost:3000` to view the app in your browser

## Features
The Real Estate App comes with the following features:

- Create, read, update, and delete (CRUD) properties
- View a list of all properties or filter by property type or location
- View a detailed page for each property, with an image gallery and description
- Google OAuth2 authentication for secure user authentication
- Responsive design that works across all devices

## Tech Stack
The Real Estate App is built using the following technologies:

- MongoDB for data storage
- Express.js for the backend server
- React.js for the frontend user interface
- Node.js for the server-side runtime environment
- TypeScript for type checking and strict typing
- CSS for styling the user interface
- Shell for script automation and management
- JavaScript for general application logic

## Screenshot🎞️
![homepage](https://user-images.githubusercontent.com/84116117/222279038-06b7b0c8-06f0-4f58-aef4-f7e9256a8135.png)

## Contributing
Contributions to the Real Estate App are welcome! If you'd like to contribute, please follow these steps:

1. Fork the repository
2. Create a new branch for your feature or bug fix
3. Commit your changes and push to your fork
4. Submit a pull request

## License
The Real Estate App is licensed under the MIT License. See the [LICENSE](/LICENSE) file for more information.
