/*******************************************************************************
 * Copyright 2018 Klaus Pfeiffer - klaus@allpiper.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.jfastnet.messages;

import lombok.extern.slf4j.Slf4j;

/** @author Klaus Pfeiffer - klaus@allpiper.com */
@Slf4j
public class AckMessage extends Message implements IAckMessage {

	/** Message id to acknowledge. */
	public long id;

	public AckMessage() {}

	public AckMessage(long id) {
		this.id = id;
	}

	@Override
	public ReliableMode getReliableMode() {
		return ReliableMode.UNRELIABLE;
	}

	public String toString() {
		return super.toString() + ", acknowledge id=" + id;
	}

	@Override
	public long getAckId() {
		return id;
	}
}