# Copyright (C) 2010-2015 Cuckoo Foundation.
# This file is part of Cuckoo Sandbox - http://www.cuckoosandbox.org
# See the file 'docs/LICENSE' for copying permission.

"""Set guest.platform to non-nullable

Revision ID: c2bd0eb5e69d
Revises: 3a1c6c03844b
Create Date: 2024-04-09 16:03:58.751378

"""

# revision identifiers, used by Alembic.
revision = "c2bd0eb5e69d"
down_revision = "3a1c6c03844b"

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.alter_column("guests", "platform", existing_type=sa.VARCHAR(length=255), nullable=False)
    except sa.exc.OperationalError:
        # sqlite does not support altering columns
        pass
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.alter_column("guests", "platform", existing_type=sa.VARCHAR(length=255), nullable=True)
    except sa.exc.OperationalError:
        # sqlite does not support altering columns
        pass
    # ### end Alembic commands ###
