# Copyright (C) 2010-2015 Cuckoo Foundation.
# This file is part of Cuckoo Sandbox - http://www.cuckoosandbox.org
# See the file 'docs/LICENSE' for copying permission.

"""Add 'reserved' column for machines

Revision ID: d6aa5d949b70
Revises: 02af0b0ec686
Create Date: 2023-02-15 17:10:41.338499

"""

# revision identifiers, used by Alembic.
revision = "d6aa5d949b70"
down_revision = "02af0b0ec686"

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("machines", sa.Column("reserved", sa.Boolean(), nullable=False, server_default="f"))
    op.create_unique_constraint("uq_machine_label", "machines", ["label"])
    op.create_unique_constraint("uq_machine_name", "machines", ["name"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("uq_machine_label", "machines", type_="unique")
    op.drop_constraint("uq_machine_name", "machines", type_="unique")
    op.drop_column("machines", "reserved")
    # ### end Alembic commands ###
