---
extends: _layouts.post
section: content
title: "Las 4 prácticas que debes dominar para ser un mejor desarrollador de software en el 2021"
date: 2020-12-21
description: "Llevo algunos años en el desarrollo de software, principalmente como PHP/Laravel developer. Desde que era estudiante, he notado y aplicado lo que leerás a continuación para mejorarme como desarrollador y como persona."  
cover_image: /assets/images/posts/practicas-que-debes-dominar-para-ser-un-mejor-desarrollador-de-software.png
featured: false
categories: [laravel, programming]
---

Llevo algunos años en el desarrollo de software, principalmente como PHP/Laravel developer. Desde que era estudiante, he notado y aplicado lo que leerás a continuación para mejorarme como desarrollador y como persona.

> _¿Quieres leerlo en inglés? [También está en Medium](https://medium.com/@kennyhorna/the-4-most-important-skills-to-master-for-you-to-become-a-great-developer-5c56642a7f83?source=friends_link&sk=c8e487f89b5932238b5cc68535484ee5)._

Es posible que hayas leído lo siguiente en otro lugar, sin embargo quiero explicar mis razones para hacerlo y cómo me ha funcionado.

<img src="https://images.unsplash.com/photo-1460518451285-97b6aa326961?ixlib=rb-1.2.1&ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&auto=format&fit=crop&w=800&q=80" class="w-full" />

### **1. Abraza el conocimiento**

Siempre me ha gustado aprender. Lo que sea que me llame la atención o necesite. Desde algo interesante, como configurar un servidor de medios casero, o algo totalmente inútil como saber cuanto tiempo puede dormir un caracol.

Comencé visitando blogs de tecnología y diseño todos los días desde que tuve mi primera computadora. Navegar entre diferentes temas y contenidos me permitió descubrir muchas cosas. Pero sobre todo **me permitió generar preguntas que luego me obligué a buscar respuestas**.

Este hábito de buscar siempre cosas nuevas me ha facilitado la vida, especialmente en nuestro sector. Algo que es el estándar hoy... puede estar desactualizado en 2 o 3 años a partir de ahora. **Por eso debes estar siempre dispuesto a mantenerte actualizado y descubrir nuevas tendencias. Recuerde: saber que esta nueva herramienta existe, puede ser útil en el futuro cuando la necesite.**

Hoy tenemos una cantidad increíble de contenido disponible, así que entiendo si esto puede parecer abrumador. Mi consejo es: quédate con lo que más te interese y luego cambia a otra cosa si así lo deseas.

Puede ver las últimas tendencias en muchos lugares, como [Encuesta anual de StackOverflow](https://insights.stackoverflow.com/survey/). Además, hay sitios como [Hacker News](https://news.ycombinator.com/), [GitHub Explore](https://github.com/explore) y muchos más. Revisa [este artículo de FreeCodeCamp](https://www.freecodecamp.org/news/12-ways-to-keep-up-with-software-engineering-trends/) que lista una serie de recursos para mantenerte actualizado.

Si tiene interés en una tecnología o herramienta específica, sigue las comunidades que la rodean. Me encanta Laravel, así que estoy suscrito a sitios como [Laravel News](https://laravel-news.com/), [el blog de Freek](https://freek.dev/) y un montón de otros blogs relacionados con Laravel. Los he agregado a mi feed de Feedly que verifico a diario. También hay muchos podcasts geniales que puedes encontrar relacionados con tus intereses.

_Entonces Kenny, eso es bueno... pero ¿qué pasa cuando necesito ayuda real con algo?_ Eso me lleva al siguiente punto.

<img src="https://images.unsplash.com/photo-1490127252417-7c393f993ee4?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" class="w-full" />

### **2. Domina tus habilidades de búsqueda**

Una de las razones por las que mejoré en la búsqueda de cosas fue mi deseo de solucionar problemas o encontrar respuestas. Cuando estaba en la escuela estropeé nuestra PC tantas veces que ya perdí la cuenta. Así que necesitaba desesperadamente arreglarlo antes de que se enteraran y terminaran castigándome. Además, dado que no tenía mucho dinero en ese entonces (o nada), tuve que buscar alternativas o atajos para obtener lo que necesitaba/quería.

Sabes, siempre he sido un geek. Por eso me parecía normal que mi familia o mis amigos no tuvieran la misma habilidad que yo con las cosas tecnológicas. Yo era (bueno, todavía lo soy) el informático de la familia. Pero, cuando ingresé a la universidad, noté lo mismo en muchos de mis compañeros. Esto me sorprendió mucho, sobre todo porque también eran estudiantes de ingeniería de software. Este también fue el caso más tarde, cuando comencé a trabajar en agencias de software. Cuando algunos de mis colegas tenían problemas para resolver un problema, tenían dificultades para obtener ayuda o averiguar por qué.

Entonces, estos son mis consejos para ti en este aspecto:

- **Consulta la documentación**. Estoy _asombrado_ por la cantidad de preguntas que encuentras que pueden resolverse fácilmente mirando los documentos.
- Si tiene un problema, las posibilidades de que le haya pasado a otra persona antes son _muy_ altas. Así que **intenta buscar exactamente el mismo problema y usa palabras clave**. Te sorprenderá la cantidad de coincidencias que encontrarás.
- Si nada de lo anterior ayudó, **no tenga miedo de publicar su pregunta con detalles en alguna parte.** Tiene sitios como StackOverflow (o cualquier sitio de StackExchange), Github, [CodeProject](https://www.codeproject.com/), [el foro de Laracasts](https://laracasts.com/discuss). Esto es _miles de veces mejor_ que preguntar en grupos de apoyo de Facebook/Whatsapp/Telegram.

Esto último es importante porque no solo **te ayudará a obtener la respuesta más rápido, sino que también ayudará a otros en el futuro**. Ampliaremos esto más adelante.

<img src="https://images.unsplash.com/photo-1542831371-29b0f74f9713?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" class="w-full" />

### 3. Pon tus conocimientos en práctica ... pero de forma significativa

Como tú también, he seguido docenas de tutoriales. Tenemos miles de estos disponibles en diferentes formatos como artículos y videotutoriales. Son una excelente manera de aprender. Vas de la mano desarrollando un pequeño proyecto que utiliza aspectos de la herramienta de tu interés.

**El problema es que debido a la simplicidad de la mayoría de los proyectos, terminan no siendo lo suficientemente interesantes para nosotros.** Eso es comprensible, ya que intentan explicar algo de la manera más simple posible. Esta es la razón por la que muchas veces terminas olvidando parte de lo aprendido en muy poco tiempo.

Hace un tiempo, quería mejorar mis habilidades con Laravel mientras nosotros (como equipo) estábamos desarrollando una aplicación multiplataforma. En ese momento, seguí la serie _"Construyamos un foro con Laravel y TDD"_ de Laracasts. Aprendí mucho de Jeffrey Way (el tutor, el mejor que he seguido por cierto). Aunque el curso no se ajustaba a lo que necesitaba específicamente, fue increíble. **Pude extraer muchas lecciones valiosas que pude replicar en nuestra aplicación.**

Hago lo mismo cuando sigo cursos sobre otros aspectos tanto de Laravel como de otros frameworks. **La clave, como has podido apreciar, es poner en práctica lo que ves para reforzarlo y aprenderlo de mejor manera.**

Si llevo lo que he aprendido - por simple que sea - a una aplicación real, es mucho más efectivo así que termino aprendiéndolo mejor. Por “aplicación real” me refiero a algo que tiene significado para ti. Esto puede ser algo que te ayude en tu día a día, o recrear una aplicación que te guste.

Esto será tremendamente beneficioso. Está tratando de resolver problemas reales, por lo que estará más interesado en descubrir más sobre cómo hacer X cosas para obtener el resultado que espera.

<img src="https://images.unsplash.com/photo-1527792492728-08d07d011113?ixid=MXwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHw%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" class="w-full" />

### **4. Dale una mano a los demás**

Desde niño siempre fui un estudiante destacado. Debido a esto, mis amigos venían a mi casa para estudiar y hacer la tarea, luego nos íbamos a jugar fútbol. Dado que en ocasiones terminaba explicándoles cómo resolver los ejercicios, **descubrí que disfruto enseñando a otros**. De hecho, una de mis primeras formas de ganar dinero fue dando lecciones privadas. Fui tutor desde que estaba en la secundaria hasta que empecé a trabajar en una compañía.

**Estar en contacto frecuente con ciertos temas me ayudó a mantenerme actualizado para cuando necesitaba aplicarlos**. Lo mismo comencé a aplicar en el desarrollo de software.

Casi como cualquier programador, he recurrido a la ayuda de StackOverflow o GitHub en busca de ayuda. Sin embargo, a medida que pasaba más tiempo en estos sitios, comencé a responder preguntas porque sabía las respuestas.

**Ayudar a otros a encontrar soluciones a problemas que yo tenía antes es muy satisfactorio. Me hace sentir que estoy contribuyendo con mis compañeros**. Se convirtió en mi pasatiempo favorito desde hace unos años.

Con el paso del tiempo, comencé a mejorar en las explicaciones que brindaba. Entendí cada vez mejor cada una de las preguntas que vi en el sitio. Estoy seguro de que conoce esta cita de Einstein:

> _"Si no puedes explicarlo de manera simple, no lo entiendes lo suficientemente bien"._

Luego, comencé a tratar de resolver preguntas que ni siquiera yo sabía cómo responder. Esto se debe a que creía que podía encontrar una solución mediante una buena búsqueda.

Como habrás notado, los beneficios de esta práctica son varios:

- **Ayudas a otros desarrolladores a resolver sus problemas**
- **Te hace mejorarte a ti mismo como desarrollador al reforzar tus conocimientos**
- **Te permite ampliar tus conocimientos** sobre determinados temas que no utilizas con frecuencia.

Un beneficio adicional de lo anterior es que **también te ayudará a construir una reputación en línea**. No estaba al tanto de esto porque no tenía la intención de obtener algo adicional. Sin embargo, **a medida que contribuía más, el interés de compañías en mí también crecía.** Así es como obtuve mi trabajo actual con el que estoy muy contento porque trabajo con un gran equipo en ABOUT YOU.

### Para concluir

That's it. Eso es todo lo que quería compartir contigo. Entonces, en resumen:

- Abraza el conocimiento
- Dominar las habilidades de búsqueda
- Pon tus conocimientos en práctica ... pero en algo significativo
- Dar una mano a los demás

Comparte tu experiencia en los comentarios sobre lo que hiciste para mejorar como desarrollador. Me encantará leerlo 😃.
