---
extends: _layouts.post
section: content
title: "Novedades de Laravel 7"
date: 2020-02-28
description: "Como en cada nueva versión, Laravel 7 nos trae una serie de nuevas funciones y mejoras. Esta lista pretende resaltar cada una de estas novedades, mejoras y correcciones."  
cover_image: /assets/images/posts/0021/0021-novedades-laravel-7.png
featured: false
categories: [laravel, php, programming, series]
---

Este **3 de marzo** se realizará el lanzamiento oficial de **Laravel 7**. Como en cada nueva versión, Laravel nos trae una serie de nuevas funciones y mejoras. Esta lista pretende resaltar -en lo posible- cada una de estas.

Entre las novedades que Laravel nos trae en esta versión, tenemos:

- [Laravel Airlock: Autenticación ligera para SPAs y APIs](/blog/0019-laravel-airlock-autenticacion-ligera-para-spas-y-apis)
- [Mejoras en el enlazado de modelos a rutas (_Route Model Binding_)](/blog/0022-novedades-de-laravel-7-mejoras-en-el-enlazado-de-modelos-a-rutas)
- [Cliente HTTP](/blog/0023-novedades-de-laravel-7-el-nuevo-facade-http-consultas-nativas-a-servicios-externos)
- _Operaciones fluidas trabajando con Strings_
- _Múltiples drivers para emails_
- _Casting personalizado en Eloquent (Eloquent Custom Casts)_
- _Etiquetas en componentes Blade y mejoras_
- _Mejoras de rendimiento en el cacheo de Rutas (Route Caching)_
- _Soporte nativo para CORS_
- _Casting en tiempo de Ejecución (Query time casts)_
- _Mejoras de rendimiento en el manejo de Colas en MySQL 8+_
- _Comando ``test`` de Artisan_
- _Mejora en las plantillas Markdown para Emails_
- _Markdown Mail Template Improvements_
- _Personalización de Stubs_

> Las referencias a este listado se irán actualizando a medida que se publiquen más artículos.

----

## Cierre

Como podrás notar, Laravel 7 no se queda atrás a la hora de **incluir novedades**. De hecho -según el mismo Taylor Otwell- esta versión es de las que más funcionalidad introducirá en comparación con los lanzamientos de los últimos años.

<div>
<blockquote class="twitter-tweet"><p lang="en" dir="ltr">I think you have to go back to Laravel 5.5 (August 2017) to find a Laravel release as nice as Laravel 7.x will be. 🏄‍♂️ Hear about it at <a href="https://twitter.com/LaraconOnline?ref_src=twsrc%5Etfw">@LaraconOnline</a></p>&mdash; Taylor Otwell 🏝 (@taylorotwell) <a href="https://twitter.com/taylorotwell/status/1222551807907586048?ref_src=twsrc%5Etfw">January 29, 2020</a></blockquote> <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
</div>
