import 'dart:io' show File;

import 'package:flutter/foundation.dart' show immutable;
import 'package:instagram_clone_kamranhccp/state/image_upload/models/file_type.dart';

/// A request to create a thumbnail for an image.
@immutable
class ThumbnailRequest {
  final File file;
  final FileType fileType;

  const ThumbnailRequest({
    required this.file,
    required this.fileType,
  });

  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is ThumbnailRequest &&
          runtimeType == other.runtimeType &&
          file == other.file &&
          fileType == other.fileType;

  @override
  int get hashCode => Object.hashAll(
        [
          runtimeType,
          file,
          fileType,
        ],
      );
}
