# Contributing Guidelines

First of all, huge thanks to you or your organisation for contributing to this repository! :heart: Before making a contribution to this project, make sure you follow the rules to get started!

## Rules to be followed:
1. When finding a vulnerability or a error, just report to the Issue and explain it accordingly. If we found it and reviewed, then you're clear to make a PR (if you can solve)
2. Don't open a PR directly to this repo, just tell it in the issue/discussion section or open an issue accordingly for review. You're allowed to do such only if you're approved and assigned
3. Stale PRs and Issues opened for more than a month will be closed except for important ones (like high level error fixes etc)
4. If you opened an issue/PR, kindly wait for review. Don't tag us many times (Coz we're humans! :) )

These are the common rules to be followed for this project. For PR rules, follow these steps:
1. Make sure you create a PR from your custom branch and not from `master`
2. The PR will be checked if some of the tests pass on yours
3. If any changes are requested on your PR, do it kindly. Failing to do so will close your PR.
4. The PRs will be tested to ensure it works
5. Sign off your PR every time you introduce a change in your PR. This step will be explained below... 

Now, you've understood the rules, it's time for the how-to guide! 

## How to contribute? 
1. Fork a copy of repo and Clone the repo using `git clone <repo-url>` or using GitHub CLI (mentioned in the clone instructions on repo itself. No worries) 
2. Install necessary requirements by giving the command `pip install .` (Linux users may need to use `pip3` instead of `pip`) 
3. Then, find or make the changes in the repo
4. To test the script, type `codeit` and use the flag you introduced or changed. 
5. Last, add those changes and checkout to other branch. 
6. Commit your changes with a sign-off by giving `git commit -s -m "Message"` You need to keep your email public in GitHub for Verification. Anonymous contributions are not accepted. (This is to practice this sign-off trend in big projects) 
7. Then, push it to GitHub and start a PR. 

Well, that's it! :smile: And what to do next? You know it! **Best of luck!** And don't forget to star this repo if you like it! :wink:

Oh and if you perform well in your contribution, you'll have chance to get featured! :smile: :heart:
