//------------------------------------------------------------------------------
//
//  Mars3D: A source port of the game "Mars - The Ultimate Fighter"
//
//  Copyright (C) 1997 by Engine Technology CO. LTD
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2018 by Retro Fans of Mars3D
//  Copyright (C) 2004-2022 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//  DESCRIPTION:
//   Thing frame/state LUT,
//   generated by multigen utilitiy.
//   This one is the original DOOM version, preserved.
//
//------------------------------------------------------------------------------
//  Site  : https://sourceforge.net/projects/mars3d/
//------------------------------------------------------------------------------

{$I Mars3D.inc}

unit info;

interface

uses
  d_delphi,
  d_think,
  m_fixed,
  info_h;

type
  statesArray_t = packed array[0..$FFFF] of state_t;
  PstatesArray_t = ^statesArray_t;

  sprnamesArray_t = packed array[0..Ord(DO_NUMSPRITES) - 1] of string[4];
  PsprnamesArray_t = ^sprnamesArray_t;

  mobjinfoArray_t = packed array[0..$FFF - 1] of mobjinfo_t;
  PmobjinfoArray_t = ^mobjinfoArray_t;

var
  states: PstatesArray_t = nil;
  numstates: integer = Ord(DO_NUMSTATES);
  sprnames: PIntegerArray = nil;
  numsprites: integer = Ord(DO_NUMSPRITES);
  mobjinfo: PmobjinfoArray_t = nil;
  pDO_mobjinfo: PmobjinfoArray_t = nil;
  nummobjtypes: integer = Ord(DO_NUMMOBJTYPES);

//==============================================================================
//
// Info_Init
//
//==============================================================================
procedure Info_Init(const usethinkers: boolean);

//==============================================================================
//
// Info_ResolveActordefActors
//
//==============================================================================
procedure Info_ResolveActordefActors;

const
  DEFPUSHFACTOR = FRACUNIT div 4;

const
  DO_sprnames: array[0..Ord(DO_NUMSPRITES)] of string[4] = (
    'TNT1', 'BLUD', 'PUFF', 'TFOG', 'IFOG', 'ROLE', 'POL5', 'DOGS',

    // [BH] 100 extra sprite names to use in dehacked patches
    'SP00', 'SP01', 'SP02', 'SP03', 'SP04', 'SP05', 'SP06', 'SP07', 'SP08', 'SP09',
    'SP10', 'SP11', 'SP12', 'SP13', 'SP14', 'SP15', 'SP16', 'SP17', 'SP18', 'SP19',
    'SP20', 'SP21', 'SP22', 'SP23', 'SP24', 'SP25', 'SP26', 'SP27', 'SP28', 'SP29',
    'SP30', 'SP31', 'SP32', 'SP33', 'SP34', 'SP35', 'SP36', 'SP37', 'SP38', 'SP39',
    'SP40', 'SP41', 'SP42', 'SP43', 'SP44', 'SP45', 'SP46', 'SP47', 'SP48', 'SP49',
    'SP50', 'SP51', 'SP52', 'SP53', 'SP54', 'SP55', 'SP56', 'SP57', 'SP58', 'SP59',
    'SP60', 'SP61', 'SP62', 'SP63', 'SP64', 'SP65', 'SP66', 'SP67', 'SP68', 'SP69',
    'SP70', 'SP71', 'SP72', 'SP73', 'SP74', 'SP75', 'SP76', 'SP77', 'SP78', 'SP79',
    'SP80', 'SP81', 'SP82', 'SP83', 'SP84', 'SP85', 'SP86', 'SP87', 'SP88', 'SP89',
    'SP90', 'SP91', 'SP92', 'SP93', 'SP94', 'SP95', 'SP96', 'SP97', 'SP98', 'SP99',
    'NULL', ''
  );

implementation

uses
  m_argv,
  p_enemy,
  p_pspr,
  p_mobj_h,
  p_gender,
  p_spec,
  info_common,
  info_export,
  r_renderstyle,
  sounds;

var
  DO_states: array[0..Ord(DO_NUMSTATES) - 1] of state_t;

var
  DO_mobjinfo: array[0..Ord(DO_NUMMOBJTYPES) - 1] of mobjinfo_t;

var
  init_buildin: boolean = false;

//==============================================================================
//
// spriteframe
//
//==============================================================================
function spriteframe(const c: Char): integer;
begin
  result := Ord(toupper(c)) - Ord('A');
end;

//==============================================================================
//
// Info_Init_BuildIn
//
//==============================================================================
procedure Info_Init_BuildIn;
begin
  if init_buildin then
    exit;

  pDO_mobjinfo := @DO_mobjinfo;
  ////////////////////////////////////////////////////////////////////////////////
  // DO_mobjinfo
  ////////////////////////////////////////////////////////////////////////////////

  ////////////////////////////////////////////////////////////////////////////////
  // MT_PLAYER
  DO_mobjinfo[Ord(MT_PLAYER)].name := 'PLAYER';
  DO_mobjinfo[Ord(MT_PLAYER)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_PLAYER)].doomednum := -1;
  DO_mobjinfo[Ord(MT_PLAYER)].spawnstate := Ord(S_PLAY);
  DO_mobjinfo[Ord(MT_PLAYER)].spawnhealth := 100;
  DO_mobjinfo[Ord(MT_PLAYER)].seestate := Ord(S_PLAY_RUN1);
  DO_mobjinfo[Ord(MT_PLAYER)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].reactiontime := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].painstate := Ord(S_PLAY_PAIN);
  DO_mobjinfo[Ord(MT_PLAYER)].painchance := 255;
  DO_mobjinfo[Ord(MT_PLAYER)].painsound := Ord(sfx_plpain);
  DO_mobjinfo[Ord(MT_PLAYER)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PLAYER)].missilestate := Ord(S_PLAY_ATK1);
  DO_mobjinfo[Ord(MT_PLAYER)].deathstate := Ord(S_PLAY_DIE1);
  DO_mobjinfo[Ord(MT_PLAYER)].xdeathstate := Ord(S_PLAY_XDIE1);
  DO_mobjinfo[Ord(MT_PLAYER)].deathsound := Ord(sfx_pldeth);
  DO_mobjinfo[Ord(MT_PLAYER)].speed := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].radius := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PLAYER)].height := 56 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PLAYER)].mass := 100;
  DO_mobjinfo[Ord(MT_PLAYER)].damage := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].flags := MF_SOLID or MF_SHOOTABLE or MF_DROPOFF or MF_PICKUP or MF_NOTDMATCH;
  DO_mobjinfo[Ord(MT_PLAYER)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PLAYER)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PLAYER)].dropitem := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].missiletype := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_PLAYER)].alpha := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PLAYER)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PLAYER)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PLAYER)].missileheight := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].vspeed := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_PLAYER)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_PLAYER)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_PLAYER)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_PLAYER)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].obituary := '';
  DO_mobjinfo[Ord(MT_PLAYER)].hitobituary := '';
  DO_mobjinfo[Ord(MT_PLAYER)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_PLAYER)].meleerange := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].maxstepheight := 32;
  DO_mobjinfo[Ord(MT_PLAYER)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_PLAYER)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_SMOKE
  DO_mobjinfo[Ord(MT_SMOKE)].name := 'FIREBALL TRAIL';
  DO_mobjinfo[Ord(MT_SMOKE)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_SMOKE)].doomednum := -1;
  DO_mobjinfo[Ord(MT_SMOKE)].spawnstate := Ord(S_SMOKE1);
  DO_mobjinfo[Ord(MT_SMOKE)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_SMOKE)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_SMOKE)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].painchance := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].speed := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_SMOKE)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_SMOKE)].mass := 100;
  DO_mobjinfo[Ord(MT_SMOKE)].damage := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].flags := MF_NOBLOCKMAP or MF_NOGRAVITY;
  DO_mobjinfo[Ord(MT_SMOKE)].flags_ex := MF_EX_TRANSPARENT or MF_EX_WHITELIGHT;
  DO_mobjinfo[Ord(MT_SMOKE)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_SMOKE)].dropitem := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].missiletype := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_SMOKE)].alpha := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_SMOKE)].missileheight := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].vspeed := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_SMOKE)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_SMOKE)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_SMOKE)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_SMOKE)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].obituary := '';
  DO_mobjinfo[Ord(MT_SMOKE)].hitobituary := '';
  DO_mobjinfo[Ord(MT_SMOKE)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_SMOKE)].meleerange := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_SMOKE)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_PUFF
  DO_mobjinfo[Ord(MT_PUFF)].name := 'BULLET PUFF';
  DO_mobjinfo[Ord(MT_PUFF)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_PUFF)].doomednum := -1;
  DO_mobjinfo[Ord(MT_PUFF)].spawnstate := Ord(S_PUFF1);
  DO_mobjinfo[Ord(MT_PUFF)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_PUFF)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_PUFF)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].painchance := 0;
  DO_mobjinfo[Ord(MT_PUFF)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].speed := 0;
  DO_mobjinfo[Ord(MT_PUFF)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PUFF)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PUFF)].mass := 100;
  DO_mobjinfo[Ord(MT_PUFF)].damage := 0;
  DO_mobjinfo[Ord(MT_PUFF)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].flags := MF_NOBLOCKMAP or MF_NOGRAVITY;
  DO_mobjinfo[Ord(MT_PUFF)].flags_ex := MF_EX_TRANSPARENT or MF_EX_WHITELIGHT;
  DO_mobjinfo[Ord(MT_PUFF)].flags2_ex := MF2_EX_DONOTRENDERSHADOW;
  DO_mobjinfo[Ord(MT_PUFF)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUFF)].dropitem := 0;
  DO_mobjinfo[Ord(MT_PUFF)].missiletype := 0;
  DO_mobjinfo[Ord(MT_PUFF)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_PUFF)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_PUFF)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_PUFF)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_PUFF)].alpha := 0;
  DO_mobjinfo[Ord(MT_PUFF)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUFF)].missileheight := 0;
  DO_mobjinfo[Ord(MT_PUFF)].vspeed := 0;
  DO_mobjinfo[Ord(MT_PUFF)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_PUFF)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_PUFF)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_PUFF)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_PUFF)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_PUFF)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_PUFF)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_PUFF)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_PUFF)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_PUFF)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_PUFF)].obituary := '';
  DO_mobjinfo[Ord(MT_PUFF)].hitobituary := '';
  DO_mobjinfo[Ord(MT_PUFF)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_PUFF)].meleerange := 0;
  DO_mobjinfo[Ord(MT_PUFF)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_PUFF)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_PUFF)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_PUFF)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_PUFF)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_PUFF)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_PUFF)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_PUFF)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_BLOOD
  DO_mobjinfo[Ord(MT_BLOOD)].name := 'BLOOD SPLAT';
  DO_mobjinfo[Ord(MT_BLOOD)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_BLOOD)].doomednum := -1;
  DO_mobjinfo[Ord(MT_BLOOD)].spawnstate := Ord(S_BLOOD1);
  DO_mobjinfo[Ord(MT_BLOOD)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_BLOOD)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_BLOOD)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].painchance := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].speed := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_BLOOD)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_BLOOD)].mass := 100;
  DO_mobjinfo[Ord(MT_BLOOD)].damage := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].flags := MF_NOBLOCKMAP;
  DO_mobjinfo[Ord(MT_BLOOD)].flags_ex := MF_EX_TRANSPARENT or MF_EX_REDLIGHT;
  DO_mobjinfo[Ord(MT_BLOOD)].flags2_ex := MF2_EX_DONOTRENDERSHADOW;
  DO_mobjinfo[Ord(MT_BLOOD)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_BLOOD)].dropitem := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].missiletype := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_BLOOD)].alpha := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_BLOOD)].missileheight := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].vspeed := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_BLOOD)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_BLOOD)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_BLOOD)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_BLOOD)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].obituary := '';
  DO_mobjinfo[Ord(MT_BLOOD)].hitobituary := '';
  DO_mobjinfo[Ord(MT_BLOOD)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_BLOOD)].meleerange := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_BLOOD)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_TFOG
  DO_mobjinfo[Ord(MT_TFOG)].name := 'TELEPORT FLASH';
  DO_mobjinfo[Ord(MT_TFOG)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_TFOG)].doomednum := -1;
  DO_mobjinfo[Ord(MT_TFOG)].spawnstate := Ord(S_TFOG);
  DO_mobjinfo[Ord(MT_TFOG)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_TFOG)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_TFOG)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].painchance := 0;
  DO_mobjinfo[Ord(MT_TFOG)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].speed := 0;
  DO_mobjinfo[Ord(MT_TFOG)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_TFOG)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_TFOG)].mass := 100;
  DO_mobjinfo[Ord(MT_TFOG)].damage := 0;
  DO_mobjinfo[Ord(MT_TFOG)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].flags := MF_NOBLOCKMAP or MF_NOGRAVITY;
  DO_mobjinfo[Ord(MT_TFOG)].flags_ex := MF_EX_TRANSPARENT or MF_EX_WHITELIGHT;
  DO_mobjinfo[Ord(MT_TFOG)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_TFOG)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TFOG)].dropitem := 0;
  DO_mobjinfo[Ord(MT_TFOG)].missiletype := 0;
  DO_mobjinfo[Ord(MT_TFOG)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_TFOG)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_TFOG)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_TFOG)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_TFOG)].alpha := 0;
  DO_mobjinfo[Ord(MT_TFOG)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TFOG)].missileheight := 0;
  DO_mobjinfo[Ord(MT_TFOG)].vspeed := 0;
  DO_mobjinfo[Ord(MT_TFOG)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_TFOG)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_TFOG)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_TFOG)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_TFOG)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_TFOG)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_TFOG)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_TFOG)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_TFOG)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_TFOG)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_TFOG)].obituary := '';
  DO_mobjinfo[Ord(MT_TFOG)].hitobituary := '';
  DO_mobjinfo[Ord(MT_TFOG)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_TFOG)].meleerange := 0;
  DO_mobjinfo[Ord(MT_TFOG)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_TFOG)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_TFOG)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_TFOG)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_TFOG)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_TFOG)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_TFOG)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_TFOG)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_IFOG
  DO_mobjinfo[Ord(MT_IFOG)].name := 'ITEM RESPAWN FOG';
  DO_mobjinfo[Ord(MT_IFOG)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_IFOG)].doomednum := -1;
  DO_mobjinfo[Ord(MT_IFOG)].spawnstate := Ord(S_IFOG);
  DO_mobjinfo[Ord(MT_IFOG)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_IFOG)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_IFOG)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].painchance := 0;
  DO_mobjinfo[Ord(MT_IFOG)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].speed := 0;
  DO_mobjinfo[Ord(MT_IFOG)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_IFOG)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_IFOG)].mass := 100;
  DO_mobjinfo[Ord(MT_IFOG)].damage := 0;
  DO_mobjinfo[Ord(MT_IFOG)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].flags := MF_NOBLOCKMAP or MF_NOGRAVITY;
  DO_mobjinfo[Ord(MT_IFOG)].flags_ex := MF_EX_TRANSPARENT or MF_EX_WHITELIGHT;
  DO_mobjinfo[Ord(MT_IFOG)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_IFOG)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_IFOG)].dropitem := 0;
  DO_mobjinfo[Ord(MT_IFOG)].missiletype := 0;
  DO_mobjinfo[Ord(MT_IFOG)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_IFOG)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_IFOG)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_IFOG)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_IFOG)].alpha := 0;
  DO_mobjinfo[Ord(MT_IFOG)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_IFOG)].missileheight := 0;
  DO_mobjinfo[Ord(MT_IFOG)].vspeed := 0;
  DO_mobjinfo[Ord(MT_IFOG)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_IFOG)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_IFOG)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_IFOG)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_IFOG)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_IFOG)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_IFOG)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_IFOG)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_IFOG)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_IFOG)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_IFOG)].obituary := '';
  DO_mobjinfo[Ord(MT_IFOG)].hitobituary := '';
  DO_mobjinfo[Ord(MT_IFOG)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_IFOG)].meleerange := 0;
  DO_mobjinfo[Ord(MT_IFOG)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_IFOG)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_IFOG)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_IFOG)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_IFOG)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_IFOG)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_IFOG)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_IFOG)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_TELEPORTMAN
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].name := 'TELEPORT EXIT';
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].doomednum := 14;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].spawnstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].painchance := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].speed := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].mass := 100;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].damage := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].flags := MF_NOSECTOR or MF_NOBLOCKMAP;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].dropitem := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].missiletype := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].alpha := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].missileheight := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].vspeed := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].obituary := '';
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].hitobituary := '';
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].meleerange := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_TELEPORTMAN)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_MISC71
  DO_mobjinfo[Ord(MT_MISC71)].name := 'POOL OF BLOOD';
  DO_mobjinfo[Ord(MT_MISC71)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_MISC71)].doomednum := 24;
  DO_mobjinfo[Ord(MT_MISC71)].spawnstate := Ord(S_GIBS);
  DO_mobjinfo[Ord(MT_MISC71)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_MISC71)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_MISC71)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].painchance := 0;
  DO_mobjinfo[Ord(MT_MISC71)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].speed := 0;
  DO_mobjinfo[Ord(MT_MISC71)].radius := 20 * FRACUNIT;
  DO_mobjinfo[Ord(MT_MISC71)].height := 16 * FRACUNIT;
  DO_mobjinfo[Ord(MT_MISC71)].mass := 100;
  DO_mobjinfo[Ord(MT_MISC71)].damage := 0;
  DO_mobjinfo[Ord(MT_MISC71)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].flags := 0;
  DO_mobjinfo[Ord(MT_MISC71)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_MISC71)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_MISC71)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_MISC71)].dropitem := 0;
  DO_mobjinfo[Ord(MT_MISC71)].missiletype := 0;
  DO_mobjinfo[Ord(MT_MISC71)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_MISC71)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_MISC71)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_MISC71)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_MISC71)].alpha := 0;
  DO_mobjinfo[Ord(MT_MISC71)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_MISC71)].missileheight := 0;
  DO_mobjinfo[Ord(MT_MISC71)].vspeed := 0;
  DO_mobjinfo[Ord(MT_MISC71)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_MISC71)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_MISC71)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_MISC71)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_MISC71)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_MISC71)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_MISC71)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_MISC71)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_MISC71)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_MISC71)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_MISC71)].obituary := '';
  DO_mobjinfo[Ord(MT_MISC71)].hitobituary := '';
  DO_mobjinfo[Ord(MT_MISC71)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_MISC71)].meleerange := 0;
  DO_mobjinfo[Ord(MT_MISC71)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_MISC71)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_MISC71)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_MISC71)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_MISC71)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_MISC71)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_MISC71)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_MISC71)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_PUSH
  DO_mobjinfo[Ord(MT_PUSH)].name := 'PUSHER';
  DO_mobjinfo[Ord(MT_PUSH)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_PUSH)].doomednum := 5001;
  DO_mobjinfo[Ord(MT_PUSH)].spawnstate := Ord(S_TNT1);
  DO_mobjinfo[Ord(MT_PUSH)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_PUSH)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_PUSH)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].painchance := 0;
  DO_mobjinfo[Ord(MT_PUSH)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].speed := 0;
  DO_mobjinfo[Ord(MT_PUSH)].radius := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PUSH)].height := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PUSH)].mass := 10;
  DO_mobjinfo[Ord(MT_PUSH)].damage := 0;
  DO_mobjinfo[Ord(MT_PUSH)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].flags := MF_NOBLOCKMAP;
  DO_mobjinfo[Ord(MT_PUSH)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_PUSH)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_PUSH)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PUSH)].dropitem := 0;
  DO_mobjinfo[Ord(MT_PUSH)].missiletype := 0;
  DO_mobjinfo[Ord(MT_PUSH)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_PUSH)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_PUSH)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_PUSH)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_PUSH)].alpha := 0;
  DO_mobjinfo[Ord(MT_PUSH)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PUSH)].missileheight := 0;
  DO_mobjinfo[Ord(MT_PUSH)].vspeed := 0;
  DO_mobjinfo[Ord(MT_PUSH)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_PUSH)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_PUSH)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_PUSH)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_PUSH)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_PUSH)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_PUSH)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_PUSH)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_PUSH)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_PUSH)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_PUSH)].obituary := '';
  DO_mobjinfo[Ord(MT_PUSH)].hitobituary := '';
  DO_mobjinfo[Ord(MT_PUSH)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_PUSH)].meleerange := 0;
  DO_mobjinfo[Ord(MT_PUSH)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_PUSH)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_PUSH)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_PUSH)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_PUSH)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_PUSH)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_PUSH)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_PUSH)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_PULL
  DO_mobjinfo[Ord(MT_PULL)].name := 'PULLER';
  DO_mobjinfo[Ord(MT_PULL)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_PULL)].doomednum := 5002;
  DO_mobjinfo[Ord(MT_PULL)].spawnstate := Ord(S_TNT1);
  DO_mobjinfo[Ord(MT_PULL)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_PULL)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_PULL)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].painchance := 0;
  DO_mobjinfo[Ord(MT_PULL)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].speed := 0;
  DO_mobjinfo[Ord(MT_PULL)].radius := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PULL)].height := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_PULL)].mass := 10;
  DO_mobjinfo[Ord(MT_PULL)].damage := 0;
  DO_mobjinfo[Ord(MT_PULL)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].flags := MF_NOBLOCKMAP;
  DO_mobjinfo[Ord(MT_PULL)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_PULL)].flags2_ex := 0;
  DO_mobjinfo[Ord(MT_PULL)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_PULL)].dropitem := 0;
  DO_mobjinfo[Ord(MT_PULL)].missiletype := 0;
  DO_mobjinfo[Ord(MT_PULL)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_PULL)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_PULL)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_PULL)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_PULL)].alpha := 0;
  DO_mobjinfo[Ord(MT_PULL)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_PULL)].missileheight := 0;
  DO_mobjinfo[Ord(MT_PULL)].vspeed := 0;
  DO_mobjinfo[Ord(MT_PULL)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_PULL)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_PULL)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_PULL)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_PULL)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_PULL)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_PULL)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_PULL)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_PULL)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_PULL)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_PULL)].obituary := '';
  DO_mobjinfo[Ord(MT_PULL)].hitobituary := '';
  DO_mobjinfo[Ord(MT_PULL)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_PULL)].meleerange := 0;
  DO_mobjinfo[Ord(MT_PULL)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_PULL)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_PULL)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_PULL)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_PULL)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_PULL)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_PULL)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_PULL)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_DOGS
  DO_mobjinfo[Ord(MT_DOGS)].name := 'DOG';
  DO_mobjinfo[Ord(MT_DOGS)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_DOGS)].doomednum := 888;
  DO_mobjinfo[Ord(MT_DOGS)].spawnstate := Ord(S_DOGS_STND);
  DO_mobjinfo[Ord(MT_DOGS)].spawnhealth := 500;
  DO_mobjinfo[Ord(MT_DOGS)].seestate := Ord(S_DOGS_RUN1);
  DO_mobjinfo[Ord(MT_DOGS)].seesound := 109;
  DO_mobjinfo[Ord(MT_DOGS)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_DOGS)].attacksound := 110;
  DO_mobjinfo[Ord(MT_DOGS)].painstate := Ord(S_DOGS_PAIN);
  DO_mobjinfo[Ord(MT_DOGS)].painchance := 180;
  DO_mobjinfo[Ord(MT_DOGS)].painsound := 113;
  DO_mobjinfo[Ord(MT_DOGS)].meleestate := Ord(S_DOGS_ATK1);
  DO_mobjinfo[Ord(MT_DOGS)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_DOGS)].deathstate := Ord(S_DOGS_DIE1);
  DO_mobjinfo[Ord(MT_DOGS)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_DOGS)].deathsound := 112;
  DO_mobjinfo[Ord(MT_DOGS)].speed := 10;
  DO_mobjinfo[Ord(MT_DOGS)].radius := 12 * FRACUNIT;
  DO_mobjinfo[Ord(MT_DOGS)].height := 28 * FRACUNIT;
  DO_mobjinfo[Ord(MT_DOGS)].mass := 100;
  DO_mobjinfo[Ord(MT_DOGS)].damage := 0;
  DO_mobjinfo[Ord(MT_DOGS)].activesound := 111;
  DO_mobjinfo[Ord(MT_DOGS)].flags := MF_SOLID or MF_SHOOTABLE or MF_COUNTKILL;
  DO_mobjinfo[Ord(MT_DOGS)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_DOGS)].flags2_ex := MF2_EX_JUMPDOWN or MF2_EX_JUMPUP or MF2_EX_DONTBLOCKPLAYER;
  DO_mobjinfo[Ord(MT_DOGS)].raisestate := Ord(S_DOGS_RAISE1);
  DO_mobjinfo[Ord(MT_DOGS)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_DOGS)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_DOGS)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_DOGS)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_DOGS)].dropitem := 0;
  DO_mobjinfo[Ord(MT_DOGS)].missiletype := 0;
  DO_mobjinfo[Ord(MT_DOGS)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_DOGS)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_DOGS)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_DOGS)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_DOGS)].alpha := 0;
  DO_mobjinfo[Ord(MT_DOGS)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_DOGS)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_DOGS)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_DOGS)].missileheight := 0;
  DO_mobjinfo[Ord(MT_DOGS)].vspeed := 0;
  DO_mobjinfo[Ord(MT_DOGS)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_DOGS)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_DOGS)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_DOGS)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_DOGS)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_DOGS)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_DOGS)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_DOGS)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_DOGS)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_DOGS)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_DOGS)].obituary := '';
  DO_mobjinfo[Ord(MT_DOGS)].hitobituary := '';
  DO_mobjinfo[Ord(MT_DOGS)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_DOGS)].meleerange := 0;
  DO_mobjinfo[Ord(MT_DOGS)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_DOGS)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_DOGS)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_DOGS)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_DOGS)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_DOGS)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_DOGS)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_DOGS)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // MT_NONE
  DO_mobjinfo[Ord(MT_NONE)].name := 'NONE';
  DO_mobjinfo[Ord(MT_NONE)].inheritsfrom := -1;
  DO_mobjinfo[Ord(MT_NONE)].doomednum := -1;
  DO_mobjinfo[Ord(MT_NONE)].spawnstate := Ord(S_NONE);
  DO_mobjinfo[Ord(MT_NONE)].spawnhealth := 1000;
  DO_mobjinfo[Ord(MT_NONE)].seestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].seesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].reactiontime := 8;
  DO_mobjinfo[Ord(MT_NONE)].attacksound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].painstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].painchance := 0;
  DO_mobjinfo[Ord(MT_NONE)].painsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].meleestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].missilestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].deathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].xdeathstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].deathsound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].speed := 0;
  DO_mobjinfo[Ord(MT_NONE)].radius := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_NONE)].height := 8 * FRACUNIT;
  DO_mobjinfo[Ord(MT_NONE)].mass := 10;
  DO_mobjinfo[Ord(MT_NONE)].damage := 0;
  DO_mobjinfo[Ord(MT_NONE)].activesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].flags := MF_NOBLOCKMAP;
  DO_mobjinfo[Ord(MT_NONE)].flags_ex := 0;
  DO_mobjinfo[Ord(MT_NONE)].flags2_ex := MF2_EX_NOHITFLOOR;
  DO_mobjinfo[Ord(MT_NONE)].raisestate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].customsound1 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].customsound2 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].customsound3 := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].meleesound := Ord(sfx_None);
  DO_mobjinfo[Ord(MT_NONE)].dropitem := 0;
  DO_mobjinfo[Ord(MT_NONE)].missiletype := 0;
  DO_mobjinfo[Ord(MT_NONE)].explosiondamage := 0;
  DO_mobjinfo[Ord(MT_NONE)].explosionradius := 0;
  DO_mobjinfo[Ord(MT_NONE)].meleedamage := 0;
  DO_mobjinfo[Ord(MT_NONE)].renderstyle := mrs_normal;
  DO_mobjinfo[Ord(MT_NONE)].alpha := 0;
  DO_mobjinfo[Ord(MT_NONE)].healstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].crashstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].interactstate := Ord(S_NULL);
  DO_mobjinfo[Ord(MT_NONE)].missileheight := 0;
  DO_mobjinfo[Ord(MT_NONE)].vspeed := 0;
  DO_mobjinfo[Ord(MT_NONE)].pushfactor := DEFPUSHFACTOR;
  DO_mobjinfo[Ord(MT_NONE)].friction := ORIG_FRICTION;
  DO_mobjinfo[Ord(MT_NONE)].scale := FRACUNIT;
  DO_mobjinfo[Ord(MT_NONE)].gravity := FRACUNIT;
  DO_mobjinfo[Ord(MT_NONE)].flags3_ex := 0;
  DO_mobjinfo[Ord(MT_NONE)].flags4_ex := 0;
  DO_mobjinfo[Ord(MT_NONE)].minmissilechance := 0;
  DO_mobjinfo[Ord(MT_NONE)].floatspeed := 0;
  DO_mobjinfo[Ord(MT_NONE)].normalspeed := 0;
  DO_mobjinfo[Ord(MT_NONE)].fastspeed := 0;
  DO_mobjinfo[Ord(MT_NONE)].obituary := '';
  DO_mobjinfo[Ord(MT_NONE)].hitobituary := '';
  DO_mobjinfo[Ord(MT_NONE)].gender := gender_Default;
  DO_mobjinfo[Ord(MT_NONE)].meleerange := 0;
  DO_mobjinfo[Ord(MT_NONE)].maxstepheight := 0;
  DO_mobjinfo[Ord(MT_NONE)].maxdropoffheight := 0;
  DO_mobjinfo[Ord(MT_NONE)].gibhealth := 0;
  DO_mobjinfo[Ord(MT_NONE)].maxtargetrange := 0;
  DO_mobjinfo[Ord(MT_NONE)].WeaveIndexXY := 0;
  DO_mobjinfo[Ord(MT_NONE)].WeaveIndexZ := 0;
  DO_mobjinfo[Ord(MT_NONE)].spriteDX := 0;
  DO_mobjinfo[Ord(MT_NONE)].spriteDY := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // states
  ////////////////////////////////////////////////////////////////////////////////

  ////////////////////////////////////////////////////////////////////////////////
  // S_NULL
  DO_states[Ord(S_NULL)].sprite := Ord(SPR_TNT1);
  DO_states[Ord(S_NULL)].frame := 0;
  DO_states[Ord(S_NULL)].tics := -1;
  DO_states[Ord(S_NULL)].tics2 := 0;
  DO_states[Ord(S_NULL)].action.acp1 := nil;
  DO_states[Ord(S_NULL)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_NULL)].misc1 := 0;
  DO_states[Ord(S_NULL)].misc2 := 0;
  DO_states[Ord(S_NULL)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_BLOOD1
  DO_states[Ord(S_BLOOD1)].sprite := Ord(SPR_BLUD);
  DO_states[Ord(S_BLOOD1)].frame := 2;
  DO_states[Ord(S_BLOOD1)].tics := 8;
  DO_states[Ord(S_BLOOD1)].tics2 := 0;
  DO_states[Ord(S_BLOOD1)].action.acp1 := nil;
  DO_states[Ord(S_BLOOD1)].nextstate := Ord(S_BLOOD2);
  DO_states[Ord(S_BLOOD1)].misc1 := 0;
  DO_states[Ord(S_BLOOD1)].misc2 := 0;
  DO_states[Ord(S_BLOOD1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_BLOOD2
  DO_states[Ord(S_BLOOD2)].sprite := Ord(SPR_BLUD);
  DO_states[Ord(S_BLOOD2)].frame := 1;
  DO_states[Ord(S_BLOOD2)].tics := 8;
  DO_states[Ord(S_BLOOD2)].tics2 := 0;
  DO_states[Ord(S_BLOOD2)].action.acp1 := nil;
  DO_states[Ord(S_BLOOD2)].nextstate := Ord(S_BLOOD3);
  DO_states[Ord(S_BLOOD2)].misc1 := 0;
  DO_states[Ord(S_BLOOD2)].misc2 := 0;
  DO_states[Ord(S_BLOOD2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_BLOOD3
  DO_states[Ord(S_BLOOD3)].sprite := Ord(SPR_BLUD);
  DO_states[Ord(S_BLOOD3)].frame := 0;
  DO_states[Ord(S_BLOOD3)].tics := 8;
  DO_states[Ord(S_BLOOD3)].tics2 := 0;
  DO_states[Ord(S_BLOOD3)].action.acp1 := nil;
  DO_states[Ord(S_BLOOD3)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_BLOOD3)].misc1 := 0;
  DO_states[Ord(S_BLOOD3)].misc2 := 0;
  DO_states[Ord(S_BLOOD3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PUFF1
  DO_states[Ord(S_PUFF1)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_PUFF1)].frame := 32768;
  DO_states[Ord(S_PUFF1)].tics := 4;
  DO_states[Ord(S_PUFF1)].tics2 := 0;
  DO_states[Ord(S_PUFF1)].action.acp1 := nil;
  DO_states[Ord(S_PUFF1)].nextstate := Ord(S_PUFF2);
  DO_states[Ord(S_PUFF1)].misc1 := 0;
  DO_states[Ord(S_PUFF1)].misc2 := 0;
  DO_states[Ord(S_PUFF1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PUFF2
  DO_states[Ord(S_PUFF2)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_PUFF2)].frame := 1;
  DO_states[Ord(S_PUFF2)].tics := 4;
  DO_states[Ord(S_PUFF2)].tics2 := 0;
  DO_states[Ord(S_PUFF2)].action.acp1 := nil;
  DO_states[Ord(S_PUFF2)].nextstate := Ord(S_PUFF3);
  DO_states[Ord(S_PUFF2)].misc1 := 0;
  DO_states[Ord(S_PUFF2)].misc2 := 0;
  DO_states[Ord(S_PUFF2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PUFF3
  DO_states[Ord(S_PUFF3)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_PUFF3)].frame := 2;
  DO_states[Ord(S_PUFF3)].tics := 4;
  DO_states[Ord(S_PUFF3)].tics2 := 0;
  DO_states[Ord(S_PUFF3)].action.acp1 := nil;
  DO_states[Ord(S_PUFF3)].nextstate := Ord(S_PUFF4);
  DO_states[Ord(S_PUFF3)].misc1 := 0;
  DO_states[Ord(S_PUFF3)].misc2 := 0;
  DO_states[Ord(S_PUFF3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PUFF4
  DO_states[Ord(S_PUFF4)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_PUFF4)].frame := 3;
  DO_states[Ord(S_PUFF4)].tics := 4;
  DO_states[Ord(S_PUFF4)].tics2 := 0;
  DO_states[Ord(S_PUFF4)].action.acp1 := nil;
  DO_states[Ord(S_PUFF4)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_PUFF4)].misc1 := 0;
  DO_states[Ord(S_PUFF4)].misc2 := 0;
  DO_states[Ord(S_PUFF4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG
  DO_states[Ord(S_TFOG)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG)].frame := 32768;
  DO_states[Ord(S_TFOG)].tics := 6;
  DO_states[Ord(S_TFOG)].tics2 := 0;
  DO_states[Ord(S_TFOG)].action.acp1 := nil;
  DO_states[Ord(S_TFOG)].nextstate := Ord(S_TFOG01);
  DO_states[Ord(S_TFOG)].misc1 := 0;
  DO_states[Ord(S_TFOG)].misc2 := 0;
  DO_states[Ord(S_TFOG)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG01
  DO_states[Ord(S_TFOG01)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG01)].frame := 32769;
  DO_states[Ord(S_TFOG01)].tics := 6;
  DO_states[Ord(S_TFOG01)].tics2 := 0;
  DO_states[Ord(S_TFOG01)].action.acp1 := nil;
  DO_states[Ord(S_TFOG01)].nextstate := Ord(S_TFOG02);
  DO_states[Ord(S_TFOG01)].misc1 := 0;
  DO_states[Ord(S_TFOG01)].misc2 := 0;
  DO_states[Ord(S_TFOG01)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG02
  DO_states[Ord(S_TFOG02)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG02)].frame := 32768;
  DO_states[Ord(S_TFOG02)].tics := 6;
  DO_states[Ord(S_TFOG02)].tics2 := 0;
  DO_states[Ord(S_TFOG02)].action.acp1 := nil;
  DO_states[Ord(S_TFOG02)].nextstate := Ord(S_TFOG2);
  DO_states[Ord(S_TFOG02)].misc1 := 0;
  DO_states[Ord(S_TFOG02)].misc2 := 0;
  DO_states[Ord(S_TFOG02)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG2
  DO_states[Ord(S_TFOG2)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG2)].frame := 32769;
  DO_states[Ord(S_TFOG2)].tics := 6;
  DO_states[Ord(S_TFOG2)].tics2 := 0;
  DO_states[Ord(S_TFOG2)].action.acp1 := nil;
  DO_states[Ord(S_TFOG2)].nextstate := Ord(S_TFOG3);
  DO_states[Ord(S_TFOG2)].misc1 := 0;
  DO_states[Ord(S_TFOG2)].misc2 := 0;
  DO_states[Ord(S_TFOG2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG3
  DO_states[Ord(S_TFOG3)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG3)].frame := 32770;
  DO_states[Ord(S_TFOG3)].tics := 6;
  DO_states[Ord(S_TFOG3)].tics2 := 0;
  DO_states[Ord(S_TFOG3)].action.acp1 := nil;
  DO_states[Ord(S_TFOG3)].nextstate := Ord(S_TFOG4);
  DO_states[Ord(S_TFOG3)].misc1 := 0;
  DO_states[Ord(S_TFOG3)].misc2 := 0;
  DO_states[Ord(S_TFOG3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG4
  DO_states[Ord(S_TFOG4)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG4)].frame := 32771;
  DO_states[Ord(S_TFOG4)].tics := 6;
  DO_states[Ord(S_TFOG4)].tics2 := 0;
  DO_states[Ord(S_TFOG4)].action.acp1 := nil;
  DO_states[Ord(S_TFOG4)].nextstate := Ord(S_TFOG5);
  DO_states[Ord(S_TFOG4)].misc1 := 0;
  DO_states[Ord(S_TFOG4)].misc2 := 0;
  DO_states[Ord(S_TFOG4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG5
  DO_states[Ord(S_TFOG5)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG5)].frame := 32772;
  DO_states[Ord(S_TFOG5)].tics := 6;
  DO_states[Ord(S_TFOG5)].tics2 := 0;
  DO_states[Ord(S_TFOG5)].action.acp1 := nil;
  DO_states[Ord(S_TFOG5)].nextstate := Ord(S_TFOG6);
  DO_states[Ord(S_TFOG5)].misc1 := 0;
  DO_states[Ord(S_TFOG5)].misc2 := 0;
  DO_states[Ord(S_TFOG5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG6
  DO_states[Ord(S_TFOG6)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG6)].frame := 32773;
  DO_states[Ord(S_TFOG6)].tics := 6;
  DO_states[Ord(S_TFOG6)].tics2 := 0;
  DO_states[Ord(S_TFOG6)].action.acp1 := nil;
  DO_states[Ord(S_TFOG6)].nextstate := Ord(S_TFOG7);
  DO_states[Ord(S_TFOG6)].misc1 := 0;
  DO_states[Ord(S_TFOG6)].misc2 := 0;
  DO_states[Ord(S_TFOG6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG7
  DO_states[Ord(S_TFOG7)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG7)].frame := 32774;
  DO_states[Ord(S_TFOG7)].tics := 6;
  DO_states[Ord(S_TFOG7)].tics2 := 0;
  DO_states[Ord(S_TFOG7)].action.acp1 := nil;
  DO_states[Ord(S_TFOG7)].nextstate := Ord(S_TFOG8);
  DO_states[Ord(S_TFOG7)].misc1 := 0;
  DO_states[Ord(S_TFOG7)].misc2 := 0;
  DO_states[Ord(S_TFOG7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG8
  DO_states[Ord(S_TFOG8)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG8)].frame := 32775;
  DO_states[Ord(S_TFOG8)].tics := 6;
  DO_states[Ord(S_TFOG8)].tics2 := 0;
  DO_states[Ord(S_TFOG8)].action.acp1 := nil;
  DO_states[Ord(S_TFOG8)].nextstate := Ord(S_TFOG9);
  DO_states[Ord(S_TFOG8)].misc1 := 0;
  DO_states[Ord(S_TFOG8)].misc2 := 0;
  DO_states[Ord(S_TFOG8)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG9
  DO_states[Ord(S_TFOG9)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG9)].frame := 32776;
  DO_states[Ord(S_TFOG9)].tics := 6;
  DO_states[Ord(S_TFOG9)].tics2 := 0;
  DO_states[Ord(S_TFOG9)].action.acp1 := nil;
  DO_states[Ord(S_TFOG9)].nextstate := Ord(S_TFOG10);
  DO_states[Ord(S_TFOG9)].misc1 := 0;
  DO_states[Ord(S_TFOG9)].misc2 := 0;
  DO_states[Ord(S_TFOG9)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TFOG10
  DO_states[Ord(S_TFOG10)].sprite := Ord(SPR_TFOG);
  DO_states[Ord(S_TFOG10)].frame := 32777;
  DO_states[Ord(S_TFOG10)].tics := 6;
  DO_states[Ord(S_TFOG10)].tics2 := 0;
  DO_states[Ord(S_TFOG10)].action.acp1 := nil;
  DO_states[Ord(S_TFOG10)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_TFOG10)].misc1 := 0;
  DO_states[Ord(S_TFOG10)].misc2 := 0;
  DO_states[Ord(S_TFOG10)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG
  DO_states[Ord(S_IFOG)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG)].frame := 32768;
  DO_states[Ord(S_IFOG)].tics := 6;
  DO_states[Ord(S_IFOG)].tics2 := 0;
  DO_states[Ord(S_IFOG)].action.acp1 := nil;
  DO_states[Ord(S_IFOG)].nextstate := Ord(S_IFOG01);
  DO_states[Ord(S_IFOG)].misc1 := 0;
  DO_states[Ord(S_IFOG)].misc2 := 0;
  DO_states[Ord(S_IFOG)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG01
  DO_states[Ord(S_IFOG01)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG01)].frame := 32769;
  DO_states[Ord(S_IFOG01)].tics := 6;
  DO_states[Ord(S_IFOG01)].tics2 := 0;
  DO_states[Ord(S_IFOG01)].action.acp1 := nil;
  DO_states[Ord(S_IFOG01)].nextstate := Ord(S_IFOG02);
  DO_states[Ord(S_IFOG01)].misc1 := 0;
  DO_states[Ord(S_IFOG01)].misc2 := 0;
  DO_states[Ord(S_IFOG01)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG02
  DO_states[Ord(S_IFOG02)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG02)].frame := 32768;
  DO_states[Ord(S_IFOG02)].tics := 6;
  DO_states[Ord(S_IFOG02)].tics2 := 0;
  DO_states[Ord(S_IFOG02)].action.acp1 := nil;
  DO_states[Ord(S_IFOG02)].nextstate := Ord(S_IFOG2);
  DO_states[Ord(S_IFOG02)].misc1 := 0;
  DO_states[Ord(S_IFOG02)].misc2 := 0;
  DO_states[Ord(S_IFOG02)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG2
  DO_states[Ord(S_IFOG2)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG2)].frame := 32769;
  DO_states[Ord(S_IFOG2)].tics := 6;
  DO_states[Ord(S_IFOG2)].tics2 := 0;
  DO_states[Ord(S_IFOG2)].action.acp1 := nil;
  DO_states[Ord(S_IFOG2)].nextstate := Ord(S_IFOG3);
  DO_states[Ord(S_IFOG2)].misc1 := 0;
  DO_states[Ord(S_IFOG2)].misc2 := 0;
  DO_states[Ord(S_IFOG2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG3
  DO_states[Ord(S_IFOG3)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG3)].frame := 32770;
  DO_states[Ord(S_IFOG3)].tics := 6;
  DO_states[Ord(S_IFOG3)].tics2 := 0;
  DO_states[Ord(S_IFOG3)].action.acp1 := nil;
  DO_states[Ord(S_IFOG3)].nextstate := Ord(S_IFOG4);
  DO_states[Ord(S_IFOG3)].misc1 := 0;
  DO_states[Ord(S_IFOG3)].misc2 := 0;
  DO_states[Ord(S_IFOG3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG4
  DO_states[Ord(S_IFOG4)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG4)].frame := 32771;
  DO_states[Ord(S_IFOG4)].tics := 6;
  DO_states[Ord(S_IFOG4)].tics2 := 0;
  DO_states[Ord(S_IFOG4)].action.acp1 := nil;
  DO_states[Ord(S_IFOG4)].nextstate := Ord(S_IFOG5);
  DO_states[Ord(S_IFOG4)].misc1 := 0;
  DO_states[Ord(S_IFOG4)].misc2 := 0;
  DO_states[Ord(S_IFOG4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_IFOG5
  DO_states[Ord(S_IFOG5)].sprite := Ord(SPR_IFOG);
  DO_states[Ord(S_IFOG5)].frame := 32772;
  DO_states[Ord(S_IFOG5)].tics := 6;
  DO_states[Ord(S_IFOG5)].tics2 := 0;
  DO_states[Ord(S_IFOG5)].action.acp1 := nil;
  DO_states[Ord(S_IFOG5)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_IFOG5)].misc1 := 0;
  DO_states[Ord(S_IFOG5)].misc2 := 0;
  DO_states[Ord(S_IFOG5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY
  DO_states[Ord(S_PLAY)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY)].frame := spriteframe('D');
  DO_states[Ord(S_PLAY)].tics := -1;
  DO_states[Ord(S_PLAY)].tics2 := 0;
  DO_states[Ord(S_PLAY)].action.acp1 := nil;
  DO_states[Ord(S_PLAY)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_PLAY)].misc1 := 0;
  DO_states[Ord(S_PLAY)].misc2 := 0;
  DO_states[Ord(S_PLAY)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_RUN1
  DO_states[Ord(S_PLAY_RUN1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_RUN1)].frame := spriteframe('A');
  DO_states[Ord(S_PLAY_RUN1)].tics := 4;
  DO_states[Ord(S_PLAY_RUN1)].tics2 := 0;
  DO_states[Ord(S_PLAY_RUN1)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_RUN1)].nextstate := Ord(S_PLAY_RUN2);
  DO_states[Ord(S_PLAY_RUN1)].misc1 := 0;
  DO_states[Ord(S_PLAY_RUN1)].misc2 := 0;
  DO_states[Ord(S_PLAY_RUN1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_RUN2
  DO_states[Ord(S_PLAY_RUN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_RUN2)].frame := spriteframe('B');
  DO_states[Ord(S_PLAY_RUN2)].tics := 4;
  DO_states[Ord(S_PLAY_RUN2)].tics2 := 0;
  DO_states[Ord(S_PLAY_RUN2)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_RUN2)].nextstate := Ord(S_PLAY_RUN3);
  DO_states[Ord(S_PLAY_RUN2)].misc1 := 0;
  DO_states[Ord(S_PLAY_RUN2)].misc2 := 0;
  DO_states[Ord(S_PLAY_RUN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_RUN3
  DO_states[Ord(S_PLAY_RUN3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_RUN3)].frame := spriteframe('C');
  DO_states[Ord(S_PLAY_RUN3)].tics := 4;
  DO_states[Ord(S_PLAY_RUN3)].tics2 := 0;
  DO_states[Ord(S_PLAY_RUN3)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_RUN3)].nextstate := Ord(S_PLAY_RUN4);
  DO_states[Ord(S_PLAY_RUN3)].misc1 := 0;
  DO_states[Ord(S_PLAY_RUN3)].misc2 := 0;
  DO_states[Ord(S_PLAY_RUN3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_RUN4
  DO_states[Ord(S_PLAY_RUN4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_RUN4)].frame := spriteframe('D');
  DO_states[Ord(S_PLAY_RUN4)].tics := 4;
  DO_states[Ord(S_PLAY_RUN4)].tics2 := 0;
  DO_states[Ord(S_PLAY_RUN4)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_RUN4)].nextstate := Ord(S_PLAY_RUN1);
  DO_states[Ord(S_PLAY_RUN4)].misc1 := 0;
  DO_states[Ord(S_PLAY_RUN4)].misc2 := 0;
  DO_states[Ord(S_PLAY_RUN4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_ATK1
  DO_states[Ord(S_PLAY_ATK1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_ATK1)].frame := spriteframe('M');
  DO_states[Ord(S_PLAY_ATK1)].tics := 12;
  DO_states[Ord(S_PLAY_ATK1)].tics2 := 0;
  DO_states[Ord(S_PLAY_ATK1)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_ATK1)].nextstate := Ord(S_PLAY);
  DO_states[Ord(S_PLAY_ATK1)].misc1 := 0;
  DO_states[Ord(S_PLAY_ATK1)].misc2 := 0;
  DO_states[Ord(S_PLAY_ATK1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_ATK2
  DO_states[Ord(S_PLAY_ATK2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_ATK2)].frame := spriteframe('M') + FF_FULLBRIGHT;
  DO_states[Ord(S_PLAY_ATK2)].tics := 6;
  DO_states[Ord(S_PLAY_ATK2)].tics2 := 0;
  DO_states[Ord(S_PLAY_ATK2)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_ATK2)].nextstate := Ord(S_PLAY_ATK1);
  DO_states[Ord(S_PLAY_ATK2)].misc1 := 0;
  DO_states[Ord(S_PLAY_ATK2)].misc2 := 0;
  DO_states[Ord(S_PLAY_ATK2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_PAIN
  DO_states[Ord(S_PLAY_PAIN)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_PAIN)].frame := spriteframe('S');
  DO_states[Ord(S_PLAY_PAIN)].tics := 4;
  DO_states[Ord(S_PLAY_PAIN)].tics2 := 0;
  DO_states[Ord(S_PLAY_PAIN)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_PAIN)].nextstate := Ord(S_PLAY_PAIN2);
  DO_states[Ord(S_PLAY_PAIN)].misc1 := 0;
  DO_states[Ord(S_PLAY_PAIN)].misc2 := 0;
  DO_states[Ord(S_PLAY_PAIN)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_PAIN2
  DO_states[Ord(S_PLAY_PAIN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_PAIN2)].frame := spriteframe('S');
  DO_states[Ord(S_PLAY_PAIN2)].tics := 4;
  DO_states[Ord(S_PLAY_PAIN2)].tics2 := 0;
  DO_states[Ord(S_PLAY_PAIN2)].action.acp1 := @A_Pain;
  DO_states[Ord(S_PLAY_PAIN2)].nextstate := Ord(S_PLAY);
  DO_states[Ord(S_PLAY_PAIN2)].misc1 := 0;
  DO_states[Ord(S_PLAY_PAIN2)].misc2 := 0;
  DO_states[Ord(S_PLAY_PAIN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE1
  DO_states[Ord(S_PLAY_DIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE1)].frame := spriteframe('U');
  DO_states[Ord(S_PLAY_DIE1)].tics := 10;
  DO_states[Ord(S_PLAY_DIE1)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE1)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_DIE1)].nextstate := Ord(S_PLAY_DIE2);
  DO_states[Ord(S_PLAY_DIE1)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE1)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE2
  DO_states[Ord(S_PLAY_DIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE2)].frame := spriteframe('V');
  DO_states[Ord(S_PLAY_DIE2)].tics := 10;
  DO_states[Ord(S_PLAY_DIE2)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE2)].action.acp1 := @A_PlayerScream;
  DO_states[Ord(S_PLAY_DIE2)].nextstate := Ord(S_PLAY_DIE3);
  DO_states[Ord(S_PLAY_DIE2)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE2)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE3
  DO_states[Ord(S_PLAY_DIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE3)].frame := spriteframe('W');
  DO_states[Ord(S_PLAY_DIE3)].tics := 10;
  DO_states[Ord(S_PLAY_DIE3)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_PLAY_DIE3)].nextstate := Ord(S_PLAY_DIE4);
  DO_states[Ord(S_PLAY_DIE3)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE3)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE4
  DO_states[Ord(S_PLAY_DIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE4)].frame := spriteframe('X');
  DO_states[Ord(S_PLAY_DIE4)].tics := 10;
  DO_states[Ord(S_PLAY_DIE4)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE4)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_DIE4)].nextstate := Ord(S_PLAY_DIE5);
  DO_states[Ord(S_PLAY_DIE4)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE4)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE5
  DO_states[Ord(S_PLAY_DIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE5)].frame := spriteframe('X');
  DO_states[Ord(S_PLAY_DIE5)].tics := 10;
  DO_states[Ord(S_PLAY_DIE5)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE5)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_DIE5)].nextstate := Ord(S_PLAY_DIE6);
  DO_states[Ord(S_PLAY_DIE5)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE5)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE6
  DO_states[Ord(S_PLAY_DIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE6)].frame := spriteframe('X');
  DO_states[Ord(S_PLAY_DIE6)].tics := 10;
  DO_states[Ord(S_PLAY_DIE6)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE6)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_DIE6)].nextstate := Ord(S_PLAY_DIE7);
  DO_states[Ord(S_PLAY_DIE6)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE6)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_DIE7
  DO_states[Ord(S_PLAY_DIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_DIE7)].frame := spriteframe('X');
  DO_states[Ord(S_PLAY_DIE7)].tics := -1;
  DO_states[Ord(S_PLAY_DIE7)].tics2 := 0;
  DO_states[Ord(S_PLAY_DIE7)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_DIE7)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_PLAY_DIE7)].misc1 := 0;
  DO_states[Ord(S_PLAY_DIE7)].misc2 := 0;
  DO_states[Ord(S_PLAY_DIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE1
  DO_states[Ord(S_PLAY_XDIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE1)].frame := spriteframe('Y');
  DO_states[Ord(S_PLAY_XDIE1)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE1)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE1)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE1)].nextstate := Ord(S_PLAY_XDIE2);
  DO_states[Ord(S_PLAY_XDIE1)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE1)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE2
  DO_states[Ord(S_PLAY_XDIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE2)].frame := spriteframe('Z');
  DO_states[Ord(S_PLAY_XDIE2)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE2)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE2)].action.acp1 := @A_XScream;
  DO_states[Ord(S_PLAY_XDIE2)].nextstate := Ord(S_PLAY_XDIE3);
  DO_states[Ord(S_PLAY_XDIE2)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE2)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE3
  DO_states[Ord(S_PLAY_XDIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE3)].frame := spriteframe('[');
  DO_states[Ord(S_PLAY_XDIE3)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE3)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_PLAY_XDIE3)].nextstate := Ord(S_PLAY_XDIE4);
  DO_states[Ord(S_PLAY_XDIE3)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE3)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE4
  DO_states[Ord(S_PLAY_XDIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE4)].frame := spriteframe(']');
  DO_states[Ord(S_PLAY_XDIE4)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE4)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE4)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE4)].nextstate := Ord(S_PLAY_XDIE5);
  DO_states[Ord(S_PLAY_XDIE4)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE4)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE5
  DO_states[Ord(S_PLAY_XDIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE5)].frame := spriteframe('\');
  DO_states[Ord(S_PLAY_XDIE5)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE5)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE5)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE5)].nextstate := Ord(S_PLAY_XDIE6);
  DO_states[Ord(S_PLAY_XDIE5)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE5)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE6
  DO_states[Ord(S_PLAY_XDIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE6)].frame := spriteframe('\');
  DO_states[Ord(S_PLAY_XDIE6)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE6)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE6)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE6)].nextstate := Ord(S_PLAY_XDIE7);
  DO_states[Ord(S_PLAY_XDIE6)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE6)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE7
  DO_states[Ord(S_PLAY_XDIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE7)].frame := spriteframe('\');
  DO_states[Ord(S_PLAY_XDIE7)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE7)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE7)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE7)].nextstate := Ord(S_PLAY_XDIE8);
  DO_states[Ord(S_PLAY_XDIE7)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE7)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE8
  DO_states[Ord(S_PLAY_XDIE8)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE8)].frame := spriteframe('\');
  DO_states[Ord(S_PLAY_XDIE8)].tics := 5;
  DO_states[Ord(S_PLAY_XDIE8)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE8)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE8)].nextstate := Ord(S_PLAY_XDIE9);
  DO_states[Ord(S_PLAY_XDIE8)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE8)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE8)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_PLAY_XDIE9
  DO_states[Ord(S_PLAY_XDIE9)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_PLAY_XDIE9)].frame := spriteframe('\');
  DO_states[Ord(S_PLAY_XDIE9)].tics := -1;
  DO_states[Ord(S_PLAY_XDIE9)].tics2 := 0;
  DO_states[Ord(S_PLAY_XDIE9)].action.acp1 := nil;
  DO_states[Ord(S_PLAY_XDIE9)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_PLAY_XDIE9)].misc1 := 0;
  DO_states[Ord(S_PLAY_XDIE9)].misc2 := 0;
  DO_states[Ord(S_PLAY_XDIE9)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY
  DO_states[Ord(S_CPLAY)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY)].frame := spriteframe('H');
  DO_states[Ord(S_CPLAY)].tics := -1;
  DO_states[Ord(S_CPLAY)].tics2 := 0;
  DO_states[Ord(S_CPLAY)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_CPLAY)].misc1 := 0;
  DO_states[Ord(S_CPLAY)].misc2 := 0;
  DO_states[Ord(S_CPLAY)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_RUN1
  DO_states[Ord(S_CPLAY_RUN1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_RUN1)].frame := spriteframe('E');
  DO_states[Ord(S_CPLAY_RUN1)].tics := 4;
  DO_states[Ord(S_CPLAY_RUN1)].tics2 := 0;
  DO_states[Ord(S_CPLAY_RUN1)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_RUN1)].nextstate := Ord(S_CPLAY_RUN2);
  DO_states[Ord(S_CPLAY_RUN1)].misc1 := 0;
  DO_states[Ord(S_CPLAY_RUN1)].misc2 := 0;
  DO_states[Ord(S_CPLAY_RUN1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_RUN2
  DO_states[Ord(S_CPLAY_RUN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_RUN2)].frame := spriteframe('F');
  DO_states[Ord(S_CPLAY_RUN2)].tics := 4;
  DO_states[Ord(S_CPLAY_RUN2)].tics2 := 0;
  DO_states[Ord(S_CPLAY_RUN2)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_RUN2)].nextstate := Ord(S_CPLAY_RUN3);
  DO_states[Ord(S_CPLAY_RUN2)].misc1 := 0;
  DO_states[Ord(S_CPLAY_RUN2)].misc2 := 0;
  DO_states[Ord(S_CPLAY_RUN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_RUN3
  DO_states[Ord(S_CPLAY_RUN3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_RUN3)].frame := spriteframe('G');
  DO_states[Ord(S_CPLAY_RUN3)].tics := 4;
  DO_states[Ord(S_CPLAY_RUN3)].tics2 := 0;
  DO_states[Ord(S_CPLAY_RUN3)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_RUN3)].nextstate := Ord(S_CPLAY_RUN4);
  DO_states[Ord(S_CPLAY_RUN3)].misc1 := 0;
  DO_states[Ord(S_CPLAY_RUN3)].misc2 := 0;
  DO_states[Ord(S_CPLAY_RUN3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_RUN4
  DO_states[Ord(S_CPLAY_RUN4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_RUN4)].frame := spriteframe('H');
  DO_states[Ord(S_CPLAY_RUN4)].tics := 4;
  DO_states[Ord(S_CPLAY_RUN4)].tics2 := 0;
  DO_states[Ord(S_CPLAY_RUN4)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_RUN4)].nextstate := Ord(S_CPLAY_RUN1);
  DO_states[Ord(S_CPLAY_RUN4)].misc1 := 0;
  DO_states[Ord(S_CPLAY_RUN4)].misc2 := 0;
  DO_states[Ord(S_CPLAY_RUN4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_ATK1
  DO_states[Ord(S_CPLAY_ATK1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_ATK1)].frame := spriteframe('O');
  DO_states[Ord(S_CPLAY_ATK1)].tics := 12;
  DO_states[Ord(S_CPLAY_ATK1)].tics2 := 0;
  DO_states[Ord(S_CPLAY_ATK1)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_ATK1)].nextstate := Ord(S_CPLAY);
  DO_states[Ord(S_CPLAY_ATK1)].misc1 := 0;
  DO_states[Ord(S_CPLAY_ATK1)].misc2 := 0;
  DO_states[Ord(S_CPLAY_ATK1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_ATK2
  DO_states[Ord(S_CPLAY_ATK2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_ATK2)].frame := spriteframe('P') + FF_FULLBRIGHT;
  DO_states[Ord(S_CPLAY_ATK2)].tics := 6;
  DO_states[Ord(S_CPLAY_ATK2)].tics2 := 0;
  DO_states[Ord(S_CPLAY_ATK2)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_ATK2)].nextstate := Ord(S_CPLAY_ATK1);
  DO_states[Ord(S_CPLAY_ATK2)].misc1 := 0;
  DO_states[Ord(S_CPLAY_ATK2)].misc2 := 0;
  DO_states[Ord(S_CPLAY_ATK2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_PAIN
  DO_states[Ord(S_CPLAY_PAIN)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_PAIN)].frame := spriteframe('E');
  DO_states[Ord(S_CPLAY_PAIN)].tics := 4;
  DO_states[Ord(S_CPLAY_PAIN)].tics2 := 0;
  DO_states[Ord(S_CPLAY_PAIN)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_PAIN)].nextstate := Ord(S_CPLAY_PAIN2);
  DO_states[Ord(S_CPLAY_PAIN)].misc1 := 0;
  DO_states[Ord(S_CPLAY_PAIN)].misc2 := 0;
  DO_states[Ord(S_CPLAY_PAIN)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_PAIN2
  DO_states[Ord(S_CPLAY_PAIN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_PAIN2)].frame := spriteframe('F');
  DO_states[Ord(S_CPLAY_PAIN2)].tics := 4;
  DO_states[Ord(S_CPLAY_PAIN2)].tics2 := 0;
  DO_states[Ord(S_CPLAY_PAIN2)].action.acp1 := @A_Pain;
  DO_states[Ord(S_CPLAY_PAIN2)].nextstate := Ord(S_CPLAY);
  DO_states[Ord(S_CPLAY_PAIN2)].misc1 := 0;
  DO_states[Ord(S_CPLAY_PAIN2)].misc2 := 0;
  DO_states[Ord(S_CPLAY_PAIN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE1
  DO_states[Ord(S_CPLAY_DIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE1)].frame := spriteframe('V');
  DO_states[Ord(S_CPLAY_DIE1)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE1)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE1)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_DIE1)].nextstate := Ord(S_CPLAY_DIE2);
  DO_states[Ord(S_CPLAY_DIE1)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE1)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE2
  DO_states[Ord(S_CPLAY_DIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE2)].frame := spriteframe('V');
  DO_states[Ord(S_CPLAY_DIE2)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE2)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE2)].action.acp1 := @A_PlayerScream;
  DO_states[Ord(S_CPLAY_DIE2)].nextstate := Ord(S_CPLAY_DIE3);
  DO_states[Ord(S_CPLAY_DIE2)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE2)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE3
  DO_states[Ord(S_CPLAY_DIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE3)].frame := spriteframe('W');
  DO_states[Ord(S_CPLAY_DIE3)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE3)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_CPLAY_DIE3)].nextstate := Ord(S_CPLAY_DIE4);
  DO_states[Ord(S_CPLAY_DIE3)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE3)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE4
  DO_states[Ord(S_CPLAY_DIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE4)].frame := spriteframe('X');
  DO_states[Ord(S_CPLAY_DIE4)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE4)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE4)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_DIE4)].nextstate := Ord(S_CPLAY_DIE5);
  DO_states[Ord(S_CPLAY_DIE4)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE4)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE5
  DO_states[Ord(S_CPLAY_DIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE5)].frame := spriteframe('X');
  DO_states[Ord(S_CPLAY_DIE5)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE5)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE5)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_DIE5)].nextstate := Ord(S_CPLAY_DIE6);
  DO_states[Ord(S_CPLAY_DIE5)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE5)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE6
  DO_states[Ord(S_CPLAY_DIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE6)].frame := spriteframe('X');
  DO_states[Ord(S_CPLAY_DIE6)].tics := 10;
  DO_states[Ord(S_CPLAY_DIE6)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE6)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_DIE6)].nextstate := Ord(S_CPLAY_DIE7);
  DO_states[Ord(S_CPLAY_DIE6)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE6)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_DIE7
  DO_states[Ord(S_CPLAY_DIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_DIE7)].frame := spriteframe('X');
  DO_states[Ord(S_CPLAY_DIE7)].tics := -1;
  DO_states[Ord(S_CPLAY_DIE7)].tics2 := 0;
  DO_states[Ord(S_CPLAY_DIE7)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_DIE7)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_CPLAY_DIE7)].misc1 := 0;
  DO_states[Ord(S_CPLAY_DIE7)].misc2 := 0;
  DO_states[Ord(S_CPLAY_DIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE1
  DO_states[Ord(S_CPLAY_XDIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE1)].frame := spriteframe('Z');
  DO_states[Ord(S_CPLAY_XDIE1)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE1)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE1)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE1)].nextstate := Ord(S_CPLAY_XDIE2);
  DO_states[Ord(S_CPLAY_XDIE1)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE1)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE2
  DO_states[Ord(S_CPLAY_XDIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE2)].frame := spriteframe('Z');
  DO_states[Ord(S_CPLAY_XDIE2)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE2)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE2)].action.acp1 := @A_XScream;
  DO_states[Ord(S_CPLAY_XDIE2)].nextstate := Ord(S_CPLAY_XDIE3);
  DO_states[Ord(S_CPLAY_XDIE2)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE2)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE3
  DO_states[Ord(S_CPLAY_XDIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE3)].frame := spriteframe('[');
  DO_states[Ord(S_CPLAY_XDIE3)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE3)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_CPLAY_XDIE3)].nextstate := Ord(S_CPLAY_XDIE4);
  DO_states[Ord(S_CPLAY_XDIE3)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE3)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE4
  DO_states[Ord(S_CPLAY_XDIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE4)].frame := spriteframe(']');
  DO_states[Ord(S_CPLAY_XDIE4)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE4)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE4)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE4)].nextstate := Ord(S_CPLAY_XDIE5);
  DO_states[Ord(S_CPLAY_XDIE4)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE4)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE5
  DO_states[Ord(S_CPLAY_XDIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE5)].frame := spriteframe('\');
  DO_states[Ord(S_CPLAY_XDIE5)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE5)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE5)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE5)].nextstate := Ord(S_CPLAY_XDIE6);
  DO_states[Ord(S_CPLAY_XDIE5)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE5)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE6
  DO_states[Ord(S_CPLAY_XDIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE6)].frame := spriteframe('\');
  DO_states[Ord(S_CPLAY_XDIE6)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE6)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE6)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE6)].nextstate := Ord(S_CPLAY_XDIE7);
  DO_states[Ord(S_CPLAY_XDIE6)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE6)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE7
  DO_states[Ord(S_CPLAY_XDIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE7)].frame := spriteframe('\');
  DO_states[Ord(S_CPLAY_XDIE7)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE7)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE7)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE7)].nextstate := Ord(S_CPLAY_XDIE8);
  DO_states[Ord(S_CPLAY_XDIE7)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE7)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE8
  DO_states[Ord(S_CPLAY_XDIE8)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE8)].frame := spriteframe('\');
  DO_states[Ord(S_CPLAY_XDIE8)].tics := 5;
  DO_states[Ord(S_CPLAY_XDIE8)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE8)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE8)].nextstate := Ord(S_CPLAY_XDIE9);
  DO_states[Ord(S_CPLAY_XDIE8)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE8)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE8)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_CPLAY_XDIE9
  DO_states[Ord(S_CPLAY_XDIE9)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_CPLAY_XDIE9)].frame := spriteframe('\');
  DO_states[Ord(S_CPLAY_XDIE9)].tics := -1;
  DO_states[Ord(S_CPLAY_XDIE9)].tics2 := 0;
  DO_states[Ord(S_CPLAY_XDIE9)].action.acp1 := nil;
  DO_states[Ord(S_CPLAY_XDIE9)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_CPLAY_XDIE9)].misc1 := 0;
  DO_states[Ord(S_CPLAY_XDIE9)].misc2 := 0;
  DO_states[Ord(S_CPLAY_XDIE9)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY
  DO_states[Ord(S_FPLAY)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY)].frame := spriteframe('L');
  DO_states[Ord(S_FPLAY)].tics := -1;
  DO_states[Ord(S_FPLAY)].tics2 := 0;
  DO_states[Ord(S_FPLAY)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_FPLAY)].misc1 := 0;
  DO_states[Ord(S_FPLAY)].misc2 := 0;
  DO_states[Ord(S_FPLAY)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_RUN1
  DO_states[Ord(S_FPLAY_RUN1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_RUN1)].frame := spriteframe('I');
  DO_states[Ord(S_FPLAY_RUN1)].tics := 4;
  DO_states[Ord(S_FPLAY_RUN1)].tics2 := 0;
  DO_states[Ord(S_FPLAY_RUN1)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_RUN1)].nextstate := Ord(S_FPLAY_RUN2);
  DO_states[Ord(S_FPLAY_RUN1)].misc1 := 0;
  DO_states[Ord(S_FPLAY_RUN1)].misc2 := 0;
  DO_states[Ord(S_FPLAY_RUN1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_RUN2
  DO_states[Ord(S_FPLAY_RUN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_RUN2)].frame := spriteframe('J');
  DO_states[Ord(S_FPLAY_RUN2)].tics := 4;
  DO_states[Ord(S_FPLAY_RUN2)].tics2 := 0;
  DO_states[Ord(S_FPLAY_RUN2)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_RUN2)].nextstate := Ord(S_FPLAY_RUN3);
  DO_states[Ord(S_FPLAY_RUN2)].misc1 := 0;
  DO_states[Ord(S_FPLAY_RUN2)].misc2 := 0;
  DO_states[Ord(S_FPLAY_RUN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_RUN3
  DO_states[Ord(S_FPLAY_RUN3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_RUN3)].frame := spriteframe('K');
  DO_states[Ord(S_FPLAY_RUN3)].tics := 4;
  DO_states[Ord(S_FPLAY_RUN3)].tics2 := 0;
  DO_states[Ord(S_FPLAY_RUN3)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_RUN3)].nextstate := Ord(S_FPLAY_RUN4);
  DO_states[Ord(S_FPLAY_RUN3)].misc1 := 0;
  DO_states[Ord(S_FPLAY_RUN3)].misc2 := 0;
  DO_states[Ord(S_FPLAY_RUN3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_RUN4
  DO_states[Ord(S_FPLAY_RUN4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_RUN4)].frame := spriteframe('L');
  DO_states[Ord(S_FPLAY_RUN4)].tics := 4;
  DO_states[Ord(S_FPLAY_RUN4)].tics2 := 0;
  DO_states[Ord(S_FPLAY_RUN4)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_RUN4)].nextstate := Ord(S_FPLAY_RUN1);
  DO_states[Ord(S_FPLAY_RUN4)].misc1 := 0;
  DO_states[Ord(S_FPLAY_RUN4)].misc2 := 0;
  DO_states[Ord(S_FPLAY_RUN4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_ATK1
  DO_states[Ord(S_FPLAY_ATK1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_ATK1)].frame := spriteframe('Q');
  DO_states[Ord(S_FPLAY_ATK1)].tics := 12;
  DO_states[Ord(S_FPLAY_ATK1)].tics2 := 0;
  DO_states[Ord(S_FPLAY_ATK1)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_ATK1)].nextstate := Ord(S_FPLAY);
  DO_states[Ord(S_FPLAY_ATK1)].misc1 := 0;
  DO_states[Ord(S_FPLAY_ATK1)].misc2 := 0;
  DO_states[Ord(S_FPLAY_ATK1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_ATK2
  DO_states[Ord(S_FPLAY_ATK2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_ATK2)].frame := spriteframe('R') + FF_FULLBRIGHT;
  DO_states[Ord(S_FPLAY_ATK2)].tics := 6;
  DO_states[Ord(S_FPLAY_ATK2)].tics2 := 0;
  DO_states[Ord(S_FPLAY_ATK2)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_ATK2)].nextstate := Ord(S_FPLAY_ATK1);
  DO_states[Ord(S_FPLAY_ATK2)].misc1 := 0;
  DO_states[Ord(S_FPLAY_ATK2)].misc2 := 0;
  DO_states[Ord(S_FPLAY_ATK2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_PAIN
  DO_states[Ord(S_FPLAY_PAIN)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_PAIN)].frame := spriteframe('S');
  DO_states[Ord(S_FPLAY_PAIN)].tics := 4;
  DO_states[Ord(S_FPLAY_PAIN)].tics2 := 0;
  DO_states[Ord(S_FPLAY_PAIN)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_PAIN)].nextstate := Ord(S_FPLAY_PAIN2);
  DO_states[Ord(S_FPLAY_PAIN)].misc1 := 0;
  DO_states[Ord(S_FPLAY_PAIN)].misc2 := 0;
  DO_states[Ord(S_FPLAY_PAIN)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_PAIN2
  DO_states[Ord(S_FPLAY_PAIN2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_PAIN2)].frame := spriteframe('S');
  DO_states[Ord(S_FPLAY_PAIN2)].tics := 4;
  DO_states[Ord(S_FPLAY_PAIN2)].tics2 := 0;
  DO_states[Ord(S_FPLAY_PAIN2)].action.acp1 := @A_Pain;
  DO_states[Ord(S_FPLAY_PAIN2)].nextstate := Ord(S_FPLAY);
  DO_states[Ord(S_FPLAY_PAIN2)].misc1 := 0;
  DO_states[Ord(S_FPLAY_PAIN2)].misc2 := 0;
  DO_states[Ord(S_FPLAY_PAIN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE1
  DO_states[Ord(S_FPLAY_DIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE1)].frame := spriteframe('U');
  DO_states[Ord(S_FPLAY_DIE1)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE1)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE1)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_DIE1)].nextstate := Ord(S_FPLAY_DIE2);
  DO_states[Ord(S_FPLAY_DIE1)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE1)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE2
  DO_states[Ord(S_FPLAY_DIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE2)].frame := spriteframe('V');
  DO_states[Ord(S_FPLAY_DIE2)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE2)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE2)].action.acp1 := @A_PlayerScream;
  DO_states[Ord(S_FPLAY_DIE2)].nextstate := Ord(S_FPLAY_DIE3);
  DO_states[Ord(S_FPLAY_DIE2)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE2)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE3
  DO_states[Ord(S_FPLAY_DIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE3)].frame := spriteframe('W');
  DO_states[Ord(S_FPLAY_DIE3)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE3)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_FPLAY_DIE3)].nextstate := Ord(S_FPLAY_DIE4);
  DO_states[Ord(S_FPLAY_DIE3)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE3)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE4
  DO_states[Ord(S_FPLAY_DIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE4)].frame := spriteframe('X');
  DO_states[Ord(S_FPLAY_DIE4)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE4)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE4)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_DIE4)].nextstate := Ord(S_FPLAY_DIE5);
  DO_states[Ord(S_FPLAY_DIE4)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE4)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE5
  DO_states[Ord(S_FPLAY_DIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE5)].frame := spriteframe('X');
  DO_states[Ord(S_FPLAY_DIE5)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE5)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE5)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_DIE5)].nextstate := Ord(S_FPLAY_DIE6);
  DO_states[Ord(S_FPLAY_DIE5)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE5)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE6
  DO_states[Ord(S_FPLAY_DIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE6)].frame := spriteframe('X');
  DO_states[Ord(S_FPLAY_DIE6)].tics := 10;
  DO_states[Ord(S_FPLAY_DIE6)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE6)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_DIE6)].nextstate := Ord(S_FPLAY_DIE7);
  DO_states[Ord(S_FPLAY_DIE6)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE6)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_DIE7
  DO_states[Ord(S_FPLAY_DIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_DIE7)].frame := spriteframe('X');
  DO_states[Ord(S_FPLAY_DIE7)].tics := -1;
  DO_states[Ord(S_FPLAY_DIE7)].tics2 := 0;
  DO_states[Ord(S_FPLAY_DIE7)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_DIE7)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_FPLAY_DIE7)].misc1 := 0;
  DO_states[Ord(S_FPLAY_DIE7)].misc2 := 0;
  DO_states[Ord(S_FPLAY_DIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE1
  DO_states[Ord(S_FPLAY_XDIE1)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE1)].frame := spriteframe('Y');
  DO_states[Ord(S_FPLAY_XDIE1)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE1)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE1)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE1)].nextstate := Ord(S_FPLAY_XDIE2);
  DO_states[Ord(S_FPLAY_XDIE1)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE1)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE2
  DO_states[Ord(S_FPLAY_XDIE2)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE2)].frame := spriteframe('Z');
  DO_states[Ord(S_FPLAY_XDIE2)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE2)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE2)].action.acp1 := @A_XScream;
  DO_states[Ord(S_FPLAY_XDIE2)].nextstate := Ord(S_FPLAY_XDIE3);
  DO_states[Ord(S_FPLAY_XDIE2)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE2)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE3
  DO_states[Ord(S_FPLAY_XDIE3)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE3)].frame := spriteframe('[');
  DO_states[Ord(S_FPLAY_XDIE3)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE3)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE3)].action.acp1 := @A_Fall;
  DO_states[Ord(S_FPLAY_XDIE3)].nextstate := Ord(S_FPLAY_XDIE4);
  DO_states[Ord(S_FPLAY_XDIE3)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE3)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE4
  DO_states[Ord(S_FPLAY_XDIE4)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE4)].frame := spriteframe(']');
  DO_states[Ord(S_FPLAY_XDIE4)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE4)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE4)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE4)].nextstate := Ord(S_FPLAY_XDIE5);
  DO_states[Ord(S_FPLAY_XDIE4)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE4)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE5
  DO_states[Ord(S_FPLAY_XDIE5)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE5)].frame := spriteframe('\');
  DO_states[Ord(S_FPLAY_XDIE5)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE5)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE5)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE5)].nextstate := Ord(S_FPLAY_XDIE6);
  DO_states[Ord(S_FPLAY_XDIE5)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE5)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE6
  DO_states[Ord(S_FPLAY_XDIE6)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE6)].frame := spriteframe('\');
  DO_states[Ord(S_FPLAY_XDIE6)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE6)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE6)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE6)].nextstate := Ord(S_FPLAY_XDIE7);
  DO_states[Ord(S_FPLAY_XDIE6)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE6)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE7
  DO_states[Ord(S_FPLAY_XDIE7)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE7)].frame := spriteframe('\');
  DO_states[Ord(S_FPLAY_XDIE7)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE7)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE7)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE7)].nextstate := Ord(S_FPLAY_XDIE8);
  DO_states[Ord(S_FPLAY_XDIE7)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE7)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE8
  DO_states[Ord(S_FPLAY_XDIE8)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE8)].frame := spriteframe('\');
  DO_states[Ord(S_FPLAY_XDIE8)].tics := 5;
  DO_states[Ord(S_FPLAY_XDIE8)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE8)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE8)].nextstate := Ord(S_FPLAY_XDIE9);
  DO_states[Ord(S_FPLAY_XDIE8)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE8)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE8)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_FPLAY_XDIE9
  DO_states[Ord(S_FPLAY_XDIE9)].sprite := Ord(SPR_ROLE);
  DO_states[Ord(S_FPLAY_XDIE9)].frame := spriteframe('\');
  DO_states[Ord(S_FPLAY_XDIE9)].tics := -1;
  DO_states[Ord(S_FPLAY_XDIE9)].tics2 := 0;
  DO_states[Ord(S_FPLAY_XDIE9)].action.acp1 := nil;
  DO_states[Ord(S_FPLAY_XDIE9)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_FPLAY_XDIE9)].misc1 := 0;
  DO_states[Ord(S_FPLAY_XDIE9)].misc2 := 0;
  DO_states[Ord(S_FPLAY_XDIE9)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_SMOKE1
  DO_states[Ord(S_SMOKE1)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_SMOKE1)].frame := 1;
  DO_states[Ord(S_SMOKE1)].tics := 4;
  DO_states[Ord(S_SMOKE1)].tics2 := 0;
  DO_states[Ord(S_SMOKE1)].action.acp1 := nil;
  DO_states[Ord(S_SMOKE1)].nextstate := Ord(S_SMOKE2);
  DO_states[Ord(S_SMOKE1)].misc1 := 0;
  DO_states[Ord(S_SMOKE1)].misc2 := 0;
  DO_states[Ord(S_SMOKE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_SMOKE2
  DO_states[Ord(S_SMOKE2)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_SMOKE2)].frame := 2;
  DO_states[Ord(S_SMOKE2)].tics := 4;
  DO_states[Ord(S_SMOKE2)].tics2 := 0;
  DO_states[Ord(S_SMOKE2)].action.acp1 := nil;
  DO_states[Ord(S_SMOKE2)].nextstate := Ord(S_SMOKE3);
  DO_states[Ord(S_SMOKE2)].misc1 := 0;
  DO_states[Ord(S_SMOKE2)].misc2 := 0;
  DO_states[Ord(S_SMOKE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_SMOKE3
  DO_states[Ord(S_SMOKE3)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_SMOKE3)].frame := 1;
  DO_states[Ord(S_SMOKE3)].tics := 4;
  DO_states[Ord(S_SMOKE3)].tics2 := 0;
  DO_states[Ord(S_SMOKE3)].action.acp1 := nil;
  DO_states[Ord(S_SMOKE3)].nextstate := Ord(S_SMOKE4);
  DO_states[Ord(S_SMOKE3)].misc1 := 0;
  DO_states[Ord(S_SMOKE3)].misc2 := 0;
  DO_states[Ord(S_SMOKE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_SMOKE4
  DO_states[Ord(S_SMOKE4)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_SMOKE4)].frame := 2;
  DO_states[Ord(S_SMOKE4)].tics := 4;
  DO_states[Ord(S_SMOKE4)].tics2 := 0;
  DO_states[Ord(S_SMOKE4)].action.acp1 := nil;
  DO_states[Ord(S_SMOKE4)].nextstate := Ord(S_SMOKE5);
  DO_states[Ord(S_SMOKE4)].misc1 := 0;
  DO_states[Ord(S_SMOKE4)].misc2 := 0;
  DO_states[Ord(S_SMOKE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_SMOKE5
  DO_states[Ord(S_SMOKE5)].sprite := Ord(SPR_PUFF);
  DO_states[Ord(S_SMOKE5)].frame := 3;
  DO_states[Ord(S_SMOKE5)].tics := 4;
  DO_states[Ord(S_SMOKE5)].tics2 := 0;
  DO_states[Ord(S_SMOKE5)].action.acp1 := nil;
  DO_states[Ord(S_SMOKE5)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_SMOKE5)].misc1 := 0;
  DO_states[Ord(S_SMOKE5)].misc2 := 0;
  DO_states[Ord(S_SMOKE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_GIBS
  DO_states[Ord(S_GIBS)].sprite := Ord(SPR_POL5);
  DO_states[Ord(S_GIBS)].frame := 0;
  DO_states[Ord(S_GIBS)].tics := -1;
  DO_states[Ord(S_GIBS)].tics2 := 0;
  DO_states[Ord(S_GIBS)].action.acp1 := nil;
  DO_states[Ord(S_GIBS)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_GIBS)].misc1 := 0;
  DO_states[Ord(S_GIBS)].misc2 := 0;
  DO_states[Ord(S_GIBS)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_TNT1
  DO_states[Ord(S_TNT1)].sprite := Ord(SPR_TNT1);
  DO_states[Ord(S_TNT1)].frame := 0;
  DO_states[Ord(S_TNT1)].tics := -1;
  DO_states[Ord(S_TNT1)].tics2 := 0;
  DO_states[Ord(S_TNT1)].action.acp1 := nil;
  DO_states[Ord(S_TNT1)].nextstate := Ord(S_TNT1);
  DO_states[Ord(S_TNT1)].misc1 := 0;
  DO_states[Ord(S_TNT1)].misc2 := 0;
  DO_states[Ord(S_TNT1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_STND
  DO_states[Ord(S_DOGS_STND)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_STND)].frame := 0;
  DO_states[Ord(S_DOGS_STND)].tics := 10;
  DO_states[Ord(S_DOGS_STND)].tics2 := 0;
  DO_states[Ord(S_DOGS_STND)].action.acp1 := @A_Look;
  DO_states[Ord(S_DOGS_STND)].nextstate := Ord(S_DOGS_STND2);
  DO_states[Ord(S_DOGS_STND)].misc1 := 0;
  DO_states[Ord(S_DOGS_STND)].misc2 := 0;
  DO_states[Ord(S_DOGS_STND)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_STND2
  DO_states[Ord(S_DOGS_STND2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_STND2)].frame := 1;
  DO_states[Ord(S_DOGS_STND2)].tics := 10;
  DO_states[Ord(S_DOGS_STND2)].tics2 := 0;
  DO_states[Ord(S_DOGS_STND2)].action.acp1 := @A_Look;
  DO_states[Ord(S_DOGS_STND2)].nextstate := Ord(S_DOGS_STND);
  DO_states[Ord(S_DOGS_STND2)].misc1 := 0;
  DO_states[Ord(S_DOGS_STND2)].misc2 := 0;
  DO_states[Ord(S_DOGS_STND2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN1
  DO_states[Ord(S_DOGS_RUN1)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN1)].frame := 0;
  DO_states[Ord(S_DOGS_RUN1)].tics := 2;
  DO_states[Ord(S_DOGS_RUN1)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN1)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN1)].nextstate := Ord(S_DOGS_RUN2);
  DO_states[Ord(S_DOGS_RUN1)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN1)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN2
  DO_states[Ord(S_DOGS_RUN2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN2)].frame := 0;
  DO_states[Ord(S_DOGS_RUN2)].tics := 2;
  DO_states[Ord(S_DOGS_RUN2)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN2)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN2)].nextstate := Ord(S_DOGS_RUN3);
  DO_states[Ord(S_DOGS_RUN2)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN2)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN3
  DO_states[Ord(S_DOGS_RUN3)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN3)].frame := 1;
  DO_states[Ord(S_DOGS_RUN3)].tics := 2;
  DO_states[Ord(S_DOGS_RUN3)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN3)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN3)].nextstate := Ord(S_DOGS_RUN4);
  DO_states[Ord(S_DOGS_RUN3)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN3)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN4
  DO_states[Ord(S_DOGS_RUN4)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN4)].frame := 1;
  DO_states[Ord(S_DOGS_RUN4)].tics := 2;
  DO_states[Ord(S_DOGS_RUN4)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN4)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN4)].nextstate := Ord(S_DOGS_RUN5);
  DO_states[Ord(S_DOGS_RUN4)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN4)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN5
  DO_states[Ord(S_DOGS_RUN5)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN5)].frame := 2;
  DO_states[Ord(S_DOGS_RUN5)].tics := 2;
  DO_states[Ord(S_DOGS_RUN5)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN5)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN5)].nextstate := Ord(S_DOGS_RUN6);
  DO_states[Ord(S_DOGS_RUN5)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN5)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN6
  DO_states[Ord(S_DOGS_RUN6)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN6)].frame := 2;
  DO_states[Ord(S_DOGS_RUN6)].tics := 2;
  DO_states[Ord(S_DOGS_RUN6)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN6)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN6)].nextstate := Ord(S_DOGS_RUN7);
  DO_states[Ord(S_DOGS_RUN6)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN6)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN7
  DO_states[Ord(S_DOGS_RUN7)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN7)].frame := 3;
  DO_states[Ord(S_DOGS_RUN7)].tics := 2;
  DO_states[Ord(S_DOGS_RUN7)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN7)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN7)].nextstate := Ord(S_DOGS_RUN8);
  DO_states[Ord(S_DOGS_RUN7)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN7)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN7)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RUN8
  DO_states[Ord(S_DOGS_RUN8)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RUN8)].frame := 3;
  DO_states[Ord(S_DOGS_RUN8)].tics := 2;
  DO_states[Ord(S_DOGS_RUN8)].tics2 := 0;
  DO_states[Ord(S_DOGS_RUN8)].action.acp1 := @A_Chase;
  DO_states[Ord(S_DOGS_RUN8)].nextstate := Ord(S_DOGS_RUN1);
  DO_states[Ord(S_DOGS_RUN8)].misc1 := 0;
  DO_states[Ord(S_DOGS_RUN8)].misc2 := 0;
  DO_states[Ord(S_DOGS_RUN8)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_ATK1
  DO_states[Ord(S_DOGS_ATK1)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_ATK1)].frame := 4;
  DO_states[Ord(S_DOGS_ATK1)].tics := 8;
  DO_states[Ord(S_DOGS_ATK1)].tics2 := 0;
  DO_states[Ord(S_DOGS_ATK1)].action.acp1 := @A_FaceTarget;
  DO_states[Ord(S_DOGS_ATK1)].nextstate := Ord(S_DOGS_ATK2);
  DO_states[Ord(S_DOGS_ATK1)].misc1 := 0;
  DO_states[Ord(S_DOGS_ATK1)].misc2 := 0;
  DO_states[Ord(S_DOGS_ATK1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_ATK2
  DO_states[Ord(S_DOGS_ATK2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_ATK2)].frame := 5;
  DO_states[Ord(S_DOGS_ATK2)].tics := 8;
  DO_states[Ord(S_DOGS_ATK2)].tics2 := 0;
  DO_states[Ord(S_DOGS_ATK2)].action.acp1 := @A_FaceTarget;
  DO_states[Ord(S_DOGS_ATK2)].nextstate := Ord(S_DOGS_ATK3);
  DO_states[Ord(S_DOGS_ATK2)].misc1 := 0;
  DO_states[Ord(S_DOGS_ATK2)].misc2 := 0;
  DO_states[Ord(S_DOGS_ATK2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_ATK3
  DO_states[Ord(S_DOGS_ATK3)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_ATK3)].frame := 6;
  DO_states[Ord(S_DOGS_ATK3)].tics := 8;
  DO_states[Ord(S_DOGS_ATK3)].tics2 := 0;
  DO_states[Ord(S_DOGS_ATK3)].action.acp1 := @A_SargAttack;
  DO_states[Ord(S_DOGS_ATK3)].nextstate := Ord(S_DOGS_RUN1);
  DO_states[Ord(S_DOGS_ATK3)].misc1 := 0;
  DO_states[Ord(S_DOGS_ATK3)].misc2 := 0;
  DO_states[Ord(S_DOGS_ATK3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_PAIN
  DO_states[Ord(S_DOGS_PAIN)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_PAIN)].frame := 7;
  DO_states[Ord(S_DOGS_PAIN)].tics := 2;
  DO_states[Ord(S_DOGS_PAIN)].tics2 := 0;
  DO_states[Ord(S_DOGS_PAIN)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_PAIN)].nextstate := Ord(S_DOGS_PAIN2);
  DO_states[Ord(S_DOGS_PAIN)].misc1 := 0;
  DO_states[Ord(S_DOGS_PAIN)].misc2 := 0;
  DO_states[Ord(S_DOGS_PAIN)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_PAIN2
  DO_states[Ord(S_DOGS_PAIN2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_PAIN2)].frame := 7;
  DO_states[Ord(S_DOGS_PAIN2)].tics := 2;
  DO_states[Ord(S_DOGS_PAIN2)].tics2 := 0;
  DO_states[Ord(S_DOGS_PAIN2)].action.acp1 := @A_Pain;
  DO_states[Ord(S_DOGS_PAIN2)].nextstate := Ord(S_DOGS_RUN1);
  DO_states[Ord(S_DOGS_PAIN2)].misc1 := 0;
  DO_states[Ord(S_DOGS_PAIN2)].misc2 := 0;
  DO_states[Ord(S_DOGS_PAIN2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE1
  DO_states[Ord(S_DOGS_DIE1)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE1)].frame := 8;
  DO_states[Ord(S_DOGS_DIE1)].tics := 8;
  DO_states[Ord(S_DOGS_DIE1)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE1)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_DIE1)].nextstate := Ord(S_DOGS_DIE2);
  DO_states[Ord(S_DOGS_DIE1)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE1)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE2
  DO_states[Ord(S_DOGS_DIE2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE2)].frame := 9;
  DO_states[Ord(S_DOGS_DIE2)].tics := 8;
  DO_states[Ord(S_DOGS_DIE2)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE2)].action.acp1 := @A_Scream;
  DO_states[Ord(S_DOGS_DIE2)].nextstate := Ord(S_DOGS_DIE3);
  DO_states[Ord(S_DOGS_DIE2)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE2)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE3
  DO_states[Ord(S_DOGS_DIE3)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE3)].frame := 10;
  DO_states[Ord(S_DOGS_DIE3)].tics := 4;
  DO_states[Ord(S_DOGS_DIE3)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE3)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_DIE3)].nextstate := Ord(S_DOGS_DIE4);
  DO_states[Ord(S_DOGS_DIE3)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE3)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE4
  DO_states[Ord(S_DOGS_DIE4)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE4)].frame := 11;
  DO_states[Ord(S_DOGS_DIE4)].tics := 4;
  DO_states[Ord(S_DOGS_DIE4)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE4)].action.acp1 := @A_Fall;
  DO_states[Ord(S_DOGS_DIE4)].nextstate := Ord(S_DOGS_DIE5);
  DO_states[Ord(S_DOGS_DIE4)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE4)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE5
  DO_states[Ord(S_DOGS_DIE5)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE5)].frame := 12;
  DO_states[Ord(S_DOGS_DIE5)].tics := 4;
  DO_states[Ord(S_DOGS_DIE5)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE5)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_DIE5)].nextstate := Ord(S_DOGS_DIE6);
  DO_states[Ord(S_DOGS_DIE5)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE5)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_DIE6
  DO_states[Ord(S_DOGS_DIE6)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_DIE6)].frame := 13;
  DO_states[Ord(S_DOGS_DIE6)].tics := -1;
  DO_states[Ord(S_DOGS_DIE6)].tics2 := 0;
  DO_states[Ord(S_DOGS_DIE6)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_DIE6)].nextstate := Ord(S_NULL);
  DO_states[Ord(S_DOGS_DIE6)].misc1 := 0;
  DO_states[Ord(S_DOGS_DIE6)].misc2 := 0;
  DO_states[Ord(S_DOGS_DIE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE1
  DO_states[Ord(S_DOGS_RAISE1)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE1)].frame := 13;
  DO_states[Ord(S_DOGS_RAISE1)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE1)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE1)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE1)].nextstate := Ord(S_DOGS_RAISE2);
  DO_states[Ord(S_DOGS_RAISE1)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE1)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE1)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE2
  DO_states[Ord(S_DOGS_RAISE2)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE2)].frame := 12;
  DO_states[Ord(S_DOGS_RAISE2)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE2)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE2)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE2)].nextstate := Ord(S_DOGS_RAISE3);
  DO_states[Ord(S_DOGS_RAISE2)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE2)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE2)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE3
  DO_states[Ord(S_DOGS_RAISE3)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE3)].frame := 11;
  DO_states[Ord(S_DOGS_RAISE3)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE3)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE3)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE3)].nextstate := Ord(S_DOGS_RAISE4);
  DO_states[Ord(S_DOGS_RAISE3)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE3)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE3)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE4
  DO_states[Ord(S_DOGS_RAISE4)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE4)].frame := 10;
  DO_states[Ord(S_DOGS_RAISE4)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE4)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE4)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE4)].nextstate := Ord(S_DOGS_RAISE5);
  DO_states[Ord(S_DOGS_RAISE4)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE4)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE4)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE5
  DO_states[Ord(S_DOGS_RAISE5)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE5)].frame := 9;
  DO_states[Ord(S_DOGS_RAISE5)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE5)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE5)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE5)].nextstate := Ord(S_DOGS_RAISE6);
  DO_states[Ord(S_DOGS_RAISE5)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE5)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE5)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_DOGS_RAISE6
  DO_states[Ord(S_DOGS_RAISE6)].sprite := Ord(SPR_DOGS);
  DO_states[Ord(S_DOGS_RAISE6)].frame := 8;
  DO_states[Ord(S_DOGS_RAISE6)].tics := 5;
  DO_states[Ord(S_DOGS_RAISE6)].tics2 := 0;
  DO_states[Ord(S_DOGS_RAISE6)].action.acp1 := nil;
  DO_states[Ord(S_DOGS_RAISE6)].nextstate := Ord(S_DOGS_RUN1);
  DO_states[Ord(S_DOGS_RAISE6)].misc1 := 0;
  DO_states[Ord(S_DOGS_RAISE6)].misc2 := 0;
  DO_states[Ord(S_DOGS_RAISE6)].flags_ex := 0;

  ////////////////////////////////////////////////////////////////////////////////
  // S_NONE
  DO_states[Ord(S_NONE)].sprite := Ord(SPR_TNT1);
  DO_states[Ord(S_NONE)].frame := 0;
  DO_states[Ord(S_NONE)].tics := 1;
  DO_states[Ord(S_NONE)].tics2 := 0;
  DO_states[Ord(S_NONE)].action.acp1 := nil;
  DO_states[Ord(S_NONE)].nextstate := Ord(S_TNT1);
  DO_states[Ord(S_NONE)].misc1 := 0;
  DO_states[Ord(S_NONE)].misc2 := 0;
  DO_states[Ord(S_NONE)].flags_ex := 0;

  init_buildin := true;
end;

//==============================================================================
//
// Info_Init
//
//==============================================================================
procedure Info_Init(const usethinkers: boolean);
var
  i: integer;
begin
  Info_Init_BuildIn;

  Info_InitDnLookUp;

  if states = nil then
  begin
    states := malloc(Ord(DO_NUMSTATES) * SizeOf(state_t));
    memcpy(states, @DO_states, Ord(DO_NUMSTATES) * SizeOf(state_t));
  end;

  if sprnames = nil then
  begin
    sprnames := malloc(Ord(DO_NUMSPRITES) * 4 + 4);
    for i := 0 to Ord(DO_NUMSPRITES) - 1 do
      sprnames[i] := Ord(DO_sprnames[i][1]) +
                     Ord(DO_sprnames[i][2]) shl 8 +
                     Ord(DO_sprnames[i][3]) shl 16 +
                     Ord(DO_sprnames[i][4]) shl 24;
    sprnames[Ord(DO_NUMSPRITES)] := 0;
  end;

  if mobjinfo = nil then
  begin
    mobjinfo := malloc(Ord(DO_NUMMOBJTYPES) * SizeOf(mobjinfo_t));
    memcpy(mobjinfo, @DO_mobjinfo, Ord(DO_NUMMOBJTYPES) * SizeOf(mobjinfo_t));
    for i := 0 to Ord(DO_NUMMOBJTYPES) - 1 do
      if mobjinfo[i].normalspeed <> 0 then
        mobjinfo[i].normalspeed := mobjinfo[i].speed;
  end;

  if not usethinkers then
  begin
    Info_SaveActions;
    for i := 0 to Ord(DO_NUMSTATES) - 1 do
      states[i].action.acp1 := nil;
    Info_InitExportCommands;
    exit;
  end;

  if Info_RestoreActions then
  begin
    Info_InitExportCommands;
    exit;
  end;

  // Player
  states[Ord(S_PLAY_PAIN2)].action.acp1 := @A_Pain;
  states[Ord(S_PLAY_DIE2)].action.acp1 := @A_PlayerScream;
  states[Ord(S_PLAY_DIE3)].action.acp1 := @A_Fall;
  states[Ord(S_PLAY_XDIE2)].action.acp1 := @A_XScream;
  states[Ord(S_PLAY_XDIE3)].action.acp1 := @A_Fall;
  // Player (couch)
  states[Ord(S_CPLAY_PAIN2)].action.acp1 := @A_Pain;
  states[Ord(S_CPLAY_DIE2)].action.acp1 := @A_PlayerScream;
  states[Ord(S_CPLAY_DIE3)].action.acp1 := @A_Fall;
  states[Ord(S_CPLAY_XDIE2)].action.acp1 := @A_XScream;
  states[Ord(S_CPLAY_XDIE3)].action.acp1 := @A_Fall;
  // Player (flying)
  states[Ord(S_FPLAY_PAIN2)].action.acp1 := @A_Pain;
  states[Ord(S_FPLAY_DIE2)].action.acp1 := @A_PlayerScream;
  states[Ord(S_FPLAY_DIE3)].action.acp1 := @A_Fall;
  states[Ord(S_FPLAY_XDIE2)].action.acp1 := @A_XScream;
  states[Ord(S_FPLAY_XDIE3)].action.acp1 := @A_Fall;
  // New states
  states[Ord(S_DOGS_STND)].action.acp1 := @A_Look; // S_DOGS_STND
  states[Ord(S_DOGS_STND2)].action.acp1 := @A_Look; // S_DOGS_STND2
  states[Ord(S_DOGS_RUN1)].action.acp1 := @A_Chase; // S_DOGS_RUN1
  states[Ord(S_DOGS_RUN2)].action.acp1 := @A_Chase; // S_DOGS_RUN2
  states[Ord(S_DOGS_RUN3)].action.acp1 := @A_Chase; // S_DOGS_RUN3
  states[Ord(S_DOGS_RUN4)].action.acp1 := @A_Chase; // S_DOGS_RUN4
  states[Ord(S_DOGS_RUN5)].action.acp1 := @A_Chase; // S_DOGS_RUN5
  states[Ord(S_DOGS_RUN6)].action.acp1 := @A_Chase; // S_DOGS_RUN6
  states[Ord(S_DOGS_RUN7)].action.acp1 := @A_Chase; // S_DOGS_RUN7
  states[Ord(S_DOGS_RUN8)].action.acp1 := @A_Chase; // S_DOGS_RUN8
  states[Ord(S_DOGS_ATK1)].action.acp1 := @A_FaceTarget; // S_DOGS_ATK1
  states[Ord(S_DOGS_ATK2)].action.acp1 := @A_FaceTarget; // S_DOGS_ATK2
  states[Ord(S_DOGS_ATK3)].action.acp1 := @A_SargAttack; // S_DOGS_ATK3
  states[Ord(S_DOGS_PAIN2)].action.acp1 := @A_Pain; // S_DOGS_PAIN2
  states[Ord(S_DOGS_DIE2)].action.acp1 := @A_Scream; // S_DOGS_DIE2
  states[Ord(S_DOGS_DIE4)].action.acp1 := @A_Fall; // S_DOGS_DIE4

  Info_InitExportCommands;
end;

//==============================================================================
// Info_ResolveActordefActors
//
// Must be called after parsing ACTORDEF lumps
//
//==============================================================================
procedure Info_ResolveActordefActors;
begin
  if not Info_ResolveMobjType('Green Blood', @MT_GREENBLOOD) then
    MT_GREENBLOOD := Ord(MT_BLOOD);
  if not Info_ResolveMobjType('Blue Blood', @MT_BLUEBLOOD) then
    MT_BLUEBLOOD := Ord(MT_BLOOD);
  if not Info_ResolveMobjType('SPLASH 2', @MT_SPLASHBASE) then
    MT_SPLASHBASE := Ord(MT_NONE);
  if not Info_ResolveMobjType('SPLASH', @MT_SPLASH) then
    MT_SPLASH := Ord(MT_NONE);
  if not Info_ResolveMobjType('LAVA SPLASH', @MT_LAVASPLASH) then
    MT_LAVASPLASH := Ord(MT_NONE);
  if not Info_ResolveMobjType('LAVA SMOKE', @MT_LAVASMOKE) then
    MT_LAVASMOKE := Ord(MT_NONE);
  if not Info_ResolveMobjType('SLUDGE SPLASH', @MT_SLUDGESPLASH) then
    MT_SLUDGESPLASH := Ord(MT_NONE);
  if not Info_ResolveMobjType('SLUDGE CHUNK', @MT_SLUDGECHUNK) then
    MT_SLUDGECHUNK := Ord(MT_NONE);
  if not Info_ResolveMobjType('NUKAGE SPLASH', @MT_NUKAGESPLASH) then
    MT_NUKAGESPLASH := Ord(MT_NONE);
  if not Info_ResolveMobjType('NUKAGE CHUNK', @MT_NUKAGECHUNK) then
    MT_NUKAGECHUNK := Ord(MT_NONE);
  if not Info_ResolveMobjType('MT_BARREL', @MT_BARREL) then
    MT_BARREL := Ord(MT_NONE);
  if not Info_ResolveMobjType('MT_GREENGIBS', @MT_GREENGIBS) then
    MT_GREENGIBS := Ord(MT_NONE);
  if not Info_ResolveMobjType('MT_BLUEGIBS', @MT_BLUEGIBS) then
    MT_BLUEGIBS := Ord(MT_NONE);
end;

end.

