//------------------------------------------------------------------------------
//
//  Mars3D: A source port of the game "Mars - The Ultimate Fighter"
//
//  Copyright (C) 1997 by Engine Technology CO. LTD
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2018 by Retro Fans of Mars3D
//  Copyright (C) 2004-2022 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//------------------------------------------------------------------------------
//  Site  : https://sourceforge.net/projects/mars3d/
//------------------------------------------------------------------------------

unit libvorbis;

{$Z+}
{$H+}

interface

//==============================================================================
//
// _floor0_exportbundle
//
//==============================================================================
procedure _floor0_exportbundle; external;

//==============================================================================
//
// _floor1_encode
//
//==============================================================================
procedure _floor1_encode; external;

//==============================================================================
//
// _floor1_exportbundle
//
//==============================================================================
procedure _floor1_exportbundle; external;

//==============================================================================
//
// _floor1_fit
//
//==============================================================================
procedure _floor1_fit; external;

//==============================================================================
//
// _floor1_interpolate_fit
//
//==============================================================================
procedure _floor1_interpolate_fit; external;

//==============================================================================
//
// _mapping0_exportbundle
//
//==============================================================================
procedure _mapping0_exportbundle; external;

//==============================================================================
//
// _vorbis_bitrate_clear
//
//==============================================================================
procedure _vorbis_bitrate_clear; external;

//==============================================================================
//
// _vorbis_bitrate_init
//
//==============================================================================
procedure _vorbis_bitrate_init; external;

//==============================================================================
//
// _vorbis_block_clear
//
//==============================================================================
procedure _vorbis_block_clear; external;

//==============================================================================
//
// _vorbis_block_init
//
//==============================================================================
procedure _vorbis_block_init; external;

//==============================================================================
//
// _vorbis_book_decode
//
//==============================================================================
procedure _vorbis_book_decode; external;

//==============================================================================
//
// _vorbis_book_decodev_add
//
//==============================================================================
procedure _vorbis_book_decodev_add; external;

//==============================================================================
//
// _vorbis_book_decodev_set
//
//==============================================================================
procedure _vorbis_book_decodev_set; external;

//==============================================================================
//
// _vorbis_book_decodevs_add
//
//==============================================================================
procedure _vorbis_book_decodevs_add; external;

//==============================================================================
//
// _vorbis_book_decodevv_add
//
//==============================================================================
procedure _vorbis_book_decodevv_add; external;

//==============================================================================
//
// _vorbis_book_encode
//
//==============================================================================
procedure _vorbis_book_encode; external;

//==============================================================================
//
// _vorbis_comment_clear
//
//==============================================================================
procedure _vorbis_comment_clear; external;

//==============================================================================
//
// _vorbis_comment_init
//
//==============================================================================
procedure _vorbis_comment_init; external;

//==============================================================================
//
// _vorbis_dsp_clear
//
//==============================================================================
procedure _vorbis_dsp_clear; external;

//==============================================================================
//
// _vorbis_info_blocksize
//
//==============================================================================
procedure _vorbis_info_blocksize; external;

//==============================================================================
//
// _vorbis_info_clear
//
//==============================================================================
procedure _vorbis_info_clear; external;

//==============================================================================
//
// _vorbis_info_init
//
//==============================================================================
procedure _vorbis_info_init; external;

//==============================================================================
//
// _vorbis_packet_blocksize
//
//==============================================================================
procedure _vorbis_packet_blocksize; external;

//==============================================================================
//
// _vorbis_staticbook_pack
//
//==============================================================================
procedure _vorbis_staticbook_pack; external;

//==============================================================================
//
// _vorbis_staticbook_unpack
//
//==============================================================================
procedure _vorbis_staticbook_unpack; external;

//==============================================================================
//
// _vorbis_synthesis
//
//==============================================================================
procedure _vorbis_synthesis; external;

//==============================================================================
//
// _vorbis_synthesis_blockin
//
//==============================================================================
procedure _vorbis_synthesis_blockin; external;

//==============================================================================
//
// _vorbis_synthesis_halfrate
//
//==============================================================================
procedure _vorbis_synthesis_halfrate; external;

//==============================================================================
//
// _vorbis_synthesis_halfrate_p
//
//==============================================================================
procedure _vorbis_synthesis_halfrate_p; external;

//==============================================================================
//
// _vorbis_synthesis_headerin
//
//==============================================================================
procedure _vorbis_synthesis_headerin; external;

//==============================================================================
//
// _vorbis_synthesis_idheader
//
//==============================================================================
procedure _vorbis_synthesis_idheader; external;

//==============================================================================
//
// _vorbis_synthesis_init
//
//==============================================================================
procedure _vorbis_synthesis_init; external;

//==============================================================================
//
// _vorbis_synthesis_lapout
//
//==============================================================================
procedure _vorbis_synthesis_lapout; external;

//==============================================================================
//
// _vorbis_synthesis_pcmout
//
//==============================================================================
procedure _vorbis_synthesis_pcmout; external;

//==============================================================================
//
// _vorbis_synthesis_read
//
//==============================================================================
procedure _vorbis_synthesis_read; external;

//==============================================================================
//
// _vorbis_synthesis_restart
//
//==============================================================================
procedure _vorbis_synthesis_restart; external;

//==============================================================================
//
// _vorbis_synthesis_trackonly
//
//==============================================================================
procedure _vorbis_synthesis_trackonly; external;

//==============================================================================
//
// _vorbis_window
//
//==============================================================================
procedure _vorbis_window; external;

//==============================================================================
//
// _vorbis_analysis
//
//==============================================================================
procedure _vorbis_analysis; external;

//==============================================================================
//
// _vorbis_analysis_blockout
//
//==============================================================================
procedure _vorbis_analysis_blockout; external;

//==============================================================================
//
// _vorbis_analysis_buffer
//
//==============================================================================
procedure _vorbis_analysis_buffer; external;

//==============================================================================
//
// _vorbis_analysis_headerout
//
//==============================================================================
procedure _vorbis_analysis_headerout; external;

//==============================================================================
//
// _vorbis_analysis_init
//
//==============================================================================
procedure _vorbis_analysis_init; external;

//==============================================================================
//
// _vorbis_analysis_wrote
//
//==============================================================================
procedure _vorbis_analysis_wrote; external;

//==============================================================================
//
// _vorbis_bitrate_addblock
//
//==============================================================================
procedure _vorbis_bitrate_addblock; external;

//==============================================================================
//
// _vorbis_bitrate_flushpacket
//
//==============================================================================
procedure _vorbis_bitrate_flushpacket; external;

//==============================================================================
//
// _vorbis_comment_add_tag
//
//==============================================================================
procedure _vorbis_comment_add_tag; external;

//==============================================================================
//
// _vorbis_comment_query
//
//==============================================================================
procedure _vorbis_comment_query; external;

//==============================================================================
//
// _vorbis_encode_init_vbr
//
//==============================================================================
procedure _vorbis_encode_init_vbr; external;

//==============================================================================
//
// _vorbis_version_string
//
//==============================================================================
procedure _vorbis_version_string; external;

//==============================================================================
//
// __vorbis_block_alloc
//
//==============================================================================
procedure __vorbis_block_alloc; external;

//==============================================================================
//
// __vorbis_block_ripcord
//
//==============================================================================
procedure __vorbis_block_ripcord; external;

//==============================================================================
//
// _safe_realloc_mul_2op_
//
//==============================================================================
procedure _safe_realloc_mul_2op_; external;

//==============================================================================
//
// _safe_realloc_
//
//==============================================================================
procedure _safe_realloc_; external;

//==============================================================================
//
// _safe_malloc_
//
//==============================================================================
procedure _safe_malloc_; external;

//==============================================================================
//
// _safe_malloc_add_2op_
//
//==============================================================================
procedure _safe_malloc_add_2op_; external;

//==============================================================================
//
// _safe_realloc_add_2op_
//
//==============================================================================
procedure _safe_realloc_add_2op_; external;

//==============================================================================
//
// _safe_calloc_
//
//==============================================================================
procedure _safe_calloc_; external;

//==============================================================================
//
// _safe_malloc_add_4op_
//
//==============================================================================
procedure _safe_malloc_add_4op_; external;

//==============================================================================
//
// _safe_malloc_muladd2_
//
//==============================================================================
procedure _safe_malloc_muladd2_; external;

implementation

uses
  c_lib, libogg;

// libvorbis
{$L libvorbis\obj\alloc.obj}
{$L libvorbis\obj\analysis.obj}
{$L libvorbis\obj\bitrate.obj}
{$L libvorbis\obj\block.obj}
{$L libvorbis\obj\codebook.obj}
{$L libvorbis\obj\envelope.obj}
{$L libvorbis\obj\floor0.obj}
{$L libvorbis\obj\floor1.obj}
{$L libvorbis\obj\info.obj}
{$L libvorbis\obj\lookup.obj}
{$L libvorbis\obj\lpc.obj}
{$L libvorbis\obj\lsp.obj}
{$L libvorbis\obj\mapping0.obj}
{$L libvorbis\obj\mdct.obj}
{$L libvorbis\obj\psy.obj}
{$L libvorbis\obj\registry.obj}
{$L libvorbis\obj\res0.obj}
{$L libvorbis\obj\sharedbook.obj}
{$L libvorbis\obj\smallft.obj}
{$L libvorbis\obj\synthesis.obj}
{$L libvorbis\obj\tone.obj}
{$L libvorbis\obj\vorbisenc.obj}
{$L libvorbis\obj\vorbisfile.obj}
{$L libvorbis\obj\vorbiswindow.obj}

end.
