# Generated by generateOTTagsModule.py
# Scraped from:
# https://docs.microsoft.com/en-us/typography/opentype/spec/featurelist
# https://docs.microsoft.com/en-us/typography/opentype/spec/scripttags
# https://docs.microsoft.com/en-us/typography/opentype/spec/languagetags


__all__ = ['features', 'scripts', 'languages']


features = {
    # tag, friendly name, documentation URL
    'aalt': ('Access All Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#aalt'),
    'abvf': ('Above-base Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#abvf'),
    'abvm': ('Above-base Mark Positioning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#abvm'),
    'abvs': ('Above-base Substitutions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#abvs'),
    'afrc': ('Alternative Fractions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#afrc'),
    'akhn': ('Akhand', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#akhn'),
    'blwf': ('Below-base Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#blwf'),
    'blwm': ('Below-base Mark Positioning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#blwm'),
    'blws': ('Below-base Substitutions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#blws'),
    'calt': ('Contextual Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#calt'),
    'case': ('Case-Sensitive Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#case'),
    'ccmp': ('Glyph Composition / Decomposition', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#ccmp'),
    'cfar': ('Conjunct Form After Ro', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cfar'),
    'chws': ('Contextual Half-width Spacing', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#chws'),
    'cjct': ('Conjunct Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cjct'),
    'clig': ('Contextual Ligatures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#clig'),
    'cpct': ('Centered CJK Punctuation', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cpct'),
    'cpsp': ('Capital Spacing', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cpsp'),
    'cswh': ('Contextual Swash', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cswh'),
    'curs': ('Cursive Positioning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#curs'),
    'cv01': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv02': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv03': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv04': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv05': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv06': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv07': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv08': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv09': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv10': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv11': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv12': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv13': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv14': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv15': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv16': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv17': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv18': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv19': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv20': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv21': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv22': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv23': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv24': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv25': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv26': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv27': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv28': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv29': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv30': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv31': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv32': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv33': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv34': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv35': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv36': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv37': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv38': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv39': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv40': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv41': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv42': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv43': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv44': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv45': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv46': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv47': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv48': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv49': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv50': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv51': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv52': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv53': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv54': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv55': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv56': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv57': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv58': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv59': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv60': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv61': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv62': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv63': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv64': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv65': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv66': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv67': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv68': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv69': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv70': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv71': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv72': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv73': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv74': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv75': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv76': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv77': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv78': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv79': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv80': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv81': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv82': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv83': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv84': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv85': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv86': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv87': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv88': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv89': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv90': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv91': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv92': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv93': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv94': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv95': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv96': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv97': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv98': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'cv99': ('Character Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#cv01-cv99'),
    'c2pc': ('Petite Capitals From Capitals', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#c2pc'),
    'c2sc': ('Small Capitals From Capitals', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#c2sc'),
    'dist': ('Distances', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#dist'),
    'dlig': ('Discretionary Ligatures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#dlig'),
    'dnom': ('Denominators', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#dnom'),
    'dtls': ('Dotless Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#dtls'),
    'expt': ('Expert Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ae#expt'),
    'falt': ('Final Glyph on Line Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#falt'),
    'fin2': ('Terminal Forms #2', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#fin2'),
    'fin3': ('Terminal Forms #3', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#fin3'),
    'fina': ('Terminal Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#fina'),
    'flac': ('Flattened accent forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#flac'),
    'frac': ('Fractions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#frac'),
    'fwid': ('Full Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#fwid'),
    'half': ('Half Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#half'),
    'haln': ('Halant Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#haln'),
    'halt': ('Alternate Half Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#halt'),
    'hist': ('Historical Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hist'),
    'hkna': ('Horizontal Kana Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hkna'),
    'hlig': ('Historical Ligatures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hlig'),
    'hngl': ('Hangul', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hngl'),
    'hojo': ('Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms)', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hojo'),
    'hwid': ('Half Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#hwid'),
    'init': ('Initial Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#init'),
    'isol': ('Isolated Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#isol'),
    'ital': ('Italics', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#ital'),
    'jalt': ('Justification Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#jalt'),
    'jp78': ('JIS78 Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#jp78'),
    'jp83': ('JIS83 Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#jp83'),
    'jp90': ('JIS90 Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#jp90'),
    'jp04': ('JIS2004 Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_fj#jp04'),
    'kern': ('Kerning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#kern'),
    'lfbd': ('Left Bounds', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#lfbd'),
    'liga': ('Standard Ligatures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#liga'),
    'ljmo': ('Leading Jamo Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#ljmo'),
    'lnum': ('Lining Figures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#lnum'),
    'locl': ('Localized Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#locl'),
    'ltra': ('Left-to-right alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#ltra'),
    'ltrm': ('Left-to-right mirrored forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#ltrm'),
    'mark': ('Mark Positioning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#mark'),
    'med2': ('Medial Forms #2', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#med2'),
    'medi': ('Medial Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#medi'),
    'mgrk': ('Mathematical Greek', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#mgrk'),
    'mkmk': ('Mark to Mark Positioning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#mkmk'),
    'mset': ('Mark Positioning via Substitution', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#mset'),
    'nalt': ('Alternate Annotation Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#nalt'),
    'nlck': ('NLC Kanji Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#nlck'),
    'nukt': ('Nukta Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#nukt'),
    'numr': ('Numerators', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#numr'),
    'onum': ('Oldstyle Figures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#onum'),
    'opbd': ('Optical Bounds', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#opbd'),
    'ordn': ('Ordinals', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#ordn'),
    'ornm': ('Ornaments', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_ko#ornm'),
    'palt': ('Proportional Alternate Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#palt'),
    'pcap': ('Petite Capitals', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pcap'),
    'pkna': ('Proportional Kana', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pkna'),
    'pnum': ('Proportional Figures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pnum'),
    'pref': ('Pre-Base Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pref'),
    'pres': ('Pre-base Substitutions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pres'),
    'pstf': ('Post-base Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pstf'),
    'psts': ('Post-base Substitutions', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#psts'),
    'pwid': ('Proportional Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#pwid'),
    'qwid': ('Quarter Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#qwid'),
    'rand': ('Randomize', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rand'),
    'rclt': ('Required Contextual Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rclt'),
    'rkrf': ('Rakar Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rkrf'),
    'rlig': ('Required Ligatures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rlig'),
    'rphf': ('Reph Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rphf'),
    'rtbd': ('Right Bounds', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rtbd'),
    'rtla': ('Right-to-left alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rtla'),
    'rtlm': ('Right-to-left mirrored forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rtlm'),
    'ruby': ('Ruby Notation Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ruby'),
    'rvrn': ('Required Variation Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#rvrn'),
    'salt': ('Stylistic Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#salt'),
    'sinf': ('Scientific Inferiors', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#sinf'),
    'size': ('Optical size', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#size'),
    'smcp': ('Small Capitals', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#smcp'),
    'smpl': ('Simplified Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#smpl'),
    'ss01': ('Stylistic Set 1', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss02': ('Stylistic Set 2', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss03': ('Stylistic Set 3', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss04': ('Stylistic Set 4', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss05': ('Stylistic Set 5', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss06': ('Stylistic Set 6', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss07': ('Stylistic Set 7', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss08': ('Stylistic Set 8', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss09': ('Stylistic Set 9', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss10': ('Stylistic Set 10', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss11': ('Stylistic Set 11', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss12': ('Stylistic Set 12', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss13': ('Stylistic Set 13', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss14': ('Stylistic Set 14', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss15': ('Stylistic Set 15', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss16': ('Stylistic Set 16', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss17': ('Stylistic Set 17', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss18': ('Stylistic Set 18', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss19': ('Stylistic Set 19', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ss20': ('Stylistic Set 20', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssxx'),
    'ssty': ('Math script style alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#ssty'),
    'stch': ('Stretching Glyph Decomposition', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#stch'),
    'subs': ('Subscript', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#subs'),
    'sups': ('Superscript', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#sups'),
    'swsh': ('Swash', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#swsh'),
    'titl': ('Titling', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#titl'),
    'tjmo': ('Trailing Jamo Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#tjmo'),
    'tnam': ('Traditional Name Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#tnam'),
    'tnum': ('Tabular Figures', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#tnum'),
    'trad': ('Traditional Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#trad'),
    'twid': ('Third Widths', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#twid'),
    'unic': ('Unicase', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#unic'),
    'valt': ('Alternate Vertical Metrics', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#valt'),
    'vatu': ('Vattu Variants', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vatu'),
    'vchw': ('Vertical Contextual Half-width Spacing', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vchw'),
    'vert': ('Vertical Writing', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vert'),
    'vhal': ('Alternate Vertical Half Metrics', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vhal'),
    'vjmo': ('Vowel Jamo Forms', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vjmo'),
    'vkna': ('Vertical Kana Alternates', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vkna'),
    'vkrn': ('Vertical Kerning', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vkrn'),
    'vpal': ('Proportional Alternate Vertical Metrics', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vpal'),
    'vrt2': ('Vertical Alternates and Rotation', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vrt2'),
    'vrtr': ('Vertical Alternates for Rotation', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#vrtr'),
    'zero': ('Slashed Zero', 'https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#zero'),
}

scripts = {
    # tag, friendly name
    'adlm': 'Adlam',
    'ahom': 'Ahom',
    'hluw': 'Anatolian Hieroglyphs',
    'arab': 'Arabic',
    'armn': 'Armenian',
    'avst': 'Avestan',
    'bali': 'Balinese',
    'bamu': 'Bamum',
    'bass': 'Bassa Vah',
    'batk': 'Batak',
    'beng': 'Bangla',
    'bng2': 'Bangla v.2',
    'bhks': 'Bhaiksuki',
    'bopo': 'Bopomofo',
    'brah': 'Brahmi',
    'brai': 'Braille',
    'bugi': 'Buginese',
    'buhd': 'Buhid',
    'byzm': 'Byzantine Music',
    'cans': 'Canadian Syllabics',
    'cari': 'Carian',
    'aghb': 'Caucasian Albanian',
    'cakm': 'Chakma',
    'cham': 'Cham',
    'cher': 'Cherokee',
    'chrs': 'Chorasmian',
    'hani': 'CJK Ideographic',
    'copt': 'Coptic',
    'cprt': 'Cypriot Syllabary',
    'cpmn': 'Cypro-Minoan',
    'cyrl': 'Cyrillic',
    'DFLT': 'Default',
    'dsrt': 'Deseret',
    'deva': 'Devanagari',
    'dev2': 'Devanagari v.2',
    'diak': 'Dives Akuru',
    'dogr': 'Dogra',
    'dupl': 'Duployan',
    'egyp': 'Egyptian Hieroglyphs',
    'elba': 'Elbasan',
    'elym': 'Elymaic',
    'ethi': 'Ethiopic',
    'geor': 'Georgian',
    'glag': 'Glagolitic',
    'goth': 'Gothic',
    'gran': 'Grantha',
    'grek': 'Greek',
    'gujr': 'Gujarati',
    'gjr2': 'Gujarati v.2',
    'gong': 'Gunjala Gondi',
    'guru': 'Gurmukhi',
    'gur2': 'Gurmukhi v.2',
    'hang': 'Hangul',
    'jamo': 'Hangul Jamo',
    'rohg': 'Hanifi Rohingya',
    'hano': 'Hanunoo',
    'hatr': 'Hatran',
    'hebr': 'Hebrew',
    'kana': 'Hiragana, Katakana',
    'armi': 'Imperial Aramaic',
    'phli': 'Inscriptional Pahlavi',
    'prti': 'Inscriptional Parthian',
    'java': 'Javanese',
    'kthi': 'Kaithi',
    'knda': 'Kannada',
    'knd2': 'Kannada v.2',
    'kali': 'Kayah Li',
    'khar': 'Kharosthi',
    'kits': 'Khitan Small Script',
    'khmr': 'Khmer',
    'khoj': 'Khojki',
    'sind': 'Khudawadi',
    'lao ': 'Lao',
    'latn': 'Latin',
    'lepc': 'Lepcha',
    'limb': 'Limbu',
    'lina': 'Linear A',
    'linb': 'Linear B',
    'lisu': 'Lisu (Fraser)',
    'lyci': 'Lycian',
    'lydi': 'Lydian',
    'mahj': 'Mahajani',
    'maka': 'Makasar',
    'mlym': 'Malayalam',
    'mlm2': 'Malayalam v.2',
    'mand': 'Mandaic, Mandaean',
    'mani': 'Manichaean',
    'marc': 'Marchen',
    'gonm': 'Masaram Gondi',
    'math': 'Mathematical Alphanumeric Symbols',
    'medf': 'Medefaidrin (Oberi Okaime, Oberi Ɔkaimɛ)',
    'mtei': 'Meitei Mayek (Meithei, Meetei)',
    'mend': 'Mende Kikakui',
    'merc': 'Meroitic Cursive',
    'mero': 'Meroitic Hieroglyphs',
    'plrd': 'Miao',
    'modi': 'Modi',
    'mong': 'Mongolian',
    'mroo': 'Mro',
    'mult': 'Multani',
    'musc': 'Musical Symbols',
    'mymr': 'Myanmar',
    'mym2': 'Myanmar v.2',
    'nbat': 'Nabataean',
    'nand': 'Nandinagari',
    'newa': 'Newa',
    'talu': 'New Tai Lue',
    'nko ': 'Ko',
    'nshu': 'Nüshu',
    'hmnp': 'Nyiakeng Puachue Hmong',
    'orya': 'Odia',
    'ory2': 'Odia v.2',
    'ogam': 'Ogham',
    'olck': 'Ol Chiki',
    'ital': 'Old Italic',
    'hung': 'Old Hungarian',
    'narb': 'Old North Arabian',
    'perm': 'Old Permic',
    'xpeo': 'Old Persian Cuneiform',
    'sogo': 'Old Sogdian',
    'sarb': 'Old South Arabian',
    'orkh': 'Old Turkic, Orkhon Runic',
    'ougr': 'Old Uyghur',
    'osge': 'Osage',
    'osma': 'Osmanya',
    'hmng': 'Pahawh Hmong',
    'palm': 'Palmyrene',
    'pauc': 'Pau Cin Hau',
    'phag': 'Phags-pa',
    'phnx': 'Phoenician',
    'phlp': 'Psalter Pahlavi',
    'rjng': 'Rejang',
    'runr': 'Runic',
    'samr': 'Samaritan',
    'saur': 'Saurashtra',
    'shrd': 'Sharada',
    'shaw': 'Shavian',
    'sidd': 'Siddham',
    'sgnw': 'Sign Writing',
    'sinh': 'Sinhala',
    'sogd': 'Sogdian',
    'sora': 'Sora Sompeng',
    'soyo': 'Soyombo',
    'xsux': 'Sumero-Akkadian Cuneiform',
    'sund': 'Sundanese',
    'sylo': 'Syloti Nagri',
    'syrc': 'Syriac',
    'tglg': 'Tagalog',
    'tagb': 'Tagbanwa',
    'tale': 'Tai Le',
    'lana': 'Tai Tham (Lanna)',
    'tavt': 'Tai Viet',
    'takr': 'Takri',
    'taml': 'Tamil',
    'tml2': 'Tamil v.2',
    'tnsa': 'Tangsa',
    'tang': 'Tangut',
    'telu': 'Telugu',
    'tel2': 'Telugu v.2',
    'thaa': 'Thaana',
    'thai': 'Thai',
    'tibt': 'Tibetan',
    'tfng': 'Tifinagh',
    'tirh': 'Tirhuta',
    'toto': 'Toto',
    'ugar': 'Ugaritic Cuneiform',
    'vai ': 'Vai',
    'vith': 'Vithkuqi',
    'wcho': 'Wancho',
    'wara': 'Warang Citi',
    'yezi': 'Yezidi',
    'yi  ': 'Yi',
    'zanb': 'Zanabazar Square (Zanabazarin Dörböljin Useg, Xewtee Dörböljin Bicig, Horizontal Square Script)',
}

languages = {
    # tag, friendly name, ISO 639 IDs (if applicable)
    'ABA ': ('Abaza', 'abq'),
    'ABK ': ('Abkhazian', 'abk'),
    'ACH ': ('Acholi', 'ach'),
    'ACR ': ('Achi', 'acr'),
    'ADY ': ('Adyghe', 'ady'),
    'AFK ': ('Afrikaans', 'afr'),
    'AFR ': ('Afar', 'aar'),
    'AGW ': ('Agaw', 'ahg'),
    'AIO ': ('Aiton', 'aio'),
    'AKA ': ('Akan', 'aka', 'fat', 'twi'),
    'AKB ': ('Batak Angkola', 'akb'),
    'ALS ': ('Alsatian', 'gsw'),
    'ALT ': ('Altai', 'atv', 'alt'),
    'AMH ': ('Amharic', 'amh'),
    'ANG ': ('Anglo-Saxon', 'ang'),
    'APPH': ('Phonetic transcription—Americanist conventions',),
    'ARA ': ('Arabic', 'ara'),
    'ARG ': ('Aragonese', 'arg'),
    'ARI ': ('Aari', 'aiw'),
    'ARK ': ('Rakhine', 'mhv', 'rmz', 'rki'),
    'ASM ': ('Assamese', 'asm'),
    'AST ': ('Asturian', 'ast'),
    'ATH ': ('Athapaskan languages', 'aht', 'apa', 'apk', 'apj', 'apl', 'apm', 'apw', 'ath', 'bea', 'sek', 'bcr', 'caf', 'chp', 'clc', 'coq', 'crx', 'ctc', 'den', 'dgr', 'gce', 'gwi', 'haa', 'hoi', 'hup', 'ing', 'kkz', 'koy', 'ktw', 'kuu', 'mvb', 'nav', 'qwt', 'scs', 'srs', 'taa', 'tau', 'tcb', 'tce', 'tfn', 'tgx', 'tht', 'tol', 'ttm', 'tuu', 'txc', 'wlk', 'xup', 'xsl'),
    'AVN ': ('Avatime', 'avn'),
    'AVR ': ('Avar', 'ava'),
    'AWA ': ('Awadhi', 'awa'),
    'AYM ': ('Aymara', 'aym'),
    'AZB ': ('Torki', 'azb'),
    'AZE ': ('Azerbaijani', 'aze'),
    'BAD ': ('Badaga', 'bfq'),
    'BAD0': ('Banda', 'bad', 'bbp', 'bfl', 'bjo', 'bpd', 'bqk', 'gox', 'kuw', 'liy', 'lna', 'lnl', 'mnh', 'nue', 'nuu', 'tor', 'yaj', 'zmz'),
    'BAG ': ('Baghelkhandi', 'bfy'),
    'BAL ': ('Balkar', 'krc'),
    'BAN ': ('Balinese', 'ban'),
    'BAR ': ('Bavarian', 'bar'),
    'BAU ': ('Baulé', 'bci'),
    'BBC ': ('Batak Toba', 'bbc'),
    'BBR ': ('Berber', 'auj', 'ber', 'cnu', 'gha', 'gho', 'grr', 'jbe', 'jbn', 'kab', 'mzb', 'oua', 'rif', 'sds', 'shi', 'shy', 'siz', 'sjs', 'swn', 'taq', 'tez', 'thv', 'thz', 'tia', 'tjo', 'tmh', 'ttq', 'tzm', 'zen', 'zgh'),
    'BCH ': ('Bench', 'bcq'),
    'BCR ': ('Bible Cree',),
    'BDY ': ('Bandjalang', 'bdy'),
    'BEL ': ('Belarussian', 'bel'),
    'BEM ': ('Bemba', 'bem'),
    'BEN ': ('Bangla', 'ben'),
    'BGC ': ('Haryanvi', 'bgc'),
    'BGQ ': ('Bagri', 'bgq'),
    'BGR ': ('Bulgarian', 'bul'),
    'BHI ': ('Bhili', 'bhi', 'bhb'),
    'BHO ': ('Bhojpuri', 'bho'),
    'BIK ': ('Bikol', 'bik', 'bhk', 'bcl', 'bto', 'cts', 'bln', 'fbl', 'lbl', 'rbl', 'ubl'),
    'BIL ': ('Bilen', 'byn'),
    'BIS ': ('Bislama', 'bis'),
    'BJJ ': ('Kanauji', 'bjj'),
    'BKF ': ('Blackfoot', 'bla'),
    'BLI ': ('Baluchi', 'bal'),
    'BLK ': ('Pa’o Karen', 'blk'),
    'BLN ': ('Balante', 'bjt', 'ble'),
    'BLT ': ('Balti', 'bft'),
    'BMB ': ('Bambara (Bamanankan)', 'bam'),
    'BML ': ('Bamileke', 'bai', 'bbj', 'bko', 'byv', 'fmp', 'jgo', 'nla', 'nnh', 'nnz', 'nwe', 'xmg', 'ybb'),
    'BOS ': ('Bosnian', 'bos'),
    'BPY ': ('Bishnupriya Manipuri', 'bpy'),
    'BRE ': ('Breton', 'bre'),
    'BRH ': ('Brahui', 'brh'),
    'BRI ': ('Braj Bhasha', 'bra'),
    'BRM ': ('Burmese', 'mya'),
    'BRX ': ('Bodo', 'brx'),
    'BSH ': ('Bashkir', 'bak'),
    'BSK ': ('Burushaski', 'bsk'),
    'BTD ': ('Batak Dairi (Pakpak)', 'btd'),
    'BTI ': ('Beti', 'btb', 'beb', 'bum', 'bxp', 'eto', 'ewo', 'mct'),
    'BTK ': ('Batak languages', 'akb', 'bbc', 'btd', 'btk', 'btm', 'bts', 'btx', 'btz'),
    'BTM ': ('Batak Mandailing', 'btm'),
    'BTS ': ('Batak Simalungun', 'bts'),
    'BTX ': ('Batak Karo', 'btx'),
    'BTZ ': ('Batak Alas-Kluet', 'btz'),
    'BUG ': ('Bugis', 'bug'),
    'BYV ': ('Medumba', 'byv'),
    'CAK ': ('Kaqchikel', 'cak'),
    'CAT ': ('Catalan', 'cat'),
    'CBK ': ('Zamboanga Chavacano', 'cbk'),
    'CCHN': ('Chinantec', 'cco', 'chj', 'chq', 'chz', 'cle', 'cnl', 'cnt', 'cpa', 'csa', 'cso', 'cte', 'ctl', 'cuc', 'cvn'),
    'CEB ': ('Cebuano', 'ceb'),
    'CGG ': ('Chiga', 'cgg'),
    'CHA ': ('Chamorro', 'cha'),
    'CHE ': ('Chechen', 'che'),
    'CHG ': ('Chaha Gurage', 'sgw'),
    'CHH ': ('Chattisgarhi', 'hne'),
    'CHI ': ('Chichewa (Chewa, Nyanja)', 'nya'),
    'CHK ': ('Chukchi', 'ckt'),
    'CHK0': ('Chuukese', 'chk'),
    'CHO ': ('Choctaw', 'cho'),
    'CHP ': ('Chipewyan', 'chp'),
    'CHR ': ('Cherokee', 'chr'),
    'CHU ': ('Chuvash', 'chv'),
    'CHY ': ('Cheyenne', 'chy'),
    'CJA ': ('Western Cham', 'cja'),
    'CJM ': ('Eastern Cham', 'cjm'),
    'CMR ': ('Comorian', 'swb', 'wlc', 'wni', 'zdj'),
    'COP ': ('Coptic', 'cop'),
    'COR ': ('Cornish', 'cor'),
    'COS ': ('Corsican', 'cos'),
    'CPP ': ('Creoles', 'abs', 'acf', 'afs', 'aig', 'aoa', 'bah', 'bew', 'bis', 'bjs', 'bpl', 'bpq', 'brc', 'bxo', 'bzj', 'bzk', 'cbk', 'ccl', 'ccm', 'chn', 'cks', 'cpe', 'cpf', 'cpi', 'cpp', 'cri', 'crp', 'crs', 'dcr', 'dep', 'djk', 'fab', 'fng', 'fpe', 'gac', 'gcf', 'gcl', 'gcr', 'gib', 'goq', 'gpe', 'gul', 'gyn', 'hat', 'hca', 'hmo', 'hwc', 'icr', 'idb', 'ihb', 'jam', 'jvd', 'kcn', 'kea', 'kmv', 'kri', 'kww', 'lir', 'lou', 'lrt', 'max', 'mbf', 'mcm', 'mfe', 'mfp', 'mkn', 'mod', 'msi', 'mud', 'mzs', 'nag', 'nef', 'ngm', 'njt', 'onx', 'oor', 'pap', 'pcm', 'pea', 'pey', 'pga', 'pih', 'pis', 'pln', 'pml', 'pmy', 'pov', 'pre', 'rcf', 'rop', 'scf', 'sci', 'skw', 'srm', 'srn', 'sta', 'svc', 'tas', 'tch', 'tcs', 'tgh', 'tmg', 'tpi', 'trf', 'tvy', 'uln', 'vic', 'vkp', 'wes', 'xmm'),
    'CRE ': ('Cree', 'cre'),
    'CRR ': ('Carrier', 'crx', 'caf'),
    'CRT ': ('Crimean Tatar', 'crh'),
    'CSB ': ('Kashubian', 'csb'),
    'CSL ': ('Church Slavonic', 'chu'),
    'CSY ': ('Czech', 'ces'),
    'CTG ': ('Chittagonian', 'ctg'),
    'CTT ': ('Wayanad Chetti', 'ctt'),
    'CUK ': ('San Blas Kuna', 'cuk'),
    'DAG ': ('Dagbani', 'dag'),
    'DAN ': ('Danish', 'dan'),
    'DAR ': ('Dargwa', 'dar'),
    'DAX ': ('Dayi', 'dax'),
    'DCR ': ('Woods Cree', 'cwd'),
    'DEU ': ('German', 'deu'),
    'DGO ': ('Dogri (individual language)', 'dgo'),
    'DGR ': ('Dogri (macrolanguage)', 'doi'),
    'DHG ': ('Dhangu', 'dhg'),
    'DHV ': ('Divehi (Dhivehi, Maldivian)', 'div'),
    'DIQ ': ('Dimli', 'diq'),
    'DIV ': ('Divehi (Dhivehi, Maldivian)', 'div'),
    'DJR ': ('Zarma', 'dje'),
    'DJR0': ('Djambarrpuyngu', 'djr'),
    'DNG ': ('Dangme', 'ada'),
    'DNJ ': ('Dan', 'dnj'),
    'DNK ': ('Dinka', 'din'),
    'DRI ': ('Dari', 'prs'),
    'DUJ ': ('Dhuwal', 'duj', 'dwu', 'dwy'),
    'DUN ': ('Dungan', 'dng'),
    'DZN ': ('Dzongkha', 'dzo'),
    'EBI ': ('Ebira', 'igb'),
    'ECR ': ('Eastern Cree', 'crj', 'crl'),
    'EDO ': ('Edo', 'bin'),
    'EFI ': ('Efik', 'efi'),
    'ELL ': ('Greek', 'ell'),
    'EMK ': ('Eastern Maninkakan', 'emk'),
    'ENG ': ('English', 'eng'),
    'ERZ ': ('Erzya', 'myv'),
    'ESP ': ('Spanish', 'spa'),
    'ESU ': ('Central Yupik', 'esu'),
    'ETI ': ('Estonian', 'est'),
    'EUQ ': ('Basque', 'eus'),
    'EVK ': ('Evenki', 'evn'),
    'EVN ': ('Even', 'eve'),
    'EWE ': ('Ewe', 'ewe'),
    'FAN ': ('French Antillean', 'acf'),
    'FAN0': ('Fang', 'fan'),
    'FAR ': ('Persian', 'fas'),
    'FAT ': ('Fanti', 'fat'),
    'FIN ': ('Finnish', 'fin'),
    'FJI ': ('Fijian', 'fij'),
    'FLE ': ('Dutch (Flemish)', 'vls'),
    'FMP ': ('Fe’fe’', 'fmp'),
    'FNE ': ('Forest Enets', 'enf'),
    'FON ': ('Fon', 'fon'),
    'FOS ': ('Faroese', 'fao'),
    'FRA ': ('French', 'fra'),
    'FRC ': ('Cajun French', 'frc'),
    'FRI ': ('Frisian', 'fry'),
    'FRL ': ('Friulian', 'fur'),
    'FRP ': ('Arpitan', 'frp'),
    'FTA ': ('Futa', 'fuf'),
    'FUL ': ('Fulah', 'ful'),
    'FUV ': ('Nigerian Fulfulde', 'fuv'),
    'GAD ': ('Ga', 'gaa'),
    'GAE ': ('Scottish Gaelic', 'gla'),
    'GAG ': ('Gagauz', 'gag'),
    'GAL ': ('Galician', 'glg'),
    'GAR ': ('Garshuni',),
    'GAW ': ('Garhwali', 'gbm'),
    'GEZ ': ('Geez', 'gez'),
    'GIH ': ('Githabul', 'gih'),
    'GIL ': ('Gilyak', 'niv'),
    'GIL0': ('Kiribati (Gilbertese)', 'gil'),
    'GKP ': ('Kpelle (Guinea)', 'gkp'),
    'GLK ': ('Gilaki', 'glk'),
    'GMZ ': ('Gumuz', 'guk'),
    'GNN ': ('Gumatj', 'gnn'),
    'GOG ': ('Gogo', 'gog'),
    'GON ': ('Gondi', 'gon'),
    'GRN ': ('Greenlandic', 'kal'),
    'GRO ': ('Garo', 'grt'),
    'GUA ': ('Guarani', 'grn'),
    'GUC ': ('Wayuu', 'guc'),
    'GUF ': ('Gupapuyngu', 'guf'),
    'GUJ ': ('Gujarati', 'guj'),
    'GUZ ': ('Gusii', 'guz'),
    'HAI ': ('Haitian (Haitian Creole)', 'hat'),
    'HAI0': ('Haida', 'hai', 'hax', 'hdn'),
    'HAL ': ('Halam (Falam Chin)', 'cfm'),
    'HAR ': ('Harauti', 'hoj'),
    'HAU ': ('Hausa', 'hau'),
    'HAW ': ('Hawaiian', 'haw'),
    'HAY ': ('Haya', 'hay'),
    'HAZ ': ('Hazaragi', 'haz'),
    'HBN ': ('Hammer-Banna', 'amf'),
    'HEI ': ('Heiltsuk', 'hei'),
    'HER ': ('Herero', 'her'),
    'HIL ': ('Hiligaynon', 'hil'),
    'HIN ': ('Hindi', 'hin'),
    'HMA ': ('High Mari', 'mrj'),
    'HMD ': ('A-Hmao', 'hmd'),
    'HMN ': ('Hmong', 'hmn'),
    'HMO ': ('Hiri Motu', 'hmo'),
    'HMZ ': ('Hmong Shuat', 'hmz'),
    'HND ': ('Hindko', 'hno', 'hnd'),
    'HO  ': ('Ho', 'hoc'),
    'HRI ': ('Harari', 'har'),
    'HRV ': ('Croatian', 'hrv'),
    'HUN ': ('Hungarian', 'hun'),
    'HYE ': ('Armenian', 'hye', 'hyw'),
    'HYE0': ('Armenian East', 'hye'),
    'IBA ': ('Iban', 'iba'),
    'IBB ': ('Ibibio', 'ibb'),
    'IBO ': ('Igbo', 'ibo'),
    'IDO ': ('Ido', 'ido'),
    'IJO ': ('Ijo languages', 'iby', 'ijc', 'ije', 'ijn', 'ijo', 'ijs', 'nkx', 'okd', 'okr', 'orr'),
    'ILE ': ('Interlingue', 'ile'),
    'ILO ': ('Ilokano', 'ilo'),
    'INA ': ('Interlingua', 'ina'),
    'IND ': ('Indonesian', 'ind'),
    'ING ': ('Ingush', 'inh'),
    'INU ': ('Inuktitut', 'iku'),
    'INUK': ('Nunavik Inuktitut', 'ike', 'iku'),
    'IPK ': ('Inupiat', 'ipk'),
    'IPPH': ('Phonetic transcription—IPA conventions',),
    'IRI ': ('Irish', 'gle'),
    'IRT ': ('Irish Traditional', 'gle'),
    'IRU ': ('Irula', 'iru'),
    'ISL ': ('Icelandic', 'isl'),
    'ISM ': ('Inari Sami', 'smn'),
    'ITA ': ('Italian', 'ita'),
    'IWR ': ('Hebrew', 'heb'),
    'JAM ': ('Jamaican Creole', 'jam'),
    'JAN ': ('Japanese', 'jpn'),
    'JAV ': ('Javanese', 'jav'),
    'JBO ': ('Lojban', 'jbo'),
    'JCT ': ('Krymchak', 'jct'),
    'JII ': ('Yiddish', 'yid'),
    'JUD ': ('Ladino', 'lad'),
    'JUL ': ('Jula', 'dyu'),
    'KAB ': ('Kabardian', 'kbd'),
    'KAB0': ('Kabyle', 'kab'),
    'KAC ': ('Kachchi', 'kfr'),
    'KAL ': ('Kalenjin', 'kln'),
    'KAN ': ('Kannada', 'kan'),
    'KAR ': ('Karachay', 'krc'),
    'KAT ': ('Georgian', 'kat'),
    'KAW ': ('Kawi (Old Javanese)', 'kaw'),
    'KAZ ': ('Kazakh', 'kaz'),
    'KDE ': ('Makonde', 'kde'),
    'KEA ': ('Kabuverdianu (Crioulo)', 'kea'),
    'KEB ': ('Kebena', 'ktb'),
    'KEK ': ('Kekchi', 'kek'),
    'KGE ': ('Khutsuri Georgian', 'kat'),
    'KHA ': ('Khakass', 'kjh'),
    'KHK ': ('Khanty-Kazim', 'kca'),
    'KHM ': ('Khmer', 'khm'),
    'KHS ': ('Khanty-Shurishkar', 'kca'),
    'KHT ': ('Khamti Shan', 'kht'),
    'KHV ': ('Khanty-Vakhi', 'kca'),
    'KHW ': ('Khowar', 'khw'),
    'KIK ': ('Kikuyu (Gikuyu)', 'kik'),
    'KIR ': ('Kirghiz (Kyrgyz)', 'kir'),
    'KIS ': ('Kisii', 'kqs', 'kss'),
    'KIU ': ('Kirmanjki', 'kiu'),
    'KJD ': ('Southern Kiwai', 'kjd'),
    'KJP ': ('Eastern Pwo Karen', 'kjp'),
    'KJZ ': ('Bumthangkha', 'kjz'),
    'KKN ': ('Kokni', 'kex'),
    'KLM ': ('Kalmyk', 'xal'),
    'KMB ': ('Kamba', 'kam'),
    'KMN ': ('Kumaoni', 'kfy'),
    'KMO ': ('Komo', 'kmw'),
    'KMS ': ('Komso', 'kxc'),
    'KMZ ': ('Khorasani Turkic', 'kmz'),
    'KNR ': ('Kanuri', 'kau'),
    'KOD ': ('Kodagu', 'kfa'),
    'KOH ': ('Korean Old Hangul', 'kor', 'okm'),
    'KOK ': ('Konkani', 'kok'),
    'KOM ': ('Komi', 'kom'),
    'KON ': ('Kikongo', 'ktu'),
    'KON0': ('Kongo', 'kon'),
    'KOP ': ('Komi-Permyak', 'koi'),
    'KOR ': ('Korean', 'kor'),
    'KOS ': ('Kosraean', 'kos'),
    'KOZ ': ('Komi-Zyrian', 'kpv'),
    'KPL ': ('Kpelle', 'kpe'),
    'KRI ': ('Krio', 'kri'),
    'KRK ': ('Karakalpak', 'kaa'),
    'KRL ': ('Karelian', 'krl'),
    'KRM ': ('Karaim', 'kdr'),
    'KRN ': ('Karen', 'blk', 'bwe', 'eky', 'ghk', 'jkm', 'jkp', 'kar', 'kjp', 'kjt', 'ksw', 'kvl', 'kvq', 'kvt', 'kvu', 'kvy', 'kxf', 'kxk', 'kyu', 'pdu', 'pwo', 'pww', 'wea'),
    'KRT ': ('Koorete', 'kqy'),
    'KSH ': ('Kashmiri', 'kas'),
    'KSH0': ('Ripuarian', 'ksh'),
    'KSI ': ('Khasi', 'kha'),
    'KSM ': ('Kildin Sami', 'sjd'),
    'KSW ': ('S’gaw Karen', 'ksw'),
    'KUA ': ('Kuanyama', 'kua'),
    'KUI ': ('Kui', 'kxu'),
    'KUL ': ('Kulvi', 'kfx'),
    'KUM ': ('Kumyk', 'kum'),
    'KUR ': ('Kurdish', 'kur'),
    'KUU ': ('Kurukh', 'kru'),
    'KUY ': ('Kuy', 'kdt'),
    'KWK ': ('Kwakʼwala', 'kwk'),
    'KYK ': ('Koryak', 'kpy'),
    'KYU ': ('Western Kayah', 'kyu'),
    'LAD ': ('Ladin', 'lld'),
    'LAH ': ('Lahuli', 'bfu'),
    'LAK ': ('Lak', 'lbe'),
    'LAM ': ('Lambani', 'lmn'),
    'LAO ': ('Lao', 'lao'),
    'LAT ': ('Latin', 'lat'),
    'LAZ ': ('Laz', 'lzz'),
    'LCR ': ('L-Cree', 'crm'),
    'LDK ': ('Ladakhi', 'lbj'),
    'LEF ': ('Lelemi', 'lef'),
    'LEZ ': ('Lezgi', 'lez'),
    'LIJ ': ('Ligurian', 'lij'),
    'LIM ': ('Limburgish', 'lim'),
    'LIN ': ('Lingala', 'lin'),
    'LIS ': ('Lisu', 'lis'),
    'LJP ': ('Lampung', 'ljp'),
    'LKI ': ('Laki', 'lki'),
    'LMA ': ('Low Mari', 'mhr'),
    'LMB ': ('Limbu', 'lif'),
    'LMO ': ('Lombard', 'lmo'),
    'LMW ': ('Lomwe', 'ngl'),
    'LOM ': ('Loma', 'lom'),
    'LPO ': ('Lipo', 'lpo'),
    'LRC ': ('Luri', 'lrc', 'luz', 'bqi', 'zum'),
    'LSB ': ('Lower Sorbian', 'dsb'),
    'LSM ': ('Lule Sami', 'smj'),
    'LTH ': ('Lithuanian', 'lit'),
    'LTZ ': ('Luxembourgish', 'ltz'),
    'LUA ': ('Luba-Lulua', 'lua'),
    'LUB ': ('Luba-Katanga', 'lub'),
    'LUG ': ('Ganda', 'lug'),
    'LUH ': ('Luyia', 'luy'),
    'LUO ': ('Luo', 'luo'),
    'LVI ': ('Latvian', 'lav'),
    'MAD ': ('Madura', 'mad'),
    'MAG ': ('Magahi', 'mag'),
    'MAH ': ('Marshallese', 'mah'),
    'MAJ ': ('Majang', 'mpe'),
    'MAK ': ('Makhuwa', 'vmw'),
    'MAL ': ('Malayalam', 'mal'),
    'MAM ': ('Mam', 'mam'),
    'MAN ': ('Mansi', 'mns'),
    'MAP ': ('Mapudungun', 'arn'),
    'MAR ': ('Marathi', 'mar'),
    'MAW ': ('Marwari', 'mwr', 'dhd', 'rwr', 'mve', 'wry', 'mtr', 'swv'),
    'MBN ': ('Mbundu', 'kmb'),
    'MBO ': ('Mbo', 'mbo'),
    'MCH ': ('Manchu', 'mnc'),
    'MCR ': ('Moose Cree', 'crm'),
    'MDE ': ('Mende', 'men'),
    'MDR ': ('Mandar', 'mdr'),
    'MEN ': ('Me’en', 'mym'),
    'MER ': ('Meru', 'mer'),
    'MFA ': ('Pattani Malay', 'mfa'),
    'MFE ': ('Morisyen', 'mfe'),
    'MIN ': ('Minangkabau', 'min'),
    'MIZ ': ('Mizo', 'lus'),
    'MKD ': ('Macedonian', 'mkd'),
    'MKR ': ('Makasar', 'mak'),
    'MKW ': ('Kituba', 'mkw'),
    'MLE ': ('Male', 'mdy'),
    'MLG ': ('Malagasy', 'mlg'),
    'MLN ': ('Malinke', 'mlq'),
    'MLR ': ('Malayalam Reformed', 'mal'),
    'MLY ': ('Malay', 'msa'),
    'MND ': ('Mandinka', 'mnk'),
    'MNG ': ('Mongolian', 'mon'),
    'MNI ': ('Manipuri', 'mni'),
    'MNK ': ('Maninka', 'man', 'mnk', 'myq', 'mku', 'msc', 'emk', 'mwk', 'mlq'),
    'MNX ': ('Manx', 'glv'),
    'MOH ': ('Mohawk', 'moh'),
    'MOK ': ('Moksha', 'mdf'),
    'MOL ': ('Romanian (Moldova)', 'mol'),
    'MON ': ('Mon', 'mnw'),
    'MONT': ('Thailand Mon', 'mnw'),
    'MOR ': ('Moroccan',),
    'MOS ': ('Mossi', 'mos'),
    'MRI ': ('Maori', 'mri'),
    'MTH ': ('Maithili', 'mai'),
    'MTS ': ('Maltese', 'mlt'),
    'MUN ': ('Mundari', 'unr'),
    'MUS ': ('Muscogee', 'mus'),
    'MWL ': ('Mirandese', 'mwl'),
    'MWW ': ('Hmong Daw', 'mww'),
    'MYN ': ('Mayan', 'acr', 'agu', 'caa', 'cac', 'cak', 'chf', 'ckz', 'cob', 'ctu', 'emy', 'hus', 'itz', 'ixl', 'jac', 'kek', 'kjb', 'knj', 'lac', 'mam', 'mhc', 'mop', 'myn', 'poc', 'poh', 'quc', 'qum', 'quv', 'toj', 'ttc', 'tzh', 'tzj', 'tzo', 'usp', 'yua'),
    'MZN ': ('Mazanderani', 'mzn'),
    'NAG ': ('Naga-Assamese', 'nag'),
    'NAH ': ('Nahuatl', 'azd', 'azn', 'azz', 'nah', 'naz', 'nch', 'nci', 'ncj', 'ncl', 'ncx', 'ngu', 'nhc', 'nhe', 'nhg', 'nhi', 'nhk', 'nhm', 'nhn', 'nhp', 'nhq', 'nht', 'nhv', 'nhw', 'nhx', 'nhy', 'nhz', 'nlv', 'npl', 'nsu', 'nuz'),
    'NAN ': ('Nanai', 'gld'),
    'NAP ': ('Neapolitan', 'nap'),
    'NAS ': ('Naskapi', 'nsk'),
    'NAU ': ('Nauruan', 'nau'),
    'NAV ': ('Navajo', 'nav'),
    'NCR ': ('N-Cree', 'csw'),
    'NDB ': ('Ndebele', 'nbl', 'nde'),
    'NDC ': ('Ndau', 'ndc'),
    'NDG ': ('Ndonga', 'ndo'),
    'NDS ': ('Low Saxon', 'nds'),
    'NEP ': ('Nepali', 'nep'),
    'NEW ': ('Newari', 'new'),
    'NGA ': ('Ngbaka', 'nga'),
    'NGR ': ('Nagari',),
    'NHC ': ('Norway House Cree', 'csw'),
    'NIS ': ('Nisi', 'dap', 'njz', 'tgj'),
    'NIU ': ('Niuean', 'niu'),
    'NKL ': ('Nyankole', 'nyn'),
    'NKO ': ('N’Ko', 'nqo'),
    'NLD ': ('Dutch', 'nld'),
    'NOE ': ('Nimadi', 'noe'),
    'NOG ': ('Nogai', 'nog'),
    'NOR ': ('Norwegian', 'nob'),
    'NOV ': ('Novial', 'nov'),
    'NSM ': ('Northern Sami', 'sme'),
    'NSO ': ('Northern Sotho', 'nso'),
    'NTA ': ('Northern Tai', 'nod'),
    'NTO ': ('Esperanto', 'epo'),
    'NYM ': ('Nyamwezi', 'nym'),
    'NYN ': ('Norwegian Nynorsk (Nynorsk, Norwegian)', 'nno'),
    'NZA ': ('Mbembe Tigon', 'nza'),
    'OCI ': ('Occitan', 'oci'),
    'OCR ': ('Oji-Cree', 'ojs'),
    'OJB ': ('Ojibway', 'oji'),
    'ORI ': ('Odia', 'ori'),
    'ORO ': ('Oromo', 'orm'),
    'OSS ': ('Ossetian', 'oss'),
    'PAA ': ('Palestinian Aramaic', 'sam'),
    'PAG ': ('Pangasinan', 'pag'),
    'PAL ': ('Pali', 'pli'),
    'PAM ': ('Pampangan', 'pam'),
    'PAN ': ('Punjabi', 'pan'),
    'PAP ': ('Palpa', 'plp'),
    'PAP0': ('Papiamentu', 'pap'),
    'PAS ': ('Pashto', 'pus'),
    'PAU ': ('Palauan', 'pau'),
    'PCC ': ('Bouyei', 'pcc'),
    'PCD ': ('Picard', 'pcd'),
    'PDC ': ('Pennsylvania German', 'pdc'),
    'PGR ': ('Polytonic Greek', 'ell'),
    'PHK ': ('Phake', 'phk'),
    'PIH ': ('Norfolk', 'pih'),
    'PIL ': ('Filipino', 'fil'),
    'PLG ': ('Palaung', 'pce', 'rbb', 'pll'),
    'PLK ': ('Polish', 'pol'),
    'PMS ': ('Piemontese', 'pms'),
    'PNB ': ('Western Panjabi', 'pnb'),
    'POH ': ('Pocomchi', 'poh'),
    'PON ': ('Pohnpeian', 'pon'),
    'PRO ': ('Provençal / Old Provençal', 'pro'),
    'PTG ': ('Portuguese', 'por'),
    'PWO ': ('Western Pwo Karen', 'pwo'),
    'QIN ': ('Chin', 'bgr', 'biu', 'cek', 'cey', 'cfm', 'cbl', 'cka', 'ckn', 'clj', 'clt', 'cmr', 'cnb', 'cnh', 'cnk', 'cnw', 'csh', 'csj', 'csv', 'csy', 'ctd', 'cth', 'czt', 'dao', 'gnb', 'hlt', 'hmr', 'hra', 'lus', 'mrh', 'mwq', 'pck', 'pkh', 'pub', 'ral', 'rtc', 'sch', 'sez', 'shl', 'smt', 'tcp', 'tcz', 'vap', 'weu', 'zom', 'zyp'),
    'QUC ': ('K’iche’', 'quc'),
    'QUH ': ('Quechua (Bolivia)', 'quh'),
    'QUZ ': ('Quechua', 'quz'),
    'QVI ': ('Quechua (Ecuador)', 'qvi'),
    'QWH ': ('Quechua (Peru)', 'qwh'),
    'RAJ ': ('Rajasthani', 'raj'),
    'RAR ': ('Rarotongan', 'rar'),
    'RBU ': ('Russian Buriat', 'bxr'),
    'RCR ': ('R-Cree', 'atj'),
    'REJ ': ('Rejang', 'rej'),
    'RIA ': ('Riang', 'ria'),
    'RHG ': ('Rohingya', 'rhg'),
    'RIF ': ('Tarifit', 'rif'),
    'RIT ': ('Ritarungo', 'rit'),
    'RKW ': ('Arakwal', 'rkw'),
    'RMS ': ('Romansh', 'roh'),
    'RMY ': ('Vlax Romani', 'rmy'),
    'ROM ': ('Romanian', 'ron'),
    'ROY ': ('Romany', 'rom'),
    'RSY ': ('Rusyn', 'rue'),
    'RTM ': ('Rotuman', 'rtm'),
    'RUA ': ('Kinyarwanda', 'kin'),
    'RUN ': ('Rundi', 'run'),
    'RUP ': ('Aromanian', 'rup'),
    'RUS ': ('Russian', 'rus'),
    'SAD ': ('Sadri', 'sck'),
    'SAN ': ('Sanskrit', 'san'),
    'SAS ': ('Sasak', 'sas'),
    'SAT ': ('Santali', 'sat'),
    'SAY ': ('Sayisi', 'chp'),
    'SCN ': ('Sicilian', 'scn'),
    'SCO ': ('Scots', 'sco'),
    'SCS ': ('North Slavey', 'scs'),
    'SEK ': ('Sekota', 'xan'),
    'SEL ': ('Selkup', 'sel'),
    'SFM ': ('Small Flowery Miao', 'sfm'),
    'SGA ': ('Old Irish', 'sga'),
    'SGO ': ('Sango', 'sag'),
    'SGS ': ('Samogitian', 'sgs'),
    'SHI ': ('Tachelhit', 'shi'),
    'SHN ': ('Shan', 'shn'),
    'SIB ': ('Sibe', 'sjo'),
    'SID ': ('Sidamo', 'sid'),
    'SIG ': ('Silte Gurage', 'xst', 'stv', 'wle'),
    'SKS ': ('Skolt Sami', 'sms'),
    'SKY ': ('Slovak', 'slk'),
    'SLA ': ('Slavey', 'den', 'scs', 'xsl'),
    'SLV ': ('Slovenian', 'slv'),
    'SML ': ('Somali', 'som'),
    'SMO ': ('Samoan', 'smo'),
    'SNA ': ('Sena', 'seh'),
    'SNA0': ('Shona', 'sna'),
    'SND ': ('Sindhi', 'snd'),
    'SNH ': ('Sinhala (Sinhalese)', 'sin'),
    'SNK ': ('Soninke', 'snk'),
    'SOG ': ('Sodo Gurage', 'gru'),
    'SOP ': ('Songe', 'sop'),
    'SOT ': ('Southern Sotho', 'sot'),
    'SQI ': ('Albanian', 'sqi'),
    'SRB ': ('Serbian', 'cnr', 'srp'),
    'SRD ': ('Sardinian', 'srd'),
    'SRK ': ('Saraiki', 'skr'),
    'SRR ': ('Serer', 'srr'),
    'SSL ': ('South Slavey', 'xsl'),
    'SSM ': ('Southern Sami', 'sma'),
    'STQ ': ('Saterland Frisian', 'stq'),
    'SUK ': ('Sukuma', 'suk'),
    'SUN ': ('Sundanese', 'sun'),
    'SUR ': ('Suri', 'suq'),
    'SVA ': ('Svan', 'sva'),
    'SVE ': ('Swedish', 'swe'),
    'SWA ': ('Swadaya Aramaic', 'aii'),
    'SWK ': ('Swahili', 'swa'),
    'SWZ ': ('Swati', 'ssw'),
    'SXT ': ('Sutu', 'ngo', 'xnj', 'xnq'),
    'SXU ': ('Upper Saxon', 'sxu'),
    'SYL ': ('Sylheti', 'syl'),
    'SYR ': ('Syriac', 'aii', 'amw', 'cld', 'syc', 'syr', 'tru'),
    'SYRE': ('Syre', 'syc', 'syr'),
    'SYRJ': ('Syrj', 'syc', 'syr'),
    'SYRN': ('Syrn', 'syc', 'syr'),
    'SZL ': ('Silesian', 'szl'),
    'TAB ': ('Tabasaran', 'tab'),
    'TAJ ': ('Tajiki', 'tgk'),
    'TAM ': ('Tamil', 'tam'),
    'TAT ': ('Tatar', 'tat'),
    'TCR ': ('TH-Cree', 'cwd'),
    'TDD ': ('Dehong Dai', 'tdd'),
    'TEL ': ('Telugu', 'tel'),
    'TET ': ('Tetum', 'tet'),
    'TGL ': ('Tagalog', 'tgl'),
    'TGN ': ('Tongan', 'ton'),
    'TGR ': ('Tigre', 'tig'),
    'TGY ': ('Tigrinya', 'tir'),
    'THA ': ('Thai', 'tha'),
    'THT ': ('Tahitian', 'tah'),
    'TIB ': ('Tibetan', 'bod'),
    'TIV ': ('Tiv', 'tiv'),
    'TJL ': ('Tai Laing', 'tjl'),
    'TKM ': ('Turkmen', 'tuk'),
    'TLI ': ('Tlingit', 'tli'),
    'TMH ': ('Tamashek', 'taq', 'thv', 'thz', 'tmh', 'ttq'),
    'TMN ': ('Temne', 'tem'),
    'TNA ': ('Tswana', 'tsn'),
    'TNE ': ('Tundra Enets', 'enh'),
    'TNG ': ('Tonga', 'toi'),
    'TOD ': ('Todo', 'xal'),
    'TOD0': ('Toma', 'tod'),
    'TPI ': ('Tok Pisin', 'tpi'),
    'TRK ': ('Turkish', 'tur'),
    'TSG ': ('Tsonga', 'tso'),
    'TSJ ': ('Tshangla', 'tsj'),
    'TUA ': ('Turoyo Aramaic', 'tru'),
    'TUL ': ('Tulu', 'tcy'),
    'TUM ': ('Tumbuka', 'tum'),
    'TUV ': ('Tuvin', 'tyv'),
    'TVL ': ('Tuvalu', 'tvl'),
    'TWI ': ('Twi', 'twi'),
    'TYZ ': ('Tày', 'tyz'),
    'TZM ': ('Tamazight', 'tzm'),
    'TZO ': ('Tzotzil', 'tzo'),
    'UDM ': ('Udmurt', 'udm'),
    'UKR ': ('Ukrainian', 'ukr'),
    'UMB ': ('Umbundu', 'umb'),
    'URD ': ('Urdu', 'urd'),
    'USB ': ('Upper Sorbian', 'hsb'),
    'UYG ': ('Uyghur', 'uig'),
    'UZB ': ('Uzbek', 'uzb'),
    'VEC ': ('Venetian', 'vec'),
    'VEN ': ('Venda', 'ven'),
    'VIT ': ('Vietnamese', 'vie'),
    'VOL ': ('Volapük', 'vol'),
    'VRO ': ('Võro', 'vro'),
    'WA  ': ('Wa', 'wbm'),
    'WAG ': ('Wagdi', 'wbr'),
    'WAR ': ('Waray-Waray', 'war'),
    'WCI ': ('Waci Gbe', 'wci'),
    'WCR ': ('West-Cree', 'crk'),
    'WEL ': ('Welsh', 'cym'),
    'WLF ': ('Wolof', 'wol'),
    'WLN ': ('Walloon', 'wln'),
    'WTM ': ('Mewati', 'wtm'),
    'XBD ': ('Lü', 'khb'),
    'XHS ': ('Xhosa', 'xho'),
    'XJB ': ('Minjangbal', 'xjb'),
    'XKF ': ('Khengkha', 'xkf'),
    'XOG ': ('Soga', 'xog'),
    'XPE ': ('Kpelle (Liberia)', 'xpe'),
    'XUB ': ('Bette Kuruma', 'xub'),
    'XUJ ': ('Jennu Kuruma', 'xuj'),
    'YAK ': ('Sakha', 'sah'),
    'YAO ': ('Yao', 'yao'),
    'YAP ': ('Yapese', 'yap'),
    'YBA ': ('Yoruba', 'yor'),
    'YCR ': ('Y-Cree', 'crj', 'crk', 'crl'),
    'YGP ': ('Gepo', 'ygp'),
    'YIC ': ('Yi Classic',),
    'YIM ': ('Yi Modern', 'iii'),
    'YNA ': ('Aluo', 'yna'),
    'YWQ ': ('Wuding-Luquan Yi', 'ywq'),
    'ZEA ': ('Zealandic', 'zea'),
    'ZGH ': ('Standard Moroccan Tamazight', 'zgh'),
    'ZHA ': ('Zhuang', 'zha'),
    'ZHH ': ('Chinese, Traditional, Hong Kong SAR', 'zho'),
    'ZHP ': ('Chinese, Phonetic', 'zho'),
    'ZHS ': ('Chinese, Simplified', 'zho'),
    'ZHT ': ('Chinese, Traditional', 'zho'),
    'ZHTM': ('Chinese, Traditional, Macao SAR', 'zho'),
    'ZND ': ('Zande', 'zne'),
    'ZUL ': ('Zulu', 'zul'),
    'ZZA ': ('Zazaki', 'zza'),
}
