<div align="center">
<img src="https://user-images.githubusercontent.com/46846821/89666520-f195cb80-d8f3-11ea-80bb-f9d5137c6c6c.png" alt ="Activity Scheduing">
<h1>Timetable Scheduler</h1>
</div>
<div align="center">
	<img src="https://img.shields.io/badge/License-MIT-%230F2A5F" alt="license MIT">
</div>

## 🎯 Plan of Action

The project deals with specific constraints:

- There should be no more than one class of teachers at the same time.

- There should be only one teacher assigned to each class during a lecture.

- A teacher cannot teach more than one subject to a class.

- Each subject can be assigned to a class at most one time.

- Credit hours cannot exceed contact hours.

- There can be only one lecture of a teacher/ subject in a class per day.

- The lecture arrangement feature is available to let users decide how multiple lectures of a subject can appear in the timetable.

- The user can define maximum lectures per day and the working days per week.

## 🚀 Installation Guidelines

### Prerequisite

Make sure you have the following tools, installed on your system.

- [git](https://git-scm.com/downloads)
- [node/ npm](https://nodejs.org/en/download/)

### Fork/ Clone the repository:

Click on the fork button in the top right corner or just [click this](https://github.com/justEhmadSaeed/timetable-scheduler/fork).
Copy the URL from that green `code` button to clone the project.
Open a terminal in your desired directory and run the following command with `REPO_URL` replaced by the link you just copied:

```
git clone REPO_URL
```

### Set Project Configurations:

- Make an account on firebase and fill up the .env variables on the frontend.
- Also, download serviceAccountKey.json from firebase project and add it in the `backend/constants` directory.

### Open Two Terminals:

- Set path of the first terminal to the root of the project folder, that would have /CS311S20PID08 at the end of the path. This terminal will operate the **frontend** of the project.

- For the second terminal, set its path to the **backend** folder, located in the root directory, or you can initialize its path from the root directory, which will have the same path as of the first terminal and then you can run the following command to set its path to the backend folder.

```
cd backend
```

### Install the required npm Packages/ dependencies:

To install the dependencies of both frontend and backend, run the following command in both terminals:

```bash
# npm
npm install
# yarn
yarn
```

Make sure you run the above-mentioned command for both terminals without any errors.

### Run the project:

Now assuming that your system has all the dependencies required to run the project, it is now set to run over your system.

Now for the final step, run the following command in both terminals to start the project:

```bash
# npm
npm start
# yarn
yarn start
```

The link for the application will appear in the frontend terminal.

For the next time, you have to follow steps 2 & 4 only.

## 👨🏻‍💻 Contributing

Make sure you read the [contributing guidelines](contributing.md) before opening a PR.

## 📧Contact Us

In case of any query regarding the project installation, feel free to contact:

- 🧑 [Ehmad Saeed](https://twitter.com/justEhmadSaeed)
- 👩 [Mehrunnisa](mailto:mehrunnisa533@gmail.com)

## 🔑 License & Conduct

- It is © [MIT Licensed](LICENSE)
- [Code of Conduct](CODE_OF_CONDUCT.md)
