
# VFX Good Night Reading

Curated collection of good reading about VFX and CG. Mostly TD-level stuff, but not too hardcore.

Links are pointing to PDFs when available for free, or to [acm digital library](https://dl.acm.org/). Note that ACM Digital Library content is sometimes available for **free**, more info [here](https://www.siggraph.org/learn/conference-content).

:information_source: Note that some links might break after some time. You can still check if they are indexed in [Wayback Machine](https://archive.org/web/) though.

:information_source: Bournemouth links are mostly dead. You should be able to find the content here though: [new website](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProject/).

Feel free to improve/extend this library and contribute with your findings. Pull requests are welcome.

See [here](#adding-new-entries) for instructions about generating this page.

Number of entries: 258, categories: 41

<br>

### Formats
* **book** (25)
* **paper** (134)
* **presentation** (48)
* **thesis** (49)
* **video** (2)

<br>

### Tags
* al (2)
* [bournemouth](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProject/) (21)
* [clemson](https://tigerprints.clemson.edu/theses/) (10)
* dd (2)
* [disney](https://studios.disneyresearch.com/) (15)
* dneg (4)
* [dwa](http://research.dreamworks.com/) (16)
* framestore (1)
* houdini (49)
* ilm (6)
* method (2)
* [mpc](http://www.moving-picture.com/film/content-pages/technology/) (13)
* nvidia (6)
* [pixar](https://graphics.pixar.com/library/) (19)
* r&h (5)
* [scad](http://ecollections.scad.edu/iii/cpro/CollectionViewPage.external?lang=eng&sp=1000005&suite=def) (9)
* [spi](http://library.imageworks.com/) (9)
* [tdforum](http://tdforum.eu/pdf/) (10)
* [weta](https://www.wetafx.co.nz/research-and-tech/publications/) (10)

<br>

### Categories
* [Abstract](#abstract) (3)
* [Animation](#animation) (13)
* [Biology & Trees](#biology--trees) (11)
* [CFX](#cfx) (2)
* [CG](#cg) (10)
* [Case studies](#case-studies) (9)
* [Cities](#cities) (1)
* [Coding](#coding) (11)
* [Colors](#colors) (10)
* [Computer Vision](#computer-vision) (1)
* [Crowds](#crowds) (12)
* [Deep comp](#deep-comp) (2)
* [Environments](#environments) (5)
* [Erosion](#erosion) (3)
* [FEM](#fem) (2)
* [FX](#fx) (60)
* [Fluids](#fluids) (25)
* [Fractals](#fractals) (3)
* [Fur & Feathers](#fur--feathers) (7)
* [History](#history) (3)
* [Lighting & Rendering](#lighting--rendering) (62)
* [Liquids](#liquids) (25)
* [Machine Learning](#machine-learning) (7)
* [Maths](#maths) (15)
* [Misc](#misc) (2)
* [Motion Capture](#motion-capture) (2)
* [Oceans](#oceans) (4)
* [PBD](#pbd) (3)
* [Photogrammetry](#photogrammetry) (2)
* [Pipeline](#pipeline) (23)
* [Production](#production) (6)
* [RBD](#rbd) (12)
* [Realtime](#realtime) (35)
* [Rigging](#rigging) (13)
* [Set](#set) (4)
* [Shading](#shading) (29)
* [Stereo](#stereo) (1)
* [USD](#usd) (5)
* [Unreal Engine](#unreal-engine) (3)
* [VR](#vr) (3)
* [Volumetrics](#volumetrics) (47)

<br>

# List
<br>


### Abstract
* [APPLICATION OF 3D PROCEDURAL ANIMATION TO THE VISUAL PRESENTATION OF MUSIC](http://ecollections.scad.edu/iii/cpro/DigitalItemViewPage.external;jsessionid=759FFC197353BBFCE1B1DC109DDE108F?lang=eng&sp=1000810&sp=T&sp=1&suite=def+++) **thesis** `houdini` `scad`
* [Creating Abstract Motion Sculptures Through Simulation](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=3101&context=all_theses) **thesis** `clemson`
* [Using Visual Effects as a Creative Tool for Contemporary Art](http://ecollections.scad.edu/iii/cpro/DigitalItemViewPage.external?lang=eng&sp=1003067&sp=T&sp=Pall%2CRk1000005%40%2CQziye+liu&suite=def) **thesis** `houdini` `scad`

### Animation
* [Achieving Real-Time Playback with Production Rigs](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/161/asset/realTime.pdf) **paper** `disney`
* [AutoSpline: animation controls only when and where you need them](https://dl.acm.org/citation.cfm?id=2927439) **paper** `pixar`
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Designing an interaction with an octopus](https://dl.acm.org/citation.cfm?id=2927434) **paper** `pixar`
* [Implicit skinning: real-time skin deformation with contact modeling](https://dl.acm.org/citation.cfm?id=2461960) **paper**
* [MoSh: Motion and Shape Capture from Sparse Markers](http://files.is.tue.mpg.de/black/papers/MoSh.pdf) **paper**
* [Procedural wrinkles generation in the implicit skinning framework](https://dl.acm.org/citation.cfm?id=2820937) **paper** `bournemouth` `mpc`
* [Robust solving of optical motion capture data by denoising](https://dl.acm.org/citation.cfm?id=3201302) **paper**
* [Self-similarity Analysis for Motion Capture Cleaning](https://pdfs.semanticscholar.org/22f4/d088646549a8cafdbd2fe48eeceb6c02a827.pdf) **paper**
* [Sketch to pose in Pixar's presto animation system](https://dl.acm.org/citation.cfm?id=2792583) **paper** `pixar`
* [Smooth Skinning Decomposition with Rigid Bones](http://graphics.cs.uh.edu/wp-content/papers/2012/2012_SA_SSDR_preprint.pdf) **paper**
* [Total Moving Face Reconstruction](http://grail.cs.washington.edu/projects/totalmoving/) **paper**
* [Warping the space around an animated object](http://www.moving-picture.com/UmbracoMedia/6315/warpingthespacearoundanimated-object.pdf) **paper** `mpc`

### Biology & Trees
* [A STUDY OF PROCEDURAL GROWTH ALGORITHMS AND ITS IMPLEMENTATION IN HOUDINI](http://edwardfx.weebly.com/uploads/9/0/7/5/9075896/innovationsreport.pdf) **thesis** `bournemouth` `houdini`
* [A hybrid approach to procedural tree skeletonization](https://dl.acm.org/citation.cfm?id=3085065) **paper** `houdini` `pixar`
* [Algorithmic Beauty Of Plants](http://algorithmicbotany.org/papers/abop/abop.pdf) **book**
* [Applying aggregation over 3D surfaces](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc09/Cashmore/MichaelCashmore-Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Art-directing Disney's Tangled Procedural Trees](http://www.andyselle.com/papers/14/tree-shek.pdf) **paper** `disney`
* [Art-directing procedural vegetation in Houdini using a space colonization algorithm](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc17/01/report.pdf) **thesis** `bournemouth` `houdini`
* [Modeling Trees with a Space Colonization Algorithm](http://algorithmicbotany.org/papers/colonization.egwnp2007.large.pdf) **paper**
* [Modeling and visualization of leaf venation patterns](http://algorithmicbotany.org/papers/venation.sig2005.pdf) **paper**
* [PROCEDURAL GENERATION AND RENDERING OF TREES AND LANDSCAPES IN THE STYLE OF EYVIND EARLE](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/155331/MURPHY-THESIS-2015.pdf?sequence=1&isAllowed=y) **thesis**
* [Simulation of Morphology Changes in Drying Leaves](https://pdfs.semanticscholar.org/bdb0/d459310e04d7167130289e1a80f588d8f111.pdf) **paper**
* [The Jungle Book: art-directing procedural scatters in rich environments](https://dl.acm.org/citation.cfm?id=2947692&dl=ACM&coll=DL) **paper** `mpc`

### CFX
* [A position-based dynamics system for animated character effects](https://dl.acm.org/citation.cfm?id=2614147) **paper** `dwa`
* [Position Based Dynamics for Character Effects](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/12/thesis.pdf) **thesis** `bournemouth` `houdini`

### CG
* [3D Math Primer for Graphics andGame Development](https://www.amazon.com/Math-Primer-Graphics-Game-Development/dp/1568817231) **book**
* [Advanced Animation and Rendering Techniques](https://www.amazon.com/Advanced-Animation-Rendering-Techniques-Alan/dp/0201544121) **book**
* [Computer Graphics - Principles and Practice, 3rd edition](http://dept.cs.williams.edu/~morgan/cgpp/about.xml) **book**
* [Fundamentals of Computer Graphics 3rd ed.](https://www.amazon.com/Fundamentals-Computer-Graphics-Peter-Shirley/dp/1568814690) **book**
* [Learning Modern 3D Graphics Programming](https://paroj.github.io/gltut/) **book**
* [Mathematics for 3D Game Programming and Computer Graphics](https://www.amazon.com/Mathematics-Programming-Computer-Graphics-Third/dp/1435458869) **book**
* [Mathematics for Computer Graphics (Undergraduate Topics in Computer Science)](https://www.amazon.com/Mathematics-Computer-Graphics-Undergraduate-Science/dp/1447173341) **book**
* [Physically Based Rendering FROM THEORY TO IMPLEMENTATION](http://www.pbrt.org/) **book**
* [Texturing and Modeling, Third Edition: A Procedural Approach](https://www.amazon.com/Texturing-Modeling-Third-Procedural-Approach/dp/1558608486) **book**
* [The CG Cinematography](https://chrisbrejon.com/cg-cinematography/) **book**

### Case studies
* [APES & BLOCKS OF FOAM](http://tdforum.eu/pdf/2012OlliRajala_Apes_and_Blocks_of_Foam.pdf) **presentation** `tdforum`
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Fido overview](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture02-FL/sfx2011.pdf) **presentation**
* [Forging a new animation pipeline with USD](https://dl.acm.org/citation.cfm?id=3214779) **paper** `al`
* [Huawei Pegasus & Free Radio 'Hamster'](http://tdforum.eu/pdf/2012_Framestore_Iceland.pdf) **presentation** `tdforum`
* [Rendering Worlds with Two Triangles with raytracing on the GPU](http://www.iquilezles.org/www/material/nvscene2008/rwwtt.pdf) **presentation**
* [The LEGO movie: bricks, bricks and more bricks](https://dl.acm.org/citation.cfm?id=2614179&dl=ACM&coll=DL) **paper**
* [Walter: an open source VFX framework for USD and alembic](https://dl.acm.org/citation.cfm?id=3214772) **paper** `houdini`
* [Zero to USD in 80 days](https://dl.acm.org/citation.cfm?id=3214745.3214816) **paper** `dwa`

### Cities
* [Procedural City Generation and Techniques for Game Designers](http://ecollections.scad.edu/iii/cpro/app?id=7920016702909652&itemId=1002643&lang=eng&service=blob&suite=def+++) **thesis** `houdini` `scad`

### Coding
* [CGAL: the computational geometry algorithms library](https://dl.acm.org/citation.cfm?id=2927362) **paper**
* [Dive Into Python Python from novice to pro](http://www.diveintopython.net/) **book**
* [Extending Houdini with HDK](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO4_handout.pdf) **presentation** `houdini`
* [Game AI Pro](http://gameaipro.com/) **book**
* [Getting started with webGL and three.js](https://dl.acm.org/citation.cfm?id=3214861) **presentation** `nvidia`
* [Learning OpenCV](https://www.amazon.com/Learning-OpenCV-Computer-Vision-Library/dp/0596516134) **book**
* [Programming Computer Vision with Python](http://programmingcomputervision.com/) **book**
* [Rendering Worlds with Two Triangles with raytracing on the GPU](http://www.iquilezles.org/www/material/nvscene2008/rwwtt.pdf) **presentation**
* [State-of-the-art webGL 2.0](https://dl.acm.org/citation.cfm?id=3134479) **presentation** `nvidia`
* [Supercharge Houdini with Python](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO3_handout.pdf) **presentation** `houdini`
* [libigl: prototyping geometry processing research in C++](https://dl.acm.org/citation.cfm?id=3134497) **paper**

### Colors
* [APPLYING COLOR THEORY TO DIGITAL MEDIA & VISUALIZATION](http://media.siggraph.org/education/cgsource/color/TM_Rhyne_Color_Theory_Class_SIGGRAPH_Education_Committee2.pdf) **presentation**
* [Cinematic Color - Visual Effects Society](https://www.visualeffectssociety.com/sites/default/files/files/cinematic_color_ves.pdf) **paper**
* [Color Correction Handbook: Professional Techniques for Video and Cinema](https://www.amazon.com/Color-Correction-Handbook-Professional-Techniques/dp/0321713117) **book**
* [Color in advanced displays: HDR, OLED, AR & VR](https://dl.acm.org/citation.cfm?id=3214840) **presentation**
* [Fundamentals of color science](https://dl.acm.org/citation.cfm?id=3214834.3214846) **paper**
* [OpenColorIO Open Source Color Pipeline](http://www.tdforum.eu/pdf/2011ntfd_ocio_selan.pdf) **presentation** `tdforum`
* [OpenColorIO and its usage with The Academy Color Encoding Specification (ACES) in a modern visual effects pipeline](https://www.hdm-stuttgart.de/vfx/alumni/bamathesis/pdf_016/) **thesis**
* [Procedural Fluid Textures](https://dl.acm.org/citation.cfm?id=3214767) **paper**
* [The Art and Technique of Digital Color Correction](https://www.amazon.com/Art-Technique-Digital-Color-Correction/dp/024081715X) **book**
* [The CG Cinematography](https://chrisbrejon.com/cg-cinematography/) **book**

### Computer Vision
* [Programming Computer Vision with Python](http://programmingcomputervision.com/) **book**

### Crowds
* [A System For Crowd Rendering](http://www.moving-picture.com/UmbracoMedia/6299/asystemcrowd.pdf) **paper** `mpc`
* [Art Directed Ant Crowd Simulation in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc13/08/_assets/i7784427_TusharK_Thesis.pdf) **thesis** `bournemouth` `houdini`
* [CrAM: artist-friendly crowds on "Edge of Tomorrow"](https://dl.acm.org/citation.cfm?id=2614204&dl=ACM&coll=DL) **paper** `spi`
* [Creating the flying armadas in Guardians of the Galaxy](https://dl.acm.org/citation.cfm?id=2614106.2614127) **paper** `mpc`
* [Flexible pipeline for crowd production](https://dl.acm.org/citation.cfm?id=3085042) **paper** `dneg` `houdini`
* [Flocking system mimicking fish school behaviours](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/02/thesis.pdf) **thesis** `bournemouth`
* [Game AI Pro](http://gameaipro.com/) **book**
* [Real-time Simulation and Rendering of Large-scale Crowd Motion](https://ir.canterbury.ac.nz/xmlui/bitstream/handle/10092/7870/thesis_fulltext.pdf?sequence=1&isAllowed=y) **thesis**
* [SCALABLE, CONTROLLABLE, EFFICIENT AND CONVINCING CROWD SIMULATION](http://research.cs.wisc.edu/graphics/Gallery/mksung.vol/FinalDefense/Thesis/thesis.pdf) **thesis**
* [Simulation, Animation and Rendering of Crowds in Real-Time](https://diglib.eg.org/bitstream/handle/10.2312/14394/beacco.pdf?sequence=1&isAllowed=y) **thesis**
* [Stadium Crowd Tool in Houdini with Key-Frameable Motion Controls](http://ecollections.scad.edu/iii/cpro/app?id=9096245370527043&itemId=1002049&lang=eng&service=blob&suite=de) **thesis** `houdini` `scad`
* [Walking Penguins Crowd Simulation](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc14/10/report/MSc%20Thesis.pdf) **thesis** `bournemouth`

### Deep comp
* [Deep Image Compositing @ Nordic TDForum 2011](http://tdforum.eu/pdf/2011ntdf_deepcomp_colindoncaster.pdf) **presentation** `tdforum`
* [Deep image compositing in a modern visual effects pipeline](http://patrickheinen.com/docs/DeepCompositingInVFX_PatrickHeinen_2013.pdf) **thesis**

### Environments
* [Building detailed fractal sets for "Guardians of the Galaxy Vol. 2"](https://dl.acm.org/citation.cfm?id=3085060) **paper** `al` `houdini`
* [Graduation report: Procedural environmental design](http://freek3d.com/downloads/Freek_Hoekstra_Graduation_final_report_Final_PRINTED.pdf) **thesis**
* [PROCEDURAL GENERATION AND RENDERING OF TREES AND LANDSCAPES IN THE STYLE OF EYVIND EARLE](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/155331/MURPHY-THESIS-2015.pdf?sequence=1&isAllowed=y) **thesis**
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [The Jungle Book: art-directing procedural scatters in rich environments](https://dl.acm.org/citation.cfm?id=2947692&dl=ACM&coll=DL) **paper** `mpc`

### Erosion
* [Fast Hydraulic Erosion Simulation and Visualization on GPU](https://hal.inria.fr/inria-00402079/document) **paper**
* [Fast Hydraulic and Thermal Erosion on the GPU](http://old.cescg.org/CESCG-2011/papers/TUBudapest-Jako-Balazs.pdf) **paper**
* [Realtime Procedural Terrain Generation](http://web.mit.edu/cesium/Public/terrain.pdf) **paper**

### FEM
* [Integrating FEA physics in a non-linear workflow for "Edge of Tomorrow"](https://dl.acm.org/citation.cfm?id=2614205&dl=ACM&coll=DL) **paper** `spi`
* [Kali: High Quality FEM Destruction in Zack Snyder's Sucker Punch](http://www.moving-picture.com/UmbracoMedia/6309/kaliehighqualityfem.pdf) **paper** `mpc`

### FX
* [3D Particle in Cell / Fluid Implicit Particle Fluid Solver using OpenMP directives](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc12/Ioannidis/Thesis.pdf) **thesis** `bournemouth` `houdini`
* [A Fluid Implicit Particle Approach to a Pyro Solver in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc11/Ahmad/aghourab_MSc_Thesis_Public.pdf) **thesis** `bournemouth` `houdini`
* [A Multiscale Approach to Mesh-based Surface Tension Flows](https://www.cc.gatech.edu/~turk/my_papers/surface_tension.pdf) **paper**
* [A Programmable System for Artistic Volumetric Lighting](https://www.iro.umontreal.ca/~derek/files/nowrouzezahrai11programmable.pdf) **paper** `disney`
* [A STUDY OF PROCEDURAL GROWTH ALGORITHMS AND ITS IMPLEMENTATION IN HOUDINI](http://edwardfx.weebly.com/uploads/9/0/7/5/9075896/innovationsreport.pdf) **thesis** `bournemouth` `houdini`
* [A hybrid approach to procedural tree skeletonization](https://dl.acm.org/citation.cfm?id=3085065) **paper** `houdini` `pixar`
* [ART DIRECTABLE TORNADOES](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/ETD-TAMU-2011-05-9417/DWIVEDI-THESIS.pdf?sequence=2) **thesis** `houdini`
* [Adaptive Nonlinearity for Collisions in Complex Rod Assemblies](http://www.cs.columbia.edu/cg/adonis/adonis-lowres.pdf) **paper** `disney` `weta`
* [Adaptive tearing and cracking of thin sheets](https://dl.acm.org/citation.cfm?id=2601132) **paper**
* [Applying aggregation over 3D surfaces](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc09/Cashmore/MichaelCashmore-Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Art directing particle flows with custom vector fields](https://dl.acm.org/citation.cfm?id=1401040&dl=ACM&coll=DL) **paper** `r&h`
* [Art directing rigid body dynamics as a post-process](https://dl.acm.org/citation.cfm?id=2614148&dl=ACM&coll=DL) **paper** `dwa`
* [Avalanche! snowy FX for XXX](https://dl.acm.org/citation.cfm?id=965492) **paper** `dd`
* [Building detailed fractal sets for "Guardians of the Galaxy Vol. 2"](https://dl.acm.org/citation.cfm?id=3085060) **paper** `al` `houdini`
* [Capturing Thin Features in Smoke Simulations](http://library.imageworks.com/pdfs/imageworks-library-capturing-thin-features-in-smoke-simulation.pdf) **paper** `spi`
* [Cloud Modeling and Rendering for 'Puss In Boots'](http://ken.museth.org/Publications_files/Miller-etal_SIG12.pdf) **paper** `dwa`
* [Controlling Fluid Simulations with Custom Fields in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc09/Claes/thesis/PeterClaesThesis.pdf) **thesis** `bournemouth` `houdini`
* [Coupling 3D eulerian, heightfield and particle methods for interactive simulation of large scale liquid phenomena](https://dl.acm.org/citation.cfm?id=2849519&dl=ACM&coll=DL) **paper** `nvidia`
* [Creating realistic CG honey](https://dl.acm.org/citation.cfm?id=1280784) **paper** `dwa`
* [Creation of a Procedural Crack Generation Tool](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc11/vigneshwar/Road%20Crack%20GenerationThesis.pdf) **thesis** `bournemouth` `houdini`
* [Diffusion Limited Aggregation Inside 3D Models](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc17/08/report.pdf) **thesis** `bournemouth` `houdini`
* [Efficient and Seamless Volumetric Fracturing](https://research.dreamworks.com/papers/Seamless_Volumetric_Fracturing_DWA_2012.pdf) **paper** `dwa`
* [Environmental FX for Multiple Productions](https://www.cs.clemson.edu/dpa/images/hughthesis.pdf) **thesis** `clemson`
* [Fluid simulation In a visual effects context](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Fluids.pdf) **presentation**
* [Frozen on ice: rendering frost and ice on Frozen](https://dl.acm.org/citation.cfm?id=2614137&dl=ACM&coll=DL) **paper** `disney`
* [GETTING SANDY: CREATING COLLAPSING SAND EFFECTS FOR AN ODE TO LOVE](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2898&context=all_theses) **thesis** `clemson`
* [Geometric fracture modeling in BOLT](http://pages.cs.wisc.edu/~sifakis/papers/bolt_fracture.pdf) **paper** `disney`
* [I Love It When A Cloud Comes Together](https://people.cs.clemson.edu/~jtessen/papers_files/ateamclouds.pdf) **paper** `r&h`
* [Implementation of Artistic Curly Hair Dynamics in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/10/Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Jack's Frost: Controllable Magic Frost Simulations for 'Rise of the Guardians'](http://ken.museth.org/Publications_files/Lipton-etal_SIG13.pdf) **paper** `houdini`
* [Jam: Major Project Report Peter Claes](#) **thesis** `bournemouth` `houdini`
* [Keyframe Control of Smoke Simulations](http://grail.cs.washington.edu/projects/control/smokeControl.pdf) **paper**
* [Large Scale Simulation and Surfacing of Water and Ice Effects in Dragons 2](http://www.museth.org/Ken/Publications_files/Opstal-etal_SIG14.pdf) **paper** `dwa`
* [Levelsets in Production: Spider-Man 3](http://library.imageworks.com/pdfs/imageworks-library-levelsets-in-production-spider-man3.pdf) **paper** `spi`
* [Moana: Foundation of a Lava Monster](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/166/asset/Moana_Foundation_of_a_Lava_Monster.pdf) **paper** `disney` `houdini`
* [Modeling and Animating Gases with Simulation Features](https://engineering.purdue.edu/~ebertd/papers/Schpok_SCA_2005.pdf) **paper**
* [Narrow Band FLIP for Liquid Simulations](https://wwwcg.in.tum.de/fileadmin/user_upload/Lehrstuehle/Lehrstuhl_XV/Research/Publications/2016/NBFlip/nbflip.pdf) **paper**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [OpenGL GPU Features and SPH Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/13/thesis.pdf) **thesis** `bournemouth`
* [Particle Expansion Tool](http://ecollections.scad.edu/iii/cpro/app?id=3306447068130864&itemId=1002089&lang=eng&service=blob&suite=de) **thesis** `houdini` `scad`
* [Physical Simulation of Fire and Smoke Masters Thesis](https://nccastaff.bmth.ac.uk/jmacey/MastersProjects/MSc07/DavidMinor/MSc%20Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Position Based Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/09/mpthesis.pdf) **thesis** `bournemouth` `houdini`
* [Procedural Fluid Textures](https://dl.acm.org/citation.cfm?id=3214767) **paper**
* [Racing to the finish line: effects challenges on Cars 3](https://dl.acm.org/citation.cfm?id=3085160&dl=ACM&coll=DL) **paper** `houdini` `pixar`
* [Real-Time Fluid Dynamics for Games](https://pdfs.semanticscholar.org/847f/819a4ea14bd789aca8bc88e85e906cfc657c.pdf) **paper**
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [SIMULATION OF THE MIXING OF INK AND WATER IN HOUDINI](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=1937&context=all_theses) **thesis** `clemson` `houdini`
* [Screen Space Fluid Rendering for Games](http://developer.download.nvidia.com/presentations/2010/gdc/Direct3D_Effects.pdf) **paper** `nvidia`
* [Shaping particle simulations with interaction forces](https://dl.acm.org/citation.cfm?id=2614121) **paper** `dwa`
* [Smooth Skinning Decomposition with Rigid Bones](http://graphics.cs.uh.edu/wp-content/papers/2012/2012_SA_SSDR_preprint.pdf) **paper**
* [Star Wars: The Last Jedi - effects simulation](https://dl.acm.org/citation.cfm?id=3214778) **paper** `houdini` `ilm`
* [THE EXPLOSION EFFECT- A Custom Volume FX Production Pipeline](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2435&context=all_theses) **thesis** `clemson` `houdini`
* [Target-Driven Smoke Animation](http://www.cs.huji.ac.il/labs/cglab/projects/tdsmoke/tdsmoke.pdf) **paper**
* [The effects of The Jungle Book](https://dl.acm.org/citation.cfm?id=2927413) **paper** `houdini` `mpc`
* [The water effects of Pirates of the Caribbean: Dead Men Tell no Tales](https://dl.acm.org/citation.cfm?id=3085044) **paper** `houdini` `mpc`
* [Volume Rendering for Visual Effects](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Volume_Rendering.pdf) **presentation**
* [Vortex of Awesomeness](http://research.dreamworks.com/papers/PussInBoots_Tornado_DWA_2012.pdf) **paper** `dwa`
* [Wrath of the Titans: complex models with voxel greeble](https://dl.acm.org/citation.cfm?id=2343106&dl=ACM&coll=DL) **paper** `method`
* [Wrath of the Titans: creating CG lava with advected sculpts](https://dl.acm.org/citation.cfm?id=2343107&dl=ACM&coll=DL) **paper** `method`

### Fluids
* [3D Particle in Cell / Fluid Implicit Particle Fluid Solver using OpenMP directives](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc12/Ioannidis/Thesis.pdf) **thesis** `bournemouth` `houdini`
* [A Fluid Implicit Particle Approach to a Pyro Solver in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc11/Ahmad/aghourab_MSc_Thesis_Public.pdf) **thesis** `bournemouth` `houdini`
* [A Technique for Art Direction of Physically Based Fire Simulation](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2178&context=all_theses) **thesis** `clemson`
* [ART DIRECTABLE TORNADOES](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/ETD-TAMU-2011-05-9417/DWIVEDI-THESIS.pdf?sequence=2) **thesis** `houdini`
* [Art directing particle flows with custom vector fields](https://dl.acm.org/citation.cfm?id=1401040&dl=ACM&coll=DL) **paper** `r&h`
* [Avalanche! snowy FX for XXX](https://dl.acm.org/citation.cfm?id=965492) **paper** `dd`
* [Capturing Thin Features in Smoke Simulations](http://library.imageworks.com/pdfs/imageworks-library-capturing-thin-features-in-smoke-simulation.pdf) **paper** `spi`
* [Controlling Fluid Simulations with Custom Fields in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc09/Claes/thesis/PeterClaesThesis.pdf) **thesis** `bournemouth` `houdini`
* [Fluid simulation In a visual effects context](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Fluids.pdf) **presentation**
* [I Love It When A Cloud Comes Together](https://people.cs.clemson.edu/~jtessen/papers_files/ateamclouds.pdf) **paper** `r&h`
* [Keyframe Control of Smoke Simulations](http://grail.cs.washington.edu/projects/control/smokeControl.pdf) **paper**
* [Moana: Foundation of a Lava Monster](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/166/asset/Moana_Foundation_of_a_Lava_Monster.pdf) **paper** `disney` `houdini`
* [Modeling and Animating Gases with Simulation Features](https://engineering.purdue.edu/~ebertd/papers/Schpok_SCA_2005.pdf) **paper**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [Physical Simulation of Fire and Smoke Masters Thesis](https://nccastaff.bmth.ac.uk/jmacey/MastersProjects/MSc07/DavidMinor/MSc%20Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Racing to the finish line: effects challenges on Cars 3](https://dl.acm.org/citation.cfm?id=3085160&dl=ACM&coll=DL) **paper** `houdini` `pixar`
* [Real-Time Fluid Dynamics for Games](https://pdfs.semanticscholar.org/847f/819a4ea14bd789aca8bc88e85e906cfc657c.pdf) **paper**
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [Star Wars: The Last Jedi - effects simulation](https://dl.acm.org/citation.cfm?id=3214778) **paper** `houdini` `ilm`
* [Target-Driven Smoke Animation](http://www.cs.huji.ac.il/labs/cglab/projects/tdsmoke/tdsmoke.pdf) **paper**
* [The Implementation of 2D Fluid Solver plugin for Houdini8.0](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc07/MyaWin/mwin_thesis.pdf) **thesis** `bournemouth` `houdini`
* [The effects of The Jungle Book](https://dl.acm.org/citation.cfm?id=2927413) **paper** `houdini` `mpc`
* [The water effects of Pirates of the Caribbean: Dead Men Tell no Tales](https://dl.acm.org/citation.cfm?id=3085044) **paper** `houdini` `mpc`
* [Volume Rendering for Visual Effects](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Volume_Rendering.pdf) **presentation**

### Fractals
* [Building detailed fractal sets for "Guardians of the Galaxy Vol. 2"](https://dl.acm.org/citation.cfm?id=3085060) **paper** `al` `houdini`
* [Fractal anatomy: imaging internal and ambient structures](https://dl.acm.org/citation.cfm?id=3230748) **paper**
* [Fractal multiverses in VR](https://dl.acm.org/citation.cfm?id=3214813) **paper** `framestore`

### Fur & Feathers
* [Adaptive Nonlinearity for Collisions in Complex Rod Assemblies](http://www.cs.columbia.edu/cg/adonis/adonis-lowres.pdf) **paper** `disney` `weta`
* [An Energy-Conserving Hair Reflectance Model](http://www.eugenedeon.com/wp-content/uploads/2014/04/egsrhair.pdf) **paper** `weta`
* [Building Efficient Fur Pipeline for a Low Cost Production of Creature-based Feature Film](http://graphics.snu.ac.kr/publications/conference_proceedings/12_Building_Efficient_Fur_Pipeline_for_a_Low_Cost_Production_of_Creature_based_Feature_Film.pdf) **paper**
* [Feathers for Mystical Creatures: Creating Pegasus for Clash of the Titans](http://www.moving-picture.com/UmbracoMedia/6300/feathersformysticalcreatures.pdf) **paper** `mpc`
* [Furtility: Dynamic Grooming for Wolfman](http://www.moving-picture.com/UmbracoMedia/6301/furtilitydynamicwolfman.pdf) **paper** `mpc`
* [Implementation of Artistic Curly Hair Dynamics in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/10/Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Volumetric Methods for Simulation and Rendering of Hair](https://graphics.pixar.com/library/Hair/paper.pdf) **paper** `pixar`

### History
* [Brief History of Special Effects in Film](http://people.uncw.edu/pattersone/resources/notes/DSFX_History.pdf) **presentation**
* [Fido overview](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture02-FL/sfx2011.pdf) **presentation**
* [SFX - Tricks of the Trade The Beginning 1895-2006](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture02-FL/fo1_Extended_history.pdf) **paper**

### Lighting & Rendering
* [3D Fractal Flame Wisps](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2704&context=all_theses) **thesis** `clemson`
* [A Comprehensive Framework for Rendering Layered Materials](http://www.cs.cornell.edu/projects/layered-sg14/layered.pdf) **paper** `weta`
* [A System For Crowd Rendering](http://www.moving-picture.com/UmbracoMedia/6299/asystemcrowd.pdf) **paper** `mpc`
* [Advanced Animation and Rendering Techniques](https://www.amazon.com/Advanced-Animation-Rendering-Techniques-Alan/dp/0201544121) **book**
* [Advanced RenderMan 2: To RI_INFINITY and Beyond SIGGRAPH 2000 Course](http://silviojemma.com/public/papers/lighting/infbeyond.pdf) **paper** `disney` `pixar` `spi`
* [Advanced Scenegraph Rendering Pipeline](http://on-demand.gputechconf.com/gtc/2013/presentations/S3032-Advanced-Scenegraph-Rendering-Pipeline.pdf) **presentation**
* [An Artist-Friendly Workflow for Panoramic HDRI](https://blog.selfshadow.com/publications/s2016-shading-course/unity/s2016_pbs_unity_hdri.pdf) **presentation**
* [An Energy-Conserving Hair Reflectance Model](http://www.eugenedeon.com/wp-content/uploads/2014/04/egsrhair.pdf) **paper** `weta`
* [Background: Physics and Math of Shading](https://pdfs.semanticscholar.org/c4e6/f55a19fa7c108f934f201ae97eedf90cefef.pdf) **paper**
* [Building Efficient Fur Pipeline for a Low Cost Production of Creature-based Feature Film](http://graphics.snu.ac.kr/publications/conference_proceedings/12_Building_Efficient_Fur_Pipeline_for_a_Low_Cost_Production_of_Creature_based_Feature_Film.pdf) **paper**
* [Building detailed fractal sets for "Guardians of the Galaxy Vol. 2"](https://dl.acm.org/citation.cfm?id=3085060) **paper** `al` `houdini`
* [CLOUDS AND RIMS](http://tdforum.eu/pdf/2012KustaaVuori_cloudsAndRims.pdf) **presentation** `tdforum`
* [Camera Space Volumetric Shadows](https://jo.dreggn.org/home/2012_camera_space.pdf) **paper** `weta`
* [Capture Color and Depth From All Around of A Live Set](http://ecollections.scad.edu/iii/cpro/DigitalItemViewPage.external;jsessionid=ABD0B1B0DDCA193A6F981612E6605AFE?lang=eng&sp=1002062&sp=T&sp=1&suite=def+++) **thesis** `scad`
* [Capturing the infinite universe in "Lucy": fractal rendering in film production](https://dl.acm.org/citation.cfm?id=2614166) **paper** `ilm`
* [Cloud Modeling and Rendering for 'Puss In Boots'](http://ken.museth.org/Publications_files/Miller-etal_SIG12.pdf) **paper** `dwa`
* [Cloudy with a chance of rendering](https://dl.acm.org/citation.cfm?id=3084363.3085041) **paper** `mpc`
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Effective Toon-Style Rendering Control Using Scalar Fields](https://graphics.pixar.com/library/ToonRendering/paper.pdf) **paper** `pixar`
* [Fully automatic ID mattes with support for motion blur and transparency](https://github.com/Psyop/Cryptomatte/raw/master/specification/IDmattes_poster.pdf) **paper**
* [Gaffer: an open-source application framework for VFX](https://dl.acm.org/citation.cfm?id=2947696) **paper** [[video]](https://vimeo.com/201047816)
* [Geometry into Shading](https://graphics.pixar.com/library/BumpRoughness/paper.pdf) **paper** `pixar`
* [Graphics Shaders: Theory and Practice](http://cs.uns.edu.ar/cg/clasespdf/GraphicShaders.pdf) **book**
* [HYDRA Pixar's Real-Time Render Engine for Feature Film Assets](http://on-demand.gputechconf.com/gtc/2015/presentation/S5327-Jeremy-Cowles.pdf) **presentation** `pixar`
* [High-contrast Computational Caustic Design](http://lgg.epfl.ch/publications/2014/Caustics/) **paper**
* [Instant Points: Fast Rendering of Unprocessed Point Clouds](http://silviojemma.com/public/papers/lighting/FastRenderingOfUnprocessedPointClouds.WIMMER-2006-IP.pdf) **paper**
* [Interactive Lighting of Effects Using Point Clouds in "BOLT"](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/68/asset/InteractiveLightingEffects_S2009.pdf) **presentation** `disney`
* [Learning Modern 3D Graphics Programming](https://paroj.github.io/gltut/) **book**
* [MANIFOLD NEXT EVENT ESTIMATION](https://jo.dreggn.org/home/2015_mnee_talk.pdf) **presentation** `weta`
* [Machine learning and rendering](https://dl.acm.org/citation.cfm?id=3214841) **paper** `disney` `nvidia`
* [Manifold Exploration: A Markov Chain Monte Carlo Technique for Rendering Scenes with Difficult Specular Transport](http://www.cs.cornell.edu/projects/manifolds-sg12/manifolds-sg12.pdf) **paper**
* [Measuring and Modeling the Appearance of Finished Wood](http://silviojemma.com/public/papers/lighting/sg05-shadingWood-lr.pdf) **paper**
* [Multiple-Scattering Microfacet BSDFs with the Smith Model](https://jo.dreggn.org/home/2015_microfacets.pdf) **paper**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [PROCEDURAL GENERATION AND RENDERING OF TREES AND LANDSCAPES IN THE STYLE OF EYVIND EARLE](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/155331/MURPHY-THESIS-2015.pdf?sequence=1&isAllowed=y) **thesis**
* [Parallel Processing within a Host Application](http://www.multithreadingandvfx.org/course_notes/2017/disney_MultiThreading_SIGGRAPH2017.pdf) **presentation** `disney`
* [Photogrammetry Workflow](https://unity3d.com/files/solutions/photogrammetry/Unity-Photogrammetry-Workflow_2017-07_v2.pdf) **book** [[video]](https://www.youtube.com/watch?v=Ny9ZXt_2v2Y)
* [Physically Based Rendering FROM THEORY TO IMPLEMENTATION](http://www.pbrt.org/) **book**
* [Point-Based Approximate Color Bleeding](https://graphics.pixar.com/library/PointBasedColorBleeding/paper.pdf) **paper** `pixar`
* [Point-Based Color Bleeding](https://graphics.pixar.com/library/PointBasedColorBleeding/SlidesFromAnnecy09.pdf) **presentation** `pixar`
* [Point-Based Global Illumination for Movie Production](https://graphics.pixar.com/library/PointBasedGlobalIlluminationForMovieProduction/paper.pdf) **paper** `pixar`
* [Production Volume Rendering: Design and Implementation](https://www.amazon.com/Production-Rendering-Implementation-Magnus-Wrenninge/dp/156881724X) **book**
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Real-World Measurements for Call of Duty: Advanced Warfare](https://www.activision.com/cdn/research/Real_World_Measurements_for_Call_of_Duty_Advanced_Warfare.pdf) **paper**
* [Realistic, Hardware-accelerated Shading and Lighting](http://silviojemma.com/public/papers/lighting/ShadingLighting.Siggraph.99.pdf) **paper**
* [Rendering Worlds with Two Triangles with raytracing on the GPU](http://www.iquilezles.org/www/material/nvscene2008/rwwtt.pdf) **presentation**
* [Renderman Point Based Effects Lighting Approach](http://ecollections.scad.edu/iii/cpro/app?id=7255011066541100&itemId=1001416&lang=...&service=blob&suite=def) **thesis** `houdini` `scad`
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [Screen Space Fluid Rendering for Games](http://developer.download.nvidia.com/presentations/2010/gdc/Direct3D_Effects.pdf) **paper** `nvidia`
* [Separable Subsurface Scattering](http://www.iryoku.com/separable-sss/) **paper**
* [Sky Browser: Search for HDR Sky Maps](http://computergraphics.ac.nz/assets/research/SkyBrowser.pdf) **paper** `weta`
* [Spherical Harmonic Lighting: The Gritty Details](http://silviojemma.com/public/papers/lighting/spherical-harmonic-lighting.pdf) **paper**
* [Stupid Spherical Harmonics (SH) Tricks](http://silviojemma.com/public/papers/lighting/StupidSphericalHarmonics36.pdf) **paper**
* [Technical Art of Uncharted 4](http://advances.realtimerendering.com/other/2016/naughty_dog/NaughtyDog_TechArt_Final.pdf) **presentation**
* [The CG Cinematography](https://chrisbrejon.com/cg-cinematography/) **book**
* [The Path to Path-Traced Movies](https://graphics.pixar.com/library/PathTracedMovies/paper.pdf) **paper** `pixar`
* [The path tracing revolution in the movie industry](https://sites.google.com/site/pathtracingrevolution/) **presentation** `disney` `nvidia` `pixar` `weta`
* [The water effects of Pirates of the Caribbean: Dead Men Tell no Tales](https://dl.acm.org/citation.cfm?id=3085044) **paper** `houdini` `mpc`
* [Using raycasting in GPU shaders to enhance real-time graphics](http://www.proun-game.com/Oogst3D/ARTICLES/Using%20raycasting%20in%20GPU%20shaders%20to%20enhance%20real-time%20graphics.pdf) **thesis**
* [Visualizing Astronomical Data in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc17/07/report.pdf) **thesis** `bournemouth` `houdini`
* [Volume Rendering for Visual Effects](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Volume_Rendering.pdf) **presentation**
* [Volumetric Methods for Simulation and Rendering of Hair](https://graphics.pixar.com/library/Hair/paper.pdf) **paper** `pixar`

### Liquids
* [A Fluid Implicit Particle (FLIP) Solver Built in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/01/thesis.pdf) **thesis** `bournemouth` `houdini`
* [A Multiscale Approach to Mesh-based Surface Tension Flows](https://www.cc.gatech.edu/~turk/my_papers/surface_tension.pdf) **paper**
* [Art Directed Fluid Flow With Secondary Water Effects](https://www.diva-portal.org/smash/get/diva2:559073/FULLTEXT01.pdf) **thesis**
* [Combining Rigid and Fluid Motion Using Point Clouds and FLIP Fluids](http://ecollections.scad.edu/iii/cpro/app?id=2536695579707187&itemId=1001581&lang=eng&service=blob&suite=def) **thesis** `houdini` `scad`
* [Coupling 3D eulerian, heightfield and particle methods for interactive simulation of large scale liquid phenomena](https://dl.acm.org/citation.cfm?id=2849519&dl=ACM&coll=DL) **paper** `nvidia`
* [Creating realistic CG honey](https://dl.acm.org/citation.cfm?id=1280784) **paper** `dwa`
* [Highly Detailed Fluid Simulations on the GPU](http://webstaff.itn.liu.se/~jonun/web/teaching/2010-TNCG13/Lectures/OceansWithMathMattias.pdf) **presentation**
* [Interactive Water Surfaces](https://people.cs.clemson.edu/~jtessen/papers_files/Interactive_Water_Surfaces.pdf) **paper** `r&h`
* [Jam: Major Project Report Peter Claes](#) **thesis** `bournemouth` `houdini`
* [Large Scale Simulation and Surfacing of Water and Ice Effects in Dragons 2](http://www.museth.org/Ken/Publications_files/Opstal-etal_SIG14.pdf) **paper** `dwa`
* [Narrow Band FLIP for Liquid Simulations](https://wwwcg.in.tum.de/fileadmin/user_upload/Lehrstuehle/Lehrstuhl_XV/Research/Publications/2016/NBFlip/nbflip.pdf) **paper**
* [OpenGL GPU Features and SPH Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/13/thesis.pdf) **thesis** `bournemouth`
* [Packing the water pipe](https://dl.acm.org/citation.cfm?id=2614106.2614203) **paper** `dneg`
* [Position Based Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/09/mpthesis.pdf) **thesis** `bournemouth` `houdini`
* [Racing to the finish line: effects challenges on Cars 3](https://dl.acm.org/citation.cfm?id=3085160&dl=ACM&coll=DL) **paper** `houdini` `pixar`
* [Rat-Sized Water Effects in Ratatouille](https://graphics.pixar.com/library/RatSizedWater/paper.pdf) **paper** `pixar`
* [SIMULATION OF THE MIXING OF INK AND WATER IN HOUDINI](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=1937&context=all_theses) **thesis** `clemson` `houdini`
* [SPH Fluid simulation](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sph_slides.pdf) **presentation**
* [Screen Space Fluid Rendering for Games](http://developer.download.nvidia.com/presentations/2010/gdc/Direct3D_Effects.pdf) **paper** `nvidia`
* [Shaping particle simulations with interaction forces](https://dl.acm.org/citation.cfm?id=2614121) **paper** `dwa`
* [Simulating Whitewater Rapids in Ratatouille](https://graphics.pixar.com/library/Whitewater/paper.pdf) **paper** `pixar`
* [Tangled Choreographing Destruction: Art Directing a Dam Break](http://www.andyselle.com/papers/16/tangled-water.pdf) **paper** `disney`
* [The effects of The Jungle Book](https://dl.acm.org/citation.cfm?id=2927413) **paper** `houdini` `mpc`
* [The water effects of Pirates of the Caribbean: Dead Men Tell no Tales](https://dl.acm.org/citation.cfm?id=3085044) **paper** `houdini` `mpc`
* [Wrath of the Titans: creating CG lava with advected sculpts](https://dl.acm.org/citation.cfm?id=2343107&dl=ACM&coll=DL) **paper** `method`

### Machine Learning
* [Big data visual analytics: fundamentals, techniques, and tools](https://dl.acm.org/citation.cfm?id=3134516) **presentation**
* [Deep Learning](https://www.deeplearningbook.org/) **book**
* [Deep learning: a crash course](https://dl.acm.org/citation.cfm?id=3214856) **presentation**
* [Machine learning and rendering](https://dl.acm.org/citation.cfm?id=3214841) **paper** `disney` `nvidia`
* [Programming Computer Vision with Python](http://programmingcomputervision.com/) **book**
* [Robust solving of optical motion capture data by denoising](https://dl.acm.org/citation.cfm?id=3201302) **paper**
* [Self-similarity Analysis for Motion Capture Cleaning](https://pdfs.semanticscholar.org/22f4/d088646549a8cafdbd2fe48eeceb6c02a827.pdf) **paper**

### Maths
* [3D Math Primer for Graphics andGame Development](https://www.amazon.com/Math-Primer-Graphics-Game-Development/dp/1568817231) **book**
* [An elementary introduction to matrix exponential for CG](https://dl.acm.org/citation.cfm?doid=2897826.2927338) **paper**
* [Big data visual analytics: fundamentals, techniques, and tools](https://dl.acm.org/citation.cfm?id=3134516) **presentation**
* [CGAL: the computational geometry algorithms library](https://dl.acm.org/citation.cfm?id=2927362) **paper**
* [Color in advanced displays: HDR, OLED, AR & VR](https://dl.acm.org/citation.cfm?id=3214840) **presentation**
* [Deep Learning](https://www.deeplearningbook.org/) **book**
* [Deep learning: a crash course](https://dl.acm.org/citation.cfm?id=3214856) **presentation**
* [Fundamentals of color science](https://dl.acm.org/citation.cfm?id=3214834.3214846) **paper**
* [Getting started with webGL and three.js](https://dl.acm.org/citation.cfm?id=3214861) **presentation** `nvidia`
* [Machine learning and rendering](https://dl.acm.org/citation.cfm?id=3214841) **paper** `disney` `nvidia`
* [Mathematics for 3D Game Programming and Computer Graphics](https://www.amazon.com/Mathematics-Programming-Computer-Graphics-Third/dp/1435458869) **book**
* [Mathematics for Computer Graphics (Undergraduate Topics in Computer Science)](https://www.amazon.com/Mathematics-Computer-Graphics-Undergraduate-Science/dp/1447173341) **book**
* [Programming Computer Vision with Python](http://programmingcomputervision.com/) **book**
* [State-of-the-art webGL 2.0](https://dl.acm.org/citation.cfm?id=3134479) **presentation** `nvidia`
* [libigl: prototyping geometry processing research in C++](https://dl.acm.org/citation.cfm?id=3134497) **paper**

### Misc
* [Procedural Generation of Rock Piles using Aperiodic Tiling](https://pdfs.semanticscholar.org/1c1a/1da6faa24826ac76a5e1f0edc6e1a401faa3.pdf) **paper**
* [Total Moving Face Reconstruction](http://grail.cs.washington.edu/projects/totalmoving/) **paper**

### Motion Capture
* [Robust solving of optical motion capture data by denoising](https://dl.acm.org/citation.cfm?id=3201302) **paper**
* [Self-similarity Analysis for Motion Capture Cleaning](https://pdfs.semanticscholar.org/22f4/d088646549a8cafdbd2fe48eeceb6c02a827.pdf) **paper**

### Oceans
* [A VFX ocean toolkit with real time preview](http://www.diva-portal.org/smash/get/diva2:272268/FULLTEXT02) **thesis**
* [Creating oceans using math](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO2_handout.pdf) **presentation**
* [Empirical directional wave spectra for computer graphics](http://dutch360hdr.com/downloads/other/EmpiricalDirectionalWaveSpectra_DigiPro2015_Jun20_2015.pdf) **paper**
* [The water effects of Pirates of the Caribbean: Dead Men Tell no Tales](https://dl.acm.org/citation.cfm?id=3085044) **paper** `houdini` `mpc`

### PBD
* [A position-based dynamics system for animated character effects](https://dl.acm.org/citation.cfm?id=2614147) **paper** `dwa`
* [Position Based Dynamics for Character Effects](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/12/thesis.pdf) **thesis** `bournemouth` `houdini`
* [Position Based Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/09/mpthesis.pdf) **thesis** `bournemouth` `houdini`

### Photogrammetry
* [An Artist-Friendly Workflow for Panoramic HDRI](https://blog.selfshadow.com/publications/s2016-shading-course/unity/s2016_pbs_unity_hdri.pdf) **presentation**
* [Photogrammetry Workflow](https://unity3d.com/files/solutions/photogrammetry/Unity-Photogrammetry-Workflow_2017-07_v2.pdf) **book** [[video]](https://www.youtube.com/watch?v=Ny9ZXt_2v2Y)

### Pipeline
* [A Pipeline for 800+ shots](http://www.moving-picture.com/UmbracoMedia/6303/800pipeline.pdf) **paper** `mpc`
* [Advanced Scenegraph Rendering Pipeline](http://on-demand.gputechconf.com/gtc/2013/presentations/S3032-Advanced-Scenegraph-Rendering-Pipeline.pdf) **presentation**
* [BUILDING AND LEVERAGING A CROSS PLATFORM VFX/ANIMATION DEVELOPMENT ENVIRONMENT](http://tdforum.eu/pdf/2012ColinDoncaster_TDForum.pdf) **presentation** `tdforum`
* [Can We Solve the Pipeline Problem?](https://researchspace.auckland.ac.nz/bitstream/handle/2292/23903/471Cris.pdf?sequence=1) **paper** `weta`
* [Cloudy with a chance of rendering](https://dl.acm.org/citation.cfm?id=3084363.3085041) **paper** `mpc`
* [Cortex Open Source Framework](http://image-engine.com/randd/siggraph-2011-birds-of-a-feather-presentation/) **video**
* [Developing a unified pipeline with character](https://dl.acm.org/citation.cfm?id=2491837) **paper**
* [Extending Houdini with HDK](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO4_handout.pdf) **presentation** `houdini`
* [Flexible pipeline for crowd production](https://dl.acm.org/citation.cfm?id=3085042) **paper** `dneg` `houdini`
* [Forging a new animation pipeline with USD](https://dl.acm.org/citation.cfm?id=3214779) **paper** `al`
* [Fully automatic ID mattes with support for motion blur and transparency](https://github.com/Psyop/Cryptomatte/raw/master/specification/IDmattes_poster.pdf) **paper**
* [Gaffer: an open-source application framework for VFX](https://dl.acm.org/citation.cfm?id=2947696) **paper** [[video]](https://vimeo.com/201047816)
* [HYDRA Pixar's Real-Time Render Engine for Feature Film Assets](http://on-demand.gputechconf.com/gtc/2015/presentation/S5327-Jeremy-Cowles.pdf) **presentation** `pixar`
* [Large scale VFX pipelines](https://dl.acm.org/citation.cfm?id=2947689) **paper** `weta`
* [Managing thousands of assets for the Prince of Persia city of Alamut](http://www.moving-picture.com/UmbracoMedia/6302/managingthousandofassetsprincepersia.pdf) **paper** `mpc`
* [Packing the water pipe](https://dl.acm.org/citation.cfm?id=2614106.2614203) **paper** `dneg`
* [Parallel Processing within a Host Application](http://www.multithreadingandvfx.org/course_notes/2017/disney_MultiThreading_SIGGRAPH2017.pdf) **presentation** `disney`
* [Production Pipeline Fundamentals for Film and Games](https://www.amazon.ca/dp/0415812291/) **book**
* [Supercharge Houdini with Python](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO3_handout.pdf) **presentation** `houdini`
* [USD-Based Pipeline (2016)](https://vimeo.com/188191100) **video**
* [Universal Scene Description](https://graphics.pixar.com/usd/files/USD_2013_07_pdf.pdf) **presentation** `pixar`
* [Walter: an open source VFX framework for USD and alembic](https://dl.acm.org/citation.cfm?id=3214772) **paper** `houdini`
* [Zero to USD in 80 days](https://dl.acm.org/citation.cfm?id=3214745.3214816) **paper** `dwa`

### Production
* [CG 101 CG/VFX Production Theory](http://www.tdforum.eu/pdf/ntdf2013_CG_101.pdf) **presentation** `tdforum`
* [Complexity, Productivity, Efficiency and Cost in Digital Production](http://tdforum.eu/pdf/2012ComplexityProductivityAndEfficncy.pdf) **presentation** `tdforum`
* [Fido overview](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture02-FL/sfx2011.pdf) **presentation**
* [Outsourcing And Its Pipes](http://www.tdforum.eu/pdf/2012OutsourcingAndItsPipes.pdf) **presentation** `tdforum`
* [Production Pipeline Fundamentals for Film and Games](https://www.amazon.ca/dp/0415812291/) **book**
* [SFX - Tricks of the Trade 2009](http://staffwww.itn.liu.se/~jonun/web/teaching/2009-TNCG13/Slides/sfxFO1_v2_handout.pdf) **presentation**

### RBD
* [Accelerating Rigid Body Simulationon Today's GPUs](http://bulletphysics.org/siggraph2011/takahiro_siggraph2011.pdf) **presentation**
* [An Object-Level Destruction Tool in Houdini](http://ecollections.scad.edu/iii/cpro/app?id=9902073086662988&itemId=1001586&lang=eng&service=blob&suite=de) **thesis** `houdini` `scad`
* [Art directing rigid body dynamics as a post-process](https://dl.acm.org/citation.cfm?id=2614148&dl=ACM&coll=DL) **paper** `dwa`
* [Authoring destruction with the Dynamica Bullet Maya plugin](http://bulletphysics.org/siggraph2011/michael_siggraph2011.pdf) **presentation** `disney`
* [Avatar : Bending Rigid Bodies](http://physbam.stanford.edu/~mlentine/images/deformingrigids.pdf) **paper** `ilm`
* [Course introduction and overview of destruction and dynamics techniques](http://bulletphysics.org/siggraph2011/erwin_intro_siggraph2011.pdf) **presentation**
* [Destruction System](https://dl.acm.org/citation.cfm?id=1401123) **paper** `ilm`
* [Elastic and Plastic Deformations with Rigid Body Dynamics](http://www.nafees.net/siggraph/budsberg-deformable_solids.pdf) **paper** `dwa`
* [Procedural Methods For Large Scale Destruction](http://bulletphysics.org/siggraph2011/nafees_siggraph2011.pdf) **presentation** `dd` `dwa`
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [Star Wars: The Last Jedi - effects simulation](https://dl.acm.org/citation.cfm?id=3214778) **paper** `houdini` `ilm`
* [Transformers 2: Breaking Buildings](#) **paper** `ilm`

### Realtime
* [A VFX ocean toolkit with real time preview](http://www.diva-portal.org/smash/get/diva2:272268/FULLTEXT02) **thesis**
* [Accelerating Rigid Body Simulationon Today's GPUs](http://bulletphysics.org/siggraph2011/takahiro_siggraph2011.pdf) **presentation**
* [Achieving Real-Time Playback with Production Rigs](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/161/asset/realTime.pdf) **paper** `disney`
* [An Artist-Friendly Workflow for Panoramic HDRI](https://blog.selfshadow.com/publications/s2016-shading-course/unity/s2016_pbs_unity_hdri.pdf) **presentation**
* [Coupling 3D eulerian, heightfield and particle methods for interactive simulation of large scale liquid phenomena](https://dl.acm.org/citation.cfm?id=2849519&dl=ACM&coll=DL) **paper** `nvidia`
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Fast Hydraulic Erosion Simulation and Visualization on GPU](https://hal.inria.fr/inria-00402079/document) **paper**
* [Fast Hydraulic and Thermal Erosion on the GPU](http://old.cescg.org/CESCG-2011/papers/TUBudapest-Jako-Balazs.pdf) **paper**
* [Fractal multiverses in VR](https://dl.acm.org/citation.cfm?id=3214813) **paper** `framestore`
* [Getting started with webGL and three.js](https://dl.acm.org/citation.cfm?id=3214861) **presentation** `nvidia`
* [Graphics Shaders: Theory and Practice](http://cs.uns.edu.ar/cg/clasespdf/GraphicShaders.pdf) **book**
* [HYDRA Pixar's Real-Time Render Engine for Feature Film Assets](http://on-demand.gputechconf.com/gtc/2015/presentation/S5327-Jeremy-Cowles.pdf) **presentation** `pixar`
* [Highly Detailed Fluid Simulations on the GPU](http://webstaff.itn.liu.se/~jonun/web/teaching/2010-TNCG13/Lectures/OceansWithMathMattias.pdf) **presentation**
* [Interactive Water Surfaces](https://people.cs.clemson.edu/~jtessen/papers_files/Interactive_Water_Surfaces.pdf) **paper** `r&h`
* [Learning Modern 3D Graphics Programming](https://paroj.github.io/gltut/) **book**
* [Mathematics for 3D Game Programming and Computer Graphics](https://www.amazon.com/Mathematics-Programming-Computer-Graphics-Third/dp/1435458869) **book**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [OpenGL GPU Features and SPH Fluid](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc16/13/thesis.pdf) **thesis** `bournemouth`
* [Parallel Processing within a Host Application](http://www.multithreadingandvfx.org/course_notes/2017/disney_MultiThreading_SIGGRAPH2017.pdf) **presentation** `disney`
* [Photogrammetry Workflow](https://unity3d.com/files/solutions/photogrammetry/Unity-Photogrammetry-Workflow_2017-07_v2.pdf) **book** [[video]](https://www.youtube.com/watch?v=Ny9ZXt_2v2Y)
* [Real-Time Fluid Dynamics for Games](https://pdfs.semanticscholar.org/847f/819a4ea14bd789aca8bc88e85e906cfc657c.pdf) **paper**
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Real-World Measurements for Call of Duty: Advanced Warfare](https://www.activision.com/cdn/research/Real_World_Measurements_for_Call_of_Duty_Advanced_Warfare.pdf) **paper**
* [Real-time Simulation and Rendering of Large-scale Crowd Motion](https://ir.canterbury.ac.nz/xmlui/bitstream/handle/10092/7870/thesis_fulltext.pdf?sequence=1&isAllowed=y) **thesis**
* [Realtime Procedural Terrain Generation](http://web.mit.edu/cesium/Public/terrain.pdf) **paper**
* [Rendering Worlds with Two Triangles with raytracing on the GPU](http://www.iquilezles.org/www/material/nvscene2008/rwwtt.pdf) **presentation**
* [Screen Space Fluid Rendering for Games](http://developer.download.nvidia.com/presentations/2010/gdc/Direct3D_Effects.pdf) **paper** `nvidia`
* [Simulation, Animation and Rendering of Crowds in Real-Time](https://diglib.eg.org/bitstream/handle/10.2312/14394/beacco.pdf?sequence=1&isAllowed=y) **thesis**
* [Smooth Skinning Decomposition with Rigid Bones](http://graphics.cs.uh.edu/wp-content/papers/2012/2012_SA_SSDR_preprint.pdf) **paper**
* [State-of-the-art webGL 2.0](https://dl.acm.org/citation.cfm?id=3134479) **presentation** `nvidia`
* [Technical Art of Uncharted 4](http://advances.realtimerendering.com/other/2016/naughty_dog/NaughtyDog_TechArt_Final.pdf) **presentation**
* [Unreal Engine 4 Game Development Essentials](https://www.packtpub.com/game-development/unreal-engine-essentials) **book**
* [Unreal Engine 4-Beginners Crash Course v1](http://www.worldofleveldesign.com/store/free-guides/ue4-beginners-crash-course-guide.php) **book**
* [Unreal Engine Game Development Blueprints](https://www.packtpub.com/game-development/unreal-engine-game-development-blueprints) **book**
* [Using raycasting in GPU shaders to enhance real-time graphics](http://www.proun-game.com/Oogst3D/ARTICLES/Using%20raycasting%20in%20GPU%20shaders%20to%20enhance%20real-time%20graphics.pdf) **thesis**

### Rigging
* [A hybrid approach to procedural tree skeletonization](https://dl.acm.org/citation.cfm?id=3085065) **paper** `houdini` `pixar`
* [Achieving Real-Time Playback with Production Rigs](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/161/asset/realTime.pdf) **paper** `disney`
* [AutoSpline: animation controls only when and where you need them](https://dl.acm.org/citation.cfm?id=2927439) **paper** `pixar`
* [Character Rigging, Deformations, and Simulations in Film and Game Production](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.474.9719&rep=rep1&type=pdf) **paper** `dwa`
* [Designing an interaction with an octopus](https://dl.acm.org/citation.cfm?id=2927434) **paper** `pixar`
* [Implicit skinning: real-time skin deformation with contact modeling](https://dl.acm.org/citation.cfm?id=2461960) **paper**
* [MoSh: Motion and Shape Capture from Sparse Markers](http://files.is.tue.mpg.de/black/papers/MoSh.pdf) **paper**
* [Parallel Processing within a Host Application](http://www.multithreadingandvfx.org/course_notes/2017/disney_MultiThreading_SIGGRAPH2017.pdf) **presentation** `disney`
* [Procedural wrinkles generation in the implicit skinning framework](https://dl.acm.org/citation.cfm?id=2820937) **paper** `bournemouth` `mpc`
* [Rigging Octopuses in Penguins of Madagascar](https://dl.acm.org/citation.cfm?id=2791274&dl=ACM&coll=DL) **paper** `dwa`
* [Sketch to pose in Pixar's presto animation system](https://dl.acm.org/citation.cfm?id=2792583) **paper** `pixar`
* [Smooth Skinning Decomposition with Rigid Bones](http://graphics.cs.uh.edu/wp-content/papers/2012/2012_SA_SSDR_preprint.pdf) **paper**
* [Total Moving Face Reconstruction](http://grail.cs.washington.edu/projects/totalmoving/) **paper**

### Set
* [An Artist-Friendly Workflow for Panoramic HDRI](https://blog.selfshadow.com/publications/s2016-shading-course/unity/s2016_pbs_unity_hdri.pdf) **presentation**
* [Capture Color and Depth From All Around of A Live Set](http://ecollections.scad.edu/iii/cpro/DigitalItemViewPage.external;jsessionid=ABD0B1B0DDCA193A6F981612E6605AFE?lang=eng&sp=1002062&sp=T&sp=1&suite=def+++) **thesis** `scad`
* [Photogrammetry Workflow](https://unity3d.com/files/solutions/photogrammetry/Unity-Photogrammetry-Workflow_2017-07_v2.pdf) **book** [[video]](https://www.youtube.com/watch?v=Ny9ZXt_2v2Y)
* [Real-World Measurements for Call of Duty: Advanced Warfare](https://www.activision.com/cdn/research/Real_World_Measurements_for_Call_of_Duty_Advanced_Warfare.pdf) **paper**

### Shading
* [A Comprehensive Framework for Rendering Layered Materials](http://www.cs.cornell.edu/projects/layered-sg14/layered.pdf) **paper** `weta`
* [Advanced RenderMan 2: To RI_INFINITY and Beyond SIGGRAPH 2000 Course](http://silviojemma.com/public/papers/lighting/infbeyond.pdf) **paper** `disney` `pixar` `spi`
* [An Energy-Conserving Hair Reflectance Model](http://www.eugenedeon.com/wp-content/uploads/2014/04/egsrhair.pdf) **paper** `weta`
* [Arnold Shaders Tutorial - Solid Angle](https://support.solidangle.com/download/attachments/7503948/ArnoldShadersTutorial.pdf?api=v2) **paper**
* [Background: Physics and Math of Shading](https://pdfs.semanticscholar.org/c4e6/f55a19fa7c108f934f201ae97eedf90cefef.pdf) **paper**
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Effective Toon-Style Rendering Control Using Scalar Fields](https://graphics.pixar.com/library/ToonRendering/paper.pdf) **paper** `pixar`
* [Geometry into Shading](https://graphics.pixar.com/library/BumpRoughness/paper.pdf) **paper** `pixar`
* [Graphics Shaders: Theory and Practice](http://cs.uns.edu.ar/cg/clasespdf/GraphicShaders.pdf) **book**
* [MANIFOLD NEXT EVENT ESTIMATION](https://jo.dreggn.org/home/2015_mnee_talk.pdf) **presentation** `weta`
* [Manifold Exploration: A Markov Chain Monte Carlo Technique for Rendering Scenes with Difficult Specular Transport](http://www.cs.cornell.edu/projects/manifolds-sg12/manifolds-sg12.pdf) **paper**
* [Measuring and Modeling the Appearance of Finished Wood](http://silviojemma.com/public/papers/lighting/sg05-shadingWood-lr.pdf) **paper**
* [Multiple-Scattering Microfacet BSDFs with the Smith Model](https://jo.dreggn.org/home/2015_microfacets.pdf) **paper**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [Photogrammetry Workflow](https://unity3d.com/files/solutions/photogrammetry/Unity-Photogrammetry-Workflow_2017-07_v2.pdf) **book** [[video]](https://www.youtube.com/watch?v=Ny9ZXt_2v2Y)
* [Procedural Fluid Textures](https://dl.acm.org/citation.cfm?id=3214767) **paper**
* [Procedural wrinkles generation in the implicit skinning framework](https://dl.acm.org/citation.cfm?id=2820937) **paper** `bournemouth` `mpc`
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Realistic, Hardware-accelerated Shading and Lighting](http://silviojemma.com/public/papers/lighting/ShadingLighting.Siggraph.99.pdf) **paper**
* [Rendering Worlds with Two Triangles with raytracing on the GPU](http://www.iquilezles.org/www/material/nvscene2008/rwwtt.pdf) **presentation**
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [Screen Space Fluid Rendering for Games](http://developer.download.nvidia.com/presentations/2010/gdc/Direct3D_Effects.pdf) **paper** `nvidia`
* [Separable Subsurface Scattering](http://www.iryoku.com/separable-sss/) **paper**
* [Skin Microstructure Deformation with Displacement Map Convolution](http://gl.ict.usc.edu/Research/SkinStretch/) **paper**
* [Texturing and Modeling, Third Edition: A Procedural Approach](https://www.amazon.com/Texturing-Modeling-Third-Procedural-Approach/dp/1558608486) **book**
* [The Path to Path-Traced Movies](https://graphics.pixar.com/library/PathTracedMovies/paper.pdf) **paper** `pixar`
* [The Rusterizer: An Art-Directable and Semi-Procedural Tool for Generating Rust Surfaces](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2979&context=all_theses) **thesis** `clemson`
* [The path tracing revolution in the movie industry](https://sites.google.com/site/pathtracingrevolution/) **presentation** `disney` `nvidia` `pixar` `weta`
* [Using raycasting in GPU shaders to enhance real-time graphics](http://www.proun-game.com/Oogst3D/ARTICLES/Using%20raycasting%20in%20GPU%20shaders%20to%20enhance%20real-time%20graphics.pdf) **thesis**

### Stereo
* [Seminar on Stereoscopic Production for Computer Animation](http://tdforum.eu/pdf/principlesofstereoscopicproduction.pdf) **presentation** `tdforum`

### USD
* [Forging a new animation pipeline with USD](https://dl.acm.org/citation.cfm?id=3214779) **paper** `al`
* [USD-Based Pipeline (2016)](https://vimeo.com/188191100) **video**
* [Universal Scene Description](https://graphics.pixar.com/usd/files/USD_2013_07_pdf.pdf) **presentation** `pixar`
* [Walter: an open source VFX framework for USD and alembic](https://dl.acm.org/citation.cfm?id=3214772) **paper** `houdini`
* [Zero to USD in 80 days](https://dl.acm.org/citation.cfm?id=3214745.3214816) **paper** `dwa`

### Unreal Engine
* [Unreal Engine 4 Game Development Essentials](https://www.packtpub.com/game-development/unreal-engine-essentials) **book**
* [Unreal Engine 4-Beginners Crash Course v1](http://www.worldofleveldesign.com/store/free-guides/ue4-beginners-crash-course-guide.php) **book**
* [Unreal Engine Game Development Blueprints](https://www.packtpub.com/game-development/unreal-engine-game-development-blueprints) **book**

### VR
* [Color in advanced displays: HDR, OLED, AR & VR](https://dl.acm.org/citation.cfm?id=3214840) **presentation**
* [Dear angelica: breathing life into VR illustrations](https://dl.acm.org/citation.cfm?id=3085073) **paper** `houdini`
* [Fractal multiverses in VR](https://dl.acm.org/citation.cfm?id=3214813) **paper** `framestore`

### Volumetrics
* [3D Fractal Flame Wisps](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2704&context=all_theses) **thesis** `clemson`
* [3D Particle in Cell / Fluid Implicit Particle Fluid Solver using OpenMP directives](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc12/Ioannidis/Thesis.pdf) **thesis** `bournemouth` `houdini`
* [A Fluid Implicit Particle Approach to a Pyro Solver in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc11/Ahmad/aghourab_MSc_Thesis_Public.pdf) **thesis** `bournemouth` `houdini`
* [A Technique for Art Direction of Physically Based Fire Simulation](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2178&context=all_theses) **thesis** `clemson`
* [ART DIRECTABLE TORNADOES](http://oaktrust.library.tamu.edu/bitstream/handle/1969.1/ETD-TAMU-2011-05-9417/DWIVEDI-THESIS.pdf?sequence=2) **thesis** `houdini`
* [Advanced Applications of OpenVDB in Production](http://www.openvdb.org/download/openvdb_particle_storage_2015.pdf) **presentation** `houdini`
* [Art directing particle flows with custom vector fields](https://dl.acm.org/citation.cfm?id=1401040&dl=ACM&coll=DL) **paper** `r&h`
* [Avalanche! snowy FX for XXX](https://dl.acm.org/citation.cfm?id=965492) **paper** `dd`
* [CLOUDS AND RIMS](http://tdforum.eu/pdf/2012KustaaVuori_cloudsAndRims.pdf) **presentation** `tdforum`
* [Camera Space Volumetric Shadows](https://jo.dreggn.org/home/2012_camera_space.pdf) **paper** `weta`
* [Capturing Thin Features in Smoke Simulations](http://library.imageworks.com/pdfs/imageworks-library-capturing-thin-features-in-smoke-simulation.pdf) **paper** `spi`
* [Cloud Modeling and Rendering for 'Puss In Boots'](http://ken.museth.org/Publications_files/Miller-etal_SIG12.pdf) **paper** `dwa`
* [Controlling Fluid Simulations with Custom Fields in Houdini](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc09/Claes/thesis/PeterClaesThesis.pdf) **thesis** `bournemouth` `houdini`
* [DIGITAL DOMAIN OPENVDB ADOPTION](http://www.openvdb.org/download/openvdb_fluids_2013.pdf) **presentation** `houdini`
* [Efficient and Seamless Volumetric Fracturing](https://research.dreamworks.com/papers/Seamless_Volumetric_Fracturing_DWA_2012.pdf) **paper** `dwa`
* [FLUID SIMULATION SIGGRAPH 2007 Course Notes](https://www.cs.ubc.ca/~rbridson/fluidsimulation/fluids_notes.pdf) **paper**
* [Fluid simulation In a visual effects context](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Fluids.pdf) **presentation**
* [I Love It When A Cloud Comes Together](https://people.cs.clemson.edu/~jtessen/papers_files/ateamclouds.pdf) **paper** `r&h`
* [Keyframe Control of Smoke Simulations](http://grail.cs.washington.edu/projects/control/smokeControl.pdf) **paper**
* [MARCHING CUBES: A HIGH RESOLUTION 3D SURFACE CONSTRUCTION ALGORITHM](http://academy.cba.mit.edu/classes/scanning_printing/MarchingCubes.pdf) **paper**
* [Moana: Foundation of a Lava Monster](https://disney-animation.s3.amazonaws.com/uploads/production/publication_asset/166/asset/Moana_Foundation_of_a_Lava_Monster.pdf) **paper** `disney` `houdini`
* [Modeling and Animating Gases with Simulation Features](https://engineering.purdue.edu/~ebertd/papers/Schpok_SCA_2005.pdf) **paper**
* [Narrow Band FLIP for Liquid Simulations](https://wwwcg.in.tum.de/fileadmin/user_upload/Lehrstuehle/Lehrstuhl_XV/Research/Publications/2016/NBFlip/nbflip.pdf) **paper**
* [Nubis: Authoring Real-Time Volumetric Cloudscapes with the Decima Engine](http://advances.realtimerendering.com/s2017/Nubis%20-%20Authoring%20Realtime%20Volumetric%20Cloudscapes%20with%20the%20Decima%20Engine%20-%20Final%20.pdf) **presentation**
* [OpenVDB at DWA](http://www.openvdb.org/download/openvdb_production_2015.pdf) **presentation** `houdini`
* [OpenVDB in Houdini](http://www.openvdb.org/download/openvdb_houdini_2015.pdf) **presentation** `houdini`
* [OpenVDB toolset](http://www.openvdb.org/download/openvdb_toolset_2013.pdf) **presentation** `houdini`
* [Physical Simulation of Fire and Smoke Masters Thesis](https://nccastaff.bmth.ac.uk/jmacey/MastersProjects/MSc07/DavidMinor/MSc%20Thesis.pdf) **thesis** `bournemouth` `houdini`
* [Production Volume Rendering Fundamentals SIGGRAPH 2011 Course Notes](http://magnuswrenninge.com/content/pubs/ProductionVolumeRenderingFundamentals2011.pdf) **paper** `dwa` `spi`
* [Production Volume Rendering SIGGRAPH 2017 Course](https://graphics.pixar.com/library/ProductionVolumeRendering/paper.pdf) **paper** `disney` `pixar` `spi`
* [Production Volume Rendering Systems SIGGRAPH 2011 Course Notes](http://magnuswrenninge.com/content/pubs/ProductionVolumeRenderingSystems2011.pdf) **paper** `clemson` `dneg` `dwa` `houdini` `r&h` `spi` `weta`
* [Production Volume Rendering: Design and Implementation](https://www.amazon.com/Production-Rendering-Implementation-Magnus-Wrenninge/dp/156881724X) **book**
* [Racing to the finish line: effects challenges on Cars 3](https://dl.acm.org/citation.cfm?id=3085160&dl=ACM&coll=DL) **paper** `houdini` `pixar`
* [Real-Time Fluid Dynamics for Games](https://pdfs.semanticscholar.org/847f/819a4ea14bd789aca8bc88e85e906cfc657c.pdf) **paper**
* [Real-Time Volumetric Cloudscapes of Horizon Zero Dawn](http://killzone.dl.playstation.net/killzone/horizonzerodawn/presentations/Siggraph15_Schneider_Real-Time_Volumetric_Cloudscapes_of_Horizon_Zero_Dawn.pdf) **presentation**
* [Rogue One: A Star Wars Story - Jedha destruction](https://dl.acm.org/citation.cfm?id=3085068) **paper** `houdini` `ilm`
* [Star Wars: The Last Jedi - effects simulation](https://dl.acm.org/citation.cfm?id=3214778) **paper** `houdini` `ilm`
* [THE EXPLOSION EFFECT- A Custom Volume FX Production Pipeline](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?article=2435&context=all_theses) **thesis** `clemson` `houdini`
* [Target-Driven Smoke Animation](http://www.cs.huji.ac.il/labs/cglab/projects/tdsmoke/tdsmoke.pdf) **paper**
* [The Implementation of 2D Fluid Solver plugin for Houdini8.0](https://nccastaff.bournemouth.ac.uk/jmacey/MastersProjects/MSc07/MyaWin/mwin_thesis.pdf) **thesis** `bournemouth` `houdini`
* [The effects of The Jungle Book](https://dl.acm.org/citation.cfm?id=2927413) **paper** `houdini` `mpc`
* [Volume Rendering for Visual Effects](http://webstaff.itn.liu.se/~jonun/web/teaching/2011-TNCG13/Lectures/Lecture03-MW/Wrenninge_2011_Volume_Rendering.pdf) **presentation**
* [Volumetric Cloud Rendering: An Animation of Clouds](https://tigerprints.clemson.edu/cgi/viewcontent.cgi?referer=https://www.google.de/&httpsredir=1&article=2926&context=all_theses) **thesis** `clemson`
* [Volumetric Methods for Simulation and Rendering of Hair](https://graphics.pixar.com/library/Hair/paper.pdf) **paper** `pixar`
* [Volumetric Methods in Visual Effects SIGGRAPH 2010 Course Notes](http://magnuswrenninge.com/content/pubs/VolumetricMethodsInVisualEffects2010.pdf) **paper** `dneg` `dwa` `houdini` `r&h` `spi`
* [Volumetric dense mesh deformation in the Tengu Monk fight](https://dl.acm.org/citation.cfm?id=2614185&dl=ACM&coll=DL) **paper**
* [Vortex of Awesomeness](http://research.dreamworks.com/papers/PussInBoots_Tornado_DWA_2012.pdf) **paper** `dwa`

<br>

### Contributing
Feel free to contribute to this project by creating pull requests.

<br>

### Adding new entries
* Create virtual environment
    ```
    $ python3 -m venv venv
    ```

* Activate it
    ```
    $ source venv/bin/activate
    ```

* Install dependencies
    ```
    $ pip install -r requirements.txt
    ```

* Edit `library.yml` to add new entries

* Run code quality checks and re-generate `README.md`
    ```
    $ make
    ```

    * You can run code checks only with
        ```
        $ make check
        ```

    * Or re-generate `README.md` only with
        ```
        $ make generate
        ```

    * Alternatively re-generate `README.md` without make
        ```
        $ python generate.py
        ```

* Done!

