unit test_old_stringhashtrie;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit 
  being tested.

}


(* TO RUN THIS YOU NEED THIS FILE: https://github.com/Convey-Compliance/convey-public-libs/blob/development/HashTrie.pas
   and other required units located on the same repo:
   
   CnvStrUtils.pas
   Mkregex.pas
   uCnvPChar.pas *)

interface

uses
  TestFramework, SysUtils, Old_HashTrie;

type
  // Test methods for class TStringHashTrie
  
  TestTOld_StringHashTrie = class(TTestCase)
  private
    FStringHashTrie: TStringHashTrie;
    Cnt : Integer;
    procedure TravMeth(UserData: Pointer; Key: PChar; Data: TObject; var Done: Boolean);
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestAddIterateAndFindManyEntries;
  end;

implementation

procedure TestTOld_StringHashTrie.SetUp;
begin
  FStringHashTrie := TStringHashTrie.Create;
end;

procedure TestTOld_StringHashTrie.TearDown;
begin
  FStringHashTrie.Free;
  FStringHashTrie := nil;
end;

procedure TestTOld_StringHashTrie.TestAddIterateAndFindManyEntries;
const
  Count = 1024 * 1024;
var
  i : integer;
begin
  for i := 0 to Count - 1 do
    FStringHashTrie.Add(IntToStr(i) + 'hello', Self);
  Cnt := 0;
  FStringHashTrie.Traverse(nil, TravMeth);
  CheckEquals(Count, Cnt, 'Count of iterated values doesn''t match');
end;

procedure TestTOld_StringHashTrie.TravMeth(UserData: Pointer; Key: PChar; Data: TObject; var Done: Boolean);
var
  AValue : TObject;
begin
  Check(FStringHashTrie.Find(String(Key), AValue), 'Item not found');
  inc(Cnt);
end;

initialization
  // Register any test cases with the test runner
  RegisterTest(TestTOld_StringHashTrie.Suite);
end.

