/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */

import React from 'react';
import type {Node} from 'react';
import {
  SafeAreaView,
  ScrollView,
  StatusBar,
  StyleSheet,
  Text,
  useColorScheme,
  View,
} from 'react-native';

import {Colors} from 'react-native/Libraries/NewAppScreen';

const Section = ({children, title}): Node => {
  const isDarkMode = useColorScheme() === 'dark';
  return (
    <View style={styles.sectionContainer}>
      <Text
        style={[
          styles.sectionTitle,
          {
            color: isDarkMode ? Colors.white : Colors.black,
          },
        ]}>
        {title}
      </Text>
      <Text
        style={[
          styles.sectionDescription,
          {
            color: isDarkMode ? Colors.light : Colors.dark,
          },
        ]}>
        {children}
      </Text>
    </View>
  );
};

const App: () => Node = () => {
  const isDarkMode = useColorScheme() === 'dark';

  const backgroundStyle = {
    backgroundColor: isDarkMode ? Colors.darker : Colors.lighter,
  };

  return (
    <SafeAreaView style={backgroundStyle}>
      <StatusBar barStyle={isDarkMode ? 'light-content' : 'dark-content'} />
      <ScrollView
        contentInsetAdjustmentBehavior="automatic"
        style={backgroundStyle}>
        <Text>Raleway, 100, normal:</Text>
        <Text style={{fontFamily: 'Raleway', fontWeight: '100', fontSize: 60}}>
          Hello world!
        </Text>
        <Text>System, 100, normal:</Text>
        <Text style={{fontWeight: '100', fontSize: 60}}>Hello world!</Text>
        <Text>Raleway, 400, italic:</Text>
        <Text
          style={{
            fontFamily: 'Raleway',
            fontWeight: '400',
            fontSize: 60,
            fontStyle: 'italic',
          }}>
          Hello world!
        </Text>
        <Text>System, 400, italic:</Text>
        <Text style={{fontWeight: '400', fontStyle: 'italic', fontSize: 60}}>
          Hello world!
        </Text>
        <Text>Raleway, 900, normal:</Text>
        <Text
          style={{
            fontFamily: 'Raleway',
            fontWeight: '900',
            fontSize: 60,
          }}>
          Hello world!
        </Text>
        <Text>System, 900, normal:</Text>
        <Text style={{fontWeight: '900', fontSize: 60}}>Hello world!</Text>
        <Text>Raleway, 900, italic:</Text>
        <Text
          style={{
            fontFamily: 'Raleway',
            fontWeight: '900',
            fontSize: 60,
            fontStyle: 'italic',
          }}>
          Hello world!
        </Text>
        <Text>System, 900, italic:</Text>
        <Text style={{fontWeight: '900', fontSize: 60, fontStyle: 'italic'}}>
          Hello world!
        </Text>
      </ScrollView>
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  sectionContainer: {
    marginTop: 32,
    paddingHorizontal: 24,
  },
  sectionTitle: {
    fontSize: 24,
    fontWeight: '600',
  },
  sectionDescription: {
    marginTop: 8,
    fontSize: 18,
    fontWeight: '400',
  },
  highlight: {
    fontWeight: '700',
  },
});

export default App;
