// Package reverse reverses a string. We test it by using fuzzing. Adapted from
// go.dev/doc/tutorial/fuzz.
//
// go test -fuzz=Fuzz -fuzztime 30s reverse/*
//
// Level: intermediate
// Topics: algorithms, fuzzing, unicode/utf8
package reverse

import (
	"errors"
	"unicode/utf8"
)

func Reverse(s string) (string, error) {
	if !utf8.ValidString(s) {
		return s, errors.New("input is not valid UTF-8")
	}
	r := []rune(s)
	for i, j := 0, len(r)-1; i < len(r)/2; i, j = i+1, j-1 {
		r[i], r[j] = r[j], r[i]
	}
	return string(r), nil
}
