package io.jpress.module.product.model;

import io.jboot.db.annotation.Table;
import io.jboot.utils.StrUtil;
import io.jpress.commons.utils.UrlUtils;
import io.jpress.module.product.model.base.BaseProductCategory;

/**
 * Generated by JPress.
 */
@Table(tableName = "product_category", primaryKey = "id")
public class ProductCategory extends BaseProductCategory<ProductCategory> {

    private static final long serialVersionUID = 1L;

    /**
     * 普通的分类
     * 分类可以有多个层级
     */
    public static final String TYPE_CATEGORY = "category";

    /**
     * 标签
     * 标签只有一个层级
     */
    public static final String TYPE_TAG = "tag";


    public boolean isTag() {
        return TYPE_TAG.equals(getType());
    }


    public String getUrl() {
        String prefix = TYPE_CATEGORY.equals(getType()) ? "/product/category/" : "/product/tag/";
        return UrlUtils.getUrl(prefix, getSlug());
    }


    public String getUrlWithPageNumber(int pageNumber) {
        if (pageNumber <= 1) {
            return getUrl();
        }

        String prefix = TYPE_CATEGORY.equals(getType()) ? "/product/category/" : "/product/tag/";
        return UrlUtils.getUrl(prefix, getSlug(), "-", pageNumber);
    }


    public String getHtmlView() {
        return StrUtil.isBlank(getStyle()) ? "prolist.html" : "prolist_" + getStyle().trim() + ".html";
    }

}
