package io.jpress.module.page.model;

import io.jboot.db.annotation.Table;
import io.jpress.commons.utils.CommonsUtils;
import io.jpress.commons.utils.JsoupUtils;
import io.jpress.model.User;
import io.jpress.module.page.model.base.BaseSinglePageComment;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by JPress.
 */
@Table(tableName = "single_page_comment", primaryKey = "id")
public class SinglePageComment extends BaseSinglePageComment<SinglePageComment> {

    private static final long serialVersionUID = 1L;

    public static final String STATUS_NORMAL = "normal"; //正常
    public static final String STATUS_UNAUDITED = "unaudited"; //待审核
    public static final String STATUS_TRASH = "trash"; //垃圾箱



    private static final Map<String, String> statusStrings = new HashMap<>();

    static {
        statusStrings.put(STATUS_NORMAL, "正常");
        statusStrings.put(STATUS_UNAUDITED, "待审核");
        statusStrings.put(STATUS_TRASH, "垃圾箱");
    }


    public boolean isNormal() {
        return STATUS_NORMAL.equals(getStatus());
    }

    public boolean isUnaudited() {
        return STATUS_UNAUDITED.equals(getStatus());
    }

    public boolean isTrash() {
        return STATUS_TRASH.equals(getStatus());
    }

    public String getStatusString() {
        String string = statusStrings.get(getStatus());
        return string == null ? "未知状态" : string;
    }

    @Override
    public String getAuthor() {
        User user = get("user");
        return user != null ? user.getNickname() : super.getAuthor();
    }

    public String getText() {
        return JsoupUtils.getText(getContent());
    }



    @Override
    public boolean save() {
        CommonsUtils.escapeModel(this, "content");
        JsoupUtils.clean(this, "content");
        return super.save();
    }

    @Override
    public boolean update() {
        CommonsUtils.escapeModel(this, "content");
        JsoupUtils.clean(this, "content");
        return super.update();
    }

	
}
