/**
 * Copyright (c) 2016-2020, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jpress.model;

import com.alibaba.fastjson.JSON;
import io.jboot.db.annotation.Table;
import io.jboot.utils.StrUtil;
import io.jpress.model.base.BaseWechatReply;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by Jboot.
 */
@Table(tableName = "wechat_reply", primaryKey = "id")
public class WechatReply extends BaseWechatReply<WechatReply> {
    private static final Map<String, String> rtypeStrings = new HashMap<>();

    static {
        rtypeStrings.put("text", "文字");
        rtypeStrings.put("image", "图片");
        rtypeStrings.put("textAndImage", "文字和图片");
        rtypeStrings.put("miniprogram", "微信小程序");
    }

    private Map<String, String> optionMap;

    public void putOption(String key, String value) {
        if (optionMap == null) {
            optionMap = getOptionMap();
        }
        optionMap.put(key, value);
    }

    public String getOption(String key) {
        if (optionMap == null) {
            optionMap = getOptionMap();
        }
        return optionMap.get(key);
    }

    public boolean getBoolOption(String key) {
        String option = getOption(key);
        return option != null && Boolean.valueOf(option);
    }

    public Integer getIntOption(String key) {
        String option = getOption(key);
        if (StrUtil.isBlank(option)) {
            return null;
        }
        return Integer.valueOf(option);
    }

    public int getIntOption(String key, int defaultValue) {
        String option = getOption(key);
        if (StrUtil.isBlank(option)) {
            return defaultValue;
        }
        return Integer.valueOf(option);
    }

    public Map<String, String> getOptionMap() {
        String optionJson = getContent();
        return isJson() ? JSON.parseObject(optionJson, HashMap.class) : new HashMap<>();
    }

    public boolean isJson() {
        String content = getContent();
        return content != null && content.startsWith("{") && content.endsWith("}");
    }

    public String getText() {
        return getOption("text");
    }


    public String getImage() {
        return getOption("image");
    }

    public String getReplyType() {
        return getOption("rtype");
    }

    public String getReplyTypeStr() {
        String text = rtypeStrings.get(getReplyType());
        return StrUtil.isNotBlank(text) ? text : "文字";
    }

    public String getMiniprogramTitle() {
        return getOption("miniprogram_title");
    }

    public String getMiniprogramAppId() {
        return getOption("miniprogram_appid");
    }

    public String getMiniprogramPage() {
        return getOption("miniprogram_page");
    }

    public String getMiniprogramCover() {
        return getOption("miniprogram_cover");
    }

    public boolean isTextType() {
        return "text".equals(getReplyType());
    }

    public boolean isImageType() {
        return "image".equals(getReplyType());
    }

    public boolean isTextAndImageType() {
        return "textAndImage".equals(getReplyType());
    }

    public boolean isMiniprogramType() {
        return "miniprogram".equals(getReplyType());
    }

    public boolean isConfigMiniprogramOk() {
        return StrUtil.areNotEmpty(getMiniprogramAppId(), getMiniprogramTitle(), getMiniprogramPage(), getMiniprogramCover());
    }


    public String getShowContent() {
        if (!isJson()) {
            return getContent();
        }

        if (isTextType()) {
            return getText();
        } else if (isImageType()) {
            return getImage();
        } else if (isMiniprogramType()) {
            return getMiniprogramTitle();
        } else if (isTextAndImageType()) {
            return getText();
        }

        return getContent();
    }

    @Override
    public boolean save() {
        if (optionMap != null) {
            setContent(JSON.toJSONString(optionMap));
        }
        return super.save();
    }

    @Override
    public boolean update() {
        if (optionMap != null) {
            setContent(JSON.toJSONString(optionMap));
        }
        return super.update();
    }

}
