package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jpress.model.base.BaseMember;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by JPress.
 */
@Table(tableName = "member", primaryKey = "id")
public class Member extends BaseMember<Member> {

    private static final long serialVersionUID = 1L;

    public static final String SOURCE_BUY = "buy"; //用户购买
    public static final String SOURCE_FREE = "free"; //免费赠送
    public static final String SOURCE_OTHER = "other"; //其他

    public static final Map<String, String> sourceTexts = new HashMap<>();

    static {
        sourceTexts.put(SOURCE_BUY, "自主购买");
        sourceTexts.put(SOURCE_FREE, "免费赠送");
        sourceTexts.put(SOURCE_OTHER, "其他方式");
    }

    public static final int STATUS_NORMAL = 9;

    public boolean isNormal() {
        Integer status = getStatus();
        return status != null && status == STATUS_NORMAL;
    }


    public String getSourceStr() {
        return sourceTexts.get(getSource());
    }

}
