package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jpress.model.base.BaseCouponCode;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by JPress.
 */
@Table(tableName = "coupon_code", primaryKey = "id")
public class CouponCode extends BaseCouponCode<CouponCode> {

    private static final long serialVersionUID = 1L;

    //该优惠码已经有人领取，并且可以正常使用
    public static final int STATUS_NORMAL = 1;

    //该优惠码未有人领取，不能被使用
    public static final int STATUS_UNCLAIMED = 2;

    //该优惠码已经有人领取，同时已经使用，不能再使用
    public static final int STATUS_USED = 3;

    //该优惠码已经被标识为不可使用
    public static final int STATUS_INVALID = 9;


    public boolean isNormal() {
        Integer status = getStatus();
        return status != null && status == STATUS_NORMAL;
    }


    public static final Map<Integer, String> statusTexts = new HashMap<>();

    static {
        statusTexts.put(STATUS_NORMAL, "正常");
        statusTexts.put(STATUS_UNCLAIMED, "未被用户领取");
        statusTexts.put(STATUS_USED, "已被使用");
        statusTexts.put(STATUS_INVALID, "失效");
    }


    public String getStatusStr(){
        return statusTexts.get(getStatus());
    }

}
