package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jpress.model.base.BaseCoupon;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by JPress.
 */
@Table(tableName = "coupon", primaryKey = "id")
public class Coupon extends BaseCoupon<Coupon> {

    private static final long serialVersionUID = 1L;

    //优惠码的验证类型：绝对有效，（XXX-XXX时间段有效）
    public static final int VALID_TYPE_ABSOLUTELY_EFFECTIVE = 1;

    //优惠码的验证类型：相对时效（领取后N天有效）
    public static final int VALID_TYPE_RELATIVELY_EFFECTIVE = 2;


    //1正常  9不能使用
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_INVALID = 9;

    //满减券
    public static final int TYPE_FULL_DISCOUNT = 1;

    //叠加满减券
    public static final int TYPE_SUPERIMPOSED_FULL_DISCOUNT = 2;

    //无门槛券
    public static final int TYPE_NO_THRESHOLD = 3;

    public static final Map<Integer, String> typeTexts = new HashMap<>();

    static {
        typeTexts.put(TYPE_FULL_DISCOUNT, "满减券");
        typeTexts.put(TYPE_SUPERIMPOSED_FULL_DISCOUNT, "叠加满减券");
        typeTexts.put(TYPE_NO_THRESHOLD, "无门槛券");
    }


    public static final Map<Integer, String> statusTexts = new HashMap<>();

    static {
        statusTexts.put(STATUS_NORMAL, "正常");
        statusTexts.put(STATUS_INVALID, "失效");
    }


    public boolean isNormal() {
        Integer status = getStatus();
        return status != null && status == STATUS_NORMAL;
    }

    public String getTypeStr(){
        return typeTexts.get(getType());
    }


    public String getStatusStr(){
        return statusTexts.get(getStatus());
    }

}
