# Drag and drop in AIR

Use the classes in the Adobe® AIR™ drag-and-drop API to support user-interface
drag-and-drop gestures. A _gesture_ in this sense is an action by the user,
mediated by both the operating system and your application, expressing an intent
to copy, move, or link information. A _drag-out_ gesture occurs when the user
drags an object out of a component or application. A _drag-in_ gesture occurs
when the user drags in an object from outside a component or application.

With the drag-and-drop API, you can allow a user to drag data between
applications and between components within an application. Supported transfer
formats include:

- Bitmaps

- Files

- HTML-formatted text

- Text

- Rich Text Format data

- URLs

- File promises

- Serialized objects

- Object references (only valid within the originating application)

- [Basics of drag and drop in AIR](./basics-of-drag-and-drop-in-air.md)
- [Supporting the drag-out gesture](./supporting-the-drag-out-gesture.md)
- [Supporting the drag-in gesture](./supporting-the-drag-in-gesture.md)
- [Drag and drop in HTML](./drag-and-drop-in-html.md)
- [Dragging data out of an HTML element](./dragging-data-out-of-an-html-element.md)
- [Dragging data into an HTML element](./dragging-data-into-an-html-element.md)
- [Example: Overriding the default HTML drag-in behavior](./example-overriding-the-default-html-drag-in-behavior.md)
- [Handling file drops in non-application HTML sandboxes](./handling-file-drops-in-non-application-html-sandboxes.md)
- [Dropping file promises](./dropping-file-promises.md)
