# Security

Security is a key concern of Adobe, users, website owners, and content
developers. For this reason, Adobe® Flash® Player and Adobe® AIR™ include a set
of security rules and controls to safeguard the user, website owner, and content
developer. This discussion covers the security model for SWF files published
with ActionScript 3.0 and running in Flash Player 9.0.124.0 or later, and SWF,
HTML, and JavaScript files running in AIR 1.0 or later, unless otherwise noted.

This discussion provides an overview of security; it does not try to
comprehensively explain all implementation details, usage scenarios, or
ramifications for using certain APIs. For a more detailed discussion of Flash
Player security concepts, see the Flash Player Developer Center topic "Security"
at
[www.adobe.com/go/devnet_security_en](https://web.archive.org/web/20150422111248/http://www.adobe.com/devnet/flashplayer/security.html).

- [Flash Platform security overview](./flash-platform-security-overview.md)
- [Security sandboxes](./security-sandboxes.md)
- [Permission controls](./permission-controls.md)
- [Restricting networking APIs](./restricting-networking-apis.md)
- [Full-screen mode security](./full-screen-mode-security.md)
- [Full-screen interactive mode security](./full-screen-interactive-mode-security.md)
- [Loading content](./loading-content.md)
- [Cross-scripting](./cross-scripting.md)
- [Accessing loaded media as data](./accessing-loaded-media-as-data.md)
- [Loading data](./loading-data.md)
- [Loading embedded content from SWF files imported into a security domain](./loading-embedded-content-from-swf-files-loaded-into-a-security-domain.md)
- [Working with legacy content](./working-with-legacy-content.md)
- [Setting LocalConnection permissions](./setting-localconnection-permissions.md)
- [Controlling outbound URL access](./controlling-outbound-url-access.md)
- [Shared objects](./shared-objects.md)
- [Camera, microphone, clipboard, mouse, and keyboard access](./camera-microphone-clipboard-mouse-and-keyboard-access.md)
- [AIR security](./air-security/index.md)
