# Full-screen mode security

Flash Player 9.0.27.0 and later support full-screen mode, in which content
running in Flash Player can fill the entire screen. To enter full-screen mode,
the `displayState` property of the Stage is set to the
`StageDisplayState.FULL_SCREEN` constant. For more information, see
[Working with full-screen mode](../display/display-programming/setting-stage-properties.md#working-with-full-screen-mode).

For SWF files running in a remote sandbox, there are some security
considerations.

To enable full-screen mode, in the `<object>` and `<embed>` tags in the HTML
page that contains a reference to the SWF file, add the `allowFullScreen`
parameter, with its value set to `"true"` (the default value is `"false"`), as
shown in the following example:

    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"
    	codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,18,0"
    	width="600" height="400" id="test" align="middle">
    	<param name="allowFullScreen" value="true" />
    	<param name="movie" value="test.swf" />
    	<param name="bgcolor" value="#333333" />
    	<embed src="test.swf" allowFullScreen="true" bgcolor="#333333"
    		width="600" height="400"
    		name="test" align="middle" type="application/x-shockwave-flash"
    		pluginspage="http://www.macromedia.com/go/getflashplayer" />
    </object>

An HTML page may also use a script to generate SWF-embedding tags. You must
alter the script so that it inserts the proper `allowFullScreen` settings. HTML
pages generated by Flash Professional and Flash Builder use the
`AC_FL_RunContent()` function to embed references to SWF files, and you need to
add the `allowFullScreen` parameter settings, as in the following:

    AC_FL_RunContent( ... "allowFullScreen", "true", ...)

The ActionScript that initiates full-screen mode can be called only in response
to a mouse event or keyboard event. If it is called in other situations, Flash
Player throws an exception.

A message appears when the content enters full-screen mode, instructing the user
how to exit and return to normal mode. The message appears for a few seconds and
then fades out.

For content that is running in a browser, keyboard usage is restricted in
full-screen mode. In Flash Player 9, only keyboard shortcuts that return the
application to normal mode, such as pressing the Escape key, are supported.
Users can't enter text in text fields or navigate around the screen. In Flash
Player 10 and later, certain non-printing keys (specifically the arrow keys,
space, and Tab key) are supported. However, text input is still prohibited.

Full-screen mode is always permitted in the stand-alone player or in a projector
file. Also, keyboard usage (including text input) is fully supported in those
environments.

Calling the `displayState` property of a Stage object throws an exception for
any caller that is not in the same security sandbox as the Stage owner (the main
SWF file). For more information, see
[Stage security](./cross-scripting.md#stage-security).

Administrators can disable full-screen mode for SWF files running in browsers by
setting `FullScreenDisable = 1` in the mms.cfg file. For details, see
[Administrator controls](./permission-controls.md#administrator-controls).

In a browser, a SWF file must be contained in an HTML page to allow full-screen
mode.
