# Full-screen interactive mode security

Flash Player 11.3 and later support full-screen interactive mode, in which
content running in Flash Player can fill the entire screen _and accept text
input_. To enter full-screen interactive mode, the `displayState` property of
the Stage is set to the `StageDisplayState.FULL_SCREEN_INTERACTIVE` constant.
For more information, see
[Working with full-screen mode](../display/display-programming/setting-stage-properties.md#working-with-full-screen-mode).

For SWF files running in a remote sandbox, there are some security
considerations.

To enable full-screen mode, in the `<object>` and `<embed>` tags in the HTML
page that contains a reference to the SWF file, add the
`allowFullScreenInteractive` parameter, with its value set to `"true"` (the
default value is `"false"`), as shown in the following example:

    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"
    	codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,18,0"
    	width="600" height="400" id="test" align="middle">
    	<param name="allowFullScreenInteractive" value="true" />
    	<param name="movie" value="test.swf" />
    	<param name="bgcolor" value="#333333" />
    	<embed src="test.swf" allowFullScreen="true" bgcolor="#333333"
    		width="600" height="400"
    		name="test" align="middle" type="application/x-shockwave-flash"
    		pluginspage="http://www.macromedia.com/go/getflashplayer" />
    </object>

An HTML page may also use a script to generate SWF-embedding tags. You must
alter the script so that it inserts the proper `allowFullScreenInteractive`
settings. HTML pages generated by Flash Professional and Flash Builder use the
`AC_FL_RunContent()` function to embed references to SWF files, and you need to
add the `allowFullScreenInteractive` parameter settings, as in the following:

    AC_FL_RunContent( ... "allowFullScreenInteractive", "true", ...)

The ActionScript that initiates full-screen interactive mode can be called only
in response to a mouse event or keyboard event. If it is called in other
situations, Flash Player throws an exception.

An overlay message appears when the content enters full-screen interactive mode.
The message displays the domain of the full-screen page, instructions on how to
exit full-screen mode, and an **Allow** button. The overlay persists until the
user clicks **Allow**, acknowledging they are in full-screen interactive mode.

Administrators can disable full-screen interactive mode for SWF files running in
browsers by setting `FullScreenInteractiveDisable = 1` in the mms.cfg file. For
details, see
[Administrator controls](./permission-controls.md#administrator-controls).

In a browser, a SWF file must be contained in an HTML page to allow full-screen
interactive mode.
