# Working with sound

ActionScript is made for immersive, interactive applications—and one often
overlooked element of powerfully immersive applications is sound. You can add
sound effects to a video game, audio feedback to an application user interface,
or even make a program that analyzes mp3 files loaded over the Internet, with
sound at the core of the application.

You can load external audio files and work with audio that's embedded in a SWF.
You can control the audio, create visual representations of the sound
information, and capture sound from a user's microphone.

- [Basics of working with sound](./basics-of-working-with-sound.md)
- [Understanding the sound architecture](./understanding-the-sound-architecture.md)
- [Loading external sound files](./loading-external-sound-files.md)
- [Working with embedded sounds](./working-with-embedded-sounds.md)
- [Working with streaming sound files](./working-with-streaming-sound-files.md)
- [Working with dynamically generated audio](./working-with-dynamically-generated-audio.md)
- [Playing sounds](./playing-sounds.md)
- [Security considerations when loading and playing sounds](./security-considerations-when-loading-and-playing-sounds.md)
- [Controlling sound volume and panning](./controlling-sound-volume-and-panning.md)
- [Working with sound metadata](./working-with-sound-metadata.md)
- [Accessing raw sound data](./accessing-raw-sound-data.md)
- [Capturing sound input](./capturing-sound-input.md)
- [Sound example: Podcast Player](./sound-example-podcast-player.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[flash.media package](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/media/package-detail.html)

![](../../img/flashplatformLinkIndicator.png)
[flash.events.SampleDataEvent](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/SampleDataEvent.html)
