# Out-of-band Licenses

Licenses can also be obtained out-of-band (without contacting a Adobe Access
License Server) by storing the voucher (license) on disk and in memory using the
`storeVoucher` method.

To play encrypted videos in Flash Player and AIR, the respective runtime needs
to obtain the DRM voucher for that video. The DRM voucher contains the video's
decryption key and is generated by the Adobe Access License Server that the
customer has deployed.

The Flash Player/AIR runtime generally obtains this voucher by sending a voucher
request to the Adobe Access License Server indicated in the video's DRM metadata
(`DRMContentData` class). The Flash/AIR application can trigger this license
request by calling the `DRMManager.loadVoucher()` method. Or, the Flash
Player/AIR runtime will automatically request a license at the start of the
encrypted video playback if there is no license for the content on disk or in
memory. In either case, the Flash/AIR application's performance gets impacted by
communicating with the Adobe Access License Server.

`DRMManager.storeVoucher()` allows the Flash/AIR application to send DRM
vouchers that it has obtained out-of-band to the Flash Player/AIR runtime. The
runtime can then skip the license request process and use the forwarded vouchers
for playing encrypted videos. The DRM voucher still needs to be generated by the
Adobe Access License Server before it can be obtained out-of-band. However, you
have the option of hosting the vouchers on any HTTP server, instead of a
public-facing Adobe Access license server.

`DRMManager.storeVoucher()` is also used to support DRM voucher sharing between
multiple devices. In Adobe Access 3.0, this feature is referred to as "Domain
Support". If your deployment supports this use case, you can register multiple
machines to a device group using the `DRMManager.addToDeviceGroup()` method. If
there is a machine with a valid domain-bound voucher for a given content, the
AIR application can then extract the serialized DRM vouchers using the
`DRMVoucher.toByteArray()` method and on your other machines you can import the
vouchers using the `DRMManager.storeVoucher()` method.

More Help topics

[Device registration](./device-registration.md)

[Factory reset](./factory-reset.md)
