# Loading external data

ActionScript 3.0 includes mechanisms for loading data from external sources.
Those sources can provide static content such as text files, or dynamic content
generated by a web script. The data can be formatted in various ways, and
ActionScript provides functionality for decoding and accessing the data. You can
also send data to the external server as part of the process of retrieving data.

## Using the URLRequest class

Many APIs that load external data use the URLRequest class to define the
properties of necessary network request.

### URLRequest properties

You can set the following properties of a URLRequest object in any security
sandbox:

| Property       | Description                                                                                                                                                                                                                                                                                                 |
| -------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| contentType    | The MIME content type of any data sent with the URL request. If no contentType is set, values are sent as `application/x-www-form-urlencoded`.                                                                                                                                                              |
| data           | An object containing data to be transmitted with the URL request.                                                                                                                                                                                                                                           |
| digest         | A string that uniquely identifies the signed Adobe platform component to be stored to (or retrieved from) the Adobe® Flash® Player cache.                                                                                                                                                                   |
| method         | The HTTP request method, such as a GET or POST. (Content running in the AIR application security domain can specify strings other than `"GET"` or `"POST"` as the `method` property. Any HTTP verb is allowed and `"GET"` is the default method. See [AIR security](../../security/air-security/index.md).) |
| requestHeaders | The array of HTTP request headers to be appended to the HTTP request. Note that permission to set some headers is restricted in Flash Player as well as in AIR content running outside the application security sandbox.                                                                                    |
| url            | Specifies the URL to be requested.                                                                                                                                                                                                                                                                          |

In AIR, you can set additional properties of the URLRequest class, which are
only available to AIR content running in the application security sandbox.
Content in the application sandbox can also define URLs using new URL schemes
(in addition to standard schemes like `file` and `http`).

| Property        | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| --------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| followRedirects | Specifies whether redirects are to be followed (`true`, the default value) or not (`false`). This is only supported in the AIR application sandbox.                                                                                                                                                                                                                                                                                                                         |
| manageCookies   | Specifies whether the HTTP protocol stack should manage cookies (`true`, the default value) or not (`false`) for this request. Setting this property is only supported in the AIR application sandbox.                                                                                                                                                                                                                                                                      |
| authenticate    | Specifies whether authentication requests should be handled (`true`) for this request. Setting this property is only supported in the AIR application sandbox. The default is to authenticate requests—which may cause an authentication dialog box to be displayed if the server requires credentials. You can also set the user name and password using the URLRequestDefaults class—see [Setting URLRequest defaults (AIR only)](#setting-urlrequest-defaults-air-only). |
| cacheResponse   | Specifies whether response data should be cached for this request. Setting this property is only supported in the AIR application sandbox. The default is to cache the response (`true`).                                                                                                                                                                                                                                                                                   |
| useCache        | Specifies whether the local cache should be consulted before this URLRequest fetches data. Setting this property is only supported in the AIR application sandbox. The default (`true`) is to use the local cached version, if available.                                                                                                                                                                                                                                   |
| userAgent       | Specifies the user-agent string to be used in the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                             |

> **Note:** The HTMLLoader class has related properties for settings pertaining
> to content loaded by an HTMLLoader object. For details, see
> [About the HTMLLoader class](../../html-content-in-adobe-air/programming-html-and-javascript-in-air/about-the-htmlloader-class.md).

### Setting URLRequest defaults (AIR only)

The URLRequestDefaults class lets you define application-specific default
settings for URLRequest objects. For example, the following code sets the
default values for the `manageCookies` and `useCache` properties. All new
URLRequest objects will use the specified values for these properties instead of
the normal defaults:

    URLRequestDefaults.manageCookies = false;
    URLRequestDefaults.useCache = false;

> **Note:** The URLRequestDefaults class is defined for content running in Adobe
> AIR only. It is not supported in Flash Player.

The URLRequestDefaults class includes a `setLoginCredentialsForHost()` method
that lets you specify a default user name and password to use for a specific
host. The host, which is defined in the hostname parameter of the method, can be
a domain, such as `"www.example.com"`, or a domain and a port number, such as
`"www.example.com:80"`. Note that `"example.com"`, `"www.example.com"`, and
`"sales.example.com"` are each considered unique hosts.

These credentials are only used if the server requires them. If the user has
already authenticated (for example, by using the authentication dialog box),
then calling the `setLoginCredentialsForHost()` method does not change the
authenticated user.

The following code sets the default user name and password to use for requests
sent to www.example.com:

    URLRequestDefaults.setLoginCredentialsForHost("www.example.com", "Ada", "love1816$X");

The URLRequestDefaults settings only apply to the current application domain,
with one exception. The credentials passed to the `setLoginCredentialsForHost()`
method are used for requests made in any application domain within the AIR
application.

For more information, see the
[URLRequestDefaults](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/net/URLRequestDefaults.html)
class listing in the
[ActionScript 3.0 Reference for the Adobe Flash Platform](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/index.html).

### URI schemes

The standard URI schemes, such as the following, can be used in requests made
from any security sandbox:

#### http: and https:

Use these for standard Internet URLs (in the same way that they are used in a
web browser).

#### file:

Use `file:` to specify the URL of a file located on the local file system. For
example:

    file:///c:/AIR Test/test.txt

In AIR, you can also use the following schemes when defining a URL for content
running in the application security sandbox:

#### app:

Use `app:` to specify a path relative to the root directory of the installed
application. For example, the following path points to a resources subdirectory
of the directory of the installed application:

    app:/resources

When an AIR application is launched using the AIR Debug Launcher (ADL), the
application directory is the directory that contains the application descriptor
file.

The URL (and `url` property) for a File object created with
`File.applicationDirectory` uses the `app` URI scheme, as in the following:

    var dir:File = File.applicationDirectory;
    dir = dir.resolvePath("assets");
    trace(dir.url); // app:/assets

#### app-storage:

Use `app-storage:` to specify a path relative to the data storage directory of
the application. For each installed application (and user), AIR creates a unique
application storage directory, which is a useful place to store data specific to
that application. For example, the following path points to a prefs.xml file in
a settings subdirectory of the application store directory:

    app-storage:/settings/prefs.xml

The URL (and `url` property) for a File object created with
`File.applicationStorageDirectory` uses the `app-storage` URI scheme, as in the
following:

    var prefsFile:File = File.applicationStorageDirectory;
    prefsFile = prefsFile.resolvePath("prefs.xml");
    trace(dir.prefsFile); // app-storage:/prefs.xml

#### mailto:

You can use the mailto scheme in URLRequest objects passed to the
`navigateToURL()` function. See
[Opening a URL in another application](./opening-a-url-in-another-application.md).

You can use a URLRequest object that uses any of these URI schemes to define the
URL request for a number of different objects, such as a FileStream or a Sound
object. You can also use these schemes in HTML content running in AIR; for
example, you can use them in the `src` attribute of an `img` tag.

However, you can only use these AIR-specific URI schemes (`app:` and
`app-storage:`) in content in the application security sandbox. For more
information, see [AIR security](../../security/air-security/index.md).

### Setting URL variables

While you can add variables to the URL string directly, it can be easier to use
the URLVariables class to define any variables needed for a request.

There are three ways in which you can add parameters to a URLVariables object:

- Within the URLVariables constructor

- With the `URLVariables.decode()` method

- As dynamic properties of the URLVariables object itself

The following example illustrates all three methods and also how to assign the
variables to a URLRequest object:

    var urlVar:URLVariables = new URLVariables( "one=1&two=2" );
    urlVar.decode("amp=" + encodeURIComponent( "&" ) );
    urlVar.three = 3;
    urlVar.amp2 = "&&";
    trace(urlVar.toString()); //amp=%26&amp2=%26%26&one=1&two=2&three=3

    var urlRequest:URLRequest = new URLRequest( "http://www.example.com/test.cfm" );
    urlRequest.data = urlVar;

When you define variables within the URLVariables constructor or within the
`URLVariables.decode()` method, make sure that you URL-encode the characters
that have a special meaning in a URI string. For example, when you use an
ampersand in a parameter name or value, you must encode the ampersand by
changing it from `&` to `%26` because the ampersand acts as a delimiter for
parameters. The top-level `encodeURIComponent()` function can be used for this
purpose.

## Using the URLLoader class

The URLLoader class let you send a request to a server and access the
information returned. You can also use the URLLoader class to access files on
the local file system in contexts where local file access is permitted (such as
the Flash Player local-with-filesystem sandbox and the AIR application sandbox).
The URLLoader class downloads data from a URL as text, binary data, or
URL-encoded variables. The URLLoader class dispatches events such as `complete`,
`httpStatus`, `ioError`, `open`, `progress`, and `securityError`.

The ActionScript 3.0 event-handling model is significantly different than the
ActionScript 2.0 model, which used the `LoadVars.onData`,
`LoadVars.onHTTPStatus`, and `LoadVars.onLoad` event handlers. For more
information on handling events in ActionScript 3.0, see
[Handling events](../../core-actionscript-classes/handling-events/index.md)

Downloaded data is not available until the download has completed. You can
monitor the progress of the download (bytes loaded and bytes total) by listening
for the `progress` event to be dispatched. However, if a file loads quickly
enough a `progress` event might not be dispatched. When a file has successfully
downloaded, the `complete` event is dispatched. By setting the URLLoader
`dataFormat` property, you can receive the data as text, raw binary data, or as
a URLVariables object.

The `URLLoader.load()` method (and optionally the URLLoader class's constructor)
takes a single parameter, `request`, which is a URLRequest object. A URLRequest
object contains all of the information for a single HTTP request, such as the
target URL, request method (`GET` or `POST`), additional header information, and
the MIME type.

For example, to upload an XML packet to a server-side script, you could use the
following code:

    var secondsUTC:Number = new Date().time;
    var dataXML:XML =
    	<clock>
    		<time>{secondsUTC}</time>
    	</clock>;
    var request:URLRequest = new URLRequest("http://www.yourdomain.com/time.cfm");
    request.contentType = "text/xml";
    request.data = dataXML.toXMLString();
    request.method = URLRequestMethod.POST;
    var loader:URLLoader = new URLLoader();
    loader.load(request);

The previous snippet creates an XML document named `dataXML` that contains the
XML packet to be sent to the server. The example sets the URLRequest
`contentType` property to `"text/xml"` and assigns the XML document to the
URLRequest `data` property. Finally, the example creates a URLLoader object and
sends the request to the remote script by using the `load()` method.

## Using the URLStream class

The URLStream class provides access to the downloading data as the data arrives.
The URLStream class also lets you close a stream before it finishes downloading.
The downloaded data is available as raw binary data.

When reading data from a URLStream object, use the `bytesAvailable` property to
determine whether sufficient data is available before reading it. An EOFError
exception is thrown if you attempt to read more data than is available.

#### The httpResponseStatus event (AIR)

In Adobe AIR, the URLStream class dispatches an `httpResponseStatus` event in
addition to the `httpStatus` event. The `httpResponseStatus` event is delivered
before any response data. The `httpResponseStatus` event (represented by the
HTTPStatusEvent class) includes a `responseURL` property, which is the URL that
the response was returned from, and a `responseHeaders` property, which is an
array of URLRequestHeader objects representing the response headers that the
response returned.

## Loading data from external documents

When you build dynamic applications, it can be useful to load data from external
files or from server-side scripts. This lets you build dynamic applications
without having to edit or recompile your application. For example, if you build
a "tip of the day" application, you can write a server-side script that
retrieves a random tip from a database and saves it to a text file once a day.
Then your application can load the contents of a static text file instead of
querying the database each time.

The following snippet creates a URLRequest and URLLoader object, which loads the
contents of an external text file, params.txt:

    var request:URLRequest = new URLRequest("params.txt");
    var loader:URLLoader = new URLLoader();
    loader.load(request);

By default, if you do not define a request method, Flash Player and Adobe AIR
load the content using the HTTP `GET` method. To send the request using the
`POST` method, set the `request.method` property to `POST` using the static
constant `URLRequestMethod.POST`, as the following code shows:

    var request:URLRequest = new URLRequest("sendfeedback.cfm");
    request.method = URLRequestMethod.POST;

The external document, params.txt, that is loaded at run time contains the
following data:

    monthNames=January,February,March,April,May,June,July,August,September,October,November,December&dayNames=Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday

The file contains two parameters, `monthNames` and `dayNames`. Each parameter
contains a comma-separated list that is parsed as strings. You can split this
list into an array using the `String.split()` method.

![](../../img/tip_help.png) Avoid using reserved words or language constructs as
variable names in external data files, because doing so makes reading and
debugging your code more difficult.

Once the data has loaded, the `complete` event is dispatched, and the contents
of the external document are available to use in the URLLoader's `data`
property, as the following code shows:

    function completeHandler(event)
    {
    	var loader2 = event.target;
    	air.trace(loader2.data);
    }

If the remote document contains name-value pairs, you can parse the data using
the URLVariables class by passing in the contents of the loaded file, as
follows:

    private function completeHandler(event:Event):void
    {
    	var loader2:URLLoader = URLLoader(event.target);
    	var variables:URLVariables = new URLVariables(loader2.data);
    	trace(variables.dayNames);
    }

Each name-value pair from the external file is created as a property in the
URLVariables object. Each property within the variables object in the previous
code sample is treated as a string. If the value of the name-value pair is a
list of items, you can convert the string into an array by calling the
`String.split()` method, as follows:

    var dayNameArray:Array = variables.dayNames.split(",");

![](../../img/tip_help.png) If you are loading numeric data from external text
files, convert the values into numeric values by using a top-level function,
such as `int()`, `uint()`, or `Number()`.

Instead of loading the contents of the remote file as a string and creating a
new URLVariables object, you could instead set the `URLLoader.dataFormat`
property to one of the static properties found in the URLLoaderDataFormat class.
The three possible values for the `URLLoader.dataFormat` property are as
follows:

- `URLLoaderDataFormat.BINARY` — The `URLLoader.data` property will contain
  binary data stored in a ByteArray object.

- `URLLoaderDataFormat.TEXT` — The `URLLoader.data` property will contain text
  in a String object.

- `URLLoaderDataFormat.VARIABLES` — The `URLLoader.data` property will contain
  URL-encoded variables stored in a URLVariables object.

The following code demonstrates how setting the `URLLoader.dataFormat` property
to `URLLoaderDataFormat.VARIABLES` allows you to automatically parse loaded data
into a URLVariables object:

    package
    {
    	import flash.display.Sprite;
    	import flash.events.*;
    	import flash.net.URLLoader;
    	import flash.net.URLLoaderDataFormat;
    	import flash.net.URLRequest;

    	public class URLLoaderDataFormatExample extends Sprite
    	{
    		public function URLLoaderDataFormatExample()
    		{
    			var request:URLRequest = new URLRequest("http://www.[yourdomain].com/params.txt");
    			var variables:URLLoader = new URLLoader();
    			variables.dataFormat = URLLoaderDataFormat.VARIABLES;
    			variables.addEventListener(Event.COMPLETE, completeHandler);
    			try
    			{
    				variables.load(request);
    			}
    			catch (error:Error)
    			{
    				trace("Unable to load URL: " + error);
    			}
    		}
    		private function completeHandler(event:Event):void
    		{
    			var loader:URLLoader = URLLoader(event.target);
    			trace(loader.data.dayNames);
    		}
    	}
    }

> **Note:** The default value for `URLLoader.dataFormat` is
> `URLLoaderDataFormat.TEXT`.

As the following example shows, loading XML from an external file is the same as
loading URLVariables. You can create a URLRequest instance and a URLLoader
instance and use them to download a remote XML document. When the file has
completely downloaded, the `Event.COMPLETE` event is dispatched and the contents
of the external file are converted to an XML instance, which you can parse using
XML methods and properties.

    package
    {
    	import flash.display.Sprite;
    	import flash.errors.*;
    	import flash.events.*;
    	import flash.net.URLLoader;
    	import flash.net.URLRequest;

    	public class ExternalDocs extends Sprite
    	{
    		public function ExternalDocs()
    		{
    			var request:URLRequest = new URLRequest("http://www.[yourdomain].com/data.xml");
    			var loader:URLLoader = new URLLoader();
    			loader.addEventListener(Event.COMPLETE, completeHandler);
    			try
    			{
    				loader.load(request);
    			}
    			catch (error:ArgumentError)
    			{
    				trace("An ArgumentError has occurred.");
    			}
    			catch (error:SecurityError)
    			{
    				trace("A SecurityError has occurred.");
    			}
    		}
    		private function completeHandler(event:Event):void
    		{
    			var dataXML:XML = XML(event.target.data);
    			trace(dataXML.toXMLString());
    		}
    	}
    }

## Communicating with external scripts

In addition to loading external data files, you can also use the URLVariables
class to send variables to a server-side script and process the server's
response. This is useful, for example, if you are programming a game and want to
send the user's score to a server to calculate whether it should be added to the
high scores list, or even send a user's login information to a server for
validation. A server-side script can process the user name and password,
validate it against a database, and return confirmation of whether the
user-supplied credentials are valid.

The following snippet creates a URLVariables object named `variables,` which
creates a new variable called `name`. Next, a URLRequest object is created that
specifies the URL of the server-side script to send the variables to. Then you
set the `method` property of the URLRequest object to send the variables as an
HTTP `POST` request. To add the URLVariables object to the URL request, you set
the `data` property of the URLRequest object to the URLVariables object created
earlier. Finally, the URLLoader instance is created and the `URLLoader.load()`
method is invoked, which initiates the request.

    var variables:URLVariables = new URLVariables("name=Franklin");
    var request:URLRequest = new URLRequest();
    request.url = "http://www.[yourdomain].com/greeting.cfm";
    request.method = URLRequestMethod.POST;
    request.data = variables;
    var loader:URLLoader = new URLLoader();
    loader.dataFormat = URLLoaderDataFormat.VARIABLES;
    loader.addEventListener(Event.COMPLETE, completeHandler);
    try
    {
    	loader.load(request);
    }
    catch (error:Error)
    {
    	trace("Unable to load URL");
    }

    function completeHandler(event:Event):void
    {
    	trace(event.target.data.welcomeMessage);
    }

The following code contains the contents of the Adobe ColdFusion® greeting.cfm
document used in the previous example:

    <cfif NOT IsDefined("Form.name") OR Len(Trim(Form.Name)) EQ 0>
    	<cfset Form.Name = "Stranger" />
    </cfif>
    <cfoutput>welcomeMessage=#UrlEncodedFormat("Welcome, " & Form.name)#
    </cfoutput>
