# Basics of internationalizing applications

The terms globalization and internationalization are sometimes used
interchangeably. But most definitions of these terms say that globalization
refers to a combination of business and engineering processes while
internationalization refers to engineering alone.

Here are some definitions for important terms:

**Globalization**  
A broad range of engineering and business processes needed for preparing and
launching products and company activities globally. Globalization consists of
engineering activities like internationalization, localization and culturization
and business activities like product management, financial planning, marketing,
and legal work. Globalization is sometimes abbreviated as _G11n_ (which stands
for the letter G, then 11 more letters, and then the letter n). _"Globalization
is what businesses do."_

**Internationalization**  
An engineering process for generalizing a product so that it can handle multiple
languages, scripts and cultural conventions (including currencies, sorting
rules, number and date formats, and more) without the need for redesign or
recompilation. This process can be divided into two sets of activities:
enablement and localization. Internationalization is sometimes known as
_world-readiness_, and sometimes abbreviated as _I18n_. _"Internationalization
is what engineers do."_

**Localization**  
A process of adapting a product or service to a particular language, culture,
and desired local appearance. Localization is sometimes abbreviated as _L10n_.
_"Localization is what translators do."_

**Culturization**  
An engineering process for developing or adapting specific features for the
unique needs of a culture. Examples include the Japanese publishing features
available in Adobe InDesign, and the Hanko support feature in Adobe Acrobat.

Some other important internationalization terms can be defined as follows:

**Character Set**  
The characters used by a language or by a group of languages. A character set
includes national characters, special characters (such as punctuation marks and
mathematical symbols), numeric digits, and computer control characters.

**Collation**  
The sorting of text into a proper order for a given locale.

**Locale**  
A value that represents the language and cultural conventions used in a
geographical, political, or cultural region (which in many cases indicates a
single country). A unique locale identifier (locale ID) represents this value.
The locale ID is used to look up a set of locale data that provides
locale-specific support. This support applies to measurement units, the parsing
and formatting of numbers and dates, and so on.

**Resource Bundle**  
A stored set of locale-specific elements that are created for a locale in which
an application is used. A resource bundle typically contains all text elements
in the application's user interface. Within the bundle, these elements are
translated into the appropriate language for the given locale. It can also
contain other settings that alter the layout or behavior of the user interface
for a specific locale. A resource bundle can contain other media types, or
references to other media types, that are locale-specific.
