# Workflow for reading and writing files

The workflow for reading and writing files is as follows.

#### Initialize a File object that points to the path.

The File object represents the path of the file that you want to work with (or a
file that you will later create).

    var file:File = File.documentsDirectory;
    file = file.resolvePath("AIR Test/testFile.txt");

This example uses the `File.documentsDirectory` property and the `resolvePath()`
method of a File object to initialize the File object. However, there are many
other ways to point a File object to a file. For more information, see
[Pointing a File object to a file](./working-with-file-objects-in-air.md#pointing-a-file-object-to-a-file).

#### Initialize a FileStream object.

#### Call the open() method or the openAsync() method of the FileStream object.

The method you call depends on whether you want to open the file for synchronous
or asynchronous operations. Use the File object as the `file` parameter of the
open method. For the `fileMode` parameter, specify a constant from the FileMode
class that specifies the way in which you will use the file.

For example, the following code initializes a FileStream object that is used to
create a file and overwrite any existing data:

    var fileStream:FileStream = new FileStream();
    fileStream.open(file, FileMode.WRITE);

For more information, see
[Initializing a FileStream object, and opening and closing files](./initializing-a-filestream-object-and-opening-and-closing-files.md)
and [FileStream open modes](./filestream-open-modes.md).

#### If you opened the file asynchronously (using the openAsync() method), add and set up event listeners for the FileStream object.

These event listener methods respond to events dispatched by the FileStream
object in various situations. These situations include when data is read in from
the file, when I/O errors are encountered, or when the complete amount of data
to be written has been written.

For details, see
[Asynchronous programming and the events generated by a FileStream object opened asynchronously](./asynchronous-programming-and-the-events-generated-by-a-filestream-object-opened-asynchronously.md).

#### Include code for reading and writing data, as needed.

There are many methods of the FileStream class related to reading and writing.
(They each begin with "read" or "write".) The method you choose to use to read
or write data depends on the format of the data in the target file.

For example, if the data in the target file is UTF-encoded text, you may use the
`readUTFBytes()` and `writeUTFBytes()` methods. If you want to deal with the
data as byte arrays, you may use the `readByte()`, `readBytes()`, `writeByte()`,
and `writeBytes()` methods. For details, see
[Data formats, and choosing the read and write methods to use](./data-formats-and-choosing-the-read-and-write-methods-to-use.md).

If you opened the file asynchronously, then be sure that enough data is
available before calling a read method. For details, see
[The read buffer and the bytesAvailable property of a FileStream object](./the-read-buffer-and-the-bytesavailable-property-of-a-filestream-object.md).

Before writing to a file, if you want to check the amount of disk space
available, you can check the spaceAvailable property of the File object. For
more information, see
[Determining space available on a volume](./working-with-file-objects-in-air.md#determining-space-available-on-a-volume).

#### Call the close() method of the FileStream object when you are done working with the file.

Calling the close() method makes the file available to other applications.

For details, see
[Initializing a FileStream object, and opening and closing files](./initializing-a-filestream-object-and-opening-and-closing-files.md).

To see a sample application that uses the FileStream class to read and write
files, see the following articles at the Adobe AIR Developer Center:

- [Building a text-file editor](https://web.archive.org/web/20090130011935/http://www.adobe.com/devnet/air/flash/quickstart/building_text_editor.html)

- [Building a text-file editor](https://web.archive.org/web/20100817082125/http://www.adobe.com/devnet/air/flex/quickstart/building_text_editor.html)

- [Reading and writing from an XML preferences file](https://web.archive.org/web/20170319130306/http://www.adobe.com/devnet/air/flex/quickstart/articles/xml_prefs.html)
