# Working with motion tweens

[Animating objects](../display-programming/animating-objects.md) describes how
to implement scripted animation in ActionScript.

Here we describe a different technique for creating animation: motion tweens.
This technique lets you create movement by setting up motion interactively in a
document using Adobe® Flash® Professional. Then you can use that motion in your
dynamic ActionScript-based animation at runtime.

Flash Professional automatically generates the ActionScript that implements the
motion tween and makes it available for you to copy and reuse.

To create motion tweens, you must have a license for Flash Professional.

- [Basics of Motion Tweens](./basics-of-motion-tweens.md)
- [Copying motion tween scripts in Flash](./copying-motion-tween-scripts-in-flash.md)
- [Incorporating motion tween scripts](./incorporating-motion-tween-scripts.md)
- [Describing the animation](./describing-the-animation.md)
- [Adding filters](./adding-filters.md)
- [Associating a motion tween with its display objects](./associating-a-motion-tween-with-its-display-objects.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[Motion tween animation](https://web.archive.org/web/20150228135850/https://helpx.adobe.com/flash/using/motion-tween-animation.html)

![](../../img/flashplatformLinkIndicator.png)
[fl.motion package](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/fl/motion/package-detail.html)
