# Working with bitmaps

In addition to its vector drawing capabilities, ActionScript 3.0 includes the
ability to create bitmap images or manipulate the pixel data of external bitmap
images that are loaded into a SWF. With the ability to access and change
individual pixel values, you can create your own filter-like image effects and
use the built-in noise functions to create textures and random noise.

- [Basics of working with bitmaps](./basics-of-working-with-bitmaps.md)
- [The Bitmap and BitmapData classes](./the-bitmap-and-bitmap-data-classes.md)
- [Manipulating pixels](./manipulating-pixels.md)
- [Copying bitmap data](./copying-bitmap-data.md)
- [Compressing bitmap data](./compressing-bitmap-data.md)
- [Making textures with noise functions](./making-textures-with-noise-functions.md)
- [Scrolling bitmaps](./scrolling-bitmaps.md)
- [Taking advantage of mipmapping](./taking-advantage-of-mipmapping.md)
- [Bitmap example: Animated spinning moon](./bitmap-example-animated-spinning-moon.md)
- [Asynchronous decoding of bitmap images](./asynchronous-decoding-of-bitmap-images.md)

More Help Topics

![](../../img/flashplatformLinkIndicator.png)
[flash.display.Bitmap class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/Bitmap.html)

![](../../img/flashplatformLinkIndicator.png)
[flash.display.BitmapData class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/BitmapData.html)

## Adobe Recommends

- [Renaun Erickson: Rendering game assets in ActionScript using blitting techniques](https://web.archive.org/web/20150313213931/https://www.adobe.com/devnet/flex/articles/actionscript_blitting.html)

- [Bitmap programming](http://my.safaribooksonline.com/0596526946/bitmap_programming):
  Chapter 26 of Essential ActionScript 3 by Colin Moock (O'Reilly Media, 2007)

- [Mike Jones: Working with Sprites in Pushbutton Engine](https://web.archive.org/web/20150320173951/http://blog.flashgen.com/2011/03/22/working-with-sprites-in-pushbutton-engine/)

- [Flash &amp; Math: Pixel Particles Made Simple](https://web.archive.org/web/20170319050448/http://www.flashandmath.com/intermediate/pixtut/)

- [Flixel](http://flixel.org/)
  ([Flixel Github](https://github.com/AdamAtomic/flixel))
