# Using the drawing API

Although imported images and artwork are important, the functionality known as
the drawing API, which allows you to draw lines and shapes in ActionScript,
gives you the freedom to start an application with the computer equivalent of a
blank canvas, on which you can create whatever images you wish. The ability to
create your own graphics opens up broad possibilities for your applications.
With the techniques covered here you can create a drawing program, make
animated, interactive art, or programmatically create your own user interface
elements, among many possibilities.

- [Basics of the drawing API](./basics-of-the-drawing-api.md)
- [The Graphics class](./the-graphics-class.md)
- [Drawing lines and curves](./drawing-lines-and-curves.md)
- [Drawing shapes using built-in methods](./drawing-shapes-using-built-in-methods.md)
- [Creating gradient lines and ills](./creating-gradient-lines-and-fills.md)
- [Using the Math class with drawing methods](./using-the-math-class-with-drawing-methods.md)
- [Animating with the drawing API](./animating-with-the-drawing-api.md)
- [Drawing API example: Algorithmic Visual Generator](./drawing-api-example-algorithmic-visual-generator.md)
- [Advanced use of the drawing API](./advanced-use-of-the-drawing-api.md)

More Help Topics

![](../../img/flashplatformLinkIndicator.png)
[flash.display.Graphics](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/Graphics.html)
