# Example: Combining basic filters

The following code example uses several basic filters, combined with a Timer for
creating repeating actions, to create an animated traffic light simulation.

    import flash.display.Shape;
    import flash.events.TimerEvent;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.DropShadowFilter;
    import flash.filters.GlowFilter;
    import flash.filters.GradientBevelFilter;
    import flash.utils.Timer;

    var count:Number = 1;
    var distance:Number = 8;
    var angleInDegrees:Number = 225; // opposite of 45 degrees
    var colors:Array = [0xFFFFCC, 0xFEFE78, 0x8F8E01];
    var alphas:Array = [1, 0, 1];
    var ratios:Array = [0, 128, 255];
    var blurX:Number = 8;
    var blurY:Number = 8;
    var strength:Number = 1;
    var quality:Number = BitmapFilterQuality.HIGH;
    var type:String = BitmapFilterType.INNER;
    var knockout:Boolean = false;

    // Draw the rectangle background for the traffic light.
    var box:Shape = new Shape();
    box.graphics.lineStyle();
    box.graphics.beginFill(0xFEFE78);
    box.graphics.drawRect(100, 50, 90, 200);
    box.graphics.endFill();

    // Draw the 3 circles for the three lights.
    var stopLight:Shape = new Shape();
    stopLight.graphics.lineStyle();
    stopLight.graphics.beginFill(0xFF0000);
    stopLight.graphics.drawCircle(145,90,25);
    stopLight.graphics.endFill();

    var cautionLight:Shape = new Shape();
    cautionLight.graphics.lineStyle();
    cautionLight.graphics.beginFill(0xFF9900);
    cautionLight.graphics.drawCircle(145,150,25);
    cautionLight.graphics.endFill();

    var goLight:Shape = new Shape();
    goLight.graphics.lineStyle();
    goLight.graphics.beginFill(0x00CC00);
    goLight.graphics.drawCircle(145,210,25);
    goLight.graphics.endFill();

    // Add the graphics to the display list.
    addChild(box);
    addChild(stopLight);
    addChild(cautionLight);
    addChild(goLight);

    // Apply a gradient bevel to the traffic light rectangle.
    var gradientBevel:GradientBevelFilter = new GradientBevelFilter(distance, angleInDegrees, colors, alphas, ratios, blurX, blurY, strength, quality, type, knockout);
    box.filters = [gradientBevel];

    // Create the inner shadow (for lights when off) and glow
    // (for lights when on).
    var innerShadow:DropShadowFilter = new DropShadowFilter(5, 45, 0, 0.5, 3, 3, 1, 1, true, false);
    var redGlow:GlowFilter = new GlowFilter(0xFF0000, 1, 30, 30, 1, 1, false, false);
    var yellowGlow:GlowFilter = new GlowFilter(0xFF9900, 1, 30, 30, 1, 1, false, false);
    var greenGlow:GlowFilter = new GlowFilter(0x00CC00, 1, 30, 30, 1, 1, false, false);

    // Set the starting state of the lights (green on, red/yellow off).
    stopLight.filters = [innerShadow];
    cautionLight.filters = [innerShadow];
    goLight.filters = [greenGlow];

    // Swap the filters based on the count value.
    function trafficControl(event:TimerEvent):void
    {
        if (count == 4)
        {
            count = 1;
        }

        switch (count)
        {
            case 1:
                stopLight.filters = [innerShadow];
                cautionLight.filters = [yellowGlow];
                goLight.filters = [innerShadow];
                break;
            case 2:
                stopLight.filters = [redGlow];
                cautionLight.filters = [innerShadow];
                goLight.filters = [innerShadow];
                break;
            case 3:
                stopLight.filters = [innerShadow];
                cautionLight.filters = [innerShadow];
                goLight.filters = [greenGlow];
                break;
        }

        count++;
    }

    // Create a timer to swap the filters at a 3 second interval.
    var timer:Timer = new Timer(3000, 9);
    timer.addEventListener(TimerEvent.TIMER, trafficControl);
    timer.start();
