# Bevel filter

The BevelFilter class allows you to add a 3D beveled edge to the filtered
object. This filter makes the hard corners or edges of your object look like
they have been chiseled, or beveled, away.

The BevelFilter class properties allow you to customize the appearance of the
bevel. You can set highlight and shadow colors, bevel edge blurs, bevel angles,
and bevel edge placement; you can even create a knockout effect.

The following example loads an external image and applies a bevel filter to it.

    import flash.display.*;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.net.URLRequest;

    // Load an image onto the Stage.
    var imageLoader:Loader = new Loader();
    var url:String = "http://www.helpexamples.com/flash/images/image3.jpg";
    var urlReq:URLRequest = new URLRequest(url);
    imageLoader.load(urlReq);
    addChild(imageLoader);

    // Create the bevel filter and set filter properties.
    var bevel:BevelFilter = new BevelFilter();

    bevel.distance = 5;
    bevel.angle = 45;
    bevel.highlightColor = 0xFFFF00;
    bevel.highlightAlpha = 0.8;
    bevel.shadowColor = 0x666666;
    bevel.shadowAlpha = 0.8;
    bevel.blurX = 5;
    bevel.blurY = 5;
    bevel.strength = 5;
    bevel.quality = BitmapFilterQuality.HIGH;
    bevel.type = BitmapFilterType.INNER;
    bevel.knockout = false;

    // Apply filter to the image.
    imageLoader.filters = [bevel];
