# Display programming

Visual elements are programmed in Adobe® ActionScript® 3.0 by working with
display objects on the display stage. For example, you can add, move, remove,
and order display objects, apply filters and masks, draw vector and bitmap
graphics, and perform three-dimensional transformations using the ActionScript
display programming API. The primary classes used for display programming are
part of the
[flash.display package](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/package-detail.html).

> **Note:** Adobe® AIR™ provides the HTMLoader object for rendering and
> displaying HTML content. The HTMLLoader renders the visual elements of the
> HTML DOM as a single display object. You cannot access the individual elements
> of the DOM directly through the ActionScript display list hierarchy. Instead,
> you access these DOM elements using the separate DOM API provided by the
> HTMLLoader.

- [Basics of display programming](./basics-of-display-programming.md)
- [Core display classes](./core-display-classes.md)
- [Advantages of the display list approach](./advantages-of-the-display-list-approach.md)
- [Working with display objects](./working-with-display-objects.md)
- [Manipulating display objects](./manipulating-display-objects.md)
- [Animating objects](./animating-objects.md)
- [Stage orientation](./stage-orientation.md)
- [Loading display content dynamically](./loading-display-content-dynamically.md)
- [Display object example: SpriteArranger](./display-object-example-sprite-arranger.md)
