# Working with XML

ActionScript 3.0 includes a group of classes based on the ECMAScript for XML
(E4X) specification (ECMA-357 edition 2). These classes include powerful and
easy-to-use functionality for working with XML data. Using E4X, you will be able
to develop code with XML data faster than was possible with previous programming
techniques. As an added benefit, the code you produce will be easier to read.

- [Basics of XML](./basics-of-xml.md)
- [The E4X approach to XML processing](./the-e4x-approach-to-xml-processing.md)
- [XML objects](./xml-objects.md)
- [XMLList objects](./xmllist-objects.md)
- [Initializing XML variables](./initializing-xml-variables.md)
- [Assembling and transforming XML objects](./assembling-and-transforming-xml-objects.md)
- [Traversing XML structures](./traversing-xml-structures.md)
- [Using XML namespaces](./using-xml-namespaces.md)
- [XML type conversion](./xml-type-conversion.md)
- [Reading external XML documents](./reading-external-xml-documents.md)
- [XML in ActionScript example: Loading RSS data from the Internet](./xml-in-actionscript-example-loading-rss-data-from-the-internet.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[XML class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/XML.html)

![](../../img/flashplatformLinkIndicator.png)
[XMLList class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/XMLList.html)

[ECMA-457 specification](https://www.ecma-international.org/publications-and-standards/standards/ecma-357/)

## Adobe recommends

> ### [![](../../img/marc_bir.png) E4X is Good4U](https://web.archive.org/web/20140817005041/http://tv.adobe.com/watch/max-2008-develop/e4x-is-good4u-by-marc-bir/)
>
> Marc Bir discusses E4X, the easy way to work with XML data in ActionScript
> 3.0. He covers techniques for creating XML and filtering XML to find the data
> you need.
